/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.DOMParserWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DOMFilter {
    private static final String DEFAULT_PARSER_NAME = "dom.wrappers.DOMParser";

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            DOMFilter.printUsage();
            System.exit(1);
        }
        var1_1 = "dom.wrappers.DOMParser";
        var2_2 = "*";
        var3_3 = null;
        var4_4 = 0;
        while (var4_4 < var0.length) {
            var5_5 = var0[var4_4];
            if (!var5_5.startsWith("-")) ** GOTO lbl32
            if (var5_5.equals("-p")) {
                if (var4_4 == var0.length - 1) {
                    System.err.println("error: missing parser name");
                    System.exit(1);
                }
                var1_1 = var0[++var4_4];
            } else if (var5_5.equals("-e")) {
                if (var4_4 == var0.length - 1) {
                    System.err.println("error: missing element name");
                    System.exit(1);
                }
                var2_2 = var0[++var4_4];
            } else if (var5_5.equals("-a")) {
                if (var4_4 == var0.length - 1) {
                    System.err.println("error: missing attribute name");
                    System.exit(1);
                }
                var3_3 = var0[++var4_4];
            } else {
                if (var5_5.equals("-h")) {
                    DOMFilter.printUsage();
                    System.exit(1);
                }
lbl32:
                // 4 sources

                System.err.println(String.valueOf(var5_5) + ':');
                DOMFilter.print(var1_1, var5_5, var2_2, var3_3);
            }
            ++var4_4;
        }
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c));
                    stringBuffer.append(';');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void print(String string, String string2, String string3, String string4) {
        try {
            DOMParserWrapper dOMParserWrapper = (DOMParserWrapper)Class.forName(string).newInstance();
            Document document = dOMParserWrapper.parse(string2);
            NodeList nodeList = document.getElementsByTagName(string3);
            DOMFilter.print(nodeList, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private static void print(Element element, NamedNodeMap namedNodeMap) {
        System.out.print('<');
        System.out.print(element.getNodeName());
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                System.out.print(' ');
                System.out.print(attr.getNodeName());
                System.out.print("=\"");
                System.out.print(DOMFilter.normalize(attr.getNodeValue()));
                System.out.print('\"');
                ++n2;
            }
        }
        System.out.println('>');
    }

    private static void print(NodeList nodeList, String string) {
        if (nodeList == null) {
            return;
        }
        if (string == null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element = (Element)nodeList.item(n2);
                DOMFilter.print(element, element.getAttributes());
                ++n2;
            }
        } else {
            int n = nodeList.getLength();
            int n3 = 0;
            while (n3 < n) {
                Element element = (Element)nodeList.item(n3);
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap.getNamedItem(string) != null) {
                    DOMFilter.print(element, namedNodeMap);
                }
                ++n3;
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.DOMFilter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Specify DOM parser wrapper by name.");
        System.err.println("           Default parser: dom.wrappers.DOMParser");
        System.err.println("  -e name  Specify element name to search for. Default is \"*\".");
        System.err.println("  -a name  Specify attribute name of specified elements.");
        System.err.println("  -h       This help screen.");
    }
}

