/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeIteratorImpl;
import org.apache.xerces.dom.RangeImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;

public abstract class ChildAndParentNode
extends ChildNode {
    static final long serialVersionUID = 0L;
    protected DocumentImpl ownerDocument;
    protected ChildNode firstChild = null;
    protected int changes = 0;
    protected transient int nodeListLength = -1;
    protected transient ChildNode nodeListNode;
    protected transient int nodeListIndex = -1;

    public ChildAndParentNode() {
    }

    protected ChildAndParentNode(DocumentImpl documentImpl) {
        super(documentImpl);
        this.ownerDocument = documentImpl;
    }

    protected void changed() {
        ++this.changes;
        this.nodeListIndex = -1;
        this.nodeListLength = -1;
        NodeImpl nodeImpl = this.parentNode();
        if (nodeImpl != null) {
            nodeImpl.changed();
        }
    }

    protected int changes() {
        return this.changes;
    }

    public Node cloneNode(boolean bl) {
        ChildAndParentNode childAndParentNode = (ChildAndParentNode)super.cloneNode(bl);
        childAndParentNode.ownerDocument = this.ownerDocument;
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        childAndParentNode.firstChild = null;
        childAndParentNode.nodeListIndex = -1;
        childAndParentNode.nodeListLength = -1;
        if (bl) {
            Node node = this.firstChild;
            while (node != null) {
                childAndParentNode.appendChild(node.cloneNode(true));
                node = node.getNextSibling();
            }
        }
        return childAndParentNode;
    }

    public NodeList getChildNodes() {
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Node getFirstChild() {
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        return this.lastChild();
    }

    public int getLength() {
        if (this.nodeListLength == -1) {
            ChildNode childNode;
            if (this.nodeListIndex != -1 && this.nodeListNode != null) {
                this.nodeListLength = this.nodeListIndex;
                childNode = this.nodeListNode;
            } else {
                childNode = this.firstChild;
                this.nodeListLength = 0;
            }
            while (childNode != null) {
                ++this.nodeListLength;
                childNode = childNode.nextSibling;
            }
        }
        return this.nodeListLength;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public boolean hasChildNodes() {
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.internalInsertBefore(node, node2, 65535);
    }

    Node internalInsertBefore(Node node, Node node2, int n) throws DOMException {
        Object object;
        if (this.readOnly()) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        boolean bl = this.ownerDocument.errorChecking;
        if (bl && node.getOwnerDocument() != this.ownerDocument) {
            throw new DOMExceptionImpl(4, "DOM005 Wrong document");
        }
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            boolean bl2 = true;
            object = this.parentNode();
            while (bl2 && object != null) {
                bl2 = node != object;
                object = ((NodeImpl)object).parentNode();
            }
            if (!bl2) {
                throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
            }
            if (node2 != null && node2.getParentNode() != this) {
                throw new DOMExceptionImpl(8, "DOM008 Not found");
            }
        }
        if (node.getNodeType() == 11) {
            Node node3 = node.getFirstChild();
            while (node3 != null) {
                if (bl && !this.ownerDocument.isKidOK(this, node3)) {
                    throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
                }
                node3 = node3.getNextSibling();
            }
            while (node.hasChildNodes()) {
                this.insertBefore(node.getFirstChild(), node2);
            }
        } else {
            ChildNode childNode;
            Object object2;
            if (!(!bl || node instanceof ChildNode && this.ownerDocument.isKidOK(this, node))) {
                throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
            }
            ChildNode childNode2 = (ChildNode)node;
            object = null;
            if ((n & 2) != 0) {
                object2 = LCount.lookup("DOMAttrModified");
                if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                    object = this.getEnclosingAttr();
                }
            }
            if ((object2 = childNode2.parentNode()) != null) {
                object2.removeChild(childNode2);
            }
            ChildNode childNode3 = (childNode = (ChildNode)node2) == null ? this.lastChild() : childNode.previousSibling;
            childNode2.ownerNode = this;
            childNode2.owned(true);
            childNode2.previousSibling = childNode3;
            if (childNode == this.firstChild) {
                this.firstChild = childNode2;
                childNode2.firstChild(true);
            } else {
                childNode3.nextSibling = childNode2;
            }
            childNode2.nextSibling = childNode;
            if (childNode == null) {
                this.firstChild.previousSibling = childNode2;
            } else {
                childNode.previousSibling = childNode2;
                childNode.firstChild(false);
            }
            this.changed();
            if ((n & 1) != 0) {
                Object object3;
                LCount lCount = LCount.lookup("DOMNodeInserted");
                if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                    object3 = new MutationEventImpl();
                    object3.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null);
                    childNode2.dispatchEvent((Event)object3);
                }
                lCount = LCount.lookup("DOMNodeInsertedIntoDocument");
                if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                    object3 = this;
                    if (object != null) {
                        object3 = (NodeImpl)((Object)((NodeImpl.EnclosingAttr)object).node.getOwnerElement());
                    }
                    if (object3 != null) {
                        Object object4 = object3;
                        while (object4 != null) {
                            object3 = object4;
                            object4 = ((NodeImpl)object4).getNodeType() == 2 ? (ElementImpl)((AttrImpl)object4).getOwnerElement() : ((NodeImpl)object4).parentNode();
                        }
                        if (((NodeImpl)object3).getNodeType() == 9) {
                            MutationEventImpl mutationEventImpl = new MutationEventImpl();
                            mutationEventImpl.initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null);
                            this.dispatchEventToSubtree(childNode2, mutationEventImpl);
                        }
                    }
                }
            }
            if ((n & 2) != 0) {
                this.dispatchAggregateEvents((NodeImpl.EnclosingAttr)object);
            }
        }
        return node;
    }

    Node internalRemoveChild(Node node, int n) throws DOMException {
        NodeImpl nodeImpl;
        Object object;
        Enumeration enumeration;
        if (this.readOnly()) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (this.ownerDocument.errorChecking && node != null && node.getParentNode() != this) {
            throw new DOMExceptionImpl(8, "DOM008 Not found");
        }
        Enumeration enumeration2 = this.ownerDocument.getNodeIterators();
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                ((NodeIteratorImpl)enumeration2.nextElement()).removeNode(node);
            }
        }
        if ((enumeration = this.ownerDocument.getRanges()) != null) {
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).removeNode(node);
            }
        }
        ChildNode childNode = (ChildNode)node;
        NodeImpl.EnclosingAttr enclosingAttr = null;
        LCount lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            enclosingAttr = this.getEnclosingAttr();
        }
        if ((n & 1) != 0) {
            lCount = LCount.lookup("DOMNodeRemoved");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                object = new MutationEventImpl();
                object.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null);
                childNode.dispatchEvent((Event)object);
            }
            lCount = LCount.lookup("DOMNodeRemovedFromDocument");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                object = this;
                if (enclosingAttr != null) {
                    object = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                }
                if (object != null) {
                    nodeImpl = ((NodeImpl)object).parentNode();
                    while (nodeImpl != null) {
                        object = nodeImpl;
                        nodeImpl = nodeImpl.parentNode();
                    }
                    if (((NodeImpl)object).getNodeType() == 9) {
                        MutationEventImpl mutationEventImpl = new MutationEventImpl();
                        mutationEventImpl.initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null);
                        this.dispatchEventToSubtree(childNode, mutationEventImpl);
                    }
                }
            }
        }
        object = childNode.previousSibling;
        nodeImpl = childNode.nextSibling;
        if (childNode != this.firstChild) {
            ((ChildNode)object).nextSibling = nodeImpl;
        } else {
            childNode.firstChild(false);
            this.firstChild = nodeImpl;
            if (nodeImpl != null) {
                nodeImpl.firstChild(true);
            }
        }
        if (nodeImpl != null) {
            ((ChildNode)nodeImpl).previousSibling = object;
        } else if (this.firstChild != null) {
            this.firstChild.previousSibling = object;
        }
        childNode.ownerNode = this.ownerDocument;
        childNode.owned(false);
        childNode.nextSibling = null;
        childNode.previousSibling = null;
        this.changed();
        if ((n & 2) != 0) {
            this.dispatchAggregateEvents(enclosingAttr);
        }
        return childNode;
    }

    public Node item(int n) {
        if (this.nodeListIndex != -1 && this.nodeListNode != null) {
            if (this.nodeListIndex < n) {
                while (this.nodeListIndex < n && this.nodeListNode != null) {
                    ++this.nodeListIndex;
                    this.nodeListNode = this.nodeListNode.nextSibling;
                }
            } else if (this.nodeListIndex > n) {
                while (this.nodeListIndex > n && this.nodeListNode != null) {
                    --this.nodeListIndex;
                    this.nodeListNode = this.nodeListNode.previousSibling();
                }
            }
            return this.nodeListNode;
        }
        this.nodeListNode = this.firstChild;
        this.nodeListIndex = 0;
        while (this.nodeListIndex < n && this.nodeListNode != null) {
            this.nodeListNode = this.nodeListNode.nextSibling;
            ++this.nodeListIndex;
        }
        return this.nodeListNode;
    }

    final ChildNode lastChild() {
        return this.firstChild != null ? this.firstChild.previousSibling : null;
    }

    final void lastChild(ChildNode childNode) {
        if (this.firstChild != null) {
            this.firstChild.previousSibling = childNode;
        }
    }

    public void normalize() {
        Node node = this.firstChild;
        while (node != null) {
            node.normalize();
            node = node.getNextSibling();
        }
    }

    DocumentImpl ownerDocument() {
        return this.ownerDocument;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.nodeListLength = -1;
        this.nodeListIndex = -1;
    }

    public Node removeChild(Node node) throws DOMException {
        return this.internalRemoveChild(node, 65535);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        NodeImpl.EnclosingAttr enclosingAttr = null;
        LCount lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            enclosingAttr = this.getEnclosingAttr();
        }
        this.internalInsertBefore(node, node2, 1);
        this.internalRemoveChild(node2, 1);
        this.dispatchAggregateEvents(enclosingAttr);
        return node2;
    }

    void setOwnerDocument(DocumentImpl documentImpl) {
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        this.ownerDocument = documentImpl;
        Node node = this.firstChild;
        while (node != null) {
            ((NodeImpl)node).setOwnerDocument(documentImpl);
            node = node.getNextSibling();
        }
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (bl2) {
            if (this.syncChildren()) {
                this.synchronizeChildren();
            }
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                if (!(childNode instanceof EntityReference)) {
                    childNode.setReadOnly(bl, true);
                }
                childNode = childNode.nextSibling;
            }
        }
    }

    protected void synchronizeChildren() {
        this.syncChildren(false);
    }

    protected final void synchronizeChildren(int n) {
        this.syncChildren(false);
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        NodeImpl nodeImpl = null;
        ChildNode childNode = null;
        int n2 = deferredDocumentImpl.getLastChild(n);
        while (n2 != -1) {
            ChildNode childNode2 = (ChildNode)((Object)deferredDocumentImpl.getNodeObject(n2));
            if (childNode == null) {
                childNode = childNode2;
            } else {
                ((ChildNode)nodeImpl).previousSibling = childNode2;
            }
            childNode2.ownerNode = this;
            childNode2.owned(true);
            childNode2.nextSibling = nodeImpl;
            nodeImpl = childNode2;
            n2 = deferredDocumentImpl.getPrevSibling(n2);
        }
        if (childNode != null) {
            this.firstChild = nodeImpl;
            nodeImpl.firstChild(true);
            this.lastChild(childNode);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.syncChildren()) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }
}

