/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLParser;
import org.apache.xerces.utils.QName;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXParser
extends XMLParser
implements XMLDocumentHandler,
XMLDocumentHandler.DTDHandler,
Parser,
XMLReader {
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespace-prefixes", "http://xml.org/sax/features/string-interning"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/properties/declaration-handler", "http://xml.org/sax/properties/dom-node"};
    private static final boolean DEBUG_CALLBACKS = false;
    private DocumentHandler fDocumentHandler;
    private DTDHandler fDTDHandler;
    private ContentHandler fContentHandler;
    private DeclHandler fDeclHandler;
    private LexicalHandler fLexicalHandler;
    private boolean fNamespacePrefixes = false;
    private transient AttributesImpl fAttributes = new AttributesImpl();

    public SAXParser() {
        try {
            this.setNamespaces(true);
        }
        catch (Exception exception) {}
        this.initHandlers(true, this, this);
    }

    public void attlistDecl(QName qName, QName qName2, int n, boolean bl, String string, int n2, int n3) throws Exception {
        if (this.fDeclHandler != null) {
            String string2 = this.fStringPool.toString(qName.rawname);
            String string3 = this.fStringPool.toString(qName2.rawname);
            String string4 = string;
            if (n != 2) {
                switch (n) {
                    case 0: {
                        string4 = "CDATA";
                        break;
                    }
                    case 1: {
                        string4 = bl ? "ENTITIES" : "ENTITY";
                        break;
                    }
                    case 3: {
                        string4 = "ID";
                        break;
                    }
                    case 4: {
                        string4 = bl ? "IDREFS" : "IDREF";
                        break;
                    }
                    case 5: {
                        string4 = bl ? "NMTOKENS" : "NMTOKEN";
                        break;
                    }
                    case 6: {
                        string4 = "NOTATION";
                        break;
                    }
                }
            }
            String string5 = "";
            switch (n2) {
                case 1: {
                    string5 = "#FIXED";
                    break;
                }
                case 0: {
                    string5 = "#IMPLIED";
                    break;
                }
                case 2: {
                    string5 = "#REQUIRED";
                    break;
                }
            }
            String string6 = this.fStringPool.toString(n3);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.attributeDecl(string2, string3, string4, string5, string6);
            }
        }
    }

    public void characters(int n) throws Exception {
        throw new RuntimeException("PAR017 cannot happen 5\n5");
    }

    public void characters(char[] cArray, int n, int n2) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(cArray, n, n2);
        }
        if (this.fContentHandler != null) {
            this.fContentHandler.characters(cArray, n, n2);
        }
    }

    public void comment(int n) throws Exception {
        if (this.fLexicalHandler != null) {
            String string = this.fStringPool.orphanString(n);
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.comment(string.toCharArray(), 0, string.length());
            }
        } else {
            this.fStringPool.releaseString(n);
        }
    }

    public void elementDecl(QName qName, int n, int n2, XMLContentSpec.Provider provider) throws Exception {
        if (this.fDeclHandler != null) {
            String string = this.fStringPool.toString(qName.rawname);
            String string2 = XMLContentSpec.toString(provider, this.fStringPool, n2);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.elementDecl(string, string2);
            }
        }
    }

    public void endCDATA() throws Exception {
        if (this.fLexicalHandler != null) {
            this.fLexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws Exception {
        if (this.fLexicalHandler != null) {
            this.fLexicalHandler.endDTD();
        }
    }

    public void endDocument() throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument();
        }
        if (this.fContentHandler != null) {
            this.fContentHandler.endDocument();
        }
    }

    public void endElement(QName qName) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(this.fStringPool.toString(qName.rawname));
        }
        if (this.fContentHandler != null) {
            boolean bl = this.getNamespaces();
            int n = qName.uri;
            String string = n != -1 && bl ? this.fStringPool.toString(n) : "";
            int n2 = qName.localpart;
            String string2 = n2 != -1 && bl ? this.fStringPool.toString(n2) : "";
            String string3 = this.fStringPool.toString(qName.rawname);
            this.fContentHandler.endElement(string, string2, string3);
        }
    }

    public void endEntityReference(int n, int n2, int n3) throws Exception {
        if (this.fLexicalHandler != null) {
            switch (n2) {
                case 0: 
                case 1: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.endEntity("%" + this.fStringPool.toString(n));
                    break;
                }
                case 2: 
                case 3: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.endEntity(this.fStringPool.toString(n));
                    break;
                }
                case 4: {
                    throw new RuntimeException("PAR016 endEntityReference(): ENTITYTYPE_UNPARSED");
                }
                case 6: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.endEntity("[dtd]");
                    break;
                }
            }
        }
    }

    public void endNamespaceDeclScope(int n) throws Exception {
        if (this.fContentHandler != null) {
            String string = this.fStringPool.toString(n);
            if (this.fContentHandler != null) {
                this.fContentHandler.endPrefixMapping(string);
            }
        }
    }

    public void externalEntityDecl(int n, int n2, int n3) throws Exception {
        if (this.fDeclHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.externalEntityDecl(string, string2, string3);
            }
        }
    }

    public void externalPEDecl(int n, int n2, int n3) throws Exception {
        if (this.fDeclHandler != null) {
            String string = "%" + this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.externalEntityDecl(string, string2, string3);
            }
        }
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    protected DeclHandler getDeclHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fDeclHandler;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith("http://xml.org/sax/features/")) {
            String string2 = string.substring("http://xml.org/sax/features/".length());
            if (string2.equals("namespace-prefixes")) {
                return this.getNamespacePrefixes();
            }
            if (string2.equals("string-interning")) {
                return false;
            }
        }
        return super.getFeature(string);
    }

    public String[] getFeaturesRecognized() {
        String[] stringArray = super.getFeaturesRecognized();
        String[] stringArray2 = RECOGNIZED_FEATURES;
        int n = stringArray2.length;
        if (n == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2 + n];
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        System.arraycopy(stringArray2, 0, stringArray3, n2, n);
        return stringArray3;
    }

    protected LexicalHandler getLexicalHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fLexicalHandler;
    }

    protected boolean getNamespacePrefixes() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fNamespacePrefixes;
    }

    public String[] getPropertiesRecognized() {
        String[] stringArray = super.getPropertiesRecognized();
        String[] stringArray2 = RECOGNIZED_PROPERTIES;
        int n = stringArray2.length;
        if (n == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2 + n];
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        System.arraycopy(stringArray2, 0, stringArray3, n2, n);
        return stringArray3;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith("http://xml.org/sax/properties/")) {
            String string2 = string.substring("http://xml.org/sax/properties/".length());
            if (string2.equals("lexical-handler")) {
                return this.getLexicalHandler();
            }
            if (string2.equals("declaration-handler")) {
                return this.getDeclHandler();
            }
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException("PAR014 Cannot getProperty(\"" + string + "\". No DOM Tree exists.\n" + string);
            }
        }
        return super.getProperty(string);
    }

    public void ignorableWhitespace(int n) throws Exception {
        throw new RuntimeException("PAR017 cannot happen 6\n6");
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(cArray, n, n2);
        }
        if (this.fContentHandler != null) {
            this.fContentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void internalEntityDecl(int n, int n2) throws Exception {
        if (this.fDeclHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.internalEntityDecl(string, string2);
            }
        }
    }

    public void internalPEDecl(int n, int n2) throws Exception {
        if (this.fDeclHandler != null) {
            String string = "%" + this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.internalEntityDecl(string, string2);
            }
        }
    }

    public void internalSubset(int n) {
    }

    public void notationDecl(int n, int n2, int n3) throws Exception {
        if (this.fDTDHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.notationDecl(string, string2, string3);
            }
        }
    }

    public void processingInstruction(int n, int n2) throws Exception {
        if (this.fDocumentHandler != null || this.fContentHandler != null) {
            String string;
            String string2 = this.fStringPool.orphanString(n);
            String string3 = string = n2 == -1 ? "" : this.fStringPool.orphanString(n2);
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.processingInstruction(string2, string);
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.processingInstruction(string2, string);
            }
        } else {
            this.fStringPool.releaseString(n);
            this.fStringPool.releaseString(n2);
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException();
        }
        this.fContentHandler = contentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler;
    }

    protected void setDeclHandler(DeclHandler declHandler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR011 Feature: http://xml.org/sax/properties/declaration-handler is not supported during parse.\nhttp://xml.org/sax/properties/declaration-handler");
        }
        this.fDeclHandler = declHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith("http://xml.org/sax/features/")) {
            String string2 = string.substring("http://xml.org/sax/features/".length());
            if (string2.equals("namespace-prefixes")) {
                this.setNamespacePrefixes(bl);
                return;
            }
            if (string2.equals("string-interning")) {
                if (bl) {
                    throw new SAXNotSupportedException("PAR018 " + bl + " state for feature \"" + string + "\" is not supported.\n" + bl + '\t' + string);
                }
                return;
            }
        }
        super.setFeature(string, bl);
    }

    protected void setLexicalHandler(LexicalHandler lexicalHandler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR011 Feature: http://xml.org/sax/properties/lexical-handler is not supported during parse.\nhttp://xml.org/sax/properties/lexical-handler");
        }
        this.fLexicalHandler = lexicalHandler;
    }

    protected void setNamespacePrefixes(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/namespace-prefixes): parse is in progress.\nhttp://xml.org/sax/features/namespace-prefixes");
        }
        this.fNamespacePrefixes = bl;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith("http://xml.org/sax/properties/")) {
            String string2 = string.substring("http://xml.org/sax/properties/".length());
            if (string2.equals("lexical-handler")) {
                try {
                    this.setLexicalHandler((LexicalHandler)object);
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException("PAR012 For propertyID \"" + string + "\", the value \"" + object + "\" cannot be cast to LexicalHandler." + '\n' + string + '\t' + object + "\tLexicalHandler");
                }
                return;
            }
            if (string2.equals("declaration-handler")) {
                try {
                    this.setDeclHandler((DeclHandler)object);
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException("PAR012 For propertyID \"" + string + "\", the value \"" + object + "\" cannot be cast to DeclHandler." + '\n' + string + '\t' + object + "\tDeclHandler");
                }
                return;
            }
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException("PAR013 Property \"" + string + "\" is read only." + '\n' + string);
            }
        }
        super.setProperty(string, object);
    }

    public void startCDATA() throws Exception {
        if (this.fLexicalHandler != null) {
            this.fLexicalHandler.startCDATA();
        }
    }

    public void startDTD(QName qName, int n, int n2) throws Exception {
        if (this.fLexicalHandler != null) {
            String string = this.fStringPool.toString(qName.rawname);
            String string2 = this.fStringPool.toString(n);
            String string3 = this.fStringPool.toString(n2);
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startDTD(string, string2, string3);
            }
        }
    }

    public void startDocument() throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.setDocumentLocator(this.getLocator());
            this.fDocumentHandler.startDocument();
        }
        if (this.fContentHandler != null) {
            this.fContentHandler.setDocumentLocator(this.getLocator());
            this.fContentHandler.startDocument();
        }
    }

    public void startElement(QName qName, XMLAttrList xMLAttrList, int n) throws Exception {
        String string = this.fStringPool.toString(qName.rawname);
        AttributeList attributeList = xMLAttrList.getAttributeList(n);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(string, attributeList);
        }
        if (this.fContentHandler != null) {
            boolean bl = this.getNamespaces();
            int n2 = qName.uri;
            String string2 = n2 != -1 && bl ? this.fStringPool.toString(n2) : "";
            int n3 = qName.localpart;
            String string3 = n3 != -1 && bl ? this.fStringPool.toString(n3) : "";
            String string4 = string;
            this.fAttributes.clear();
            int n4 = xMLAttrList.getFirstAttr(n);
            while (n4 != -1) {
                int n5 = xMLAttrList.getAttrName(n4);
                int n6 = xMLAttrList.getAttrURI(n4);
                String string5 = n6 != -1 && bl ? this.fStringPool.toString(n6) : "";
                int n7 = xMLAttrList.getAttrLocalpart(n4);
                String string6 = n7 != -1 && bl ? this.fStringPool.toString(n7) : "";
                String string7 = this.fStringPool.toString(n5);
                String string8 = this.fStringPool.toString(xMLAttrList.getAttType(n4));
                String string9 = this.fStringPool.toString(xMLAttrList.getAttValue(n4));
                int n8 = xMLAttrList.getAttrPrefix(n4);
                boolean bl2 = this.getNamespacePrefixes();
                if (!bl || bl2 || n8 != this.fStringPool.addSymbol("xmlns") && n7 != this.fStringPool.addSymbol("xmlns")) {
                    this.fAttributes.addAttribute(string5, string6, string7, string8, string9);
                }
                n4 = xMLAttrList.getNextAttr(n4);
            }
            this.fContentHandler.startElement(string2, string3, string4, this.fAttributes);
        }
        xMLAttrList.releaseAttrList(n);
    }

    public void startEntityReference(int n, int n2, int n3) throws Exception {
        if (this.fLexicalHandler != null) {
            switch (n2) {
                case 0: 
                case 1: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.startEntity("%" + this.fStringPool.toString(n));
                    break;
                }
                case 2: 
                case 3: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.startEntity(this.fStringPool.toString(n));
                    break;
                }
                case 4: {
                    throw new RuntimeException("PAR015 startEntityReference(): ENTITYTYPE_UNPARSED");
                }
                case 6: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.startEntity("[dtd]");
                    break;
                }
            }
        }
    }

    public void startNamespaceDeclScope(int n, int n2) throws Exception {
        if (this.fContentHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            if (this.fContentHandler != null) {
                this.fContentHandler.startPrefixMapping(string, string2);
            }
        }
    }

    public void textDecl(int n, int n2) throws Exception {
        this.fStringPool.releaseString(n);
        this.fStringPool.releaseString(n2);
    }

    public void unparsedEntityDecl(int n, int n2, int n3, int n4) throws Exception {
        if (this.fDTDHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            String string4 = this.fStringPool.toString(n4);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.unparsedEntityDecl(string, string2, string3, string4);
            }
        }
    }

    public void xmlDecl(int n, int n2, int n3) throws Exception {
        this.fStringPool.releaseString(n);
        this.fStringPool.releaseString(n2);
        this.fStringPool.releaseString(n3);
    }
}

