/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class DecimalDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    private DatatypeValidator fBaseValidator = null;
    private boolean fDerivationByList = false;
    private BigDecimal[] fEnumDecimal = null;
    private String fPattern = null;
    private BigDecimal fMaxInclusive = null;
    private BigDecimal fMaxExclusive = null;
    private BigDecimal fMinInclusive = null;
    private BigDecimal fMinExclusive = null;
    private int fFacetsDefined = 0;
    private int fScale = 0;
    private int fPrecision = 0;
    private boolean isMaxExclusiveDefined = false;
    private boolean isMaxInclusiveDefined = false;
    private boolean isMinExclusiveDefined = false;
    private boolean isMinInclusiveDefined = false;
    private boolean isScaleDefined = false;
    private boolean isPrecisionDefined = false;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();

    public DecimalDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public DecimalDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        if (hashtable != null && !bl) {
            Object object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                String string = (String)hashtable.get(object);
                try {
                    if (((String)object).equals("pattern")) {
                        this.fFacetsDefined += 8;
                        this.fPattern = string;
                        continue;
                    }
                    if (((String)object).equals("enumeration")) {
                        this.fFacetsDefined += 16;
                        continue;
                    }
                    if (((String)object).equals("maxInclusive")) {
                        this.fFacetsDefined += 32;
                        this.fMaxInclusive = new BigDecimal(string);
                        continue;
                    }
                    if (((String)object).equals("maxExclusive")) {
                        this.fFacetsDefined += 64;
                        this.fMaxExclusive = new BigDecimal(string);
                        continue;
                    }
                    if (((String)object).equals("minInclusive")) {
                        this.fFacetsDefined += 128;
                        this.fMinInclusive = new BigDecimal(string);
                        continue;
                    }
                    if (((String)object).equals("minExclusive")) {
                        this.fFacetsDefined += 128;
                        this.fMinExclusive = new BigDecimal(string);
                        continue;
                    }
                    if (((String)object).equals("precision")) {
                        this.fFacetsDefined += 512;
                        this.isPrecisionDefined = true;
                        this.fPrecision = Integer.parseInt(string);
                        continue;
                    }
                    if (((String)object).equals("scale")) {
                        this.fFacetsDefined += 1024;
                        this.isScaleDefined = true;
                        this.fScale = Integer.parseInt(string);
                        continue;
                    }
                    throw new InvalidDatatypeFacetException(this.getErrorString(1, 0, null));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                }
            }
            this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
            this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x20) != 0;
            this.isMinExclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
            boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
            if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
            }
            if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
            }
            if ((this.fFacetsDefined & 0x10) != 0 && (object = (Vector)hashtable.get("enumeration")) != null) {
                this.fEnumDecimal = new BigDecimal[((Vector)object).size()];
                int n = 0;
                while (n < ((Vector)object).size()) {
                    try {
                        this.fEnumDecimal[n] = new BigDecimal((String)((Vector)object).elementAt(n));
                        this.boundsCheck(this.fEnumDecimal[n]);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("Internal Error parsing enumerated values for Decimal type");
                    }
                    ++n;
                }
            }
        }
    }

    private void boundsCheck(BigDecimal bigDecimal) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isMaxInclusiveDefined) {
            bl2 = bigDecimal.compareTo(this.fMaxInclusive) <= 0;
        } else if (this.isMaxExclusiveDefined) {
            bl2 = bigDecimal.compareTo(this.fMaxExclusive) < 0;
        } else {
            boolean bl3 = bl2 = !this.isMaxInclusiveDefined && !this.isMaxExclusiveDefined;
        }
        if (this.isMinInclusiveDefined) {
            bl = bigDecimal.compareTo(this.fMinInclusive) >= 0;
        } else if (this.isMinExclusiveDefined) {
            bl = bigDecimal.compareTo(this.fMinInclusive) > 0;
        } else {
            boolean bl4 = bl = !this.isMinInclusiveDefined && !this.isMinExclusiveDefined;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(9, 0, new Object[]{bigDecimal}));
        }
    }

    public int compare(String string, String string2) {
        return 0;
    }

    private void enumCheck(BigDecimal bigDecimal) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < this.fEnumDecimal.length) {
            if (bigDecimal == this.fEnumDecimal[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{bigDecimal}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    public Hashtable getFacets() {
        return null;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (!this.fDerivationByList) {
            int n;
            BigDecimal bigDecimal = null;
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidDatatypeValueException(this.getErrorString(3, 0, new Object[]{string}));
            }
            if (this.isScaleDefined && bigDecimal.scale() > this.fScale) {
                throw new InvalidDatatypeValueException(this.getErrorString(17, 0, new Object[]{string}));
            }
            if (this.isPrecisionDefined && (n = bigDecimal.movePointRight(bigDecimal.scale()).toString().length() - (bigDecimal.signum() < 0 ? 1 : 0)) > this.fPrecision) {
                throw new InvalidDatatypeValueException(this.getErrorString(16, 0, new Object[]{string}));
            }
            this.boundsCheck(bigDecimal);
            if (this.fEnumDecimal != null) {
                this.enumCheck(bigDecimal);
            }
        }
        return null;
    }
}

