/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import org.apache.xalan.xpath.Function;
import org.apache.xalan.xpath.XNumber;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XString;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FuncSystemProperty
extends Function {
    Properties xsltInfo = new Properties();
    static String XSLT_PROPERTIES = "/org/apache/xalan/xpath/xml/XSLTInfo.properties";

    public XObject execute(XPath path, XPathSupport execContext, Node context, int opPos, Vector args) throws SAXException {
        String result;
        String fullName = ((XObject)args.elementAt(0)).str();
        int indexOfNSSep = fullName.indexOf(58);
        String propName = "";
        this.loadPropertyFile(XSLT_PROPERTIES, this.xsltInfo);
        if (indexOfNSSep > 0) {
            String prefix = indexOfNSSep >= 0 ? fullName.substring(0, indexOfNSSep) : "";
            String namespace = execContext.getNamespaceContext().getNamespaceForPrefix(prefix);
            String string = propName = indexOfNSSep < 0 ? fullName : fullName.substring(indexOfNSSep + 1);
            if (namespace.startsWith("http://www.w3.org/XSL/Transform") || namespace.equals("http://www.w3.org/1999/XSL/Transform")) {
                result = this.xsltInfo.getProperty(propName);
                if (result == null) {
                    path.warn(2, new Object[]{fullName});
                    result = "";
                }
            } else {
                path.warn(3, new Object[]{namespace, fullName});
                try {
                    result = System.getProperty(propName);
                    if (result == null) {
                        result = "";
                    }
                }
                catch (SecurityException securityException) {
                    path.warn(4, new Object[]{fullName});
                    result = "";
                }
            }
        } else {
            try {
                result = System.getProperty(fullName);
                if (result == null) {
                    result = "";
                }
            }
            catch (SecurityException securityException) {
                path.warn(4, new Object[]{fullName});
                result = "";
            }
        }
        if (propName.equals("version") && result.length() > 0) {
            try {
                return new XNumber(new Double(result));
            }
            catch (Exception exception) {
                return new XString(result);
            }
        }
        return new XString(result);
    }

    public void loadPropertyFile(String file, Properties target) {
        try {
            InputStream is = this.getClass().getResourceAsStream(file);
            BufferedInputStream bis = new BufferedInputStream(is);
            target.load(bis);
            ((FilterInputStream)bis).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

