/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XRTreeFrag
extends XObject {
    public XRTreeFrag(DocumentFragment frag) {
        super(frag);
    }

    public int getType() {
        return 5;
    }

    private String getTypeString() {
        return "#RTREEFRAG";
    }

    public double num() {
        double result;
        NumberFormat m_formatter = NumberFormat.getNumberInstance();
        String s = XMLParserLiaisonDefault.getNodeData((DocumentFragment)this.m_obj);
        if (s != null) {
            try {
                Number n = m_formatter.parse(s.trim());
                result = n.doubleValue();
            }
            catch (ParseException parseException) {
                result = Double.NaN;
            }
        } else {
            result = Double.NaN;
        }
        return result;
    }

    public boolean bool() {
        boolean result = false;
        NodeList nl = ((DocumentFragment)this.m_obj).getChildNodes();
        int nChildren = nl.getLength();
        int i = 0;
        while (i < nChildren) {
            Node n = nl.item(i);
            if (n.getNodeType() != 3 || ((Text)n).getData().trim().length() != 0) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public String str() {
        String str = XMLParserLiaisonDefault.getNodeData((DocumentFragment)this.m_obj);
        return str == null ? "" : str;
    }

    public DocumentFragment rtree() {
        return (DocumentFragment)this.m_obj;
    }

    public NodeList convertToNodeset() {
        return ((DocumentFragment)this.m_obj).getChildNodes();
    }

    public boolean equals(XObject obj2) throws SAXException {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        if (obj2.getType() == 1) {
            return this.bool() == obj2.bool();
        }
        if (obj2.getType() == 2) {
            return this.num() == obj2.num();
        }
        if (obj2.getType() == 4) {
            return this.str().equals(obj2.str());
        }
        if (obj2.getType() == 3) {
            return this.str().equals(obj2.str());
        }
        if (obj2.getType() == 5) {
            return this.str().equals(obj2.str());
        }
        return super.equals(obj2);
    }
}

