/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.Writer;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class FormatterToDOM
implements DocumentHandler {
    Document m_doc;
    Node m_currentNode;
    public DocumentFragment m_docFrag;
    Stack m_elemStack = new Stack();

    public FormatterToDOM(Document doc, Element elem) {
        this.m_doc = doc;
        this.m_currentNode = elem;
    }

    public FormatterToDOM(Document doc, DocumentFragment docFrag) {
        this.m_doc = doc;
        this.m_docFrag = docFrag;
    }

    public FormatterToDOM(Document doc) {
        this.m_doc = doc;
    }

    public Node getRootNode() {
        return this.m_docFrag != null ? this.m_docFrag : this.m_doc;
    }

    public Writer getWriter() {
        return null;
    }

    private void append(Node newNode) {
        if (this.m_currentNode != null) {
            this.m_currentNode.appendChild(newNode);
        } else if (this.m_docFrag != null) {
            this.m_docFrag.appendChild(newNode);
        } else {
            this.m_doc.appendChild(newNode);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        Element elem = this.m_doc.createElement(name);
        int nAtts = atts.getLength();
        int i = 0;
        while (i < nAtts) {
            elem.setAttribute(atts.getName(i), atts.getValue(i));
            ++i;
        }
        this.append(elem);
        this.m_elemStack.push(elem);
        this.m_currentNode = elem;
    }

    public void endElement(String name) throws SAXException {
        this.m_elemStack.pop();
        this.m_currentNode = !this.m_elemStack.isEmpty() ? (Element)this.m_elemStack.peek() : null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        Text text = this.m_doc.createTextNode(s);
        this.append(text);
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(this.m_doc.createTextNode(s));
    }

    public void entityReference(String name) throws SAXException {
        this.append(this.m_doc.createEntityReference(name));
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        this.append(this.m_doc.createTextNode(s));
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.append(this.m_doc.createProcessingInstruction(target, data));
    }

    public void comment(String data) throws SAXException {
        this.append(this.m_doc.createComment(data));
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        this.append(this.m_doc.createCDATASection(s));
    }
}

