/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.Serializable;
import java.util.Stack;
import org.apache.xalan.xpath.xml.NameSpace;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.w3c.dom.Element;

public class QName
implements Serializable {
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    public String m_namespace = null;
    public String m_localpart;
    int m_hashCode;

    public int hashCode() {
        return this.m_hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof QName)) return false;
        QName qname = (QName)obj;
        if (!this.m_localpart.equals(qname.m_localpart)) return false;
        if (this.m_namespace == null || qname.m_namespace == null) {
            if (this.m_namespace != null) return false;
            if (qname.m_namespace == null) return true;
            return false;
        }
        boolean bl = this.m_namespace.equals(qname.m_namespace);
        if (bl) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(String ns, String localPart) {
        if (!this.m_localpart.equals(localPart)) return false;
        if (this.m_namespace == null || ns == null) {
            if (this.m_namespace != null) return false;
            if (ns == null) return true;
            return false;
        }
        boolean bl = this.m_namespace.equals(ns);
        if (bl) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(QName qname) {
        if (!this.m_localpart.equals(qname.m_localpart)) return false;
        if (this.m_namespace == null || qname.m_namespace == null) {
            if (this.m_namespace != null) return false;
            if (qname.m_namespace == null) return true;
            return false;
        }
        boolean bl = this.m_namespace.equals(qname.m_namespace);
        if (bl) return true;
        return false;
    }

    public QName(String qname, Stack namespaces) {
        int indexOfNSSep = qname.indexOf(58);
        if (indexOfNSSep > 0) {
            String prefix = qname.substring(0, indexOfNSSep);
            if (prefix.equals("xml")) {
                this.m_namespace = S_XMLNAMESPACEURI;
            } else {
                if (prefix.equals("xmlns")) {
                    return;
                }
                int depth = namespaces.size();
                int i = depth - 1;
                while (i >= 0) {
                    NameSpace ns = (NameSpace)namespaces.elementAt(i);
                    while (ns != null) {
                        if (ns.m_prefix != null && prefix.equals(ns.m_prefix)) {
                            this.m_namespace = ns.m_uri;
                            i = -1;
                            break;
                        }
                        ns = ns.m_next;
                    }
                    --i;
                }
            }
            if (this.m_namespace == null) {
                throw new RuntimeException("Prefix must resolve to a namespace: " + prefix);
            }
        }
        String string = this.m_localpart = indexOfNSSep < 0 ? qname : qname.substring(indexOfNSSep + 1);
        if (this.m_namespace == null) {
            this.m_hashCode = this.m_localpart.hashCode();
        } else {
            String hashString = String.valueOf(this.m_namespace) + this.m_localpart;
            this.m_hashCode = hashString.hashCode();
        }
    }

    public QName(String qname, Element namespaceContext, PrefixResolver resolver) {
        int indexOfNSSep = qname.indexOf(58);
        if (indexOfNSSep > 0 && namespaceContext != null) {
            String prefix = qname.substring(0, indexOfNSSep);
            this.m_namespace = prefix.equals("xml") ? S_XMLNAMESPACEURI : resolver.getNamespaceForPrefix(prefix, namespaceContext);
            if (this.m_namespace == null) {
                throw new RuntimeException("Prefix must resolve to a namespace: " + prefix);
            }
        }
        String string = this.m_localpart = indexOfNSSep < 0 ? qname : qname.substring(indexOfNSSep + 1);
        if (this.m_namespace == null) {
            this.m_hashCode = this.m_localpart.hashCode();
        } else {
            String hashString = String.valueOf(this.m_namespace) + this.m_localpart;
            this.m_hashCode = hashString.hashCode();
        }
    }

    public QName(String qname, PrefixResolver resolver) {
        int indexOfNSSep = qname.indexOf(58);
        if (indexOfNSSep > 0) {
            String prefix = qname.substring(0, indexOfNSSep);
            this.m_namespace = prefix.equals("xml") ? S_XMLNAMESPACEURI : resolver.getNamespaceForPrefix(prefix);
            if (this.m_namespace == null) {
                throw new RuntimeException("Prefix must resolve to a namespace: " + prefix);
            }
        }
        String string = this.m_localpart = indexOfNSSep < 0 ? qname : qname.substring(indexOfNSSep + 1);
        if (this.m_namespace == null) {
            this.m_hashCode = this.m_localpart.hashCode();
        } else {
            String hashString = String.valueOf(this.m_namespace) + this.m_localpart;
            this.m_hashCode = hashString.hashCode();
        }
    }

    public String toString() {
        return this.m_namespace != null ? String.valueOf(this.m_namespace) + ":" + this.m_localpart : this.m_localpart;
    }
}

