/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import org.apache.xalan.xpath.xml.AttList;
import org.apache.xalan.xpath.xml.RawCharacterHandler;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.misc.LexicalHandler;

public class TreeWalker {
    private DocumentHandler m_formatterListener;
    boolean nextIsRaw = false;

    public TreeWalker(DocumentHandler formatterListener) {
        this.m_formatterListener = formatterListener;
    }

    public void traverse(Node pos) throws SAXException {
        Node top = pos;
        while (pos != null) {
            this.startNode(pos);
            Node nextNode = pos.getFirstChild();
            while (nextNode == null) {
                this.endNode(pos);
                if (top.equals(pos)) break;
                nextNode = pos.getNextSibling();
                if (nextNode != null || (pos = pos.getParentNode()) != null && !top.equals(pos)) continue;
                if (pos != null) {
                    this.endNode(pos);
                }
                nextNode = null;
                break;
            }
            pos = nextNode;
        }
    }

    public void traverse(Node pos, Node parent) throws SAXException {
        Node top = parent;
        while (pos != null) {
            this.startNode(pos);
            Node nextNode = pos.getFirstChild();
            while (nextNode == null) {
                this.endNode(pos);
                if (top == pos) break;
                nextNode = pos.getNextSibling();
                if (nextNode != null || parent != (pos = pos.getParentNode()) && pos != null) continue;
                nextNode = pos;
                break;
            }
            pos = nextNode;
        }
    }

    protected void startNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 8: {
                String data = ((Comment)node).getData();
                if (!(this.m_formatterListener instanceof LexicalHandler)) break;
                LexicalHandler lh = (LexicalHandler)this.m_formatterListener;
                lh.comment(data.toCharArray(), 0, data.length());
                break;
            }
            case 9: {
                this.m_formatterListener.startDocument();
                break;
            }
            case 1: {
                NamedNodeMap atts = ((Element)node).getAttributes();
                this.m_formatterListener.startElement(node.getNodeName(), new AttList(atts));
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                String name = pi.getNodeName();
                String data = pi.getData();
                if (name.equals("xslt-next-is-raw") && name.equals("formatter-to-dom")) {
                    this.nextIsRaw = true;
                    break;
                }
                this.m_formatterListener.processingInstruction(pi.getNodeName(), pi.getData());
                break;
            }
            case 4: {
                LexicalHandler lh;
                String data = ((Text)node).getData();
                boolean isLexH = this.m_formatterListener instanceof LexicalHandler;
                LexicalHandler lexicalHandler = lh = isLexH ? (LexicalHandler)this.m_formatterListener : null;
                if (isLexH) {
                    lh.startCDATA();
                }
                this.m_formatterListener.characters(data.toCharArray(), 0, data.length());
                if (!isLexH) break;
                lh.endCDATA();
                break;
            }
            case 3: {
                String data = ((Text)node).getData();
                if (this.nextIsRaw) {
                    this.nextIsRaw = false;
                    if (this.m_formatterListener instanceof RawCharacterHandler) {
                        ((RawCharacterHandler)((Object)this.m_formatterListener)).charactersRaw(data.toCharArray(), 0, data.length());
                        break;
                    }
                    System.out.println("Warning: can't output raw characters!");
                    this.m_formatterListener.characters(data.toCharArray(), 0, data.length());
                    break;
                }
                this.m_formatterListener.characters(data.toCharArray(), 0, data.length());
                break;
            }
            case 5: {
                EntityReference eref = (EntityReference)node;
                if (!(this.m_formatterListener instanceof LexicalHandler)) break;
                ((LexicalHandler)this.m_formatterListener).startEntity(eref.getNodeName());
                break;
            }
        }
    }

    protected void endNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                this.m_formatterListener.endDocument();
                break;
            }
            case 1: {
                this.m_formatterListener.endElement(node.getNodeName());
                break;
            }
            case 5: {
                EntityReference eref = (EntityReference)node;
                if (!(this.m_formatterListener instanceof LexicalHandler)) break;
                LexicalHandler lh = (LexicalHandler)this.m_formatterListener;
                lh.endEntity(eref.getNodeName());
                break;
            }
        }
    }
}

