/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xslt.AVT;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class ElemAttribute
extends ElemTemplateElement {
    public AVT m_name_avt;
    public AVT m_namespace_avt;

    public int getXSLToken() {
        return 48;
    }

    ElemAttribute(XSLTEngineImpl processor, Stylesheet stylesheetTree, String name, AttributeList atts, int lineNumber, int columnNumber) throws SAXException {
        super(processor, stylesheetTree, name, atts, lineNumber, columnNumber);
        int nAttrs = atts.getLength();
        int i = 0;
        while (i < nAttrs) {
            String aname = atts.getName(i);
            if (aname.equals("name")) {
                this.m_name_avt = new AVT(aname, atts.getType(i), atts.getValue(i), this, this.m_stylesheet, processor);
            } else if (aname.equals("namespace")) {
                this.m_namespace_avt = new AVT(aname, atts.getType(i), atts.getValue(i), this, this.m_stylesheet, processor);
            } else if (!this.isAttrOK(aname, atts, i) && !this.processSpaceAttr(aname, atts, i)) {
                processor.error(2, new Object[]{name, aname});
            }
            ++i;
        }
        if (this.m_name_avt == null) {
            processor.error(6, new Object[]{name});
        }
    }

    public void execute(XSLTEngineImpl processor, Node sourceTree, Node sourceNode, QName mode) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        super.execute(processor, sourceTree, sourceNode, mode);
        XMLParserLiaison execContext = processor.getXMLProcessorLiaison();
        String attrName = this.m_name_avt.evaluate(execContext, sourceNode, this, new StringBuffer());
        if (attrName != null) {
            String attrNameSpace;
            if (this.m_namespace_avt != null && (attrNameSpace = this.m_namespace_avt.evaluate(execContext, sourceNode, this, new StringBuffer())) != null) {
                String prefix = processor.getResultPrefixForNamespace(attrNameSpace);
                if (prefix == null) {
                    prefix = "ns" + String.valueOf(processor.m_uniqueNSValue);
                    ++processor.m_uniqueNSValue;
                    String nsDecl = "xmlns:" + prefix;
                    processor.addResultAttribute(processor.m_pendingAttributes, nsDecl, attrNameSpace);
                }
                attrName = String.valueOf(prefix) + ":" + attrName;
            }
            if (processor.m_pendingElementName != null) {
                String val = this.childrenToString(processor, sourceTree, sourceNode, mode);
                this.addResultAttribute(processor.m_resultNameSpaces, processor.m_pendingAttributes, attrName, val);
            }
        }
    }

    public Node appendChild(Node newChild) throws DOMException {
        int type = ((ElemTemplateElement)newChild).getXSLToken();
        switch (type) {
            default: {
                this.error(4, new Object[]{((ElemTemplateElement)newChild).m_elemName, this.m_elemName});
            }
            case 9: 
            case 17: 
            case 28: 
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 50: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
        }
        return super.appendChild(newChild);
    }
}

