/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.xml.NameSpace;
import org.apache.xalan.xpath.xml.StringToStringTable;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xalan.xslt.ElemApplyImport;
import org.apache.xalan.xslt.ElemApplyTemplates;
import org.apache.xalan.xslt.ElemAttribute;
import org.apache.xalan.xslt.ElemAttributeSet;
import org.apache.xalan.xslt.ElemCallTemplate;
import org.apache.xalan.xslt.ElemChoose;
import org.apache.xalan.xslt.ElemComment;
import org.apache.xalan.xslt.ElemCopy;
import org.apache.xalan.xslt.ElemCopyOf;
import org.apache.xalan.xslt.ElemDecimalFormat;
import org.apache.xalan.xslt.ElemElement;
import org.apache.xalan.xslt.ElemEmpty;
import org.apache.xalan.xslt.ElemExtensionCall;
import org.apache.xalan.xslt.ElemFallback;
import org.apache.xalan.xslt.ElemForEach;
import org.apache.xalan.xslt.ElemIf;
import org.apache.xalan.xslt.ElemLiteralResult;
import org.apache.xalan.xslt.ElemMessage;
import org.apache.xalan.xslt.ElemNumber;
import org.apache.xalan.xslt.ElemOtherwise;
import org.apache.xalan.xslt.ElemPI;
import org.apache.xalan.xslt.ElemParam;
import org.apache.xalan.xslt.ElemSort;
import org.apache.xalan.xslt.ElemTemplate;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.ElemText;
import org.apache.xalan.xslt.ElemTextLiteral;
import org.apache.xalan.xslt.ElemUse;
import org.apache.xalan.xslt.ElemValueOf;
import org.apache.xalan.xslt.ElemVariable;
import org.apache.xalan.xslt.ElemWhen;
import org.apache.xalan.xslt.ElemWithParam;
import org.apache.xalan.xslt.ExtensionNSHandler;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.apache.xalan.xslt.res.XSLTErrorResources;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class StylesheetHandler
implements DocumentHandler {
    XSLTEngineImpl m_processor;
    Stylesheet m_stylesheet;
    Stack m_elems = new Stack();
    Stack m_whiteSpaceElems = new Stack();
    ElemTemplate m_template;
    ElemTemplateElement m_lastPopped;
    boolean m_inTemplate = false;
    boolean m_foundStylesheet = false;
    boolean m_foundNotImport = false;
    boolean m_inLXSLTScript = false;
    StringBuffer m_LXSLTScriptBody;
    String m_LXSLTScriptLang;
    String m_LXSLTScriptSrcURL;
    ExtensionNSHandler m_LXSLTExtensionNSH;
    public String m_includeBase;
    private boolean warnedAboutOldXSLTNamespace = false;
    static final String m_oldXSLNameSpaceURL = "http://www.w3.org/XSL/Transform/1.0";

    public StylesheetHandler(XSLTEngineImpl processor, Stylesheet stylesheetTree) {
        this.m_processor = processor;
        this.m_stylesheet = stylesheetTree;
        this.m_includeBase = this.m_stylesheet.m_baseIdent;
    }

    public void setDocumentLocator(Locator locator) {
        this.m_processor.m_stylesheetLocatorStack.push(locator);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        if (!this.m_processor.m_stylesheetLocatorStack.empty()) {
            Locator locator = (Locator)this.m_processor.m_stylesheetLocatorStack.pop();
        }
    }

    boolean isAttrOK(String attrName, AttributeList atts, int which) {
        return this.m_stylesheet.isAttrOK(attrName, atts, which);
    }

    boolean processSpaceAttr(String aname, AttributeList atts, int which) throws SAXException {
        boolean isSpaceAttr = aname.equals("xml:space");
        if (isSpaceAttr) {
            String spaceVal = atts.getValue(which);
            if (spaceVal.equals("default")) {
                this.m_stylesheet.m_defaultSpace = true;
            } else if (spaceVal.equals("preserve")) {
                this.m_stylesheet.m_defaultSpace = false;
            } else {
                throw new SAXException(XSLMessages.createMessage(85, new Object[]{spaceVal}));
            }
        }
        return isSpaceAttr;
    }

    private boolean isXSLTNameSpace(String ns) throws SAXException {
        boolean isXSLT;
        boolean isOld = false;
        boolean bl = isXSLT = ns != null && (ns.equals("http://www.w3.org/1999/XSL/Transform") || (isOld = ns.equals(m_oldXSLNameSpaceURL)));
        if (isOld && !this.warnedAboutOldXSLTNamespace) {
            this.warnedAboutOldXSLTNamespace = true;
            this.m_processor.warn(18, new Object[]{ns});
        }
        return isXSLT;
    }

    private String getLocalName(String name) {
        int index = name.indexOf(58);
        return index < 0 ? name : name.substring(index + 1);
    }

    private void processStripAndPreserve(String name, AttributeList atts, int xslToken, int lineNumber, int columnNumber) throws SAXException {
        ElemEmpty nsNode = new ElemEmpty(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
        int nAttrs = atts.getLength();
        boolean foundIt = false;
        int i = 0;
        while (i < nAttrs) {
            String aname = atts.getName(i);
            if (aname.equals("elements")) {
                foundIt = true;
                StringTokenizer tokenizer = new StringTokenizer(atts.getValue(i), " \t\n\r");
                while (tokenizer.hasMoreTokens()) {
                    String wildcardName = tokenizer.nextToken();
                    XPath matchPat = this.m_stylesheet.createMatchPattern(wildcardName, nsNode);
                    if (xslToken == 33) {
                        if (this.m_stylesheet.m_stylesheetRoot.m_whitespacePreservingElements == null) {
                            this.m_stylesheet.m_stylesheetRoot.m_whitespacePreservingElements = new Vector();
                        }
                        this.m_stylesheet.m_stylesheetRoot.m_whitespacePreservingElements.addElement(matchPat);
                        continue;
                    }
                    if (this.m_stylesheet.m_stylesheetRoot.m_whitespaceStrippingElements == null) {
                        this.m_stylesheet.m_stylesheetRoot.m_whitespaceStrippingElements = new Vector();
                    }
                    this.m_stylesheet.m_stylesheetRoot.m_whitespaceStrippingElements.addElement(matchPat);
                }
            } else if (!this.isAttrOK(aname, atts, i)) {
                this.m_stylesheet.error(2, new Object[]{name, aname});
            }
            ++i;
        }
        if (!foundIt) {
            throw new SAXException(XSLMessages.createMessage(33, new Object[]{name, "elements"}));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String name, AttributeList atts) throws SAXException {
        int origStackSize;
        ElemTemplateElement elem;
        int columnNumber;
        int lineNumber;
        block112: {
            String localName;
            String ns;
            block113: {
                int xslToken;
                block114: {
                    Object obj;
                    XSLTErrorResources resbundle = XSLTErrorResources.loadResourceBundle("org.apache.xalan.xslt.res.XSLTErrorResources");
                    this.m_whiteSpaceElems.removeAllElements();
                    Locator locator = this.m_processor.m_stylesheetLocatorStack.isEmpty() ? null : (Locator)this.m_processor.m_stylesheetLocatorStack.peek();
                    lineNumber = locator != null ? locator.getLineNumber() : 0;
                    columnNumber = locator != null ? locator.getColumnNumber() : 0;
                    this.m_stylesheet.pushNamespaces(atts);
                    ns = this.m_stylesheet.getNamespaceFromStack(name);
                    localName = this.getLocalName(name);
                    elem = null;
                    origStackSize = this.m_elems.size();
                    if (!this.isXSLTNameSpace(ns)) break block113;
                    if (this.m_stylesheet.m_XSLNameSpaceURL != null) {
                        this.m_stylesheet.m_XSLNameSpaceURL = ns;
                    }
                    if (!this.m_foundStylesheet) {
                        this.m_stylesheet.initXSLTKeys();
                        this.m_stylesheet.m_stylesheetRoot.initDefaultRule();
                        this.m_stylesheet.getTemplateList().setIsWrapperless(false);
                    }
                    int n = xslToken = (obj = Stylesheet.m_elementKeys.get(localName)) != null ? (Integer)obj : -2;
                    if (this.m_inTemplate) break block114;
                    if (this.m_foundStylesheet && xslToken != 26) {
                        this.m_foundNotImport = true;
                    }
                    switch (xslToken) {
                        case 19: {
                            this.m_template = new ElemTemplate(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                            this.m_elems.push(this.m_template);
                            this.m_inTemplate = true;
                            this.m_stylesheet.getTemplateList().addTemplate(this.m_template);
                            break block112;
                        }
                        case 65: {
                            this.m_processor.m_translateCSS = true;
                            break block112;
                        }
                        case 54: {
                            if (ns != null && !ns.equals("http://xml.apache.org/xslt") && !ns.equals("http://xsl.lotus.com/")) {
                                this.m_processor.warn(9, new Object[]{"http://xml.apache.org/xslt"});
                            }
                            break block112;
                        }
                        case 41: 
                        case 73: {
                            ElemVariable elemVariable = xslToken == 41 ? new ElemParam(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber) : new ElemVariable(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                            this.m_elems.push(elemVariable);
                            this.m_inTemplate = true;
                            this.m_stylesheet.setTopLevelVariable(elemVariable);
                            elemVariable.m_isTopLevel = true;
                            break block112;
                        }
                        case 76: {
                            this.m_processor.warn(88);
                            break block112;
                        }
                        case 32: 
                        case 33: {
                            this.processStripAndPreserve(name, atts, xslToken, lineNumber, columnNumber);
                            break block112;
                        }
                        case 31: {
                            ElemEmpty elemEmpty = new ElemEmpty(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                            this.m_stylesheet.processKeyElement(elemEmpty, atts);
                            break block112;
                        }
                        case 40: {
                            this.m_inTemplate = true;
                            ElemAttributeSet elemAttributeSet = new ElemAttributeSet(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                            this.m_elems.push(elemAttributeSet);
                            break block112;
                        }
                        case 27: {
                            this.processInclude(name, atts);
                            break block112;
                        }
                        case 26: {
                            this.processImport(name, atts);
                            break block112;
                        }
                        case 80: {
                            this.m_stylesheet.m_stylesheetRoot.processOutputSpec(name, atts);
                            break block112;
                        }
                        case 83: {
                            ElemDecimalFormat edf = new ElemDecimalFormat(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                            this.m_stylesheet.processDecimalFormatElement(edf, atts);
                            break block112;
                        }
                        case 84: {
                            this.m_stylesheet.processNSAliasElement(name, atts);
                            break block112;
                        }
                        case 2: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 12: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 28: 
                        case 30: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 42: 
                        case 46: 
                        case 48: 
                        case 50: 
                        case 58: 
                        case 59: 
                        case 64: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 71: 
                        case 72: 
                        case 74: 
                        case 75: {
                            throw new SAXException(XSLMessages.createMessage(62, new Object[]{name}));
                        }
                        case 25: {
                            this.m_stylesheet.getTemplateList().setIsWrapperless(false);
                            this.m_foundStylesheet = true;
                            int nAttrs = atts.getLength();
                            boolean didSpecifiyIndent = false;
                            int i = 0;
                            while (i < nAttrs) {
                                String aname = atts.getName(i);
                                if (aname.equals("result-ns")) {
                                    throw new SAXException(XSLMessages.createMessage(63, null));
                                }
                                if (aname.equals("default-space")) {
                                    throw new SAXException(XSLMessages.createMessage(64, null));
                                }
                                if (aname.equals("exclude-result-prefixes")) {
                                    StringToStringTable excluded = this.m_stylesheet.getExcludeResultPrefixes();
                                    excluded = this.m_stylesheet.processExcludeResultPrefixes(atts.getValue(i), excluded);
                                    this.m_stylesheet.setExcludeResultPrefixes(excluded);
                                } else if (aname.equals("extension-element-prefixes")) {
                                    StringTokenizer tokenizer = new StringTokenizer(atts.getValue(i), " \t\n\r", false);
                                    while (tokenizer.hasMoreTokens()) {
                                        String prefix = tokenizer.nextToken();
                                        String extns = this.m_stylesheet.getNamespaceForPrefixFromStack(prefix);
                                        if (extns == null) {
                                            extns = "";
                                        }
                                        ExtensionNSHandler nsh = new ExtensionNSHandler(this.m_processor, extns);
                                        this.m_stylesheet.addExtensionNamespace(extns, nsh);
                                    }
                                } else if (!aname.equals("id")) {
                                    if (aname.equals("indent-result")) {
                                        throw new SAXException(XSLMessages.createMessage(65, null));
                                    }
                                    if (aname.equals("version")) {
                                        String versionStr = atts.getValue(i);
                                        this.m_stylesheet.m_XSLTVerDeclared = Double.valueOf(versionStr);
                                    } else if (!(this.isAttrOK(aname, atts, i) || this.processSpaceAttr(aname, atts, i) || this.m_stylesheet.getTemplateList().getIsWrapperless())) {
                                        throw new SAXException(XSLMessages.createMessage(66, new Object[]{name, aname}));
                                    }
                                }
                                if (!this.m_stylesheet.m_namespaces.empty()) {
                                    this.m_stylesheet.m_namespaceDecls = (NameSpace)this.m_stylesheet.m_namespaces.peek();
                                }
                                ++i;
                            }
                            break block112;
                        }
                        default: {
                            throw new SAXException(XSLMessages.createMessage(67, new Object[]{localName}));
                        }
                    }
                }
                switch (xslToken) {
                    case 50: {
                        elem = new ElemApplyTemplates(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 17: {
                        elem = new ElemCallTemplate(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 2: {
                        elem = new ElemWithParam(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 28: {
                        elem = new ElemForEach(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 64: {
                        try {
                            ElemForEach elemForEach = (ElemForEach)this.m_elems.peek();
                            ElemSort sortElem = new ElemSort(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                            if (elemForEach.m_sortElems == null) {
                                elemForEach.m_sortElems = new Vector();
                            }
                            elemForEach.m_sortElems.addElement(sortElem);
                            sortElem.m_parentNode = elemForEach;
                            break block112;
                        }
                        catch (ClassCastException classCastException) {
                            throw new SAXException(XSLMessages.createMessage(68, null));
                        }
                    }
                    case 72: {
                        elem = new ElemApplyImport(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 30: {
                        elem = new ElemValueOf(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 35: {
                        elem = new ElemNumber(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 73: {
                        elem = new ElemVariable(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 41: {
                        elem = new ElemParam(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 36: {
                        elem = new ElemIf(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 57: {
                        elem = new ElemFallback(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 37: {
                        elem = new ElemChoose(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 38: {
                        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)this.m_elems.peek();
                        if (elemTemplateElement.getXSLToken() != 37) throw new SAXException(XSLMessages.createMessage(70, null));
                        ElemTemplateElement lastChild = (ElemTemplateElement)elemTemplateElement.getLastChild();
                        if (lastChild != null && lastChild.getXSLToken() != 38) throw new SAXException(XSLMessages.createMessage(69, null));
                        elem = new ElemWhen(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 39: {
                        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)this.m_elems.peek();
                        if (elemTemplateElement.getXSLToken() != 37) throw new SAXException(XSLMessages.createMessage(72, null));
                        ElemTemplateElement lastChild = (ElemTemplateElement)elemTemplateElement.getLastChild();
                        if (lastChild != null && lastChild.getXSLToken() != 38) throw new SAXException(XSLMessages.createMessage(71, null));
                        elem = new ElemOtherwise(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 74: {
                        elem = new ElemCopyOf(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 9: {
                        elem = new ElemCopy(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 42: {
                        this.m_elems.push(new ElemText(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber));
                        break block112;
                    }
                    case 34: {
                        elem = new ElemUse(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 48: {
                        elem = new ElemAttribute(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 46: {
                        elem = new ElemElement(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 58: {
                        elem = new ElemPI(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 59: {
                        elem = new ElemComment(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 75: {
                        elem = new ElemMessage(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 83: {
                        elem = new ElemDecimalFormat(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
                        break block112;
                    }
                    case 11: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 40: 
                    case 54: 
                    case 63: 
                    case 76: {
                        throw new SAXException(XSLMessages.createMessage(73, new Object[]{name}));
                    }
                    default: {
                        if (this.m_stylesheet.m_XSLTVerDeclared <= 1.0) {
                            throw new SAXException(XSLMessages.createMessage(67, new Object[]{localName}));
                        }
                        break block112;
                    }
                }
            }
            if (!this.m_inTemplate && ns != null && (ns.equals("http://xml.apache.org/xslt") || ns.equals("http://xsl.lotus.com/"))) {
                if (localName.equals("component")) {
                    void var13_27;
                    ExtensionNSHandler nsh;
                    String prefix = null;
                    String elements = null;
                    Object var13_26 = null;
                    int nAttrs = atts.getLength();
                    int i = 0;
                    while (i < nAttrs) {
                        String aname = atts.getName(i);
                        if (aname.equals("prefix")) {
                            prefix = atts.getValue(i);
                        } else if (aname.equals("elements")) {
                            elements = atts.getValue(i);
                        } else if (aname.equals("functions")) {
                            String string = atts.getValue(i);
                        } else if (!this.isAttrOK(aname, atts, i)) {
                            this.m_stylesheet.error(2, new Object[]{name, aname});
                        }
                        ++i;
                    }
                    if (prefix == null) {
                        throw new SAXException(XSLMessages.createMessage(74, new Object[]{name}));
                    }
                    String extns = this.m_stylesheet.getNamespaceForPrefixFromStack(prefix);
                    if (extns == null) {
                        extns = "";
                    }
                    if ((nsh = this.m_stylesheet.lookupExtensionNSHandler(extns)) == null) {
                        if (elements != null) {
                            throw new SAXException(XSLMessages.createMessage(75, new Object[]{name, prefix}));
                        }
                        if (extns == null) {
                            extns = "";
                        }
                        nsh = new ExtensionNSHandler(this.m_processor, extns);
                        this.m_stylesheet.addExtensionNamespace(extns, nsh);
                    }
                    nsh.setScript("javaclass", extns, null);
                    if (elements != null) {
                        nsh.setElements(elements);
                    }
                    if (var13_27 != null) {
                        nsh.setFunctions((String)var13_27);
                    }
                    this.m_LXSLTExtensionNSH = nsh;
                } else if (localName.equals("script")) {
                    this.m_inLXSLTScript = true;
                    this.m_LXSLTScriptBody = new StringBuffer();
                    int nAttrs = atts.getLength();
                    int i = 0;
                    while (i < nAttrs) {
                        String string = atts.getName(i);
                        if (string.equals("lang")) {
                            this.m_LXSLTScriptLang = atts.getValue(i);
                        } else if (string.equals("src")) {
                            this.m_LXSLTScriptSrcURL = atts.getValue(i);
                        } else if (!this.isAttrOK(string, atts, i)) {
                            this.m_stylesheet.error(2, new Object[]{name, string});
                        }
                        ++i;
                    }
                }
            } else if (!this.m_inTemplate && !this.m_foundStylesheet) {
                elem = this.initWrapperless(name, atts, lineNumber, columnNumber);
            } else {
                ExtensionNSHandler nsh = null;
                if (ns != null) {
                    void var13_31;
                    int nAtts = atts.getLength();
                    boolean bl = false;
                    while (var13_31 < nAtts) {
                        String nm;
                        String attrNS;
                        String prefix;
                        String aname = atts.getName((int)var13_31);
                        int indexOfNSSep = aname.indexOf(58);
                        if (indexOfNSSep > 0 && !(prefix = aname.substring(0, indexOfNSSep)).equals("xmlns") && (attrNS = this.m_stylesheet.getNamespaceForPrefixFromStack(prefix)) != null && attrNS.equals(this.m_stylesheet.m_XSLNameSpaceURL) && (nm = aname.substring(indexOfNSSep + 1)).equals("extension-element-prefixes")) {
                            String qnames = atts.getValue((int)var13_31);
                            StringTokenizer tokenizer = new StringTokenizer(qnames, " \t\n\r", false);
                            int k = 0;
                            while (tokenizer.hasMoreTokens()) {
                                String extnsPrefix = tokenizer.nextToken();
                                String extns = this.m_stylesheet.getNamespaceForPrefixFromStack(extnsPrefix);
                                if (ns != null && ns.equals(extns)) {
                                    nsh = new ExtensionNSHandler(this.m_processor, extns);
                                    break;
                                }
                                ++k;
                            }
                        }
                        ++var13_31;
                    }
                    if (nsh == null) {
                        ElemTemplateElement parent = (ElemTemplateElement)this.m_elems.peek();
                        while (parent != null) {
                            int tok = parent.getXSLToken();
                            String[] extensionElementPrefixes = null;
                            if (tok == 79) {
                                ElemExtensionCall extcall = (ElemExtensionCall)parent;
                                extensionElementPrefixes = extcall.m_extensionElementPrefixes;
                            } else if (tok == 77) {
                                ElemLiteralResult extcall = (ElemLiteralResult)parent;
                                extensionElementPrefixes = extcall.m_extensionElementPrefixes;
                            }
                            if (extensionElementPrefixes != null) {
                                int n = extensionElementPrefixes.length;
                                int i = 0;
                                while (i < n) {
                                    String extnsPrefix = extensionElementPrefixes[i];
                                    String extns = this.m_stylesheet.getNamespaceForPrefixFromStack(extnsPrefix);
                                    if (ns != null && ns.equals(extns)) {
                                        nsh = new ExtensionNSHandler(this.m_processor, extns);
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            parent = parent.m_parentNode;
                        }
                    }
                }
                if (ns != null && nsh == null) {
                    nsh = this.m_stylesheet.lookupExtensionNSHandler(ns);
                }
                elem = nsh != null ? new ElemExtensionCall(this.m_processor, this.m_stylesheet, nsh, name, localName, atts, lineNumber, columnNumber) : new ElemLiteralResult(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
            }
        }
        if (this.m_inTemplate && elem != null) {
            if (!this.m_elems.empty()) {
                ElemTemplateElement parent = (ElemTemplateElement)this.m_elems.peek();
                parent.appendChild(elem);
            }
            this.m_elems.push(elem);
        }
        if (origStackSize != this.m_elems.size()) return;
        this.m_elems.push(new ElemEmpty(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber));
    }

    private ElemTemplateElement initWrapperless(String name, AttributeList atts, int lineNumber, int columnNumber) throws SAXException {
        this.m_stylesheet.initXSLTKeys();
        this.m_stylesheet.m_stylesheetRoot.initDefaultRule();
        AttributeListImpl templateAttrs = new AttributeListImpl();
        templateAttrs.addAttribute("name", "CDATA", "simple");
        this.m_template = new ElemTemplate(this.m_processor, this.m_stylesheet, "xsl:template", templateAttrs, lineNumber, columnNumber);
        ElemLiteralResult elem = new ElemLiteralResult(this.m_processor, this.m_stylesheet, name, atts, lineNumber, columnNumber);
        this.m_template.appendChild(elem);
        this.m_inTemplate = true;
        this.m_stylesheet.getTemplateList().setWrapperlessTemplate(this.m_template);
        this.m_stylesheet.getTemplateList().setIsWrapperless(true);
        this.m_foundStylesheet = true;
        if (name.equals("HTML")) {
            this.m_stylesheet.m_stylesheetRoot.m_indentResult = true;
            this.m_stylesheet.m_stylesheetRoot.setOutputMethod("html");
        }
        return elem;
    }

    void processImport(String name, AttributeList atts) throws SAXException {
        int nAttrs = atts.getLength();
        boolean foundIt = false;
        int i = 0;
        while (i < nAttrs) {
            String aname = atts.getName(i);
            if (aname.equals("href")) {
                foundIt = true;
                if (this.m_foundNotImport) {
                    throw new SAXException(XSLMessages.createMessage(76, null));
                }
                String saved_XSLNameSpaceURL = this.m_stylesheet.m_XSLNameSpaceURL;
                String href = atts.getValue(i);
                URL hrefUrl = this.m_processor.getURLFromString(href, this.m_stylesheet.m_baseIdent);
                if (this.stackContains(this.m_stylesheet.m_stylesheetRoot.m_importStack, hrefUrl)) {
                    throw new SAXException(XSLMessages.createMessage(77, new Object[]{hrefUrl}));
                }
                this.m_stylesheet.m_stylesheetRoot.m_importStack.push(hrefUrl);
                try {
                    String[] stringHolder = new String[]{null};
                    Stylesheet importedStylesheet = new Stylesheet(this.m_stylesheet.m_stylesheetRoot, this.m_processor, this.m_stylesheet.m_baseIdent);
                    StylesheetHandler tp = new StylesheetHandler(this.m_processor, importedStylesheet);
                    importedStylesheet.m_baseIdent = hrefUrl.toExternalForm();
                    this.m_processor.parseXML(hrefUrl, tp, importedStylesheet);
                    this.m_stylesheet.m_imports.insertElementAt(importedStylesheet, 0);
                    importedStylesheet.m_stylesheetParent = this.m_stylesheet;
                }
                catch (MalformedURLException mue) {
                    throw new SAXException(XSLMessages.createMessage(78, new Object[]{atts.getValue(i)}), mue);
                }
                catch (FileNotFoundException fnfe) {
                    throw new SAXException(XSLMessages.createMessage(79, new Object[]{atts.getValue(i)}), fnfe);
                }
                catch (IOException ioe) {
                    throw new SAXException(XSLMessages.createMessage(80, new Object[]{atts.getValue(i)}), ioe);
                }
                this.m_stylesheet.m_stylesheetRoot.m_importStack.pop();
                this.m_stylesheet.m_XSLNameSpaceURL = saved_XSLNameSpaceURL;
            } else if (!this.isAttrOK(aname, atts, i)) {
                this.m_stylesheet.error(2, new Object[]{name, aname});
            }
            ++i;
        }
        if (!foundIt) {
            throw new SAXException(XSLMessages.createMessage(81, new Object[]{name}));
        }
    }

    private boolean stackContains(Stack stack, URL url) {
        int n = stack.size();
        boolean contains = false;
        int i = 0;
        while (i < n) {
            URL url2 = (URL)stack.elementAt(i);
            if (url2.toString().equals(url.toString())) {
                contains = true;
                break;
            }
            ++i;
        }
        return contains;
    }

    void processInclude(String name, AttributeList atts) throws SAXException {
        int nAttrs = atts.getLength();
        boolean foundIt = false;
        int i = 0;
        while (i < nAttrs) {
            String aname = atts.getName(i);
            if (aname.equals("href")) {
                foundIt = true;
                Stack saved_elems = this.m_elems;
                this.m_elems = new Stack();
                ElemTemplate saved_template = this.m_template;
                this.m_template = null;
                ElemTemplateElement saved_lastPopped = this.m_lastPopped;
                this.m_lastPopped = null;
                boolean saved_inTemplate = this.m_inTemplate;
                this.m_inTemplate = false;
                boolean saved_foundStylesheet = this.m_foundStylesheet;
                this.m_foundStylesheet = false;
                String saved_XSLNameSpaceURL = this.m_stylesheet.m_XSLNameSpaceURL;
                boolean saved_foundNotImport = this.m_foundNotImport;
                this.m_foundNotImport = false;
                String href = atts.getValue(i);
                URL hrefUrl = this.m_processor.getURLFromString(href, ((URL)this.m_stylesheet.m_includeStack.peek()).toString());
                if (this.stackContains(this.m_stylesheet.m_includeStack, hrefUrl)) {
                    throw new SAXException(XSLMessages.createMessage(77, new Object[]{hrefUrl}));
                }
                this.m_stylesheet.m_includeStack.push(hrefUrl);
                try {
                    this.m_processor.parseXML(hrefUrl, this, this.m_stylesheet);
                }
                catch (IOException ioe) {
                    throw new SAXException(XSLMessages.createMessage(82, null), ioe);
                }
                this.m_stylesheet.m_includeStack.pop();
                this.m_elems = saved_elems;
                this.m_template = saved_template;
                this.m_lastPopped = saved_lastPopped;
                this.m_inTemplate = saved_inTemplate;
                this.m_foundStylesheet = saved_foundStylesheet;
                this.m_stylesheet.m_XSLNameSpaceURL = saved_XSLNameSpaceURL;
                this.m_foundNotImport = saved_foundNotImport;
            } else if (!this.isAttrOK(aname, atts, i)) {
                this.m_stylesheet.error(2, new Object[]{name, aname});
            }
            ++i;
        }
        if (!foundIt) {
            throw new SAXException(XSLMessages.createMessage(81, new Object[]{name}));
        }
    }

    public void endElement(String name) throws SAXException {
        this.m_stylesheet.popNamespaces();
        this.m_lastPopped = (ElemTemplateElement)this.m_elems.pop();
        this.m_lastPopped.m_finishedConstruction = true;
        int tok = this.m_lastPopped.getXSLToken();
        if (tok == 19) {
            this.m_inTemplate = false;
        } else if (tok == 41 || tok == 73) {
            ElemVariable var = (ElemVariable)this.m_lastPopped;
            if (var.m_isTopLevel) {
                this.m_inTemplate = false;
            }
        } else if (tok == 40) {
            this.m_inTemplate = false;
        }
        if (this.m_inLXSLTScript) {
            if (this.m_LXSLTScriptLang == null) {
                throw new SAXException(XSLMessages.createMessage(83, new Object[]{name}));
            }
            if (this.m_LXSLTExtensionNSH == null) {
                throw new SAXException(XSLMessages.createMessage(84, new Object[]{name}));
            }
            this.m_LXSLTExtensionNSH.setScript(this.m_LXSLTScriptLang, this.m_LXSLTScriptSrcURL, this.m_LXSLTScriptBody.toString());
            this.m_inLXSLTScript = false;
            this.m_LXSLTScriptLang = null;
            this.m_LXSLTScriptSrcURL = null;
            this.m_LXSLTScriptBody = null;
            this.m_LXSLTExtensionNSH = null;
        } else if (this.m_LXSLTExtensionNSH != null) {
            this.m_inLXSLTScript = false;
            this.m_LXSLTScriptLang = null;
            this.m_LXSLTScriptSrcURL = null;
            this.m_LXSLTScriptBody = null;
            this.m_LXSLTExtensionNSH = null;
        }
    }

    public static boolean isSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public boolean isWhiteSpace(char[] ch, int start, int length) {
        boolean isWhiteSpace = true;
        int end = start + length;
        int s = start;
        while (s < end) {
            if (!StylesheetHandler.isSpace(ch[s])) {
                isWhiteSpace = false;
                break;
            }
            ++s;
        }
        return isWhiteSpace;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_inTemplate) {
            ElemTemplateElement parent = (ElemTemplateElement)this.m_elems.peek();
            boolean preserveSpace = false;
            boolean disableOutputEscaping = false;
            if (parent.getXSLToken() == 42) {
                disableOutputEscaping = ((ElemText)parent).m_disableOutputEscaping;
                parent = (ElemTemplateElement)this.m_elems.elementAt(this.m_elems.size() - 2);
                preserveSpace = true;
            }
            Locator locator = this.m_processor.m_stylesheetLocatorStack.isEmpty() ? null : (Locator)this.m_processor.m_stylesheetLocatorStack.peek();
            int lineNumber = locator != null ? locator.getLineNumber() : 0;
            int columnNumber = locator != null ? locator.getColumnNumber() : 0;
            ElemTextLiteral elem = new ElemTextLiteral(this.m_processor, this.m_stylesheet, ch, start, length, false, preserveSpace, disableOutputEscaping, lineNumber, columnNumber);
            boolean isWhite = this.isWhiteSpace(ch, start, length);
            if (preserveSpace || !preserveSpace && !isWhite) {
                while (!this.m_whiteSpaceElems.isEmpty()) {
                    ElemTextLiteral whiteElem = (ElemTextLiteral)this.m_whiteSpaceElems.pop();
                    parent.appendChild(whiteElem);
                }
                parent.appendChild(elem);
            } else if (isWhite) {
                ElemTemplateElement lastElem;
                boolean shouldPush = true;
                Node last = parent.getLastChild();
                if (last != null && (lastElem = (ElemTemplateElement)last).getXSLToken() == 78 && !((ElemTextLiteral)lastElem).m_preserveSpace) {
                    parent.appendChild(elem);
                    shouldPush = false;
                }
                if (shouldPush) {
                    this.m_whiteSpaceElems.push(elem);
                }
            }
        } else if (this.m_inLXSLTScript) {
            this.m_LXSLTScriptBody.append(ch, start, length);
        }
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        if (this.m_inTemplate) {
            ElemTemplateElement parent = (ElemTemplateElement)this.m_elems.peek();
            boolean preserveSpace = false;
            boolean disableOutputEscaping = false;
            if (parent.getXSLToken() == 42) {
                disableOutputEscaping = ((ElemText)parent).m_disableOutputEscaping;
                parent = (ElemTemplateElement)this.m_elems.elementAt(this.m_elems.size() - 2);
                preserveSpace = true;
            }
            Locator locator = this.m_processor.m_stylesheetLocatorStack.isEmpty() ? null : (Locator)this.m_processor.m_stylesheetLocatorStack.peek();
            int lineNumber = locator != null ? locator.getLineNumber() : 0;
            int columnNumber = locator != null ? locator.getColumnNumber() : 0;
            ElemTextLiteral elem = new ElemTextLiteral(this.m_processor, this.m_stylesheet, ch, start, length, true, preserveSpace, disableOutputEscaping, lineNumber, columnNumber);
            boolean isWhite = this.isWhiteSpace(ch, start, length);
            if (preserveSpace || !preserveSpace && !isWhite) {
                while (!this.m_whiteSpaceElems.isEmpty()) {
                    ElemTextLiteral whiteElem = (ElemTextLiteral)this.m_whiteSpaceElems.pop();
                    parent.appendChild(whiteElem);
                }
                parent.appendChild(elem);
            } else if (isWhite) {
                ElemTemplateElement lastElem;
                boolean shouldPush = true;
                Node last = parent.getLastChild();
                if (last != null && (lastElem = (ElemTemplateElement)last).getXSLToken() == 78 && !((ElemTextLiteral)lastElem).m_preserveSpace) {
                    parent.appendChild(elem);
                    shouldPush = false;
                }
                if (shouldPush) {
                    this.m_whiteSpaceElems.push(elem);
                }
            }
        } else if (this.m_inLXSLTScript) {
            this.m_LXSLTScriptBody.append(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void comment(String data) throws SAXException {
    }

    public void entityReference(String name) throws SAXException {
    }
}

