/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.apache.xalan.xpath.ExtensionFunctionHandler;
import org.apache.xalan.xpath.xml.FormatterToDOM;
import org.apache.xalan.xpath.xml.FormatterToHTML;
import org.apache.xalan.xpath.xml.FormatterToText;
import org.apache.xalan.xpath.xml.FormatterToXML;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xalan.xslt.ElemApplyTemplates;
import org.apache.xalan.xslt.ElemTemplate;
import org.apache.xalan.xslt.ElemValueOf;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.apache.xalan.xslt.trace.SelectionEvent;
import org.apache.xalan.xslt.trace.TraceListener;
import org.apache.xalan.xslt.trace.TracerEvent;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class StylesheetRoot
extends Stylesheet
implements Serializable {
    String m_resultNameSpaceURL;
    transient Vector m_traceListeners;
    static final String DEFAULT_ENCODING = "UTF-8";
    public boolean m_useXercesSerializers = false;
    String m_outputmethod;
    String m_version;
    boolean m_indentResult = false;
    String m_encoding;
    String m_mediatype;
    String m_doctypeSystem;
    String m_doctypePublic;
    boolean m_omitxmlDecl = false;
    boolean m_standalone = false;
    QName[] m_cdataSectionElems;
    transient Stack m_importStack;
    public ElemTemplate m_defaultTextRule;
    public ElemTemplate m_defaultRule;
    public ElemTemplate m_defaultRootRule;

    private void readObject(ObjectInputStream stream) throws IOException, SAXException {
        try {
            stream.defaultReadObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new XSLProcessorException(cnfe);
        }
        this.m_traceListeners = null;
    }

    public void addTraceListener(TraceListener tl) throws TooManyListenersException {
        if (this.m_traceListeners == null) {
            this.m_traceListeners = new Vector();
        }
        this.m_traceListeners.addElement(tl);
    }

    public void removeTraceListener(TraceListener tl) {
        if (this.m_traceListeners != null) {
            this.m_traceListeners.removeElement(tl);
        }
    }

    void fireTraceEvent(TracerEvent te) {
        if (this.m_traceListeners != null) {
            int nListeners = this.m_traceListeners.size();
            int i = 0;
            while (i < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i);
                tl.trace(te);
                ++i;
            }
        }
    }

    void fireSelectedEvent(SelectionEvent se) throws SAXException {
        if (this.m_traceListeners != null) {
            int nListeners = this.m_traceListeners.size();
            int i = 0;
            while (i < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i);
                tl.selected(se);
                ++i;
            }
        }
    }

    public StylesheetRoot(XSLTEngineImpl processor, String baseIdentifier) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        super(null, processor, baseIdentifier);
    }

    protected void init(XSLTEngineImpl processor) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        this.m_importStack = new Stack();
        if (this.m_baseIdent == null) {
            this.m_baseIdent = "";
        }
        URL url = processor.getURLFromString(this.m_baseIdent, null);
        this.m_baseIdent = url.toExternalForm();
        this.m_importStack.push(processor.getURLFromString(this.m_baseIdent, null));
        this.m_stylesheetRoot = this;
        super.init(processor);
    }

    public OutputFormat getOutputFormat() {
        OutputFormat formatter = new OutputFormat(this.getOutputMethod(), this.getOutputEncoding(), this.getOutputIndent());
        formatter.setDoctype(this.getOutputDoctypePublic(), this.getOutputDoctypeSystem());
        formatter.setOmitXMLDeclaration(this.getOmitOutputXMLDecl());
        formatter.setStandalone(this.getOutputStandalone());
        formatter.setMediaType(this.getOutputMediaType());
        formatter.setVersion(this.getOutputVersion());
        return formatter;
    }

    public void process(XSLTInputSource xmlSource, XSLTResultTarget outputTarget) throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        new XSLTProcessorFactory();
        XSLTProcessor iprocessor = XSLTProcessorFactory.getProcessor();
        this.process(iprocessor, iprocessor.getSourceTreeFromInput(xmlSource), outputTarget);
    }

    public void process(XSLTProcessor iprocessor, XSLTInputSource xmlSource, XSLTResultTarget outputTarget) throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        this.process(iprocessor, iprocessor.getSourceTreeFromInput(xmlSource), outputTarget);
    }

    public void process(XSLTProcessor iprocessor, Node sourceTree, XSLTResultTarget outputTarget) throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        XSLTEngineImpl processor;
        XSLTEngineImpl xSLTEngineImpl = processor = (XSLTEngineImpl)iprocessor;
        synchronized (xSLTEngineImpl) {
            OutputStream ostream;
            block27: {
                processor.m_stylesheetRoot = this;
                ostream = null;
                try {
                    OutputFormat formatter;
                    DocumentHandler docHandler;
                    processor.getXMLProcessorLiaison().checkNode(sourceTree);
                    Enumeration keys = this.m_extensionNamespaces.keys();
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        processor.getExecContext().addExtensionNamespace((String)key, (ExtensionFunctionHandler)this.m_extensionNamespaces.get(key));
                    }
                    ElemTemplate rootRule = this.findTemplate(processor, sourceTree, sourceTree);
                    if (rootRule == null) {
                        rootRule = this.m_defaultRootRule;
                    }
                    if ((docHandler = outputTarget.getDocumentHandler()) != null) {
                        processor.m_flistener = docHandler;
                    } else if (outputTarget.getByteStream() != null) {
                        formatter = this.getOutputFormat();
                        processor.m_flistener = this.makeSAXSerializer(outputTarget.getByteStream(), formatter);
                    } else if (outputTarget.getCharacterStream() != null) {
                        formatter = this.getOutputFormat();
                        processor.m_flistener = this.makeSAXSerializer(outputTarget.getCharacterStream(), formatter);
                    } else if (outputTarget.getFileName() != null) {
                        formatter = this.getOutputFormat();
                        ostream = new FileOutputStream(outputTarget.getFileName());
                        processor.m_flistener = this.makeSAXSerializer(ostream, formatter);
                    } else if (outputTarget.getNode() != null) {
                        switch (outputTarget.getNode().getNodeType()) {
                            case 9: {
                                processor.m_flistener = new FormatterToDOM((Document)outputTarget.getNode());
                                break;
                            }
                            case 11: {
                                processor.m_flistener = new FormatterToDOM(processor.m_parserLiaison.createDocument(), (DocumentFragment)outputTarget.getNode());
                                break;
                            }
                            case 1: {
                                processor.m_flistener = new FormatterToDOM(processor.m_parserLiaison.createDocument(), (Element)outputTarget.getNode());
                                break;
                            }
                            default: {
                                this.error(43);
                                break;
                            }
                        }
                    } else {
                        outputTarget.setNode(processor.m_parserLiaison.createDocument());
                        processor.m_flistener = new FormatterToDOM((Document)outputTarget.getNode());
                    }
                    processor.resetCurrentState(sourceTree, sourceTree);
                    processor.m_rootDoc = sourceTree;
                    if (processor.m_diagnosticsPrintWriter != null) {
                        processor.diag("=============================");
                        processor.diag("Transforming...");
                        processor.pushTime(sourceTree);
                    }
                    processor.m_variableStacks.pushContextMarker(null, null);
                    try {
                        processor.resolveTopLevelParams();
                    }
                    catch (Exception e) {
                        throw new SAXException(XSLMessages.createMessage(44, null), e);
                    }
                    processor.m_resultTreeHandler.startDocument();
                    rootRule.execute(processor, sourceTree, sourceTree, null);
                    processor.m_resultTreeHandler.endDocument();
                    processor.m_topLevelParams = new Vector();
                    if (processor.m_diagnosticsPrintWriter == null) break block27;
                    processor.displayDuration("transform", sourceTree);
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (ostream != null) {
                        ostream.close();
                    }
                    throw throwable;
                }
            }
            Object var9_12 = null;
            if (ostream != null) {
                ostream.close();
            }
        }
    }

    public DocumentHandler makeSAXSerializer(Writer writer, OutputFormat format) {
        DocumentHandler handler;
        if (this.m_useXercesSerializers) {
            handler = Serializer.makeSAXSerializer((Writer)writer, (OutputFormat)format);
        } else if (format == null) {
            format = new OutputFormat("xml", DEFAULT_ENCODING, false);
            FormatterToXML serializer = new FormatterToXML();
            serializer.init(writer, format);
            handler = serializer;
        } else if (format.getMethod().equalsIgnoreCase("html")) {
            FormatterToHTML serializer = new FormatterToHTML();
            serializer.init(writer, format);
            handler = serializer;
        } else if (format.getMethod().equalsIgnoreCase("xml")) {
            FormatterToXML serializer = new FormatterToXML();
            serializer.init(writer, format);
            handler = serializer;
        } else {
            handler = format.getMethod().equalsIgnoreCase("text") ? new FormatterToText(writer) : (format.getMethod().equalsIgnoreCase("xhtml") ? Serializer.makeSAXSerializer((Writer)writer, (OutputFormat)format) : Serializer.makeSAXSerializer((Writer)writer, (OutputFormat)format));
        }
        return handler;
    }

    public DocumentHandler getSAXSerializer(OutputStream ostream) throws UnsupportedEncodingException {
        return this.makeSAXSerializer(ostream, this.getOutputFormat());
    }

    public DocumentHandler makeSAXSerializer(OutputStream ostream, OutputFormat format) throws UnsupportedEncodingException {
        DocumentHandler handler;
        if (this.m_useXercesSerializers) {
            handler = Serializer.makeSAXSerializer((OutputStream)ostream, (OutputFormat)format);
        } else if (format == null) {
            format = new OutputFormat("xml", DEFAULT_ENCODING, false);
            FormatterToXML serializer = new FormatterToXML();
            serializer.init(ostream, format);
            handler = serializer;
        } else if (format.getMethod().equalsIgnoreCase("html")) {
            FormatterToHTML serializer = new FormatterToHTML();
            serializer.init(ostream, format);
            handler = serializer;
        } else if (format.getMethod().equalsIgnoreCase("xml")) {
            FormatterToXML serializer = new FormatterToXML();
            serializer.init(ostream, format);
            handler = serializer;
        } else if (format.getMethod().equalsIgnoreCase("text")) {
            String encoding = format.getEncoding();
            if (encoding == null) {
                try {
                    encoding = System.getProperty("file.encoding");
                    String string = encoding = encoding != null ? FormatterToXML.convertJava2MimeEncoding(encoding) : "ASCII";
                    if (encoding == null) {
                        encoding = "ASCII";
                    }
                }
                catch (SecurityException securityException) {
                    encoding = "ASCII";
                }
            }
            this.m_encoding = encoding;
            String javaEncoding = FormatterToXML.convertMime2JavaEncoding(encoding);
            OutputStreamWriter w = new OutputStreamWriter(ostream, javaEncoding);
            handler = new FormatterToText(w);
        } else {
            handler = format.getMethod().equalsIgnoreCase("xhtml") ? Serializer.makeSAXSerializer((OutputStream)ostream, (OutputFormat)format) : Serializer.makeSAXSerializer((OutputStream)ostream, (OutputFormat)format);
        }
        return handler;
    }

    public String getOutputMethod() {
        return this.m_outputmethod == null ? "xml" : this.m_outputmethod;
    }

    public boolean isOutputMethodSet() {
        return this.m_outputmethod != null;
    }

    public void setOutputMethod(String om) {
        this.m_outputmethod = om;
    }

    public String getOutputVersion() {
        return this.m_version;
    }

    public boolean getOutputIndent() {
        return this.m_indentResult;
    }

    public String getOutputEncoding() {
        return this.m_encoding;
    }

    public String getOutputMediaType() {
        return this.m_mediatype;
    }

    public String getOutputDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    public String getOutputDoctypePublic() {
        return this.m_doctypePublic;
    }

    public boolean getOmitOutputXMLDecl() {
        return this.m_omitxmlDecl;
    }

    public boolean getOutputStandalone() {
        return this.m_standalone;
    }

    public QName[] getCDataSectionElems() {
        return this.m_cdataSectionElems;
    }

    void processOutputSpec(String name, AttributeList atts) throws SAXException {
        int nAttrs = atts.getLength();
        boolean didSpecifyIndent = false;
        int i = 0;
        while (i < nAttrs) {
            String aname = atts.getName(i);
            if (aname.equals("method")) {
                this.m_outputmethod = atts.getValue(i);
            } else if (aname.equals("version")) {
                this.m_version = atts.getValue(i);
            } else if (aname.equals("indent")) {
                this.m_indentResult = this.getYesOrNo(aname, atts.getValue(i));
                didSpecifyIndent = true;
            } else if (aname.equals("encoding")) {
                this.m_encoding = atts.getValue(i);
            } else if (aname.equals("media-type")) {
                this.m_mediatype = atts.getValue(i);
            } else if (aname.equals("doctype-system")) {
                this.m_doctypeSystem = atts.getValue(i);
            } else if (aname.equals("doctype-public")) {
                this.m_doctypePublic = atts.getValue(i);
            } else if (aname.equals("omit-xml-declaration")) {
                this.m_omitxmlDecl = this.getYesOrNo(aname, atts.getValue(i));
            } else if (aname.equals("standalone")) {
                this.m_standalone = this.getYesOrNo(aname, atts.getValue(i));
            } else if (aname.equals("cdata-section-elements")) {
                int cdataindex;
                StringTokenizer tokenizer = new StringTokenizer(atts.getValue(i));
                int nElems = tokenizer.countTokens();
                if (this.m_cdataSectionElems == null) {
                    this.m_cdataSectionElems = new QName[nElems];
                    cdataindex = 0;
                } else {
                    QName[] cdataSectionElems = this.m_cdataSectionElems;
                    int n = cdataSectionElems.length;
                    this.m_cdataSectionElems = new QName[nElems + n];
                    int k = 0;
                    while (k < n) {
                        this.m_cdataSectionElems[k] = cdataSectionElems[k];
                        ++k;
                    }
                    cdataindex = n;
                }
                while (tokenizer.hasMoreTokens()) {
                    QName qname;
                    String token = tokenizer.nextToken();
                    this.m_cdataSectionElems[cdataindex] = qname = new QName(token, this.m_namespaces);
                    ++cdataindex;
                }
            } else {
                throw new SAXException(XSLMessages.createMessage(2, new Object[]{name, aname}));
            }
            ++i;
        }
        if (this.m_outputmethod != null && this.m_outputmethod.equals("html") && !didSpecifyIndent) {
            this.m_indentResult = true;
        }
    }

    boolean isRoot() {
        return true;
    }

    void initDefaultRule() throws XSLProcessorException, SAXException {
        int lineNumber = 0;
        int columnNumber = 0;
        AttributeListImpl attrs = new AttributeListImpl();
        attrs.addAttribute("match", "CDATA", "*");
        this.m_defaultRule = new ElemTemplate(null, this, "xsl:template", attrs, lineNumber, columnNumber);
        attrs.clear();
        ElemApplyTemplates childrenElement = new ElemApplyTemplates(null, this, "xsl:apply-templates", attrs, lineNumber, columnNumber);
        childrenElement.m_isDefaultTemplate = true;
        this.m_defaultRule.appendChild(childrenElement);
        attrs.clear();
        attrs.addAttribute("match", "CDATA", "text() | @*");
        this.m_defaultTextRule = new ElemTemplate(null, this, "xsl:template", attrs, lineNumber, columnNumber);
        attrs.clear();
        attrs.addAttribute("select", "CDATA", ".");
        ElemValueOf elemValueOf = new ElemValueOf(null, this, "xsl:value-of", attrs, lineNumber, columnNumber);
        this.m_defaultTextRule.appendChild(elemValueOf);
        attrs.clear();
        attrs.addAttribute("match", "CDATA", "/");
        this.m_defaultRootRule = new ElemTemplate(null, this, "xsl:template", attrs, lineNumber, columnNumber);
        attrs.clear();
        childrenElement = new ElemApplyTemplates(null, this, "xsl:apply-templates", attrs, lineNumber, columnNumber);
        childrenElement.m_isDefaultTemplate = true;
        this.m_defaultRootRule.appendChild(childrenElement);
    }
}

