/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xslt.ElemTemplate;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TemplateList {
    Stylesheet m_stylesheet;
    ElemTemplateElement m_firstTemplate;
    Hashtable m_namedTemplates = new Hashtable();
    private boolean m_isWrapperless = false;
    private ElemTemplate m_wrapperlessTemplate;
    private Hashtable m_patternTable = new Hashtable();

    TemplateList(Stylesheet stylesheet) {
        this.m_stylesheet = stylesheet;
    }

    public ElemTemplateElement getFirstTemplate() {
        return this.m_firstTemplate;
    }

    public void setFirstTemplate(ElemTemplateElement v) {
        this.m_firstTemplate = v;
    }

    void setIsWrapperless(boolean b) {
        this.m_isWrapperless = b;
    }

    boolean getIsWrapperless() {
        return this.m_isWrapperless;
    }

    void setWrapperlessTemplate(ElemTemplate t) {
        this.m_wrapperlessTemplate = t;
    }

    ElemTemplate getWrapperlessTemplate() {
        return this.m_wrapperlessTemplate;
    }

    public Hashtable getNamedTemplates() {
        return this.m_namedTemplates;
    }

    public void setNamedTemplates(Hashtable v) {
        this.m_namedTemplates = v;
    }

    public ElemTemplate findTemplate(XSLTEngineImpl transformContext, Node sourceTree, Node targetNode, QName mode, boolean useImports, Stylesheet[] foundStylesheet) throws SAXException {
        ElemTemplate bestMatchedRule = null;
        MatchPattern2 bestMatchedPattern = null;
        if (this.m_isWrapperless) {
            return this.m_wrapperlessTemplate;
        }
        Vector<MatchPattern2> conflicts = null;
        if (!useImports) {
            double highScore = Double.NEGATIVE_INFINITY;
            MatchPattern2 matchPat = null;
            short targetNodeType = targetNode.getNodeType();
            switch (targetNodeType) {
                case 1: {
                    String targetName = transformContext.m_parserLiaison.getLocalNameOfNode(targetNode);
                    matchPat = this.locateMatchPatternList2(targetName, true);
                    break;
                }
                case 2: 
                case 7: {
                    matchPat = this.locateMatchPatternList2(targetNode.getNodeName(), true);
                    break;
                }
                case 3: 
                case 4: {
                    matchPat = this.locateMatchPatternList2("#text", false);
                    break;
                }
                case 8: {
                    matchPat = this.locateMatchPatternList2("#comment", false);
                    break;
                }
                case 9: {
                    matchPat = this.locateMatchPatternList2("/", false);
                    break;
                }
                case 11: {
                    matchPat = this.locateMatchPatternList2("*", false);
                    break;
                }
                default: {
                    matchPat = this.locateMatchPatternList2(targetNode.getNodeName(), false);
                }
            }
            String prevPat = null;
            MatchPattern2 prevMatchPat = null;
            while (matchPat != null) {
                MatchPattern2 nextMatchPat;
                String patterns;
                ElemTemplate rule = matchPat.getTemplate();
                QName ruleMode = rule.m_mode;
                if ((mode == null && ruleMode == null || ruleMode != null && mode != null && ruleMode.equals(mode)) && (patterns = matchPat.getPattern()) != null && (prevPat == null || !prevPat.equals(patterns) || prevMatchPat.getTemplate().m_priority != matchPat.getTemplate().m_priority)) {
                    prevMatchPat = matchPat;
                    prevPat = patterns;
                    XPath xpath = matchPat.getExpression();
                    double score = xpath.getMatchScore(transformContext.getExecContext(), targetNode);
                    if (score != Double.NEGATIVE_INFINITY) {
                        double priorityOfBestMatched;
                        double priorityOfRule;
                        matchPat.m_priority = priorityOfRule = rule.m_priority != Double.NEGATIVE_INFINITY ? rule.m_priority : score;
                        double d = priorityOfBestMatched = bestMatchedPattern != null ? bestMatchedPattern.m_priority : Double.NEGATIVE_INFINITY;
                        if (priorityOfRule > priorityOfBestMatched) {
                            if (conflicts != null) {
                                conflicts.removeAllElements();
                            }
                            highScore = score;
                            bestMatchedRule = rule;
                            bestMatchedPattern = matchPat;
                        } else if (priorityOfRule == priorityOfBestMatched) {
                            if (conflicts == null) {
                                conflicts = new Vector<MatchPattern2>(10);
                            }
                            this.addObjectIfNotFound(bestMatchedPattern, conflicts);
                            conflicts.addElement(matchPat);
                            highScore = score;
                            bestMatchedRule = rule;
                            bestMatchedPattern = matchPat;
                        }
                    }
                }
                if (!((nextMatchPat = matchPat.getNext()) != null || matchPat.m_targetString.equals("*") || targetNodeType != 1 && targetNodeType != 2 && targetNodeType != 7)) {
                    nextMatchPat = (MatchPattern2)this.m_patternTable.get("*");
                }
                matchPat = nextMatchPat;
            }
        }
        if (bestMatchedRule == null) {
            int nImports = this.m_stylesheet.m_imports.size();
            int i = 0;
            while (i < nImports) {
                Stylesheet stylesheet = (Stylesheet)this.m_stylesheet.m_imports.elementAt(i);
                bestMatchedRule = stylesheet.findTemplate(transformContext, sourceTree, targetNode, mode, false, foundStylesheet);
                if (bestMatchedRule != null) break;
                ++i;
            }
        }
        if (conflicts != null) {
            int nConflicts = conflicts.size();
            String conflictsString = !transformContext.m_quietConflictWarnings ? "" : null;
            int i = 0;
            while (i < nConflicts) {
                MatchPattern2 conflictPat = (MatchPattern2)conflicts.elementAt(i);
                if (i != 0) {
                    if (!transformContext.m_quietConflictWarnings) {
                        conflictsString = String.valueOf(conflictsString) + ", ";
                    }
                    if (conflictPat.m_posInStylesheet > bestMatchedPattern.m_posInStylesheet) {
                        bestMatchedPattern = conflictPat;
                    }
                } else {
                    bestMatchedPattern = conflictPat;
                }
                if (!transformContext.m_quietConflictWarnings) {
                    conflictsString = String.valueOf(conflictsString) + "\"" + conflictPat.getPattern() + "\"";
                }
                ++i;
            }
            bestMatchedRule = bestMatchedPattern.getTemplate();
            if (!transformContext.m_quietConflictWarnings) {
                transformContext.warn(12, new Object[]{conflictsString});
            }
        }
        if (bestMatchedPattern != null && foundStylesheet != null) {
            foundStylesheet[0] = bestMatchedPattern.m_stylesheet;
        }
        return bestMatchedRule;
    }

    void addObjectIfNotFound(Object obj, Vector v) {
        int n = v.size();
        boolean addIt = true;
        int i = 0;
        while (i < n) {
            if (v.elementAt(i) == obj) {
                addIt = false;
                break;
            }
            ++i;
        }
        if (addIt) {
            v.addElement(obj);
        }
    }

    private MatchPattern2 locateMatchPatternList2(String sourceElementType, boolean tryWildCard) {
        MatchPattern2 startMatchList = null;
        Object val = this.m_patternTable.get(sourceElementType);
        if (val != null) {
            startMatchList = (MatchPattern2)val;
        } else if (tryWildCard && (val = this.m_patternTable.get("*")) != null) {
            startMatchList = (MatchPattern2)val;
        }
        return startMatchList;
    }

    void addTemplate(ElemTemplate template) {
        Vector strings;
        int pos = 0;
        if (this.m_firstTemplate == null) {
            this.m_firstTemplate = template;
        } else {
            ElemTemplateElement next = this.m_firstTemplate;
            while (next != null) {
                if (next.m_nextSibling == null) {
                    next.m_nextSibling = template;
                    template.m_nextSibling = null;
                    break;
                }
                ++pos;
                next = next.m_nextSibling;
            }
        }
        if (template.m_name != null) {
            this.m_namedTemplates.put(template.m_name, template);
        }
        if (template.m_matchPattern != null && (strings = template.m_matchPattern.getTargetElementStrings()) != null) {
            int nTargets = strings.size();
            int stringIndex = 0;
            while (stringIndex < nTargets) {
                String target = (String)strings.elementAt(stringIndex);
                MatchPattern2 newMatchPat = new MatchPattern2(template.m_matchPattern.m_currentPattern, template.m_matchPattern, template, pos, target, this.m_stylesheet);
                Object val = this.m_patternTable.get(target);
                if (val == null) {
                    this.m_patternTable.put(target, newMatchPat);
                } else {
                    MatchPattern2 matchPat = (MatchPattern2)val;
                    newMatchPat.setNext(matchPat);
                    this.m_patternTable.put(target, newMatchPat);
                }
                ++stringIndex;
            }
        }
    }

    ElemTemplateElement findNamedTemplate(String name) throws XSLProcessorException {
        QName qname = new QName(name, this.m_stylesheet.m_namespaces);
        return this.findNamedTemplate(qname);
    }

    ElemTemplateElement findNamedTemplate(QName qname) throws XSLProcessorException {
        ElemTemplateElement namedTemplate = null;
        Object obj = this.m_namedTemplates.get(qname);
        if (obj == null) {
            Stylesheet stylesheet;
            int nImports = this.m_stylesheet.m_imports.size();
            int i = 0;
            while (i < nImports) {
                stylesheet = (Stylesheet)this.m_stylesheet.m_imports.elementAt(i);
                namedTemplate = stylesheet.findNamedTemplate(qname);
                if (namedTemplate != null) break;
                ++i;
            }
            if (namedTemplate == null && this.m_stylesheet.m_stylesheetParent != null && (stylesheet = this.m_stylesheet.m_stylesheetParent.getPreviousImport(this.m_stylesheet)) != null) {
                namedTemplate = stylesheet.findNamedTemplate(qname);
            }
        } else {
            namedTemplate = (ElemTemplateElement)obj;
        }
        return namedTemplate;
    }

    class MatchPattern2
    implements Serializable {
        Stylesheet m_stylesheet;
        String m_targetString;
        XPath m_expression;
        int m_posInStylesheet;
        double m_priority = Double.NEGATIVE_INFINITY;
        private String m_pattern;
        private ElemTemplate m_template;
        private MatchPattern2 m_next;

        MatchPattern2(String pat, XPath exp, ElemTemplate template, int posInStylesheet, String targetString, Stylesheet stylesheet) {
            TemplateList.this = TemplateList.this;
            this.m_pattern = pat;
            this.m_template = template;
            this.m_posInStylesheet = posInStylesheet;
            this.m_targetString = targetString;
            this.m_stylesheet = stylesheet;
            this.m_expression = exp;
        }

        public XPath getExpression() {
            return this.m_expression;
        }

        public String getPattern() {
            return this.m_pattern;
        }

        public ElemTemplate getTemplate() {
            return this.m_template;
        }

        public MatchPattern2 getNext() {
            return this.m_next;
        }

        public void setNext(MatchPattern2 mp) {
            this.m_next = mp;
        }
    }
}

