/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.apache.xalan.xpath.XBoolean;
import org.apache.xalan.xpath.XLocator;
import org.apache.xalan.xpath.XNodeSet;
import org.apache.xalan.xpath.XNull;
import org.apache.xalan.xpath.XNumber;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathEnvSupport;
import org.apache.xalan.xpath.XPathFactory;
import org.apache.xalan.xpath.XPathProcessorImpl;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XRTreeFrag;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.xdom.XercesLiaison;
import org.apache.xalan.xpath.xml.FormatterToDOM;
import org.apache.xalan.xpath.xml.FormatterToHTML;
import org.apache.xalan.xpath.xml.FormatterToXML;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.ProblemListener;
import org.apache.xalan.xpath.xml.ProblemListenerDefault;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.RawCharacterHandler;
import org.apache.xalan.xpath.xml.StringToStringTable;
import org.apache.xalan.xpath.xml.TreeWalker;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xalan.xslt.Arg;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.ElemWithParam;
import org.apache.xalan.xslt.ResultNameSpace;
import org.apache.xalan.xslt.ResultTreeFrag;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.StylesheetHandler;
import org.apache.xalan.xslt.StylesheetRoot;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.apache.xalan.xslt.trace.GenerateEvent;
import org.apache.xalan.xslt.trace.TraceListener;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.misc.LexicalHandler;

public class XSLTEngineImpl
implements XPathEnvSupport,
XSLTProcessor {
    StylesheetRoot m_stylesheetRoot;
    Node m_rootDoc;
    static final double m_XSLTVerSupported = 1.0;
    static final String m_XSLNameSpaceURL = "http://www.w3.org/1999/XSL/Transform";
    static final String m_XSLT4JNameSpaceURL = "http://xml.apache.org/xslt";
    boolean m_quietConflictWarnings = false;
    private boolean m_traceTemplateChildren = false;
    private boolean m_traceTemplates = false;
    boolean m_traceSelects = false;
    PrintWriter m_diagnosticsPrintWriter;
    Hashtable m_durationsTable = new Hashtable();
    Stack m_stylesheetLocatorStack = new Stack();
    protected String m_pendingElementName;
    protected boolean m_pendingStartDoc = false;
    AttributeListImpl m_pendingAttributes = new AttributeListImpl();
    protected Stack m_resultNameSpaces = new Stack();
    static final ResultNameSpace m_emptyNamespace = new ResultNameSpace(null, null);
    int m_uniqueNSValue;
    private static Hashtable m_cssKeys = null;
    boolean m_translateCSS = false;
    Vector m_topLevelParams = new Vector();
    XMLParserLiaison m_parserLiaison;
    DocumentHandler m_flistener;
    Document m_resultTreeFactory;
    protected Node m_currentNode;
    boolean m_needToCheckForInfiniteLoops = false;
    private StackGuard m_stackGuard = new StackGuard();
    VariableStack m_variableStacks = new VariableStack();
    boolean m_outputCarriageReturns = false;
    boolean m_outputLinefeeds = false;
    private String m_outputFileName;
    Stack m_cdataStack = new Stack();
    ResultTreeHandler m_resultTreeHandler = new ResultTreeHandler();
    private static XSLMessages m_XSLMessages = new XSLMessages();
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    transient Vector m_key_tables;
    transient Stack m_attrSetStack;
    transient Vector m_traceListeners;
    private FormatterToDOM m_sourceTreeHandler;
    private OutputStream m_outputStream;
    boolean m_mustFlushStartDoc = false;

    private void ____GENERAL_VARIABLES____() {
    }

    private void ____CONSTRUCTORS____() {
    }

    protected XSLTEngineImpl() throws SAXException {
        try {
            String parserLiaisonClassName = "org.apache.xalan.xpath.dtm.DTMLiaison";
            Class<?> parserLiaisonClass = Class.forName(parserLiaisonClassName);
            Constructor<?> parserLiaisonCtor = parserLiaisonClass.getConstructor(null);
            this.m_parserLiaison = (XMLParserLiaison)parserLiaisonCtor.newInstance(null);
            this.m_parserLiaison.setEnvSupport(this);
        }
        catch (Exception e) {
            throw new XSLProcessorException(e);
        }
    }

    public XSLTEngineImpl(String parserLiaisonClassName) throws SAXException {
        try {
            Class<?> parserLiaisonClass = Class.forName(parserLiaisonClassName);
            Constructor<?> parserLiaisonCtor = parserLiaisonClass.getConstructor(null);
            this.m_parserLiaison = (XMLParserLiaison)parserLiaisonCtor.newInstance(null);
            this.m_parserLiaison.setEnvSupport(this);
        }
        catch (Exception e) {
            throw new XSLProcessorException(e);
        }
    }

    public XSLTEngineImpl(XMLParserLiaison parserLiason) {
        this.m_parserLiaison = parserLiason;
        this.m_parserLiaison.setEnvSupport(this);
    }

    XSLTEngineImpl(XMLParserLiaison parserLiason, XPathFactory xpathFactory) {
        this.m_parserLiaison = parserLiason;
        this.m_parserLiaison.setEnvSupport(this);
    }

    public void reset() {
        this.m_stylesheetRoot = null;
        this.m_rootDoc = null;
        this.m_durationsTable.clear();
        this.m_stylesheetLocatorStack.removeAllElements();
        this.m_stylesheetLocatorStack = new Stack();
        this.m_pendingElementName = null;
        this.m_pendingAttributes.clear();
        this.m_pendingAttributes = new AttributeListImpl();
        this.m_resultNameSpaces.removeAllElements();
        this.m_cdataStack = new Stack();
        this.m_resultTreeFactory = null;
        this.m_currentNode = null;
        this.m_needToCheckForInfiniteLoops = false;
        this.m_variableStacks = new VariableStack();
        this.m_stackGuard = new StackGuard();
        this.m_parserLiaison.reset();
    }

    private void writeObject(ObjectOutputStream stream) throws SAXException, IOException {
        this.error(47);
    }

    private void ____MAIN_API____() {
    }

    public void process(XSLTInputSource inputSource, XSLTInputSource stylesheetSource, XSLTResultTarget outputTarget) throws SAXException {
        try {
            String xslIdentifier = stylesheetSource == null || stylesheetSource.getSystemId() == null ? "Input XSL" : stylesheetSource.getSystemId();
            Boolean totalTimeID = new Boolean(true);
            this.pushTime(totalTimeID);
            Node sourceTree = null;
            if (inputSource != null) {
                sourceTree = this.getSourceTreeFromInput(inputSource);
            }
            if (stylesheetSource != null) {
                this.m_stylesheetRoot = this.processStylesheet(stylesheetSource);
            } else if (sourceTree != null) {
                String stylesheetURI = null;
                Stack<String> hrefs = new Stack<String>();
                Node child = sourceTree.getFirstChild();
                while (child != null) {
                    ProcessingInstruction pi;
                    if (child.getNodeType() == 7 && ((pi = (ProcessingInstruction)child).getNodeName().equals("xml-stylesheet") || pi.getNodeName().equals("xml:stylesheet"))) {
                        boolean isOK = true;
                        StringTokenizer tokenizer = new StringTokenizer(pi.getNodeValue(), " \t=");
                        while (tokenizer.hasMoreTokens()) {
                            if (!tokenizer.nextToken().equals("type")) continue;
                            String typeVal = tokenizer.nextToken();
                            if ((typeVal = typeVal.substring(1, typeVal.length() - 1)).equals("text/xsl")) continue;
                            isOK = false;
                        }
                        if (isOK) {
                            tokenizer = new StringTokenizer(pi.getNodeValue(), " \t=");
                            while (tokenizer.hasMoreTokens()) {
                                if (!tokenizer.nextToken().equals("href")) continue;
                                stylesheetURI = tokenizer.nextToken();
                                stylesheetURI = stylesheetURI.substring(1, stylesheetURI.length() - 1);
                                hrefs.push(stylesheetURI);
                            }
                        }
                    }
                    child = child.getNextSibling();
                }
                boolean isRoot = true;
                Stylesheet prevStylesheet = null;
                while (!hrefs.isEmpty()) {
                    Stylesheet stylesheet = this.getStylesheetFromPIURL((String)hrefs.pop(), sourceTree, inputSource != null ? inputSource.getSystemId() : null, isRoot);
                    if (!isRoot) {
                        prevStylesheet.m_imports.addElement(stylesheet);
                    }
                    prevStylesheet = stylesheet;
                    isRoot = false;
                }
            } else {
                this.error(48);
            }
            if (this.m_stylesheetRoot == null) {
                this.error(49);
            }
            if (sourceTree != null) {
                this.m_stylesheetRoot.process((XSLTProcessor)this, sourceTree, outputTarget);
                if (this.m_diagnosticsPrintWriter != null) {
                    this.displayDuration("Total time", totalTimeID);
                }
            }
        }
        catch (MalformedURLException mue) {
            this.error(0, new Object[]{mue.getMessage()}, mue);
        }
        catch (FileNotFoundException fnfe) {
            this.error(0, new Object[]{fnfe.getMessage()}, fnfe);
        }
        catch (IOException ioe) {
            this.error(0, new Object[]{ioe.getMessage()}, ioe);
        }
        catch (SAXException se) {
            this.error(87, se);
        }
    }

    protected StylesheetRoot createStylesheetRoot(String baseIdentifier) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        return new StylesheetRoot(this, baseIdentifier);
    }

    public StylesheetRoot processStylesheet(XSLTInputSource stylesheetSource) throws SAXException {
        if (this.m_stylesheetRoot != null) {
            this.reset();
        }
        String xslIdentifier = stylesheetSource == null || stylesheetSource.getSystemId() == null ? "Input XSL" : stylesheetSource.getSystemId();
        try {
            this.m_stylesheetRoot = this.createStylesheetRoot(stylesheetSource.getSystemId());
            this.addTraceListenersToStylesheet();
            StylesheetHandler stylesheetProcessor = new StylesheetHandler(this, this.m_stylesheetRoot);
            if (stylesheetSource.getNode() != null) {
                if (stylesheetSource.getNode() instanceof StylesheetRoot) {
                    this.m_stylesheetRoot = (StylesheetRoot)stylesheetSource.getNode();
                } else {
                    TreeWalker tw = new TreeWalker(stylesheetProcessor);
                    tw.traverse(stylesheetSource.getNode());
                }
            } else {
                this.diag("========= Parsing " + xslIdentifier + " ==========");
                this.pushTime(xslIdentifier);
                this.m_parserLiaison.setDocumentHandler(stylesheetProcessor);
                this.m_parserLiaison.parse(stylesheetSource);
                if (this.m_diagnosticsPrintWriter != null) {
                    this.displayDuration("Parse of " + xslIdentifier, xslIdentifier);
                }
            }
        }
        catch (Exception e) {
            this.error(50, new Object[]{xslIdentifier}, e);
        }
        return this.m_stylesheetRoot;
    }

    public StylesheetRoot processStylesheet(String xsldocURLString) throws SAXException {
        try {
            XSLTInputSource input = new XSLTInputSource(this.getURLFromString(xsldocURLString, null).toString());
            return this.processStylesheet(input);
        }
        catch (SAXException se) {
            this.error(86, se);
            return null;
        }
    }

    public void setStylesheet(StylesheetRoot stylesheetRoot) {
        this.m_stylesheetRoot = stylesheetRoot;
    }

    public StylesheetRoot getStylesheet() {
        return this.m_stylesheetRoot;
    }

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public void setOutputFileName(String filename) {
        this.m_outputFileName = filename;
    }

    private void ____XML_PARSING_FUNCTIONS____() {
    }

    public URL getURLFromString(String urlString, String base) throws SAXException {
        return this.m_parserLiaison.getURLFromString(urlString, base);
    }

    public Node getSourceTreeFromInput(XSLTInputSource inputSource) throws SAXException {
        Node sourceTree;
        String xmlIdentifier;
        String string = xmlIdentifier = inputSource == null || inputSource.getSystemId() == null ? "Input XML" : inputSource.getSystemId();
        if (inputSource.getNode() != null) {
            sourceTree = inputSource.getNode();
        } else {
            try {
                this.diag("========= Parsing " + xmlIdentifier + " ==========");
                this.pushTime(xmlIdentifier);
                this.m_parserLiaison.parse(inputSource);
                if (this.m_diagnosticsPrintWriter != null) {
                    this.displayDuration("Parse of " + xmlIdentifier, xmlIdentifier);
                }
                sourceTree = this.m_parserLiaison.getDocument();
            }
            catch (Exception e) {
                if (e instanceof SAXException && ((SAXException)e).getException() != null) {
                    e = ((SAXException)e).getException();
                }
                sourceTree = null;
                this.error(50, new Object[]{xmlIdentifier}, e);
            }
        }
        return sourceTree;
    }

    public Document parseXML(URL url, DocumentHandler docHandler, Document docToRegister) throws SAXException, IOException {
        Object docObj = this.getSourceDocsTable().get(url.toExternalForm());
        if (docObj != null) {
            return (Document)docObj;
        }
        XSLTInputSource inputSource = new XSLTInputSource(url.toString());
        if (docHandler != null) {
            this.m_parserLiaison.setDocumentHandler(docHandler);
        }
        this.m_parserLiaison.parse(inputSource);
        Document doc = docHandler == null ? this.m_parserLiaison.getDocument() : docToRegister;
        return doc;
    }

    Stylesheet getStylesheetFromPIURL(String xslURLString, Node fragBase, String xmlBaseIdent, boolean isRoot) throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        Stylesheet stylesheet = null;
        String[] stringHolder = new String[]{null};
        int fragIndex = (xslURLString = xslURLString.trim()).indexOf(35);
        if (fragIndex == 0) {
            Node frag;
            this.diag("Locating stylesheet from fragment identifier...");
            String fragID = xslURLString.substring(1);
            PrefixResolver nsNode = this.getExecContext().getNamespaceContext();
            XPathProcessorImpl parser = new XPathProcessorImpl();
            XPath xpath = new XPath();
            parser.initXPath(xpath, "id(" + fragID + ")", nsNode);
            XObject xobj = xpath.execute(this.getExecContext(), fragBase, nsNode);
            NodeList nl = xobj.nodeset();
            if (nl.getLength() == 0) {
                xpath = new XPath();
                parser.initXPath(xpath, "//*[@id='" + fragID + "']", nsNode);
                xobj = xpath.execute(this.getExecContext(), fragBase, nsNode);
                nl = xobj.nodeset();
                if (nl.getLength() == 0) {
                    xpath = new XPath();
                    parser.initXPath(xpath, "//*[@name='" + fragID + "']", nsNode);
                    xobj = xpath.execute(this.getExecContext(), fragBase, nsNode);
                    nl = xobj.nodeset();
                    if (nl.getLength() == 0) {
                        xpath = new XPath();
                        parser.initXPath(xpath, fragID, nsNode);
                        xobj = xpath.execute(this.getExecContext(), fragBase, nsNode);
                        nl = xobj.nodeset();
                    }
                }
            }
            if (nl.getLength() == 0) {
                this.error(51, new Object[]{fragID});
            }
            if ((frag = nl.item(0)).getNodeType() == 1) {
                this.pushTime(frag);
                stylesheet = isRoot ? (this.m_stylesheetRoot = this.createStylesheetRoot(stringHolder[0])) : new Stylesheet(this.m_stylesheetRoot, this, stringHolder[0]);
                this.addTraceListenersToStylesheet();
                StylesheetHandler stylesheetProcessor = new StylesheetHandler(this, stylesheet);
                TreeWalker tw = new TreeWalker(stylesheetProcessor);
                tw.traverse(frag);
                this.displayDuration("Setup of " + xslURLString, frag);
            } else {
                Object stylesheetDoc = null;
                this.error(52, new Object[]{fragID});
            }
        } else {
            this.diag(XSLMessages.createMessage(13, new Object[]{xslURLString}));
            this.pushTime(xslURLString);
            stylesheet = isRoot ? (this.m_stylesheetRoot = this.createStylesheetRoot(xslURLString)) : new Stylesheet(this.m_stylesheetRoot, this, xslURLString);
            this.addTraceListenersToStylesheet();
            StylesheetHandler stylesheetProcessor = new StylesheetHandler(this, stylesheet);
            URL xslURL = this.getURLFromString(xslURLString, xmlBaseIdent);
            XSLTInputSource inputSource = new XSLTInputSource(xslURL.toString());
            this.m_parserLiaison.setDocumentHandler(stylesheetProcessor);
            this.m_parserLiaison.parse(inputSource);
            this.displayDuration("Parsing and init of " + xslURLString, xslURLString);
        }
        return stylesheet;
    }

    private void ____SOURCE_TREE_TABLES____() {
    }

    public String findURIFromDoc(Document doc) {
        return this.m_parserLiaison.findURIFromDoc(doc);
    }

    public Hashtable getSourceDocsTable() {
        return this.m_parserLiaison.getSourceDocsTable();
    }

    public void setSourceDocument(String uri, Document doc) {
        this.m_parserLiaison.getSourceDocsTable().put(uri, doc);
    }

    private void ____EXTENSION_HANDLING____() {
    }

    public void outputToResultTree(Stylesheet stylesheetTree, Object obj) throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        XObject value = obj instanceof XObject ? (XObject)obj : (obj instanceof String ? new XString((String)obj) : (obj instanceof Boolean ? new XBoolean((Boolean)obj) : (obj instanceof Double ? new XNumber((Double)obj) : (obj instanceof DocumentFragment ? new XRTreeFrag((DocumentFragment)obj) : (obj instanceof Node ? new XNodeSet((Node)obj) : (obj instanceof NodeList ? new XNodeSet((NodeList)obj) : new XString(obj.toString())))))));
        int type = value.getType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: {
                String s = value.str();
                this.m_resultTreeHandler.characters(s.toCharArray(), 0, s.length());
                break;
            }
            case 4: {
                NodeList nl = value.nodeset();
                int nChildren = nl.getLength();
                int i = 0;
                while (i < nChildren) {
                    Node pos;
                    Node top = pos = nl.item(i);
                    while (pos != null) {
                        this.flushPending();
                        this.cloneToResultTree(stylesheetTree, pos, false, false, true);
                        Node nextNode = pos.getFirstChild();
                        while (nextNode == null) {
                            if (pos.getNodeType() == 1) {
                                this.m_resultTreeHandler.endElement(pos.getNodeName());
                            }
                            if (top == pos) break;
                            nextNode = pos.getNextSibling();
                            if (nextNode != null || top != (pos = pos.getParentNode())) continue;
                            if (pos.getNodeType() == 1) {
                                this.m_resultTreeHandler.endElement(pos.getNodeName());
                            }
                            nextNode = null;
                            break;
                        }
                        pos = nextNode;
                    }
                    ++i;
                }
                break;
            }
            case 5: {
                this.outputResultTreeFragment(value, this.m_parserLiaison);
                break;
            }
        }
    }

    public boolean functionAvailable(String namespace, String extensionName) {
        return this.m_parserLiaison.functionAvailable(namespace, extensionName);
    }

    public Object extFunction(String namespace, String extensionName, Vector argVec) throws SAXException {
        return this.m_parserLiaison.extFunction(namespace, extensionName, argVec);
    }

    protected void handleFunctionsInstruction(Element extensionElem) throws SAXException {
        throw new XSLProcessorException("xsl:functions is unsupported");
    }

    private void ____ERROR_AND_DIAGNOSTIC____() {
    }

    public void addTraceListener(TraceListener tl) throws TooManyListenersException {
        if (this.m_traceListeners == null) {
            this.m_traceListeners = new Vector();
        }
        this.m_traceListeners.addElement(tl);
        if (this.m_stylesheetRoot != null) {
            this.m_stylesheetRoot.addTraceListener(tl);
        }
    }

    void addTraceListenersToStylesheet() throws SAXException {
        try {
            if (this.m_traceListeners != null) {
                int nListeners = this.m_traceListeners.size();
                int i = 0;
                while (i < nListeners) {
                    TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i);
                    if (this.m_stylesheetRoot != null) {
                        this.m_stylesheetRoot.addTraceListener(tl);
                    }
                    ++i;
                }
            }
        }
        catch (TooManyListenersException tmle) {
            throw new SAXException("addTraceListenersToStylesheet - TooManyListenersException", tmle);
        }
    }

    public void removeTraceListener(TraceListener tl) {
        if (this.m_traceListeners != null) {
            this.m_traceListeners.removeElement(tl);
        }
        if (this.m_stylesheetRoot != null) {
            this.m_stylesheetRoot.removeTraceListener(tl);
        }
    }

    void fireGenerateEvent(GenerateEvent te) {
        if (this.m_traceListeners != null) {
            int nListeners = this.m_traceListeners.size();
            int i = 0;
            while (i < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i);
                tl.generated(te);
                ++i;
            }
        }
    }

    public void message(String msg) throws SAXException {
        this.message(null, null, msg);
    }

    public void message(Node styleNode, Node sourceNode, String msg) throws SAXException {
        boolean shouldThrow = this.getProblemListener().message(msg);
        if (shouldThrow) {
            throw new XSLProcessorException(msg);
        }
    }

    public void warn(int msg) throws SAXException {
        this.warn(null, null, msg, null);
    }

    public void warn(int msg, Object[] args) throws SAXException {
        this.warn(null, null, msg, args);
    }

    public void warn(Node styleNode, Node sourceNode, int msg) throws SAXException {
        this.warn(styleNode, sourceNode, msg, null);
    }

    public void warn(Node styleNode, Node sourceNode, int msg, Object[] args) throws SAXException {
        Locator locator;
        String formattedMsg = XSLMessages.createWarning(msg, args);
        Locator locator2 = locator = this.m_stylesheetLocatorStack.isEmpty() ? null : (Locator)this.m_stylesheetLocatorStack.peek();
        String id = locator == null ? null : (locator.getSystemId() == null ? locator.getPublicId() : locator.getSystemId());
        boolean shouldThrow = this.getProblemListener().problem((short)2, (short)1, styleNode, sourceNode, formattedMsg, id, locator == null ? 0 : locator.getLineNumber(), locator == null ? 0 : locator.getColumnNumber());
        if (shouldThrow) {
            throw new XSLProcessorException(formattedMsg);
        }
    }

    public void error(int msg) throws SAXException {
        this.error(null, null, msg, null);
    }

    public void error(int msg, Object[] args) throws SAXException {
        this.error(null, null, msg, args);
    }

    public void error(int msg, Exception e) throws SAXException {
        this.error(msg, null, e);
    }

    public void error(int msg, Object[] args, Exception e) throws SAXException {
        Locator locator;
        String formattedMsg = XSLMessages.createMessage(msg, args);
        Locator locator2 = locator = this.m_stylesheetLocatorStack.isEmpty() ? null : (Locator)this.m_stylesheetLocatorStack.peek();
        String id = locator == null ? null : (locator.getSystemId() == null ? locator.getPublicId() : locator.getSystemId());
        boolean shouldThrow = this.getProblemListener().problem((short)2, (short)2, null, null, formattedMsg, id, locator == null ? 0 : locator.getLineNumber(), locator == null ? 0 : locator.getColumnNumber());
        if (shouldThrow) {
            if (e instanceof XSLProcessorException) {
                throw (XSLProcessorException)e;
            }
            throw new XSLProcessorException(formattedMsg, e);
        }
    }

    public void error(Node styleNode, Node sourceNode, int msg) throws SAXException {
        this.error(styleNode, sourceNode, msg, null);
    }

    public void error(Node styleNode, Node sourceNode, int msg, Object[] args) throws SAXException {
        Locator locator;
        String formattedMsg = XSLMessages.createMessage(msg, args);
        Locator locator2 = locator = this.m_stylesheetLocatorStack.isEmpty() ? null : (Locator)this.m_stylesheetLocatorStack.peek();
        String id = locator == null ? null : (locator.getSystemId() == null ? locator.getPublicId() : locator.getSystemId());
        boolean shouldThrow = this.getProblemListener().problem((short)2, (short)2, styleNode, sourceNode, formattedMsg, id, locator == null ? 0 : locator.getLineNumber(), locator == null ? 0 : locator.getColumnNumber());
        if (shouldThrow) {
            throw new XSLProcessorException("");
        }
    }

    public void pushTime(Object key) {
        if (key != null) {
            this.m_durationsTable.put(key, new Date());
        }
    }

    public long popDuration(Object key) {
        long millisecondsDuration = 0L;
        if (key != null) {
            Date date1 = (Date)this.m_durationsTable.get(key);
            Date date2 = new Date();
            millisecondsDuration = date2.getTime() - date1.getTime();
            this.m_durationsTable.remove(key);
        }
        return millisecondsDuration;
    }

    protected void displayDuration(String info, Object key) {
        long millisecondsDuration = 0L;
        if (key != null) {
            Date date1 = (Date)this.m_durationsTable.get(key);
            Date date2 = new Date();
            millisecondsDuration = date2.getTime() - date1.getTime();
            if (this.m_diagnosticsPrintWriter != null) {
                this.m_diagnosticsPrintWriter.println(String.valueOf(info) + " took " + millisecondsDuration + " milliseconds");
            }
            this.m_durationsTable.remove(key);
        }
    }

    public void setDiagnosticsOutput(OutputStream out) {
        this.setDiagnosticsOutput(new PrintWriter(out));
    }

    public void setDiagnosticsOutput(PrintWriter pw) {
        this.m_diagnosticsPrintWriter = pw;
        if (this.getProblemListener() instanceof ProblemListenerDefault) {
            ((ProblemListenerDefault)this.getProblemListener()).setDiagnosticsOutput(pw);
        }
    }

    protected void diag(String s) {
        if (this.m_diagnosticsPrintWriter != null) {
            this.m_diagnosticsPrintWriter.println(s);
        }
    }

    public void setTraceTemplates(boolean b) {
        this.m_traceTemplates = b;
    }

    public void setTraceSelect(boolean b) {
        this.m_traceSelects = b;
    }

    public void setTraceTemplateChildren(boolean b) {
        this.m_traceTemplateChildren = b;
    }

    public void setQuietConflictWarnings(boolean b) {
        this.m_quietConflictWarnings = b;
    }

    protected void traceSelect(Element template, NodeList nl) throws SAXException {
        String msg = String.valueOf(template.getNodeName()) + ": ";
        Attr attr = template.getAttributeNode("select");
        msg = attr != null ? String.valueOf(msg) + attr.getValue() + ", " + (nl != null ? nl.getLength() : 0) + " selected" : String.valueOf(msg) + "*|text(), (default select), " + nl.getLength() + " selected";
        attr = template.getAttributeNode("mode");
        if (attr != null) {
            msg = String.valueOf(msg) + ", mode = " + attr.getValue();
        }
        System.out.println(msg);
    }

    protected void traceTemplate(Node templateNode) throws SAXException {
        if (templateNode.getNodeType() == 1) {
            String msg;
            Element template = (Element)templateNode;
            Attr attr = template.getAttributeNode("match");
            if (attr != null) {
                msg = "Calling template for: " + attr.getValue();
            } else {
                attr = template.getAttributeNode("name");
                if (attr != null) {
                    msg = "Calling named template, name = " + attr.getValue();
                } else {
                    int xslToken = ((ElemTemplateElement)template).getXSLToken();
                    if (xslToken == 28) {
                        attr = template.getAttributeNode("select");
                        if (attr != null) {
                            msg = "Processing for-each, select = " + attr.getValue();
                        } else {
                            this.error(53);
                            msg = null;
                        }
                    } else {
                        this.error(54);
                        msg = null;
                    }
                }
            }
            attr = template.getAttributeNode("mode");
            if (attr != null) {
                msg = String.valueOf(msg) + ", mode = " + attr.getValue();
            }
            System.out.println(msg);
        }
    }

    protected void diagnoseTemplateChildren(Node templateChild, Node sourceNode) {
        if (this.m_traceTemplateChildren) {
            String templateChildTagName = templateChild.getNodeName();
            String xmlElemName = sourceNode.getNodeName();
            this.diag("source node: " + xmlElemName + ", template-node: " + templateChildTagName);
        }
    }

    private void ____RESULT_TREE_CREATION___() {
    }

    protected void cloneToResultTree(Stylesheet stylesheetTree, Node node, boolean shouldCloneWithChildren, boolean overrideStrip, boolean shouldCloneAttributes) throws SAXException, SAXException, MalformedURLException, FileNotFoundException, IOException {
        boolean stripWhiteSpace = false;
        switch (node.getNodeType()) {
            case 3: {
                if (!overrideStrip) {
                    stripWhiteSpace = false;
                }
                Text tx = (Text)node;
                String data = null;
                if (stripWhiteSpace) {
                    if (!this.m_parserLiaison.isIgnorableWhitespace(tx) && (data = this.getNormalizedText(tx)) != null && this.isWhiteSpace(data)) {
                        data = null;
                    }
                } else {
                    Node parent = node.getParentNode();
                    if (parent != null) {
                        if (parent.getNodeType() != 9 && (data = this.getNormalizedText(tx)) != null && data.length() == 0) {
                            data = null;
                        }
                    } else {
                        data = this.getNormalizedText(tx);
                        if (data != null && data.length() == 0) {
                            data = null;
                        }
                    }
                }
                if (data == null) break;
                if (this.m_parserLiaison.isIgnorableWhitespace(tx)) {
                    this.m_resultTreeHandler.ignorableWhitespace(data.toCharArray(), 0, data.length());
                    break;
                }
                this.m_resultTreeHandler.characters(data.toCharArray(), 0, data.length());
                break;
            }
            case 1: {
                if (shouldCloneAttributes) {
                    this.copyAttributesToAttList(node, this.m_stylesheetRoot, (Element)node, this.m_pendingAttributes);
                    this.copySourceNSAttrs(node, this.m_pendingAttributes);
                }
                this.m_resultTreeHandler.startElement(node.getNodeName());
                break;
            }
            case 4: {
                String data = ((CDATASection)node).getData();
                this.m_resultTreeHandler.cdata(data.toCharArray(), 0, data.length());
                break;
            }
            case 2: {
                this.addResultAttribute(this.m_pendingAttributes, ((Attr)node).getName(), ((Attr)node).getValue());
                break;
            }
            case 8: {
                this.m_resultTreeHandler.comment(((Comment)node).getData());
                break;
            }
            case 11: {
                this.error(null, node, 55);
                break;
            }
            case 5: {
                EntityReference er = (EntityReference)node;
                this.m_resultTreeHandler.entityReference(er.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                this.m_resultTreeHandler.processingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            default: {
                this.error(56, new Object[]{node.getNodeName()});
            }
            case 9: 
        }
    }

    DocumentFragment createResultTreeFrag(Stylesheet stylesheetTree, ElemTemplateElement templateParent, Node sourceTree, Node sourceNode, QName mode) throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        DocumentFragment resultFragment = this.createDocFrag();
        DocumentHandler savedFListener = this.m_flistener;
        boolean savedMustFlushStartDoc = this.m_mustFlushStartDoc;
        boolean savedPendingStartDoc = this.m_pendingStartDoc;
        String savedPendingName = this.m_pendingElementName;
        this.m_pendingElementName = null;
        AttributeListImpl savedPendingAttributes = this.m_pendingAttributes;
        this.m_pendingAttributes = new AttributeListImpl();
        this.m_flistener = new FormatterToDOM(this.m_resultTreeFactory, resultFragment);
        templateParent.executeChildren(this, sourceTree, sourceNode, mode);
        this.m_pendingElementName = savedPendingName;
        this.m_pendingAttributes = savedPendingAttributes;
        this.m_mustFlushStartDoc = savedMustFlushStartDoc;
        this.m_pendingStartDoc = savedPendingStartDoc;
        this.m_flistener = savedFListener;
        return resultFragment;
    }

    public void writeChildren(DocumentHandler flistener, Stylesheet stylesheetTree, ElemTemplateElement templateParent, Node sourceTree, Node sourceNode, QName mode) throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        this.flushPending();
        DocumentHandler savedFormatterListener = this.m_flistener;
        String savedPendingName = this.m_pendingElementName;
        this.m_pendingElementName = null;
        AttributeListImpl savedPendingAttributes = this.m_pendingAttributes;
        this.m_pendingAttributes = new AttributeListImpl();
        this.m_flistener = flistener;
        templateParent.executeChildren(this, sourceTree, sourceNode, mode);
        this.flushPending();
        this.m_flistener = savedFormatterListener;
        this.m_pendingElementName = savedPendingName;
        this.m_pendingAttributes = savedPendingAttributes;
    }

    public void outputResultTreeFragment(XObject obj, XPathSupport support) throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        DocumentFragment docFrag = obj.rtree(support);
        NodeList nl = docFrag.getChildNodes();
        int nChildren = nl.getLength();
        TreeWalker tw = new TreeWalker(this.m_flistener);
        int i = 0;
        while (i < nChildren) {
            this.flushPending();
            tw.traverse(nl.item(i));
            ++i;
        }
    }

    private void ____ATTRIBUTES___() {
    }

    boolean isCDataResultElem(String elementName) {
        boolean is = false;
        QName[] cdataElems = this.m_stylesheetRoot.m_cdataSectionElems;
        if (cdataElems != null) {
            String prefix;
            String elemNS = null;
            String elemLocalName = null;
            int indexOfNSSep = elementName.indexOf(58);
            if (indexOfNSSep > 0 && (elemNS = (prefix = elementName.substring(0, indexOfNSSep)).equals("xml") ? "http://www.w3.org/XML/1998/namespace" : this.getResultNamespaceForPrefix(prefix)) == null) {
                throw new RuntimeException("Prefix must resolve to a namespace: " + prefix);
            }
            elemLocalName = indexOfNSSep < 0 ? elementName : elementName.substring(indexOfNSSep + 1);
            int n = cdataElems.length;
            int i = 0;
            while (i < n) {
                QName qname = cdataElems[i];
                is = qname.equals(elemNS, elemLocalName);
                if (is) break;
                ++i;
            }
        }
        return is;
    }

    boolean qnameEqualsResultElemName(QName qname, String elementName) {
        String prefix;
        String elemNS = null;
        String elemLocalName = null;
        int indexOfNSSep = elementName.indexOf(58);
        if (indexOfNSSep > 0 && (elemNS = (prefix = elementName.substring(0, indexOfNSSep)).equals("xml") ? "http://www.w3.org/XML/1998/namespace" : this.getResultNamespaceForPrefix(prefix)) == null) {
            throw new RuntimeException("Prefix must resolve to a namespace: " + prefix);
        }
        elemLocalName = indexOfNSSep < 0 ? elementName : elementName.substring(indexOfNSSep + 1);
        return qname.equals(elemNS, elemLocalName);
    }

    String getResultNamespaceForPrefix(String prefix) {
        String namespace = null;
        int nParents = this.m_resultNameSpaces.size();
        int i = nParents - 1;
        while (i >= 0 && namespace == null) {
            ResultNameSpace rns = (ResultNameSpace)this.m_resultNameSpaces.elementAt(i);
            if (m_emptyNamespace != rns) {
                while (rns != null) {
                    if (rns.m_prefix.equals(prefix)) {
                        namespace = rns.m_uri;
                        break;
                    }
                    rns = rns.m_next;
                }
            }
            --i;
        }
        return namespace;
    }

    String getResultPrefixForNamespace(String namespace) {
        String prefix = null;
        int nParents = this.m_resultNameSpaces.size();
        int i = nParents - 1;
        while (i >= 0 && prefix == null) {
            ResultNameSpace rns = (ResultNameSpace)this.m_resultNameSpaces.elementAt(i);
            if (m_emptyNamespace != rns) {
                while (rns != null) {
                    if (rns.m_uri.equals(namespace)) {
                        prefix = rns.m_prefix;
                        break;
                    }
                    rns = rns.m_next;
                }
            }
            --i;
        }
        return prefix;
    }

    private String getPrefixForNamespace(String namespace, Element namespaceContext) {
        short type;
        Node parent = namespaceContext;
        String prefix = null;
        while (parent != null && prefix == null && ((type = parent.getNodeType()) == 1 || type == 5)) {
            if (type == 1) {
                NamedNodeMap nnm = parent.getAttributes();
                int i = 0;
                while (i < nnm.getLength()) {
                    Node attr = nnm.item(i);
                    String aname = attr.getNodeName();
                    boolean isPrefix = aname.startsWith("xmlns:");
                    if (isPrefix || aname.equals("xmlns")) {
                        int index = aname.indexOf(58);
                        String namespaceOfPrefix = attr.getNodeValue();
                        if (namespaceOfPrefix != null && namespaceOfPrefix.equals(namespace)) {
                            prefix = isPrefix ? aname.substring(index + 1) : "";
                        }
                    }
                    ++i;
                }
            }
            parent = this.m_parserLiaison.getParentOfNode(parent);
        }
        return prefix;
    }

    void copySourceNSAttrs(Node src, AttributeListImpl destination) {
        short type;
        Node parent = src;
        while (parent != null && ((type = parent.getNodeType()) == 1 || type == 5)) {
            if (type == 1) {
                NamedNodeMap nnm = parent.getAttributes();
                int nAttrs = nnm.getLength();
                int i = 0;
                while (i < nAttrs) {
                    Node attr = nnm.item(i);
                    String aname = attr.getNodeName();
                    boolean isPrefix = aname.startsWith("xmlns:");
                    if (isPrefix || aname.equals("xmlns")) {
                        String prefix = isPrefix ? aname.substring(6) : "";
                        String desturi = this.getResultNamespaceForPrefix(prefix);
                        String srcURI = attr.getNodeValue();
                        if (!srcURI.equalsIgnoreCase(desturi)) {
                            this.addResultAttribute(this.m_pendingAttributes, aname, srcURI);
                        }
                    }
                    ++i;
                }
            }
            parent = parent.getParentNode();
        }
    }

    static final String getAttrVal(Element el, String key, Node contextNode) {
        Attr a = el.getAttributeNode(key);
        return a == null ? null : a.getValue();
    }

    static final String getAttrVal(Element el, String key) {
        Attr a = el.getAttributeNode(key);
        return a == null ? null : a.getValue();
    }

    protected void copyAttributeToTarget(Attr attr, Node contextNode, Stylesheet stylesheetTree, AttributeListImpl attrList, Element namespaceContext) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        String attrName = attr.getName().trim();
        String stringedValue = attr.getValue();
        if (stringedValue != null) {
            if ((attrName.equals("xmlns") || attrName.startsWith("xmlns:")) && stringedValue.startsWith("quote:")) {
                stringedValue = stringedValue.substring(6);
            }
            this.addResultAttribute(attrList, attrName, stringedValue);
        }
    }

    protected void copyAttributesToAttList(Node contextNode, Stylesheet stylesheetTree, Element templateChild, AttributeListImpl attList) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        NamedNodeMap attributes = templateChild.getAttributes();
        int nAttributes = attributes != null ? attributes.getLength() : 0;
        String attrSetUseVal = null;
        int i = 0;
        while (i < nAttributes) {
            Attr attr = (Attr)attributes.item(i);
            if (this.m_parserLiaison.getExpandedAttributeName(attr).equals(String.valueOf(this.m_stylesheetRoot.m_XSLNameSpaceURL) + ":use")) {
                attrSetUseVal = attr.getValue();
            } else {
                this.copyAttributeToTarget(attr, contextNode, stylesheetTree, attList, templateChild);
            }
            ++i;
        }
    }

    public void setTranslateCSS(boolean b) {
        this.m_translateCSS = b;
    }

    private void ____WHITESPACE____() {
    }

    public boolean shouldStripSourceNode(Node textNode) throws SAXException {
        boolean strip = false;
        short type = textNode.getNodeType();
        if (type == 3 || type == 4) {
            if (!this.m_parserLiaison.isIgnorableWhitespace((Text)textNode)) {
                String data = ((Text)textNode).getData();
                if (data == null) {
                    return true;
                }
                if (!this.isWhiteSpace(data)) {
                    return false;
                }
            }
            Node parent = this.m_parserLiaison.getParentOfNode(textNode);
            while (parent != null) {
                if (parent.getNodeType() == 1) {
                    Element parentElem = (Element)parent;
                    Attr attr = parentElem.getAttributeNode("xml:space");
                    if (attr != null) {
                        String xmlSpaceVal = attr.getValue();
                        if (xmlSpaceVal.equals("preserve")) {
                            strip = false;
                            break;
                        }
                        if (xmlSpaceVal.equals("default")) {
                            strip = true;
                            break;
                        }
                        this.error(57, new Object[]{xmlSpaceVal});
                        break;
                    }
                    double highPreserveScore = Double.NEGATIVE_INFINITY;
                    double highStripScore = Double.NEGATIVE_INFINITY;
                    if (this.m_stylesheetRoot != null) {
                        double score;
                        XPath matchPat;
                        int i;
                        int nTests;
                        if (this.m_stylesheetRoot.m_whitespacePreservingElements != null) {
                            nTests = this.m_stylesheetRoot.m_whitespacePreservingElements.size();
                            i = 0;
                            while (i < nTests) {
                                matchPat = (XPath)this.m_stylesheetRoot.m_whitespacePreservingElements.elementAt(i);
                                score = matchPat.getMatchScore(this.getExecContext(), parent);
                                if (score > highPreserveScore) {
                                    highPreserveScore = score;
                                }
                                ++i;
                            }
                        }
                        if (this.m_stylesheetRoot.m_whitespaceStrippingElements != null) {
                            nTests = this.m_stylesheetRoot.m_whitespaceStrippingElements.size();
                            i = 0;
                            while (i < nTests) {
                                matchPat = (XPath)this.m_stylesheetRoot.m_whitespaceStrippingElements.elementAt(i);
                                score = matchPat.getMatchScore(this.getExecContext(), parent);
                                if (score > highStripScore) {
                                    highStripScore = score;
                                }
                                ++i;
                            }
                        }
                    }
                    if (highPreserveScore > Double.NEGATIVE_INFINITY || highStripScore > Double.NEGATIVE_INFINITY) {
                        if (highPreserveScore > highStripScore) {
                            strip = false;
                            break;
                        }
                        if (highStripScore > highPreserveScore) {
                            strip = true;
                            break;
                        }
                        this.warn(15);
                        break;
                    }
                }
                parent = parent.getParentNode();
            }
        }
        return strip;
    }

    public static boolean isSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public boolean isWhiteSpace(String string) {
        char[] buf = string.toCharArray();
        int len = buf.length;
        boolean isWhiteSpace = true;
        int s = 0;
        while (s < len) {
            if (!XSLTEngineImpl.isSpace(buf[s])) {
                isWhiteSpace = false;
                break;
            }
            ++s;
        }
        return isWhiteSpace;
    }

    public String fixWhiteSpace(String string, boolean trimHead, boolean trimTail, boolean doublePunctuationSpaces) {
        char[] buf = string.toCharArray();
        int len = buf.length;
        boolean edit = false;
        int s = 0;
        while (s < len) {
            if (XSLTEngineImpl.isSpace(buf[s])) break;
            ++s;
        }
        int d = s;
        boolean pres = false;
        while (s < len) {
            char c = buf[s];
            if (XSLTEngineImpl.isSpace(c)) {
                if (!pres) {
                    if (c != ' ') {
                        edit = true;
                    }
                    buf[d++] = 32;
                    if (doublePunctuationSpaces && s != 0) {
                        char prevChar = buf[s - 1];
                        if (prevChar != '.' && prevChar != '!' && prevChar != '?') {
                            pres = true;
                        }
                    } else {
                        pres = true;
                    }
                } else {
                    edit = true;
                    pres = true;
                }
            } else {
                buf[d++] = c;
                pres = false;
            }
            ++s;
        }
        if (trimTail && d >= 1 && buf[d - 1] == ' ') {
            edit = true;
            --d;
        }
        int start = 0;
        if (trimHead && d > 0 && buf[0] == ' ') {
            edit = true;
            ++start;
        }
        return edit ? new String(buf, start, d - start) : string;
    }

    String trim(String string) {
        char[] buf = string.toCharArray();
        int len = buf.length;
        boolean edit = false;
        int s = 0;
        int e = 0;
        if (len > 0) {
            s = 0;
            while (s < len) {
                if (!XSLTEngineImpl.isSpace(buf[s])) break;
                ++s;
            }
            e = len;
            while (e > s) {
                if (!XSLTEngineImpl.isSpace(buf[e - 1])) break;
                --e;
            }
            edit = s > 0 || e < len;
        }
        return edit ? new String(buf, s, e - s) : string;
    }

    int trimLen(String string) {
        char[] buf = string.toCharArray();
        int len = buf.length;
        int s = 0;
        while (s < len) {
            if (!XSLTEngineImpl.isSpace(buf[s])) break;
            ++s;
        }
        int e = len;
        while (e > s) {
            if (!XSLTEngineImpl.isSpace(buf[e - 1])) break;
            --e;
        }
        return e - s;
    }

    public void setOutputCarriageReturns(boolean b) {
        this.m_outputCarriageReturns = b;
    }

    public void setOutputLinefeeds(boolean b) {
        this.m_outputLinefeeds = b;
    }

    String getNormalizedText(Text tx) {
        if (!this.m_outputCarriageReturns && !this.m_outputLinefeeds) {
            return tx.getData();
        }
        String src = tx.getData();
        int nSrcChars = src.length();
        StringBuffer sb = new StringBuffer(nSrcChars + 8);
        int prevChar = 0;
        int i = 0;
        while (i < nSrcChars) {
            char c = src.charAt(i);
            if (c == '\n') {
                if (prevChar != 13) {
                    if (this.m_outputCarriageReturns) {
                        sb.append('\r');
                    }
                    if (this.m_outputLinefeeds) {
                        sb.append('\n');
                    }
                }
            } else if (c == '\r') {
                if (this.m_outputCarriageReturns) {
                    sb.append('\r');
                }
                if (this.m_outputLinefeeds) {
                    sb.append('\n');
                }
            } else {
                sb.append(c);
            }
            prevChar = c;
            ++i;
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private void ____SUPPORT____() {
    }

    public XPathSupport getExecContext() {
        return this.m_parserLiaison;
    }

    public XMLParserLiaison getXMLProcessorLiaison() {
        return this.m_parserLiaison;
    }

    public XString createXString(String s) {
        return new XString(s);
    }

    public XObject createXObject(Object o) {
        return new XObject(o);
    }

    public XNumber createXNumber(double d) {
        return new XNumber(d);
    }

    public XBoolean createXBoolean(boolean b) {
        return new XBoolean(b);
    }

    public XNodeSet createXNodeSet(NodeList nl) {
        return new XNodeSet(nl);
    }

    public XNodeSet createXNodeSet(Node n) {
        return new XNodeSet(n);
    }

    public XNull createXNull() {
        return new XNull();
    }

    public NodeList getNodeSetByKey(Node doc, String name, String ref, PrefixResolver nscontext) throws SAXException {
        NodeList nl = this.m_stylesheetRoot.getNodeSetByKey(this, doc, name, ref, nscontext);
        if (nl == null) {
            this.error(58, new Object[]{name});
        }
        return nl;
    }

    Element getElementByID(String id, Document doc) {
        return this.m_parserLiaison.getElementByID(id, doc);
    }

    public XObject getVariable(QName qname) throws SAXException {
        Object obj = this.m_variableStacks.getVariable(qname);
        if (obj != null && !(obj instanceof XObject)) {
            obj = new XObject(obj);
        }
        return (XObject)obj;
    }

    public XLocator getXLocatorFromNode(Node node) {
        return this.m_parserLiaison.getXLocatorFromNode(node);
    }

    public void associateXLocatorToNode(Node node, XLocator xlocator) {
        this.m_parserLiaison.associateXLocatorToNode(node, xlocator);
    }

    DocumentFragment createDocFrag() {
        if (this.m_resultTreeFactory == null) {
            this.m_resultTreeFactory = this.m_parserLiaison.createDocument();
        }
        return new ResultTreeFrag(this.m_resultTreeFactory, this.m_parserLiaison);
    }

    public String getStyleSheetURIfromDoc(Node sourceTree) {
        String stylesheetURI = null;
        Node child = sourceTree.getFirstChild();
        while (child != null) {
            ProcessingInstruction pi;
            if (child.getNodeType() == 7 && ((pi = (ProcessingInstruction)child).getNodeName().equals("xml-stylesheet") || pi.getNodeName().equals("xml:stylesheet"))) {
                boolean isOK = true;
                StringTokenizer tokenizer = new StringTokenizer(pi.getNodeValue(), " \t=");
                while (tokenizer.hasMoreTokens()) {
                    if (!tokenizer.nextToken().equals("type")) continue;
                    String typeVal = tokenizer.nextToken();
                    if ((typeVal = typeVal.substring(1, typeVal.length() - 1)).equals("text/xsl")) continue;
                    isOK = false;
                }
                if (isOK) {
                    tokenizer = new StringTokenizer(pi.getNodeValue(), " \t=");
                    while (tokenizer.hasMoreTokens()) {
                        if (!tokenizer.nextToken().equals("href")) continue;
                        stylesheetURI = tokenizer.nextToken();
                        stylesheetURI = stylesheetURI.substring(1, stylesheetURI.length() - 1);
                    }
                    break;
                }
            }
            child = child.getNextSibling();
        }
        return stylesheetURI;
    }

    public void setStylesheetParam(String key, String expression) {
        QName qname = new QName(key, this.m_parserLiaison.getNamespaceContext());
        this.m_topLevelParams.addElement(new Arg(qname, expression, true));
    }

    public void setStylesheetParam(String key, XObject value) {
        QName qname = new QName(key, this.m_parserLiaison.getNamespaceContext());
        this.m_topLevelParams.addElement(new Arg(qname, value));
    }

    void resolveTopLevelParams() throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        this.m_stylesheetRoot.pushTopLevelVariables(this.m_topLevelParams, this);
    }

    public Node getSourceNode() {
        return this.m_currentNode;
    }

    public Node getSourceNode(String selectPattern, PrefixResolver namespaceContext) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        XObject xobj = this.m_stylesheetRoot.evalXPathStr(this.getExecContext(), selectPattern, this.m_currentNode, namespaceContext);
        NodeList sourceNodes = xobj.nodeset();
        return sourceNodes != null && sourceNodes.getLength() > 0 ? sourceNodes.item(0) : null;
    }

    protected void resetCurrentState(Node sourceTree, Node xmlNode) {
        if (xmlNode != null) {
            this.m_currentNode = xmlNode;
        }
    }

    protected Element findElementByAttribute(Node elem, String targetElementName, String targetAttributeName, String targetAttributeValue) {
        Element theFoundElement = null;
        String tagName = elem.getNodeName();
        if (targetElementName == null || tagName.equals(targetElementName)) {
            NamedNodeMap attributes = elem.getAttributes();
            try {
                int nAttributes = attributes != null ? attributes.getLength() : 0;
                int i = 0;
                while (i < nAttributes) {
                    String attrVal;
                    Attr attr = (Attr)attributes.item(i);
                    String attrName = attr.getName();
                    if (attrName != null && attrName.equals(targetAttributeName) && (attrVal = attr.getValue()).equals(targetAttributeValue)) {
                        theFoundElement = (Element)elem;
                        break;
                    }
                    ++i;
                }
            }
            catch (DOMException dOMException) {}
        }
        if (theFoundElement == null) {
            Node childNode = elem.getFirstChild();
            while (childNode != null) {
                String childName;
                if (childNode.getNodeType() == 1 && (childName = childNode.getNodeName()) != null && (theFoundElement = this.findElementByAttribute(childNode, targetElementName, targetAttributeName, targetAttributeValue)) != null) break;
                childNode = childNode.getNextSibling();
            }
        }
        return theFoundElement;
    }

    URL getURLFromString(String urlString) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                String lastPart = new File(urlString).getAbsolutePath();
                String fullpath = "file:" + lastPart;
                url = new URL(fullpath);
            }
            catch (MalformedURLException e2) {
                this.diag(XSLMessages.createMessage(59, new Object[]{urlString}));
                throw e2;
            }
        }
        return url;
    }

    public DocumentHandler getDocumentHandler() {
        return this.m_flistener;
    }

    public void setDocumentHandler(DocumentHandler listener) {
        this.m_flistener = listener;
    }

    public DocumentHandler getFormatterListener() {
        return this.m_flistener;
    }

    public void setFormatterListener(DocumentHandler flistener) {
        this.m_flistener = flistener;
    }

    public Document getDOMFactory() {
        if (this.m_resultTreeFactory == null) {
            this.m_resultTreeFactory = this.m_parserLiaison.createDocument();
        }
        return this.m_resultTreeFactory;
    }

    public void setProblemListener(ProblemListener l) {
        this.m_parserLiaison.setProblemListener(l);
    }

    public ProblemListener getProblemListener() {
        return this.m_parserLiaison.getProblemListener();
    }

    private void ____FormatterListener_INTERFACE____() {
    }

    public void setOutputStream(OutputStream os) {
        this.m_outputStream = os;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.m_sourceTreeHandler = new FormatterToDOM(this.m_parserLiaison.createDocument());
        ErrorHandler errHandler = this.m_parserLiaison.getErrorHandler();
        this.m_parserLiaison = new XercesLiaison(errHandler);
        StylesheetRoot stylesheet = this.m_stylesheetRoot;
        this.reset();
        this.m_stylesheetRoot = stylesheet;
        this.m_sourceTreeHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.m_sourceTreeHandler.endDocument();
        try {
            XSLTResultTarget result = this.m_outputStream == null ? new XSLTResultTarget(this.m_flistener) : new XSLTResultTarget(this.m_outputStream);
            this.m_stylesheetRoot.process((XSLTProcessor)this, this.m_sourceTreeHandler.getRootNode(), result);
        }
        catch (Exception e) {
            if (!(e instanceof SAXException)) {
                throw new SAXException(e);
            }
            throw (SAXException)e;
        }
        this.m_sourceTreeHandler = null;
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        this.m_sourceTreeHandler.startElement(name, atts);
    }

    public void endElement(String name) throws SAXException {
        this.m_sourceTreeHandler.endElement(name);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_sourceTreeHandler.characters(ch, start, length);
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        this.m_sourceTreeHandler.charactersRaw(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.m_sourceTreeHandler.charactersRaw(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.m_sourceTreeHandler.processingInstruction(target, data);
    }

    public void comment(String data) throws SAXException {
        this.m_sourceTreeHandler.comment(data);
    }

    public void entityReference(String name) throws SAXException {
        this.m_sourceTreeHandler.entityReference(name);
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        this.m_sourceTreeHandler.cdata(ch, start, length);
    }

    /*
     * Unable to fully structure code
     */
    void addResultAttribute(AttributeListImpl attList, String aname, String value) {
        block1: {
            isPrefix = aname.startsWith("xmlns:");
            if (!aname.equals("xmlns") && !isPrefix) break block1;
            p = isPrefix != false ? aname.substring(6) : "";
            ns = new ResultNameSpace(p, value);
            if (this.m_resultNameSpaces.isEmpty()) break block1;
            nsOnStack = (ResultNameSpace)this.m_resultNameSpaces.peek();
            if (XSLTEngineImpl.m_emptyNamespace != nsOnStack) ** GOTO lbl11
            this.m_resultNameSpaces.setElementAt(ns, this.m_resultNameSpaces.size() - 1);
            break block1;
lbl-1000:
            // 1 sources

            {
                nsOnStack = nsOnStack.m_next;
lbl11:
                // 2 sources

                ** while (nsOnStack.m_next != null)
            }
lbl12:
            // 1 sources

            nsOnStack.m_next = ns;
        }
        attList.removeAttribute(aname);
        attList.addAttribute(aname, "CDATA", value);
    }

    private boolean pendingHasDefaultNS() {
        if (this.m_pendingAttributes != null) {
            int n = this.m_pendingAttributes.getLength();
            int i = 0;
            while (i < n) {
                if (this.m_pendingAttributes.getName(i).equals("xmlns")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private String excludePrefix(String name) {
        int indexOfNSSep;
        if (this.m_stylesheetRoot != null && (indexOfNSSep = name.indexOf(58)) > 0) {
            String prefix = name.substring(0, indexOfNSSep);
            StringToStringTable erp = this.m_stylesheetRoot.getExcludeResultPrefixes();
            if (erp != null && erp.contains(prefix)) {
                name = name.substring(indexOfNSSep + 1);
            }
        }
        return name;
    }

    protected void flushPending() throws SAXException {
        if (this.m_pendingStartDoc && this.m_pendingElementName != null && !this.m_stylesheetRoot.isOutputMethodSet() && this.m_pendingElementName.equalsIgnoreCase("html") && !this.pendingHasDefaultNS()) {
            FormatterToXML xmlListener;
            try {
                xmlListener = (FormatterToXML)this.m_flistener;
            }
            catch (ClassCastException classCastException) {
                xmlListener = null;
            }
            if (xmlListener != null) {
                this.m_stylesheetRoot.setOutputMethod("html");
                this.m_flistener = new FormatterToHTML(xmlListener);
            }
        }
        if (this.m_pendingStartDoc && this.m_mustFlushStartDoc) {
            this.m_pendingStartDoc = false;
            this.m_flistener.startDocument();
            if (this.m_traceListeners != null) {
                this.fireGenerateEvent(new GenerateEvent(this, 1));
            }
        }
        if (this.m_pendingElementName != null && this.m_mustFlushStartDoc) {
            if (this.m_stylesheetRoot.m_cdataSectionElems != null) {
                if (this.isCDataResultElem(this.m_pendingElementName)) {
                    this.m_cdataStack.push(TRUE);
                } else {
                    this.m_cdataStack.push(FALSE);
                }
            }
            this.m_flistener.startElement(this.m_pendingElementName, this.m_pendingAttributes);
            if (this.m_traceListeners != null) {
                this.fireGenerateEvent(new GenerateEvent(this, 3, this.m_pendingElementName, this.m_pendingAttributes));
            }
            this.m_pendingAttributes.clear();
            this.m_pendingElementName = null;
        }
    }

    class XSLInfiniteLoopException
    extends Error {
        XSLInfiniteLoopException() {
            XSLTEngineImpl.this = XSLTEngineImpl.this;
        }

        public String getMessage() {
            return "Processing Terminated.";
        }
    }

    class StackGuard {
        Node m_xslRule;
        Node m_sourceXML;
        Stack stack = new Stack();

        public StackGuard() {
            XSLTEngineImpl.this = XSLTEngineImpl.this;
        }

        public StackGuard(Node xslTemplate, Node sourceXML) {
            XSLTEngineImpl.this = XSLTEngineImpl.this;
            this.m_xslRule = xslTemplate;
            this.m_sourceXML = sourceXML;
        }

        public boolean equals(Object obj) {
            return ((StackGuard)obj).m_xslRule.equals(this.m_xslRule) && ((StackGuard)obj).m_sourceXML.equals(this.m_sourceXML);
        }

        public void print(PrintWriter pw) {
            if (this.m_sourceXML instanceof Text) {
                Text tx = (Text)this.m_sourceXML;
                pw.println(tx.getData());
            } else if (this.m_sourceXML instanceof Element) {
                Element elem = (Element)this.m_sourceXML;
                pw.println(elem.getNodeName());
            }
        }

        public void checkForInfinateLoop(StackGuard guard) {
            int nRules = this.stack.size();
            int loopCount = 0;
            int i = nRules - 1;
            while (i >= 0) {
                if (this.stack.elementAt(i).equals(guard)) {
                    ++loopCount;
                }
                if (loopCount >= 4) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println("Infinite loop diagnosed!  Stack trace:");
                    int k = 0;
                    while (k < nRules) {
                        pw.println("Source Elem #" + k + " ");
                        StackGuard guardOnStack = (StackGuard)this.stack.elementAt(i);
                        guardOnStack.print(pw);
                        ++k;
                    }
                    pw.println("Source Elem #" + k + " ");
                    guard.print(pw);
                    pw.println("End of infinite loop diagnosis.");
                    XSLTEngineImpl.this.diag(sw.getBuffer().toString());
                    throw new XSLInfiniteLoopException();
                }
                --i;
            }
        }

        public void push(Node xslTemplate, Node sourceXML) {
            StackGuard guard = new StackGuard(xslTemplate, sourceXML);
            this.checkForInfinateLoop(guard);
            this.stack.push(guard);
        }

        public void pop() {
            this.stack.pop();
        }
    }

    class ContextState {
        Node m_caller;
        Node m_source;

        ContextState(Node caller, Node sourceNode) {
            XSLTEngineImpl.this = XSLTEngineImpl.this;
            this.m_caller = caller;
            this.m_source = sourceNode;
        }
    }

    class ContextMarker
    extends ContextState {
        ContextMarker(Node caller, Node sourceNode) {
            super(caller, sourceNode);
            XSLTEngineImpl.this = XSLTEngineImpl.this;
        }
    }

    class ElementMarker {
        Node m_elem;

        ElementMarker(Node elem) {
            XSLTEngineImpl.this = XSLTEngineImpl.this;
            this.m_elem = elem;
        }
    }

    class VariableStack
    extends Stack {
        Element m_caller;

        VariableStack() {
            XSLTEngineImpl.this = XSLTEngineImpl.this;
            this.pushContextMarker(null, null);
        }

        void pushElementMarker(Node elem) {
            this.push(new ElementMarker(elem));
        }

        void popElementMarker(Node elem) {
            if (this.elementMarkerAlreadyPushed(elem)) {
                int nElems = this.size();
                int i = nElems - 1;
                while (i >= 0) {
                    Object obj = this.elementAt(i);
                    if (obj instanceof ElementMarker) {
                        this.pop();
                        break;
                    }
                    this.pop();
                    --i;
                }
            }
        }

        boolean elementMarkerAlreadyPushed(Node elem) {
            boolean alreadyPushed = false;
            int nElems = this.size();
            int i = nElems - 1;
            while (i >= 0) {
                Object obj = this.elementAt(i);
                if (obj instanceof ElementMarker) {
                    if (((ElementMarker)obj).m_elem != elem) break;
                    alreadyPushed = true;
                    break;
                }
                --i;
            }
            return alreadyPushed;
        }

        void pushContextMarker(Node caller, Node sourceNode) {
            this.push(new ContextMarker(caller, sourceNode));
        }

        void popCurrentContext() {
            int nElems = this.size();
            int i = nElems - 1;
            while (i >= 0) {
                Object obj = this.peek();
                if (obj instanceof ContextMarker) {
                    this.pop();
                    break;
                }
                this.pop();
                --i;
            }
        }

        void pushParams(XPathSupport execContext, Stylesheet stylesheetTree, ElemTemplateElement xslCallTemplateElement, Node sourceTree, Node sourceNode, QName mode, Node targetTemplate) throws SAXException, MalformedURLException, FileNotFoundException, IOException, SAXException {
            Stack<Arg> tempStack = new Stack<Arg>();
            ContextMarker cm = (ContextMarker)this.pop();
            ElemTemplateElement child = (ElemTemplateElement)xslCallTemplateElement.getFirstChild();
            while (child != null) {
                if (child.getXSLToken() == 2) {
                    XObject var;
                    ElemWithParam xslParamElement = (ElemWithParam)child;
                    if (xslParamElement.m_selectPattern != null) {
                        var = xslParamElement.m_selectPattern.execute(execContext, sourceNode, xslParamElement);
                    } else {
                        DocumentFragment df = XSLTEngineImpl.this.createResultTreeFrag(stylesheetTree, xslParamElement, sourceTree, sourceNode, mode);
                        var = new XRTreeFrag(df);
                    }
                    Arg arg = new Arg(xslParamElement.m_qname, var, true);
                    tempStack.push(arg);
                }
                child = child.m_nextSibling;
            }
            this.push(cm);
            this.pushElementMarker(targetTemplate);
            int nParams = tempStack.size();
            int i = 0;
            while (i < nParams) {
                this.push(tempStack.elementAt(i));
                ++i;
            }
        }

        boolean hasParamVariable(QName qname) throws SAXException {
            boolean hasit = false;
            int nElems = this.size();
            int i = nElems - 1;
            while (i >= 0) {
                Object obj = this.elementAt(i);
                if (obj instanceof Arg) {
                    if (((Arg)obj).equals(qname)) {
                        hasit = true;
                        break;
                    }
                } else if (obj instanceof ContextMarker) break;
                --i;
            }
            return hasit;
        }

        XObject getParamVariable(QName qname) throws SAXException {
            XObject val = null;
            int nElems = this.size();
            int i = nElems - 1;
            while (i >= 0) {
                Object obj = this.elementAt(i);
                if (obj instanceof Arg) {
                    if (((Arg)obj).equals(qname)) {
                        val = ((Arg)obj).m_val;
                        break;
                    }
                } else if (obj instanceof ContextMarker) break;
                --i;
            }
            return val;
        }

        Object getVariable(QName name) throws SAXException {
            XObject val = null;
            int nElems = this.size();
            int i = nElems - 1;
            while (i >= 0) {
                Object obj = this.elementAt(i);
                if (obj instanceof Arg) {
                    if (((Arg)obj).equals(name)) {
                        val = ((Arg)obj).m_val;
                        break;
                    }
                } else if (obj instanceof ContextMarker) break;
                --i;
            }
            if (val == null) {
                Object obj;
                int i2 = 2;
                while (i2 < nElems - 1) {
                    obj = this.elementAt(i2);
                    if (obj instanceof ContextMarker) break;
                    ++i2;
                }
                --i2;
                while (i2 >= 2) {
                    obj = this.elementAt(i2);
                    if (obj instanceof Arg) {
                        if (((Arg)obj).equals(name)) {
                            val = ((Arg)obj).m_val;
                            break;
                        }
                    } else if (obj instanceof ContextMarker) break;
                    --i2;
                }
            }
            return val;
        }

        void pushVariable(QName qname, XObject val, Node e) {
            if (!this.elementMarkerAlreadyPushed(e)) {
                this.pushElementMarker(e);
            }
            Arg arg = new Arg(qname, val, false);
            this.push(arg);
        }
    }

    class ResultTreeHandler
    implements DocumentHandler,
    RawCharacterHandler {
        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            XSLTEngineImpl.this.m_uniqueNSValue = 0;
            XSLTEngineImpl.this.m_pendingStartDoc = true;
            XSLTEngineImpl.this.m_mustFlushStartDoc = false;
            if (XSLTEngineImpl.this.m_traceListeners != null) {
                XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 1));
            }
        }

        public void endDocument() throws SAXException {
            XSLTEngineImpl.this.m_mustFlushStartDoc = true;
            XSLTEngineImpl.this.flushPending();
            XSLTEngineImpl.this.m_flistener.endDocument();
            if (XSLTEngineImpl.this.m_traceListeners != null) {
                XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 2));
            }
            XSLTEngineImpl.this.m_variableStacks.popCurrentContext();
        }

        public void startElement(String name) throws SAXException {
            XSLTEngineImpl.this.flushPending();
            XSLTEngineImpl.this.m_resultNameSpaces.push(m_emptyNamespace);
            XSLTEngineImpl.this.m_pendingElementName = name;
            XSLTEngineImpl.this.m_mustFlushStartDoc = true;
        }

        public void startElement(String name, AttributeList atts) throws SAXException {
            name = XSLTEngineImpl.this.excludePrefix(name);
            XSLTEngineImpl.this.flushPending();
            int nAtts = atts.getLength();
            XSLTEngineImpl.this.m_pendingAttributes.clear();
            int i = 0;
            while (i < nAtts) {
                XSLTEngineImpl.this.m_pendingAttributes.addAttribute(atts.getName(i), atts.getType(i), atts.getValue(i));
                ++i;
            }
            XSLTEngineImpl.this.m_resultNameSpaces.push(m_emptyNamespace);
            XSLTEngineImpl.this.m_pendingElementName = name;
            XSLTEngineImpl.this.m_mustFlushStartDoc = true;
        }

        public void endElement(String name) throws SAXException {
            name = XSLTEngineImpl.this.excludePrefix(name);
            XSLTEngineImpl.this.flushPending();
            XSLTEngineImpl.this.m_flistener.endElement(name);
            if (XSLTEngineImpl.this.m_traceListeners != null) {
                XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 4, name, null));
            }
            XSLTEngineImpl.this.m_resultNameSpaces.pop();
            if (XSLTEngineImpl.this.m_stylesheetRoot.m_cdataSectionElems != null) {
                XSLTEngineImpl.this.m_cdataStack.pop();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!XSLTEngineImpl.this.m_mustFlushStartDoc) {
                int n = ch.length;
                int i = 0;
                while (i < n) {
                    if (!Character.isSpaceChar(ch[i])) {
                        XSLTEngineImpl.this.m_mustFlushStartDoc = true;
                        break;
                    }
                    ++i;
                }
            }
            if (XSLTEngineImpl.this.m_mustFlushStartDoc) {
                XSLTEngineImpl.this.flushPending();
                if (XSLTEngineImpl.this.m_stylesheetRoot.m_cdataSectionElems != null && !XSLTEngineImpl.this.m_cdataStack.isEmpty() && XSLTEngineImpl.this.m_cdataStack.peek() == TRUE) {
                    boolean isLexHandler = XSLTEngineImpl.this.m_flistener instanceof LexicalHandler;
                    if (isLexHandler) {
                        ((LexicalHandler)XSLTEngineImpl.this.m_flistener).startCDATA();
                    }
                    XSLTEngineImpl.this.m_flistener.characters(ch, start, length);
                    if (isLexHandler) {
                        ((LexicalHandler)XSLTEngineImpl.this.m_flistener).endCDATA();
                    }
                    if (XSLTEngineImpl.this.m_traceListeners != null) {
                        XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 10, ch, start, length));
                    }
                } else {
                    XSLTEngineImpl.this.m_flistener.characters(ch, start, length);
                    if (XSLTEngineImpl.this.m_traceListeners != null) {
                        XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 5, ch, start, length));
                    }
                }
            }
        }

        public void charactersRaw(char[] ch, int start, int length) throws SAXException {
            XSLTEngineImpl.this.m_mustFlushStartDoc = true;
            XSLTEngineImpl.this.flushPending();
            if (XSLTEngineImpl.this.m_flistener instanceof FormatterToXML) {
                ((FormatterToXML)XSLTEngineImpl.this.m_flistener).charactersRaw(ch, start, length);
            } else if (XSLTEngineImpl.this.m_flistener instanceof FormatterToDOM) {
                ((FormatterToDOM)XSLTEngineImpl.this.m_flistener).charactersRaw(ch, start, length);
            } else {
                XSLTEngineImpl.this.m_flistener.characters(ch, start, length);
            }
            if (XSLTEngineImpl.this.m_traceListeners != null) {
                XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 5, ch, start, length));
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (XSLTEngineImpl.this.m_mustFlushStartDoc) {
                XSLTEngineImpl.this.flushPending();
                XSLTEngineImpl.this.m_flistener.ignorableWhitespace(ch, start, length);
                if (XSLTEngineImpl.this.m_traceListeners != null) {
                    XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 6, ch, start, length));
                }
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
            XSLTEngineImpl.this.m_mustFlushStartDoc = true;
            XSLTEngineImpl.this.flushPending();
            XSLTEngineImpl.this.m_flistener.processingInstruction(target, data);
            if (XSLTEngineImpl.this.m_traceListeners != null) {
                XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 7, target, data));
            }
        }

        public void comment(String data) throws SAXException {
            XSLTEngineImpl.this.m_mustFlushStartDoc = true;
            XSLTEngineImpl.this.flushPending();
            if (XSLTEngineImpl.this.m_flistener instanceof LexicalHandler) {
                ((LexicalHandler)XSLTEngineImpl.this.m_flistener).comment(data.toCharArray(), 0, data.length());
            }
            if (XSLTEngineImpl.this.m_traceListeners != null) {
                XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 8, data));
            }
        }

        public void entityReference(String name) throws SAXException {
            XSLTEngineImpl.this.m_mustFlushStartDoc = true;
            XSLTEngineImpl.this.flushPending();
            if (XSLTEngineImpl.this.m_flistener instanceof LexicalHandler) {
                ((LexicalHandler)XSLTEngineImpl.this.m_flistener).startEntity(name);
                ((LexicalHandler)XSLTEngineImpl.this.m_flistener).endEntity(name);
            }
            if (XSLTEngineImpl.this.m_traceListeners != null) {
                XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 9, name));
            }
        }

        public void cdata(char[] ch, int start, int length) throws SAXException {
            XSLTEngineImpl.this.m_mustFlushStartDoc = true;
            XSLTEngineImpl.this.flushPending();
            if (XSLTEngineImpl.this.m_stylesheetRoot.m_cdataSectionElems != null && !XSLTEngineImpl.this.m_cdataStack.isEmpty() && XSLTEngineImpl.this.m_cdataStack.peek() == TRUE) {
                boolean isLexH = XSLTEngineImpl.this.m_flistener instanceof LexicalHandler;
                if (XSLTEngineImpl.this.m_flistener instanceof LexicalHandler) {
                    ((LexicalHandler)XSLTEngineImpl.this.m_flistener).startCDATA();
                }
                XSLTEngineImpl.this.m_flistener.characters(ch, start, length);
                if (XSLTEngineImpl.this.m_flistener instanceof LexicalHandler) {
                    ((LexicalHandler)XSLTEngineImpl.this.m_flistener).endCDATA();
                }
                if (XSLTEngineImpl.this.m_traceListeners != null) {
                    XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 10, ch, start, length));
                }
            } else {
                XSLTEngineImpl.this.m_flistener.characters(ch, start, length);
                if (XSLTEngineImpl.this.m_traceListeners != null) {
                    XSLTEngineImpl.this.fireGenerateEvent(new GenerateEvent(XSLTEngineImpl.this, 5, ch, start, length));
                }
            }
        }

        ResultTreeHandler() {
            XSLTEngineImpl.this = XSLTEngineImpl.this;
        }
    }
}

