/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt.extensions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Hashtable;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.StylesheetRoot;
import org.apache.xalan.xslt.XSLProcessorContext;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Element;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class Redirect {
    protected Hashtable m_formatterListeners = new Hashtable();
    protected Hashtable m_outputStreams = new Hashtable();

    public void open(XSLProcessorContext context, Element elem) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        String fileName = this.getFilename(context, elem);
        Object flistener = this.m_formatterListeners.get(fileName);
        if (flistener == null) {
            DocumentHandler documentHandler = this.makeFormatterListener(context, fileName, true);
        }
    }

    public void write(XSLProcessorContext context, Element elem) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        OutputStream ostream;
        DocumentHandler formatter;
        String fileName = this.getFilename(context, elem);
        Object flObject = this.m_formatterListeners.get(fileName);
        boolean inTable = false;
        if (flObject == null) {
            formatter = this.makeFormatterListener(context, fileName, true);
        } else {
            inTable = true;
            formatter = (DocumentHandler)flObject;
        }
        context.processor.writeChildren(formatter, context.stylesheetTree, (ElemTemplateElement)elem, context.sourceTree, context.sourceNode, context.mode);
        if (!inTable && (ostream = (OutputStream)this.m_outputStreams.get(fileName)) != null) {
            ostream.close();
            this.m_outputStreams.remove(fileName);
            this.m_formatterListeners.remove(fileName);
        }
    }

    public void close(XSLProcessorContext context, Element elem) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        String fileName = this.getFilename(context, elem);
        Object formatterObj = this.m_formatterListeners.get(fileName);
        if (formatterObj != null) {
            OutputStream ostream = (OutputStream)this.m_outputStreams.get(fileName);
            if (ostream != null) {
                ostream.close();
                this.m_outputStreams.remove(fileName);
            }
            DocumentHandler fl = (DocumentHandler)formatterObj;
            fl.endDocument();
            this.m_formatterListeners.remove(fileName);
        }
    }

    private String getFilename(XSLProcessorContext context, Element elem) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        String fileName;
        String fileNameExpr = elem.getAttribute("select");
        if (fileNameExpr != null) {
            XPathSupport execContext = context.processor.getExecContext();
            XObject xobj = context.processor.getStylesheet().evalXPathStr(execContext, fileNameExpr, context.sourceNode, execContext.getNamespaceContext());
            fileName = xobj.str();
            if (fileName == null || fileName.length() == 0) {
                fileName = elem.getAttribute("file");
            }
        } else {
            fileName = elem.getAttribute("file");
        }
        if (fileName == null) {
            context.processor.error(elem, context.sourceNode, 93);
        }
        return fileName;
    }

    private DocumentHandler makeFormatterListener(XSLProcessorContext context, String fileName, boolean shouldPutInTable) throws MalformedURLException, FileNotFoundException, IOException, SAXException {
        File file = new File(fileName);
        if (!file.isAbsolute() && context.processor.getOutputFileName() != null) {
            File baseFile = new File(context.processor.getOutputFileName());
            file = new File(baseFile.getParent(), fileName);
        }
        StylesheetRoot sr = context.stylesheetTree.m_stylesheetRoot;
        OutputFormat formatter = sr.getOutputFormat();
        FileOutputStream ostream = new FileOutputStream(file);
        DocumentHandler flistener = sr.makeSAXSerializer(ostream, formatter);
        flistener.startDocument();
        if (shouldPutInTable) {
            this.m_outputStreams.put(fileName, ostream);
            this.m_formatterListeners.put(fileName, flistener);
        }
        return flistener;
    }
}

