/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.events.EventImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.apache.xerces.dom.traversal.NodeIteratorImpl;
import org.apache.xerces.domx.events.Event;
import org.apache.xerces.domx.events.EventListener;
import org.apache.xerces.domx.events.EventTarget;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeImpl
implements Node,
NodeList,
EventTarget,
Cloneable,
Serializable {
    static final long serialVersionUID = 2815829867052120872L;
    public static final short ELEMENT_DEFINITION_NODE = -1;
    protected DocumentImpl ownerDocument;
    protected NodeImpl parentNode;
    protected NodeImpl previousSibling;
    protected NodeImpl nextSibling;
    protected String name;
    protected String value;
    protected boolean readOnly;
    protected Object userData;
    protected NodeImpl firstChild;
    protected NodeImpl lastChild;
    protected transient boolean syncChildren;
    protected transient boolean syncData;
    int changes;
    protected static int[] kidOK = new int[13];
    protected static final boolean MUTATIONEVENTS = true;
    protected static final int MUTATION_NONE = 0;
    protected static final int MUTATION_LOCAL = 1;
    protected static final int MUTATION_AGGREGATE = 2;
    protected static final int MUTATION_ALL = 65535;
    Vector nodeListeners;

    protected NodeImpl(DocumentImpl documentImpl, String string, String string2) {
        this.ownerDocument = documentImpl;
        this.name = string;
        this.value = string2;
    }

    public NodeImpl() {
    }

    public abstract short getNodeType();

    public String getNodeName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void setNodeValue(String string) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        String string2 = this.value;
        EnclosingAttr enclosingAttr = null;
        LCount lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            enclosingAttr = this.getEnclosingAttr();
        }
        this.value = string;
        LCount lCount2 = LCount.lookup("DOMCharacterDataModified");
        if (lCount2.captures + lCount2.bubbles + lCount2.defaults > 0) {
            MutationEventImpl mutationEventImpl = new MutationEventImpl();
            mutationEventImpl.initMutationEvent("DOMCharacterDataModified", true, false, null, string2, string, null);
            this.dispatchEvent(mutationEventImpl);
        }
        this.dispatchAggregateEvents(enclosingAttr);
    }

    public String getNodeValue() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value;
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public Node cloneNode(boolean bl) {
        NodeImpl nodeImpl;
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        try {
            nodeImpl = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        nodeImpl.readOnly = false;
        nodeImpl.parentNode = null;
        nodeImpl.previousSibling = null;
        nodeImpl.nextSibling = null;
        nodeImpl.firstChild = null;
        nodeImpl.lastChild = null;
        if (bl) {
            NodeImpl nodeImpl2 = (NodeImpl)this.getFirstChild();
            while (nodeImpl2 != null) {
                nodeImpl.appendChild(nodeImpl2.cloneNode(true));
                nodeImpl2 = (NodeImpl)nodeImpl2.getNextSibling();
            }
        }
        return nodeImpl;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public NodeList getChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Node getFirstChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.lastChild;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.internalInsertBefore(node, node2, 65535);
    }

    Node internalInsertBefore(Node node, Node node2, int n) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (!(node instanceof NodeImpl) || node.getOwnerDocument() != this.ownerDocument && (this.getNodeType() != 9 || node.getOwnerDocument() != (Document)((Object)this))) {
            throw new DOMExceptionImpl(4, "WRONG_DOCUMENT_ERR");
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        boolean bl = true;
        NodeImpl nodeImpl2 = this.parentNode;
        while (bl && nodeImpl2 != null) {
            bl = nodeImpl != nodeImpl2;
            nodeImpl2 = nodeImpl2.parentNode;
        }
        if (!bl) {
            throw new DOMExceptionImpl(3, "HIERARCHY_REQUEST_ERR");
        }
        if (node2 != null && node2.getParentNode() != this) {
            throw new DOMExceptionImpl(8, "NOT_FOUND_ERR");
        }
        if (nodeImpl.getNodeType() == 11) {
            Node node3 = nodeImpl.getFirstChild();
            while (node3 != null) {
                if (!this.ownerDocument.isKidOK(this, node3)) {
                    throw new DOMExceptionImpl(3, "HIERARCHY_REQUEST_ERR");
                }
                node3 = node3.getNextSibling();
            }
            while (nodeImpl.hasChildNodes()) {
                this.insertBefore(nodeImpl.getFirstChild(), node2);
            }
        } else {
            Object object;
            if (!this.ownerDocument.isKidOK(this, nodeImpl)) {
                throw new DOMExceptionImpl(3, "HIERARCHY_REQUEST_ERR");
            }
            EnclosingAttr enclosingAttr = null;
            if ((n & 2) != 0) {
                object = LCount.lookup("DOMAttrModified");
                if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                    enclosingAttr = this.getEnclosingAttr();
                }
            }
            if ((object = nodeImpl.getParentNode()) != null) {
                object.removeChild(nodeImpl);
            }
            NodeImpl nodeImpl3 = node2 == null ? this.lastChild : ((NodeImpl)node2).previousSibling;
            nodeImpl.parentNode = this;
            nodeImpl.previousSibling = nodeImpl3;
            if (nodeImpl3 == null) {
                this.firstChild = nodeImpl;
            } else {
                nodeImpl3.nextSibling = nodeImpl;
            }
            nodeImpl.nextSibling = (NodeImpl)node2;
            if (node2 == null) {
                this.lastChild = nodeImpl;
            } else {
                ((NodeImpl)node2).previousSibling = nodeImpl;
            }
            this.changed();
            if ((n & 1) != 0) {
                Object object2;
                LCount lCount = LCount.lookup("DOMNodeInserted");
                if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                    object2 = new MutationEventImpl();
                    object2.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null);
                    nodeImpl.dispatchEvent((Event)object2);
                }
                lCount = LCount.lookup("DOMNodeInsertedIntoDocument");
                if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                    object2 = this;
                    if (enclosingAttr != null) {
                        object2 = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                    }
                    if (object2 != null) {
                        Object object3 = object2;
                        while (object3 != null) {
                            object2 = object3;
                            object3 = ((NodeImpl)object3).getNodeType() == 2 ? (ElementImpl)((AttrImpl)object3).getOwnerElement() : ((NodeImpl)object3).parentNode;
                        }
                        if (((NodeImpl)object2).getNodeType() == 9) {
                            MutationEventImpl mutationEventImpl = new MutationEventImpl();
                            mutationEventImpl.initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null);
                            this.dispatchEventToSubtree(nodeImpl, mutationEventImpl);
                        }
                    }
                }
            }
            if ((n & 2) != 0) {
                this.dispatchAggregateEvents(enclosingAttr);
            }
        }
        return nodeImpl;
    }

    public Node removeChild(Node node) throws DOMException {
        return this.internalRemoveChild(node, 65535);
    }

    Node internalRemoveChild(Node node, int n) throws DOMException {
        NodeImpl nodeImpl;
        Object object;
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (node != null && node.getParentNode() != this) {
            throw new DOMExceptionImpl(8, "NOT_FOUND_ERR");
        }
        Enumeration enumeration = this.ownerDocument.getNodeIterators();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ((NodeIteratorImpl)enumeration.nextElement()).removeNode(node);
            }
        }
        NodeImpl nodeImpl2 = (NodeImpl)node;
        EnclosingAttr enclosingAttr = null;
        LCount lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            enclosingAttr = this.getEnclosingAttr();
        }
        if ((n & 1) != 0) {
            lCount = LCount.lookup("DOMNodeRemoved");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                object = new MutationEventImpl();
                object.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null);
                nodeImpl2.dispatchEvent((Event)object);
            }
            lCount = LCount.lookup("DOMNodeRemovedFromDocument");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                object = this;
                if (enclosingAttr != null) {
                    object = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                }
                if (object != null) {
                    nodeImpl = ((NodeImpl)object).parentNode;
                    while (nodeImpl != null) {
                        object = nodeImpl;
                        nodeImpl = nodeImpl.parentNode;
                    }
                    if (((NodeImpl)object).getNodeType() == 9) {
                        MutationEventImpl mutationEventImpl = new MutationEventImpl();
                        mutationEventImpl.initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null);
                        this.dispatchEventToSubtree(nodeImpl2, mutationEventImpl);
                    }
                }
            }
        }
        object = nodeImpl2.previousSibling;
        nodeImpl = nodeImpl2.nextSibling;
        if (object != null) {
            ((NodeImpl)object).nextSibling = nodeImpl;
        } else {
            this.firstChild = nodeImpl;
        }
        if (nodeImpl != null) {
            nodeImpl.previousSibling = object;
        } else {
            this.lastChild = object;
        }
        nodeImpl2.parentNode = null;
        nodeImpl2.nextSibling = null;
        nodeImpl2.previousSibling = null;
        this.changed();
        if ((n & 2) != 0) {
            this.dispatchAggregateEvents(enclosingAttr);
        }
        return nodeImpl2;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        EnclosingAttr enclosingAttr = null;
        LCount lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            enclosingAttr = this.getEnclosingAttr();
        }
        this.internalInsertBefore(node, node2, 1);
        this.internalRemoveChild(node2, 1);
        this.dispatchAggregateEvents(enclosingAttr);
        return node2;
    }

    public int getLength() {
        int n = 0;
        NodeImpl nodeImpl = this.firstChild;
        while (nodeImpl != null) {
            ++n;
            nodeImpl = nodeImpl.nextSibling;
        }
        return n;
    }

    public Node item(int n) {
        NodeImpl nodeImpl = this.firstChild;
        int n2 = 0;
        while (n2 < n && nodeImpl != null) {
            nodeImpl = nodeImpl.nextSibling;
            ++n2;
        }
        return nodeImpl;
    }

    public boolean supports(String string, String string2) {
        return this.ownerDocument.getImplementation().hasFeature(string, string2);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) throws DOMException {
    }

    public String getLocalName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        if (string == null || string.equals("") || eventListener == null) {
            return;
        }
        this.removeEventListener(string, eventListener, bl);
        if (this.nodeListeners == null) {
            this.nodeListeners = new Vector();
        }
        this.nodeListeners.addElement(new LEntry(string, eventListener, bl));
        LCount lCount = LCount.lookup(string);
        if (bl) {
            ++lCount.captures;
            return;
        }
        ++lCount.bubbles;
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        if (this.nodeListeners == null || string == null || string.equals("") || eventListener == null) {
            return;
        }
        int n = this.nodeListeners.size() - 1;
        while (n >= 0) {
            LEntry lEntry = (LEntry)this.nodeListeners.elementAt(n);
            if (lEntry.useCapture == bl && lEntry.listener == eventListener && lEntry.type.equals(string)) {
                this.nodeListeners.removeElementAt(n);
                if (this.nodeListeners.size() == 0) {
                    this.nodeListeners = null;
                }
                LCount lCount = LCount.lookup(string);
                if (bl) {
                    --lCount.captures;
                    return;
                }
                --lCount.bubbles;
                return;
            }
            --n;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.nodeListeners != null) {
            int n = this.nodeListeners.size() - 1;
            while (n >= 0) {
                LEntry lEntry = (LEntry)this.nodeListeners.elementAt(n);
                LCount lCount = LCount.lookup(lEntry.type);
                if (lEntry.useCapture) {
                    --lCount.captures;
                } else {
                    --lCount.bubbles;
                }
                --n;
            }
        }
    }

    public boolean dispatchEvent(Event event) {
        LEntry lEntry;
        int n;
        Object object;
        NodeImpl nodeImpl;
        if (event == null) {
            return false;
        }
        EventImpl eventImpl = (EventImpl)event;
        if (!eventImpl.initialized || eventImpl.type == null || eventImpl.type.equals("")) {
            throw new DOMExceptionImpl(100, "");
        }
        LCount lCount = LCount.lookup(eventImpl.getType());
        if (lCount.captures + lCount.bubbles + lCount.defaults == 0) {
            return eventImpl.preventDefault;
        }
        eventImpl.target = this;
        eventImpl.stopPropagation = false;
        eventImpl.preventDefault = false;
        Vector<Node> vector = new Vector<Node>(10, 10);
        Node node = this;
        Node node2 = node.getParentNode();
        while (node2 != null) {
            vector.addElement(node2);
            node = node2;
            node2 = node2.getParentNode();
        }
        if (lCount.captures > 0) {
            eventImpl.eventPhase = (short)2;
            int n2 = vector.size() - 1;
            while (n2 >= 0) {
                if (eventImpl.stopPropagation) break;
                nodeImpl = (NodeImpl)vector.elementAt(n2);
                eventImpl.currentNode = nodeImpl;
                if (nodeImpl.nodeListeners != null) {
                    object = (Vector)nodeImpl.nodeListeners.clone();
                    n = ((Vector)object).size() - 1;
                    while (n >= 0) {
                        lEntry = (LEntry)((Vector)object).elementAt(n);
                        if (lEntry.useCapture && lEntry.type.equals(eventImpl.type)) {
                            try {
                                lEntry.listener.handleEvent(eventImpl);
                            }
                            catch (Exception exception) {}
                        }
                        --n;
                    }
                }
                --n2;
            }
        }
        if (lCount.bubbles > 0) {
            eventImpl.eventPhase = (short)3;
            eventImpl.currentNode = this;
            if (!eventImpl.stopPropagation && this.nodeListeners != null) {
                Vector vector2 = (Vector)this.nodeListeners.clone();
                int n3 = vector2.size() - 1;
                while (n3 >= 0) {
                    object = (LEntry)vector2.elementAt(n3);
                    if (object != null && !((LEntry)object).useCapture && ((LEntry)object).type.equals(eventImpl.type)) {
                        try {
                            ((LEntry)object).listener.handleEvent(eventImpl);
                        }
                        catch (Exception exception) {}
                    }
                    --n3;
                }
            }
            if (eventImpl.bubbles) {
                eventImpl.eventPhase = 1;
                int n4 = 0;
                while (n4 < vector.size()) {
                    if (eventImpl.stopPropagation) break;
                    nodeImpl = (NodeImpl)vector.elementAt(n4);
                    eventImpl.currentNode = nodeImpl;
                    if (nodeImpl.nodeListeners != null) {
                        object = (Vector)nodeImpl.nodeListeners.clone();
                        n = ((Vector)object).size() - 1;
                        while (n >= 0) {
                            lEntry = (LEntry)((Vector)object).elementAt(n);
                            if (!lEntry.useCapture && lEntry.type.equals(eventImpl.type)) {
                                try {
                                    lEntry.listener.handleEvent(eventImpl);
                                }
                                catch (Exception exception) {}
                            }
                            --n;
                        }
                    }
                    ++n4;
                }
            }
        }
        boolean bl = lCount.defaults > 0 && (!eventImpl.cancelable || !eventImpl.preventDefault);
        return eventImpl.preventDefault;
    }

    void dispatchEventToSubtree(NodeImpl nodeImpl, Event event) {
        if (this.nodeListeners == null || nodeImpl == null) {
            return;
        }
        nodeImpl.dispatchEvent(event);
        if (nodeImpl.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = nodeImpl.getAttributes();
            int n = namedNodeMap.getLength() - 1;
            while (n >= 0) {
                this.dispatchEventToSubtree((NodeImpl)namedNodeMap.item(n), event);
                --n;
            }
        }
        this.dispatchEventToSubtree(nodeImpl.firstChild, event);
        this.dispatchEventToSubtree(nodeImpl.nextSibling, event);
    }

    EnclosingAttr getEnclosingAttr() {
        NodeImpl nodeImpl = this;
        while (true) {
            if (nodeImpl == null) {
                return null;
            }
            short s = nodeImpl.getNodeType();
            if (s == 2) {
                EnclosingAttr enclosingAttr = new EnclosingAttr();
                enclosingAttr.node = (AttrImpl)nodeImpl;
                enclosingAttr.oldvalue = enclosingAttr.node.getNodeValue();
                return enclosingAttr;
            }
            if (s != 5) break;
            nodeImpl = nodeImpl.parentNode;
        }
        return null;
    }

    void dispatchAggregateEvents(EnclosingAttr enclosingAttr) {
        if (enclosingAttr != null) {
            this.dispatchAggregateEvents(enclosingAttr.node, enclosingAttr.oldvalue);
            return;
        }
        this.dispatchAggregateEvents(null, null);
    }

    void dispatchAggregateEvents(AttrImpl attrImpl, String string) {
        MutationEventImpl mutationEventImpl;
        LCount lCount;
        if (this.nodeListeners == null) {
            return;
        }
        NodeImpl nodeImpl = null;
        if (attrImpl != null) {
            lCount = LCount.lookup("DOMAttrModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0 && (nodeImpl = (NodeImpl)((Object)attrImpl.getOwnerElement())) != null) {
                mutationEventImpl = new MutationEventImpl();
                mutationEventImpl.initMutationEvent("DOMAttrModified", true, false, null, string, attrImpl.getNodeValue(), attrImpl.getNodeName());
                nodeImpl.dispatchEvent(mutationEventImpl);
            }
        }
        lCount = LCount.lookup("DOMSubtreeModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            mutationEventImpl = new MutationEventImpl();
            mutationEventImpl.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null);
            if (attrImpl != null) {
                attrImpl.dispatchEvent(mutationEventImpl);
                if (nodeImpl != null) {
                    nodeImpl.dispatchEvent(mutationEventImpl);
                    return;
                }
            } else {
                this.dispatchEvent(mutationEventImpl);
            }
        }
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.syncData) {
            this.synchronizeData();
        }
        this.readOnly = bl;
        if (bl2) {
            if (this.syncChildren) {
                this.synchronizeChildren();
            }
            NodeImpl nodeImpl = this.firstChild;
            while (nodeImpl != null) {
                if (!(nodeImpl instanceof EntityReference)) {
                    nodeImpl.setReadOnly(bl, true);
                }
                nodeImpl = nodeImpl.nextSibling;
            }
        }
    }

    public boolean getReadOnly() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.readOnly;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    protected void synchronizeChildren() {
    }

    protected void synchronizeData() {
    }

    protected void changed() {
        ++this.changes;
        if (this.parentNode != null) {
            this.parentNode.changed();
        }
    }

    public String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }

    static {
        NodeImpl.kidOK[9] = 1410;
        NodeImpl.kidOK[1] = 446;
        NodeImpl.kidOK[5] = 446;
        NodeImpl.kidOK[6] = 446;
        NodeImpl.kidOK[11] = 446;
        NodeImpl.kidOK[2] = 40;
        NodeImpl.kidOK[12] = 0;
        NodeImpl.kidOK[4] = 0;
        NodeImpl.kidOK[3] = 0;
        NodeImpl.kidOK[8] = 0;
        NodeImpl.kidOK[7] = 0;
        NodeImpl.kidOK[10] = 0;
    }

    class LEntry {
        String type;
        EventListener listener;
        boolean useCapture;

        LEntry(String string, EventListener eventListener, boolean bl) {
            NodeImpl.this = NodeImpl.this;
            this.type = string;
            this.listener = eventListener;
            this.useCapture = bl;
        }
    }

    class EnclosingAttr {
        AttrImpl node;
        String oldvalue;

        EnclosingAttr() {
            NodeImpl.this = NodeImpl.this;
        }
    }
}

