/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLParser;
import org.apache.xerces.framework.XMLValidator;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.misc.DeclHandler;
import org.xml.sax.misc.LexicalHandler;
import org.xml.sax.misc.NamespaceHandler;

public class SAXParser
extends XMLParser
implements Parser {
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/normalize-text", "http://xml.org/sax/features/use-locator"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://xml.org/sax/properties/dom-node", "http://xml.org/sax/handlers/DeclHandler", "http://xml.org/sax/handlers/LexicalHandler", "http://xml.org/sax/handlers/NamespaceHandler"};
    private static final boolean DEBUG_CALLBACKS = false;
    private DTDHandler fDTDHandler;
    private DocumentHandler fDocumentHandler;
    private DeclHandler fDeclHandler;
    private LexicalHandler fLexicalHandler;
    private NamespaceHandler fNamespaceHandler;

    public SAXParser() {
        this.setSendCharDataAsCharArray(true);
    }

    public String[] getFeaturesRecognized() {
        String[] stringArray = super.getFeaturesRecognized();
        String[] stringArray2 = RECOGNIZED_FEATURES;
        int n = stringArray2.length;
        if (n == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2 + n];
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        System.arraycopy(stringArray2, 0, stringArray3, n2, n);
        return stringArray3;
    }

    public String[] getPropertiesRecognized() {
        String[] stringArray = super.getPropertiesRecognized();
        String[] stringArray2 = RECOGNIZED_PROPERTIES;
        int n = stringArray2.length;
        if (n == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2 + n];
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        System.arraycopy(stringArray2, 0, stringArray3, n2, n);
        return stringArray3;
    }

    protected void setNormalizeText(boolean bl) throws SAXException {
        if (bl) {
            throw new SAXNotSupportedException("http://xml.org/sax/features/normalize-text");
        }
    }

    protected boolean getNormalizeText() throws SAXException {
        return false;
    }

    protected void setUseLocator(boolean bl) throws SAXException {
        if (!bl) {
            throw new SAXNotSupportedException("http://xml.org/sax/features/use-locator");
        }
    }

    protected boolean getUseLocator() throws SAXException {
        return true;
    }

    protected void setDeclHandler(DeclHandler declHandler) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://xml.org/sax/handlers/DeclHandler: parse is in progress");
        }
        this.fDeclHandler = declHandler;
    }

    protected DeclHandler getDeclHandler() throws SAXException {
        return this.fDeclHandler;
    }

    protected void setLexicalHandler(LexicalHandler lexicalHandler) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://xml.org/sax/handlers/LexicalHandler: parse is in progress");
        }
        this.fLexicalHandler = lexicalHandler;
    }

    protected LexicalHandler getLexicalHandler() throws SAXException {
        return this.fLexicalHandler;
    }

    protected void setNamespaceHandler(NamespaceHandler namespaceHandler) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://xml.org/sax/handlers/NamespaceHandler: parse is in progress");
        }
        this.fNamespaceHandler = namespaceHandler;
    }

    protected NamespaceHandler getNamespaceHandler() throws SAXException {
        return this.fNamespaceHandler;
    }

    public void setFeature(String string, boolean bl) throws SAXException {
        if (string.startsWith("http://xml.org/sax/features/")) {
            String string2 = string.substring("http://xml.org/sax/features/".length());
            if (string2.equals("normalize-text")) {
                this.setNormalizeText(bl);
                return;
            }
            if (string2.equals("use-locator")) {
                this.setUseLocator(bl);
                return;
            }
        }
        super.setFeature(string, bl);
    }

    public boolean getFeature(String string) throws SAXException {
        if (string.startsWith("http://xml.org/sax/features/")) {
            String string2 = string.substring("http://xml.org/sax/features/".length());
            if (string2.equals("normalize-text")) {
                return this.getNormalizeText();
            }
            if (string2.equals("use-locator")) {
                return this.getUseLocator();
            }
        }
        return super.getFeature(string);
    }

    public void setProperty(String string, Object object) throws SAXException {
        if (string.startsWith("http://xml.org/sax/properties/")) {
            String string2 = string.substring("http://xml.org/sax/properties/".length());
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException(string);
            }
        } else if (string.startsWith("http://xml.org/sax/handlers/")) {
            String string3 = string.substring("http://xml.org/sax/handlers/".length());
            if (string3.equals("DeclHandler")) {
                try {
                    this.setDeclHandler((DeclHandler)object);
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
            }
            if (string3.equals("LexicalHandler")) {
                try {
                    this.setLexicalHandler((LexicalHandler)object);
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
            }
            if (string3.equals("NamespaceHandler")) {
                try {
                    this.setNamespaceHandler((NamespaceHandler)object);
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
            }
        }
        super.setProperty(string, object);
    }

    public Object getProperty(String string) throws SAXException {
        if (string.startsWith("http://xml.org/sax/properties/")) {
            String string2 = string.substring("http://xml.org/sax/properties/".length());
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException(string);
            }
        } else if (string.startsWith("http://xml.org/sax/handlers/")) {
            String string3 = string.substring("http://xml.org/sax/handlers/".length());
            if (string3.equals("DeclHandler")) {
                return this.getDeclHandler();
            }
            if (string3.equals("LexicalHandler")) {
                return this.getLexicalHandler();
            }
            if (string3.equals("NamespaceHandler")) {
                return this.getNamespaceHandler();
            }
        }
        return super.getProperty(string);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void startDTD(int n, int n2, int n3) throws Exception {
        if (this.fLexicalHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startDTD(string, string2, string3);
            }
        }
    }

    public void endDTD() throws Exception {
        if (this.fLexicalHandler != null) {
            this.fLexicalHandler.endDTD();
        }
    }

    public void elementDecl(int n, XMLValidator.ContentSpec contentSpec) throws Exception {
        if (this.fDeclHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = contentSpec.toString();
            if (this.fDeclHandler != null) {
                this.fDeclHandler.elementDecl(string, string2);
            }
        }
    }

    public void attlistDecl(int n, int n2, int n3, String string, int n4, int n5) throws Exception {
        if (this.fDeclHandler != null) {
            String string2 = this.fStringPool.toString(n);
            String string3 = this.fStringPool.toString(n2);
            String string4 = n3 == this.fStringPool.addSymbol("ENUMERATION") ? string : this.fStringPool.toString(n3);
            String string5 = n4 == 0 ? null : this.fStringPool.toString(n4);
            String string6 = this.fStringPool.toString(n5);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.attributeDecl(string2, string3, string4, string5, string6);
            }
        }
    }

    public void internalPEDecl(int n, int n2) throws Exception {
        if (this.fDeclHandler != null) {
            String string = "%" + this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.internalEntityDecl(string, string2);
            }
        }
    }

    public void externalPEDecl(int n, int n2, int n3) throws Exception {
        if (this.fDeclHandler != null) {
            String string = "%" + this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.externalEntityDecl(string, string2, string3);
            }
        }
    }

    public void internalEntityDecl(int n, int n2) throws Exception {
        if (this.fDeclHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.internalEntityDecl(string, string2);
            }
        }
    }

    public void externalEntityDecl(int n, int n2, int n3) throws Exception {
        if (this.fDeclHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            if (this.fDeclHandler != null) {
                this.fDeclHandler.externalEntityDecl(string, string2, string3);
            }
        }
    }

    public void unparsedEntityDecl(int n, int n2, int n3, int n4) throws Exception {
        if (this.fDTDHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            String string4 = this.fStringPool.toString(n4);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.unparsedEntityDecl(string, string2, string3, string4);
            }
        }
    }

    public void notationDecl(int n, int n2, int n3) throws Exception {
        if (this.fDTDHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            if (this.fDTDHandler != null) {
                this.fDTDHandler.notationDecl(string, string2, string3);
            }
        }
    }

    public void startDocument(int n, int n2, int n3) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.setDocumentLocator(this.getLocator());
            this.fDocumentHandler.startDocument();
        }
        this.fStringPool.releaseString(n);
        this.fStringPool.releaseString(n2);
        this.fStringPool.releaseString(n3);
    }

    public void endDocument() throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument();
        }
    }

    public void startNamespaceDeclScope(int n, int n2) throws Exception {
        if (this.fNamespaceHandler != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            if (this.fNamespaceHandler != null) {
                this.fNamespaceHandler.startNamespaceDeclScope(string, string2);
            }
        }
    }

    public void endNamespaceDeclScope(int n) throws Exception {
        if (this.fNamespaceHandler != null) {
            String string = this.fStringPool.toString(n);
            if (this.fNamespaceHandler != null) {
                this.fNamespaceHandler.endNamespaceDeclScope(string);
            }
        }
    }

    public void startElement(int n, XMLAttrList xMLAttrList, int n2) throws Exception {
        String string = this.fStringPool.toString(n);
        AttributeList attributeList = xMLAttrList.getAttributeList(n2);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(string, attributeList);
        }
        xMLAttrList.releaseAttrList(n2);
    }

    public void endElement(int n) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(this.fStringPool.toString(n));
        }
    }

    public void startEntityReference(int n, int n2, int n3) throws Exception {
        if (this.fLexicalHandler != null) {
            switch (n2) {
                case 0: 
                case 1: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.startEntity("%" + this.fStringPool.toString(n));
                    return;
                }
                case 2: 
                case 3: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.startEntity(this.fStringPool.toString(n));
                    return;
                }
                case 4: {
                    throw new RuntimeException("startEntityReference(): ENTITYTYPE_UNPARSED");
                }
                case 6: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.startEntity("[dtd]");
                    return;
                }
            }
        }
    }

    public void endEntityReference(int n, int n2, int n3) throws Exception {
        if (this.fLexicalHandler != null) {
            switch (n2) {
                case 0: 
                case 1: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.endEntity("%" + this.fStringPool.toString(n));
                    return;
                }
                case 2: 
                case 3: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.endEntity(this.fStringPool.toString(n));
                    return;
                }
                case 4: {
                    throw new RuntimeException("endEntityReference(): ENTITYTYPE_UNPARSED");
                }
                case 6: {
                    if (this.fLexicalHandler == null) break;
                    this.fLexicalHandler.endEntity("[dtd]");
                    return;
                }
            }
        }
    }

    public void startCDATA() throws Exception {
        if (this.fLexicalHandler != null) {
            this.fLexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws Exception {
        if (this.fLexicalHandler != null) {
            this.fLexicalHandler.endCDATA();
        }
    }

    public void characters(int n) throws Exception {
        throw new RuntimeException("cannot happen 5");
    }

    public void ignorableWhitespace(int n) throws Exception {
        throw new RuntimeException("cannot happen 6");
    }

    public void processingInstruction(int n, int n2) throws Exception {
        if (this.fDocumentHandler != null) {
            String string;
            String string2 = this.fStringPool.orphanString(n);
            String string3 = string = n2 == -1 ? "" : this.fStringPool.orphanString(n2);
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.processingInstruction(string2, string);
                return;
            }
        } else {
            this.fStringPool.releaseString(n);
            this.fStringPool.releaseString(n2);
        }
    }

    public void processingInstructionInDTD(int n, int n2) throws Exception {
        this.processingInstruction(n, n2);
    }

    public void comment(int n) throws Exception {
        if (this.fLexicalHandler != null) {
            String string = this.fStringPool.orphanString(n);
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.comment(string.toCharArray(), 0, string.length());
                return;
            }
        } else {
            this.fStringPool.releaseString(n);
        }
    }

    public void commentInDTD(int n) throws Exception {
        this.comment(n);
    }

    public void characters(char[] cArray, int n, int n2) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws Exception {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }
}

