/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.IllegalFacetException;
import org.apache.xerces.validators.datatype.IllegalFacetValueException;
import org.apache.xerces.validators.datatype.InternalDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.UnknownFacetException;

public class DecimalValidator
implements InternalDatatypeValidator {
    double fMaxInclusive;
    boolean fIsMaxInclusive = false;
    double fMaxExclusive;
    boolean fIsMaxExclusive = false;
    double fMinInclusive;
    boolean fIsMinInclusive = false;
    double fMinExclusive;
    boolean fIsMinExclusive = false;
    double[] fEnumValues;
    boolean fHasEnums = false;
    DecimalValidator fBaseValidator;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private Locale fLocale;

    public void validate(String string) throws InvalidDatatypeValueException {
        double d = 0.0;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException(this.getErrorString(3, 0, new Object[]{string}));
        }
        this.boundsCheck(d);
        if (this.fHasEnums) {
            this.enumCheck(d);
        }
    }

    public void validate(int n) throws InvalidDatatypeValueException {
    }

    boolean ensureFacetsAreConsistent(Hashtable hashtable) {
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (bl && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            if (string.equals("enumeration")) continue;
            string2 = (String)hashtable.get(string);
            double d = 0.0;
            try {
                d = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (string.equals("minInclusive") && this.fIsMinInclusive) {
                bl = this.fMinInclusive <= d;
                continue;
            }
            if (string.equals("minExclusive") && this.fIsMinExclusive) {
                bl = this.fMinExclusive < d;
                continue;
            }
            if (string.equals("maxInclusive") && this.fIsMaxInclusive) {
                bl = this.fMaxInclusive >= d;
                continue;
            }
            if (!string.equals("maxExclusive") || !this.fIsMaxExclusive) continue;
            boolean bl2 = bl = this.fMaxExclusive > d;
        }
        return bl;
    }

    public void setFacets(Hashtable hashtable) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
        Object object;
        if (this.fBaseValidator != null && !this.fBaseValidator.ensureFacetsAreConsistent(hashtable)) {
            throw new IllegalFacetValueException(this.getErrorString(4, 0, null));
        }
        this.fHasEnums = false;
        this.fIsMaxExclusive = false;
        this.fIsMaxInclusive = false;
        this.fIsMinExclusive = false;
        this.fIsMinInclusive = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = null;
            if (((String)object).equals("enumeration")) continue;
            string = (String)hashtable.get(object);
            double d = 0.0;
            try {
                d = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalFacetValueException(this.getErrorString(5, 0, new Object[]{string, object}));
            }
            if (((String)object).equals("minInclusive")) {
                this.fIsMinInclusive = true;
                this.fMinInclusive = d;
                continue;
            }
            if (((String)object).equals("minExclusive")) {
                this.fIsMinExclusive = true;
                this.fMinExclusive = d;
                continue;
            }
            if (((String)object).equals("maxInclusive")) {
                this.fIsMaxInclusive = true;
                this.fMaxInclusive = d;
                continue;
            }
            if (((String)object).equals("maxExclusive")) {
                this.fIsMaxExclusive = true;
                this.fMaxExclusive = d;
                continue;
            }
            if (((String)object).equals("enumeration") || ((String)object).equals("precision") || ((String)object).equals("scale")) continue;
            if (((String)object).equals("length") || ((String)object).equals("maxLength") || ((String)object).equals("literal") || ((String)object).equals("lexicalRepresentation") || ((String)object).equals("lexical")) {
                throw new IllegalFacetException(this.getErrorString(6, 0, null));
            }
            throw new UnknownFacetException(this.getErrorString(7, 0, new Object[]{object}));
        }
        object = (Vector)hashtable.get("enumeration");
        if (object != null) {
            this.fHasEnums = true;
            this.fEnumValues = new double[((Vector)object).size()];
            int n = 0;
            while (n < ((Vector)object).size()) {
                try {
                    this.fEnumValues[n] = Double.valueOf((String)((Vector)object).elementAt(n));
                    this.boundsCheck(this.fEnumValues[n]);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new IllegalFacetValueException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Internal Error parsing enumerated values for decimal type");
                }
                ++n;
            }
        }
    }

    public void setFacets(int[] nArray) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
    }

    public void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = (DecimalValidator)datatypeValidator;
    }

    private void boundsCheck(double d) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.fIsMaxInclusive) {
            bl2 = d <= this.fMaxInclusive;
        } else if (this.fIsMaxExclusive) {
            bl2 = d < this.fMaxExclusive;
        } else {
            boolean bl3 = bl2 = !this.fIsMaxInclusive && !this.fIsMaxExclusive;
        }
        if (this.fIsMinInclusive) {
            bl = d >= this.fMinInclusive;
        } else if (this.fIsMinExclusive) {
            bl = d > this.fMinInclusive;
        } else {
            boolean bl4 = bl = !this.fIsMinInclusive && !this.fIsMinExclusive;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(9, 0, new Object[]{new Double(d)}));
        }
    }

    private void enumCheck(double d) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < this.fEnumValues.length) {
            if (d == this.fEnumValues[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{new Double(d)}));
    }

    public void setLocale(Locale locale) {
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }
}

