/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xml.serialize.BaseSerializer;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XHTMLSerializer;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.DocumentHandler;

public abstract class Serializer {
    public abstract void serialize(Element var1) throws IOException;

    public abstract void serialize(Document var1) throws IOException;

    public static Serializer makeSerializer(Writer writer, OutputFormat outputFormat) {
        BaseSerializer baseSerializer = Serializer.makeBaseSerializer(outputFormat);
        baseSerializer.init(writer, outputFormat);
        return baseSerializer;
    }

    public static Serializer makeSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        BaseSerializer baseSerializer = Serializer.makeBaseSerializer(outputFormat);
        baseSerializer.init(outputStream, outputFormat);
        return baseSerializer;
    }

    public static DocumentHandler makeSAXSerializer(Writer writer, OutputFormat outputFormat) {
        BaseSerializer baseSerializer = Serializer.makeBaseSerializer(outputFormat);
        baseSerializer.init(writer, outputFormat);
        return baseSerializer;
    }

    public static DocumentHandler makeSAXSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        BaseSerializer baseSerializer = Serializer.makeBaseSerializer(outputFormat);
        baseSerializer.init(outputStream, outputFormat);
        return baseSerializer;
    }

    public static void serialize(Document document, Writer writer, OutputFormat outputFormat) throws IOException {
        if (outputFormat == null) {
            outputFormat = new OutputFormat(document);
        }
        BaseSerializer baseSerializer = Serializer.makeBaseSerializer(outputFormat);
        baseSerializer.init(writer, outputFormat);
        baseSerializer.serialize(document);
    }

    public static void serialize(Document document, OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException, IOException {
        if (outputFormat == null) {
            outputFormat = new OutputFormat(document);
        }
        BaseSerializer baseSerializer = Serializer.makeBaseSerializer(outputFormat);
        baseSerializer.init(outputStream, outputFormat);
        baseSerializer.serialize(document);
    }

    private static BaseSerializer makeBaseSerializer(OutputFormat outputFormat) {
        BaseSerializer baseSerializer;
        if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", "UTF-8", false);
            baseSerializer = new XMLSerializer();
        } else {
            baseSerializer = outputFormat.getMethod().equalsIgnoreCase("html") ? new XHTMLSerializer() : (outputFormat.getMethod().equalsIgnoreCase("xhtml") ? new HTMLSerializer() : new XMLSerializer());
        }
        return baseSerializer;
    }
}

