/*
 * $Header: /home/cvs/jakarta-tomcat/proposals/catalina/src/share/org/apache/tomcat/connector/ConnectorBase.java,v 1.2 2000/02/20 02:55:06 craigmcc Exp $
 * $Revision: 1.2 $
 * $Date: 2000/02/20 02:55:06 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 


package org.apache.tomcat.connector;


import java.util.Stack;
import org.apache.tomcat.Connector;
import org.apache.tomcat.Container;
import org.apache.tomcat.Request;
import org.apache.tomcat.Response;


/**
 * Convenience base class implementation of the <b>Connector</b> interface.
 *
 * @author Craig R. McClanahan
 * @version $Revision: 1.2 $ $Date: 2000/02/20 02:55:06 $
 */

public abstract class ConnectorBase implements Connector {


    // ----------------------------------------------------- Instance Variables


    /**
     * The Container used for processing requests received by this Connector.
     */
    protected Container container = null;


    /**
     * Descriptive information about this Connector implementation.
     */
    protected static final String info =
	"org.apache.tomcat.connector.ConnectorBase/1.0";


    /**
     * Collection of Requests available for allocation.
     */
    protected Stack requests = new Stack();


    /**
     * Collection of Responses available for allocation.
     */
    protected Stack responses = new Stack();


    // ------------------------------------------------------------- Properties


    /**
     * Return the Container used for processing requests received by this
     * Connector.
     */
    public Container getContainer() {

	return (container);

    }


    /**
     * Set the Container used for processing requests received by this
     * Connector.
     *
     * @param container The new Container to use
     */
    public void setContainer(Container container) {

	this.container = container;

    }


    /**
     * Return descriptive information about this Connector implementation.
     */
    public String getInfo() {

	return (info);

    }


    // --------------------------------------------------------- Public Methods


    /**
     * Create (or allocate) and return a Request object suitable for
     * specifying the contents of a Request to the responsible Container.
     */
    public Request createRequest() {

	synchronized (requests) {
	    if (requests.size() > 0)
		return ((Request) requests.pop());
	    else
		return (newRequest());
	}

    }


    /**
     * Create (or allocate) and return a Response object suitable for
     * receiving the contents of a Response from the responsible Container.
     */
    public Response createResponse() {

	synchronized (responses) {
	    if (responses.size() > 0)
		return ((Response) responses.pop());
	    else
		return (newResponse());
	}

    }


    /**
     * Instantiate and return a new Request object suitable for specifying
     * the contents of a Request to the responsible Container.  This method
     * must be implemented by a subclass.
     */
    public abstract Request newRequest();


    /**
     * Instantiate and return a new Response object suitable for receiving
     * the contents of a Response from the responsible Container.  This method
     * must be implemented by a subclass.
     */
    public abstract Response newResponse();


}
