/*
 * $Header: /home/cvs/jakarta-tomcat/proposals/catalina/src/share/org/apache/tomcat/connector/RequestBase.java,v 1.1 2000/02/20 02:55:06 craigmcc Exp $
 * $Revision: 1.1 $
 * $Date: 2000/02/20 02:55:06 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 


package org.apache.tomcat.connector;


import java.io.BufferedReader;
import java.io.InputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.Connector;
import org.apache.tomcat.Context;
import org.apache.tomcat.Request;
import org.apache.tomcat.Response;


/**
 * Convenience base implementation of the <b>Request</b> interface, which can
 * be used for the Request implementation required by most Connectors.  Only
 * the connector-specific methods need to be implemented.
 *
 * @author Craig R. McClanahan
 * @version $Revision: 1.1 $ $Date: 2000/02/20 02:55:06 $
 */

public class RequestBase
    implements HttpServletRequest, Request {


    // ----------------------------------------------------- Instance Variables


    /**
     * The attributes associated with this Request, keyed by attribute name.
     */
    protected Hashtable attributes = new Hashtable();


    /**
     * The authentication type used for this request.
     */
    protected String authType = null;


    /**
     * The Connector through which this Request was received.
     */
    protected Connector connector = null;


    /**
     * The content length associated with this request.
     */
    protected int contentLength = -1;


    /**
     * The content type associated with this request.
     */
    protected String contentType = null;


    /**
     * The Context within which this Request is being processed.
     */
    protected Context context = null;


    /**
     * The set of cookies associated with this Request.
     */
    protected Vector cookies = new Vector();


    /**
     * The HTTP headers associated with this Request, keyed by name.
     */
    protected Hashtable headers = new Hashtable();


    /**
     * Descriptive information about this Request implementation.
     */
    protected static final String info =
	"org.apache.tomcat.connector.RequestBase/1.0";


    /**
     * The preferred Locales assocaited with this Request.
     */
    protected Vector locales = new Vector();


    /**
     * The request method associated with this Request.
     */
    protected String method = null;


    /**
     * The protocol name and version associated with this Request.
     */
    protected String protocol = null;


    /**
     * The remote address associated with this request.
     */
    protected String remoteAddr = null;


    /**
     * The request URI associated with this request.
     */
    protected String requestUri = null;


    /**
     * The response with which this request is associated.
     */
    protected Response response = null;


    /**
     * The scheme associated with this Request.
     */
    protected String scheme = null;


    /**
     * Was this request received on a secure connection?
     */
    protected boolean secure = false;


    /**
     * The server name associated with this Request.
     */
    protected String serverName = null;


    /**
     * The server port associated with this Request.
     */
    protected int serverPort = -1;


    /**
     * The input stream associated with this Request.
     */
    protected InputStream stream = null;


    /**
     * The Principal who has been authenticated for this Request.
     */
    protected Principal userPrincipal;


    // ------------------------------------------------------------- Properties


    /**
     * Return the Connector through which this Request was received.
     */
    public Connector getConnector() {

	return (this.connector);

    }


    /**
     * Set the Connector through which this Request was received.
     *
     * @param connector The new connector
     */
    public void setConnector(Connector connector) {

	this.connector = connector;

    }


    /**
     * Return the Context within which this Request is being processed.
     */
    public Context getContext() {

	return (this.context);

    }


    /**
     * Set the Context within which this Request is being processed.  This
     * must be called as soon as the appropriate Context is identified, because
     * it identifies the value to be returned by <code>getContextPath()</code>,
     * and thus enables parsing of the request URI.
     *
     * @param context The newly associated Context
     */
    public void setContext(Context context) {

	this.context = context;

    }


    /**
     * Return descriptive information about this Request implementation and
     * the corresponding version number, in the format
     * <code>&lt;description&gt;/&lt;version&gt;</code>.
     */
    public String getInfo() {

	return (info);

    }


    /**
     * Return the <code>HttpServletRequest</code> for which this object
     * is the facade.  This method must be implemented by a subclass.
     */
    public HttpServletRequest getRequest() {

	return ((HttpServletRequest) this);

    }


    /**
     * Return the Response with which this Request is associated.
     */
    public Response getResponse() {

	return (this.response);

    }


    /**
     * Set the Response with which this Request is associated.
     *
     * @param response The new associated response
     */
    public void setResponse(Response response) {

	this.response = response;

    }


    /**
     * Return the input stream associated with this Request.
     */
    public InputStream getStream() {

	return (this.stream);

    }


    /**
     * Set the input stream associated with this Request.
     *
     * @param stream The new input stream
     */
    public void setStream(InputStream stream) {

	this.stream = stream;

    }


    // --------------------------------------------------------- Public Methods


    /**
     * Add a Cookie to the set of Cookies associated with this Request.
     *
     * @param cookie The new cookie
     */
    public void addCookie(Cookie cookie) {

	cookies.addElement(cookie);

    }


    /**
     * Add a Header to the set of Headers associated with this Request.
     *
     * @param name The new header name
     * @param value The new header value
     */
    public void addHeader(String name, String value) {

	headers.put(name.toLowerCase(), value);

    }


    /**
     * Add a Locale to the set of preferred Locales for this Request.  The
     * first added Locale will be the first one returned by getLocales().
     *
     * @param locale The new preferred Locale
     */
    public void addLocale(Locale locale) {

	locales.addElement(locale);

    }


    /**
     * Create and return a ServletInputStream to read the content
     * associated with this Request.
     *
     * @exception IOException if an input/output error occurs
     */
    public ServletInputStream createInputStream() throws IOException {

	return (new RequestStream(this));

    }


    /**
     * Release all object references, and initialize instance variables, in
     * preparation for reuse of this object.
     */
    public void recycle() {

	attributes.clear();
	authType = null;
	// connector is NOT reset when recycling
	contentLength = -1;
	contentType = null;
	context = null;
	cookies.removeAllElements();
	headers.clear();
	locales.removeAllElements();
	method = null;
	protocol = null;
	response = null;
	scheme = null;
	serverName = null;
	serverPort = -1;
	stream = null;

    }


    /**
     * Set the authentication type used for this request, if any; otherwise
     * set the type to <code>null</code>.  Typical values are "BASIC",
     * "DIGEST", or "SSL".
     *
     * @param type The authentication type used
     */
    public void setAuthType(String type) {

	this.authType = authType;

    }


    /**
     * Set the content length associated with this Request.
     *
     * @param length The new content length
     */
    public void setContentLength(int length) {

	this.contentLength = length;

    }


    /**
     * Set the content type (and optionally the character encoding)
     * associated with this Request.  For example,
     * <code>text/html; charset=ISO-8859-4</code>.
     *
     * @param type The new content type
     */
    public void setContentType(String type) {

	this.contentType = type;

    }


    /**
     * Set the HTTP request method used for this Request.
     *
     * @param method The request method
     */
    public void setMethod(String method) {

	this.method = method;

    }


    /**
     * Set the protocol name and version associated with this Request.
     *
     * @param protocol Protocol name and version
     */
    public void setProtocol(String protocol) {

	this.protocol = protocol;

    }


    /**
     * Set the remote IP address associated with this Request.  NOTE:  This
     * value will be used to resolve the value for <code>getRemoteHost()</code>
     * if that method is called.
     *
     * @param remote The remote IP address
     */
    public void setRemoteAddr(String remote) {

	this.remoteAddr = remote;

    }


    /**
     * Set the unparsed request URI for this Request.  This value cannot be
     * parsed until <code>setContext()</code> has been called.  <b>FIXME</b>:
     * how and when is parsing initiated?
     *
     * @param uri The request URI
     */
    public void setRequestURI(String uri) {

	this.requestUri = uri;

    }


    /**
     * Set the name of the scheme associated with this request.  Typical values
     * are <code>http</code>, <code>https</code>, and <code>ftp</code>.
     *
     * @param scheme The scheme
     */
    public void setScheme(String scheme) {

	this.scheme = scheme;

    }


    /**
     * Set the value to be returned by <code>isSecure()</code>
     * for this Request.
     *
     * @param secure The new isSecure value
     */
    public void setSecure(boolean secure) {

	this.secure = secure;

    }


    /**
     * Set the name of the server (virtual host) to process this request.
     *
     * @param name The server name
     */
    public void setServerName(String name) {

	this.serverName = name;

    }


    /**
     * Set the port number of the server to process this request.
     *
     * @param port The server port
     */
    public void setServerPort(int port) {

	this.serverPort = port;

    }


    /**
     * Set the Principal who has been authenticated for this Request.  This
     * value is also used to calculate the value to be returned by the
     * <code>getRemoteUser()</code> method.
     *
     * @param principal The user Principal
     */
    public void setUserPrincipal(Principal principal) {

	this.userPrincipal = principal;

    }


    // ------------------------------------------------- ServletRequest Methods


    /**
     * Return the specified request attribute if it exists; otherwise, return
     * <code>null</code>.
     *
     * @param name Name of the request attribute to return
     */
    public Object getAttribute(String name) {

	return ((String) attributes.get(name));

    }


    /**
     * Return the names of all request attributes for this Request, or an
     * empty <code>Enumeration</code> if there are none.
     */
    public Enumeration getAttributeNames() {

	return (attributes.keys());

    }


    /**
     * Return the character encoding for this Request.
     */
    public String getCharacterEncoding() {

	return (null);	// FIXME: getCharacterEncoding()

    }


    /**
     * Return the content length for this Request.
     */
    public int getContentLength() {

	return (this.contentLength);

    }


    /**
     * Return the content type for this Request.
     */
    public String getContentType() {

	return (contentType);

    }


    /**
     * Return the servlet input stream for this Request.
     *
     * @exception IllegalStateException if <code>getReader()</code> has
     *  already been called for this request
     * @exception IOException if an input/output error occurs
     */
    public ServletInputStream getInputStream() throws IOException {

	return (null);	// FIXME: getInputStream()

    }


    /**
     * Return the preferred Locale that the client will accept content in,
     * based on the value for the first <code>Accept-Language</code> header
     * that was encountered.  If the request did not specify a preferred
     * language, the server's default Locale is returned.
     */
    public Locale getLocale() {

	if (locales.size() > 0)
	    return ((Locale) locales.elementAt(0));
	else
	    return (Locale.getDefault());

    }


    /**
     * Return the set of preferred Locales that the client will accept
     * content in, based on the values for any <code>Accept-Language</code>
     * headers that were encountered.  If the request did not specify a
     * preferred language, the server's default Locale is returned.
     */
    public Enumeration getLocales() {

	if (locales.size() > 0)
	    return (locales.elements());
	Vector results = new Vector();
	results.addElement(Locale.getDefault());
	return (results.elements());

    }


    /**
     * Return the value of the specified request parameter, if any; otherwise,
     * return <code>null</code>.  If there is more than one value defined,
     * return only the first one.
     *
     * @param name Name of the desired request parameter
     */
    public String getParameter(String name) {

	return (null);	// FIXME: getParameter()

    }


    /**
     * Return the names of all defined request parameters for this request.
     */
    public Enumeration getParameterNames() {

	return (null);	// FIXME: getParameterNames()

    }


    /**
     * Return the defined values for the specified request parameter, if any;
     * otherwise, return <code>null</code>.
     *
     * @param name Name of the desired request parameter
     */
    public String[] getParameterValues(String name) {

	return (null);	// FIXME: getParameterValues()

    }


    /**
     * Return the protocol and version used to make this Request.
     */
    public String getProtocol() {

	return (this.protocol);

    }


    /**
     * Read the Reader wrapping the input stream for this Request.
     *
     * @exception IllegalStateException if <code>getInputStream()</code>
     *  has already been called for this request
     * @exception IOException if an input/output error occurs
     */
    public BufferedReader getReader() {

	return (null);	// FIXME: getReader()

    }


    /**
     * Return the real path of the specified virtual path.
     *
     * @param path Path to be translated
     *
     * @deprecated As of version 2.1 of the Java Servlet API, use
     *  <code>ServletContext.getRealPath()</code>.
     */
    public String getRealPath(String path) {

	return (null);	// FIXME: getRealPath()

    }


    /**
     * Return the remote IP address making this Request.
     */
    public String getRemoteAddr() {

	return (this.remoteAddr);

    }


    /**
     * Return the remote host name making this Request.
     */
    public String getRemoteHost() {

	return (null);	// FIXME: getRemoteHost()

    }


    /**
     * Return a RequestDispatcher that wraps the resource at the specified
     * path, which may be interpreted as relative to the current request path.
     *
     * @param path Path of the resource to be wrapped
     */
    public RequestDispatcher getRequestDispatcher(String path) {

	return (null);	// FIXME: getRequestDispatcher()

    }


    /**
     * Return the scheme used to make this Request.
     */
    public String getScheme() {

	return (this.scheme);

    }


    /**
     * Return the server name responding to this Request.
     */
    public String getServerName() {

	return (this.serverName);

    }


    /**
     * Return the server port responding to this Request.
     */
    public int getServerPort() {

	return (this.serverPort);

    }


    /**
     * Was this request received on a secure connection?
     */
    public boolean isSecure() {

	return (this.secure);

    }


    /**
     * Remove the specified request attribute if it exists.
     *
     * @param name Name of the request attribute to remove
     */
    public void removeAttribute(String name) {

	attributes.remove(name);

    }


    /**
     * Set the specified request attribute to the specified value.
     *
     * @param name Name of the request attribute to set
     * @param value The associated value
     */
    public void setAttribute(String name, Object value) {

	attributes.put(name, value);

    }


    // --------------------------------------------- HttpServletRequest Methods


    /**
     * Return the authentication type used for this Request.
     */
    public String getAuthType() {

	return (this.authType);

    }


    /**
     * Return the portion of the request URI used to select the Context
     * of the Request.
     */
    public String getContextPath() {

	return (null);	// FIXME: getContextPath()

    }


    /**
     * Return the set of Cookies received with this Request.
     */
    public Cookie[] getCookies() {

	synchronized (cookies) {
	    Cookie results[] = new Cookie[cookies.size()];
	    for (int i = 0; i < results.length; i++)
		results[i] = (Cookie) cookies.elementAt(i);
	    return (results);
	}

    }


    /**
     * Return the value of the specified date header, if any; otherwise
     * return -1.
     *
     * @param name Name of the requested date header
     *
     * @exception IllegalArgumentException if the specified header value
     *  cannot be converted to a date
     */
    public long getDateHeader(String name) {

	return (-1);	// FIXME: getDateHeader()

    }


    /**
     * Return the first value of the specified header, if any; otherwise,
     * return <code>null</code>
     *
     * @param name Name of the requested header
     */
    public String getHeader(String name) {

	Vector values = (Vector) headers.get(name.toLowerCase());
	if (values == null)
	    return (null);
	else
	    return ((String) values.elementAt(0));

    }


    /**
     * Return all of the values of the specified header, if any; otherwise,
     * return <code>null</code>.
     *
     * @param name Name of the requested header
     */
    public Enumeration getHeaders(String name) {

	Vector values = (Vector) headers.get(name.toLowerCase());
	if (values != null)
	    return (values.elements());
	else
	    return (null);

    }


    /**
     * Return the names of all headers received with this request.
     */
    public Enumeration getHeaderNames() {

	return (headers.keys());

    }


    /**
     * Return the value of the specified header as an integer, or -1 if there
     * is no such header for this request.
     *
     * @param name Name of the requested header
     *
     * @exception IllegalArgumentException if the specified header value
     *  cannot be converted to an integer
     */
    public int getIntHeader(String name) {

	return (-1);	// FIXME: getIntHeader()

    }


    /**
     * Return the HTTP request method used in this Request.
     */
    public String getMethod() {

	return (this.method);

    }


    /**
     * Return the path information associated with this Request.
     */
    public String getPathInfo() {

	return (null);	// FIXME: getPathInfo()

    }


    /**
     * Return the extra path information for this request, translated
     * to a real path.
     */
    public String getPathTranslated() {

	return (null);	// FIXME: getPathTranslated()

    }


    /**
     * Return the query string associated with this request.
     */
    public String getQueryString() {

	return (null);	// FIXME: getQueryString()

    }


    /**
     * Return the name of the remote user that has been authenticated
     * for this Request.
     */
    public String getRemoteUser() {

	if (userPrincipal != null)
	    return (userPrincipal.getName());
	else
	    return (null);

    }


    /**
     * Return the session identifier included in this request, if any.
     */
    public String getRequestedSessionId() {

	return (null);	// FIXME: getRequestedSessionId()

    }


    /**
     * Return the request URI for this request.
     */
    public String getRequestURI() {

	return (this.requestUri);

    }


    /**
     * Return the portion of the request URI used to select the servlet
     * that will process this request.
     */
    public String getServletPath() {

	return (null);	// FIXME: getServletPath()

    }


    /**
     * Return the session associated with this Request, creating one
     * if necessary.
     */
    public HttpSession getSession() {

	return (null);	// FIXME: getSession()

    }


    /**
     * Return the session associated with this Request, creating one
     * if necessary and requested.
     *
     * @param create Create a new session if one does not exist
     */
    public HttpSession getSession(boolean create) {

	return (null);	// FIXME: getSession(create)

    }


    /**
     * Return <code>true</code> if the session identifier included in this
     * request came from a cookie.
     */
    public boolean isRequestedSessionIdFromCookie() {

	return (false);	// FIXME: isRequestedSessionIdFromCookie()

    }


    /**
     * Return <code>true</code> if the session identifier included in this
     * request came from the request URI.
     */
    public boolean isRequestedSessionIdFromURL() {

	return (false);	// FIXME: isRequestedSessionIdFromURL()

    }


    /**
     * Return <code>true</code> if the session identifier included in this
     * request came from the request URI.
     *
     * @deprecated As of Version 2.1 of the Java Servlet API, use
     *  <code>isRequestedSessionIdFromURL()</code> instead.
     */
    public boolean isRequestedSessionIdFromUrl() {

	return (isRequestedSessionIdFromURL());

    }


    /**
     * Return <code>true</code> if the session identifier included in this
     * request identifies a valid session.
     */
    public boolean isRequestedSessionIdValid() {

	return (false);	// FIXME: isRequestedSessionIdValid()

    }


    /**
     * Return <code>true</code> if the authenticated user principal
     * possesses the specified role name.  FIXME - Respect translations
     * in the web application deployment descriptor!
     *
     * @param role Role name to be validated
     */
    public boolean isUserInRole(String role) {

	return (false);	// FIXME: isUserInRole()

    }


    /**
     * Return the principal that has been authenticated for this Request.
     */
    public Principal getUserPrincipal() {

	return (userPrincipal);

    }


}
