/*
 * $Header: /home/cvs/jakarta-tomcat/proposals/catalina/src/share/org/apache/tomcat/connector/ResponseBase.java,v 1.1 2000/02/20 02:55:06 craigmcc Exp $
 * $Revision: 1.1 $
 * $Date: 2000/02/20 02:55:06 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 


package org.apache.tomcat.connector;


import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.Connector;
import org.apache.tomcat.Context;
import org.apache.tomcat.Request;
import org.apache.tomcat.Response;


/**
 * Convenience base implementation of the <b>Response</b> interface, which can
 * be used for the Response implementation required by most Connectors.  Only
 * the connector-specific methods need to be implemented.
 *
 * @author Craig R. McClanahan
 * @version $Revision: 1.1 $ $Date: 2000/02/20 02:55:06 $
 */

public class ResponseBase
    implements Response, HttpServletResponse {


    // ----------------------------------------------------- Instance Variables


    /**
     * The Connector through which this Response is returned.
     */
    protected Connector connector = null;


    /**
     * The content length associated with this Response.
     */
    protected int contentLength = -1;


    /**
     * The content type associated with this Response.
     */
    protected String contentType = "text/plain";


    /**
     * The Context within which this Response is being produced.
     */
    protected Context context = null;


    /**
     * The HTTP headers explicitly added via addHeader(), but not including
     * those to be added with setContentLength(), setContentType(), and so on.
     * This collection is keyed by the header name, and the elements are
     * Vectors containing the associated values that have been set.
     */
    protected Hashtable headers = new Hashtable();


    /**
     * Descriptive information about this Response implementation.
     */
    protected static final String info =
	"org.apache.tomcat.connector.ResponseBase/1.0";


    /**
     * The Request with which this Response is associated.
     */
    protected Request request = null;


    /**
     * The HTTP status code associated with this Response.
     */
    protected int status = HttpServletResponse.SC_OK;


    /**
     * The output stream associated with this Response.
     */
    protected OutputStream stream = null;


    // ------------------------------------------------------------- Properties


    /**
     * Return the Connector through which this Response will be transmitted.
     */
    public Connector getConnector() {

	return (this.connector);

    }


    /**
     * Set the Connector through which this Response will be transmitted.
     *
     * @param connector The new connector
     */
    public void setConnector(Connector connector) {

	this.connector = connector;

    }


    /**
     * Return the Context with which this Response is associated.
     */
    public Context getContext() {

	return (this.context);

    }


    /**
     * Set the Context with which this Response is associated.  This should
     * be called as soon as the appropriate Context is identified.
     *
     * @param context The associated Context
     */
    public void setContext(Context context) {

	this.context = context;

    }


    /**
     * Return descriptive information about this Response implementation and
     * the corresponding version number, in the format
     * <code>&lt;description&gt;/&lt;version&gt;</code>.
     */
    public String getInfo() {

	return (this.info);

    }


    /**
     * Return the Request with which this Response is associated.
     */
    public Request getRequest() {

	return (this.request);

    }


    /**
     * Set the Request with which this Response is associated.
     *
     * @param request The new associated request
     */
    public void setRequest(Request request) {

	this.request = request;

    }


    /**
     * Return the <code>HttpServletResponse</code> for which this object
     * is the facade.
     */
    public HttpServletResponse getResponse() {

	return ((HttpServletResponse) this);

    }


    /**
     * Return the output stream associated with this Response.
     */
    public OutputStream getStream() {

	return (this.stream);

    }


    /**
     * Set the output stream associated with this Response.
     *
     * @param stream The new output stream
     */
    public void setStream(OutputStream stream) {

	this.stream = stream;

    }


    // --------------------------------------------------------- Public Methods


    /**
     * Create and return a ServletOutputStream to write the content
     * associated with this Response.
     *
     * @exception IOException if an input/output error occurs
     */
    public ServletOutputStream createOutputStream() throws IOException {

	return (new ResponseStream(this));

    }


    /**
     * Ensure that the HTTP headers (and any buffered output) have been
     * flushed to the output stream, even if it was never acquired by
     * a servlet.
     *
     * @exception IOException if an input/output error occurs
     */
    public void flush() throws IOException {

	// FIXME: flush()

    }


    /**
     * Return the content length that was set or calculated for this Response.
     */
    public int getContentLength() {

	return (this.contentLength);

    }


    /**
     * Return the content type that was set or calculated for this response,
     * or <code>null</code> if no content type was set.
     */
    public String getContentType() {

	return (this.contentType);

    }


    /**
     * Return the value for the specified header, or <code>null</code> if this
     * header has not been set.  If more than one value was added for this
     * name, only the first is returned; use getHeaderValues() to retrieve all
     * of them.
     *
     * @param name Header name to look up
     */
    public String getHeader(String name) {

	Vector values = (Vector) headers.get(name);
	if (values != null)
	    return ((String) values.elementAt(0));
	else
	    return (null);

    }


    /**
     * Return an enumeration all the header names set for this response, or
     * an empty Enumeration if no headers have been set.
     */
    public Enumeration getHeaderNames() {

	return (headers.keys());

    }


    /**
     * Return an enumeration of all the header values associated with the
     * specified header name, or an empty enumeration if there are no such
     * header values.
     *
     * @param name Header name to look up
     */
    public Enumeration getHeaderValues(String name) {

	Vector values = (Vector) headers.get(name);
	if (values != null)
	    return (values.elements());
	else
	    return (null);

    }


    /**
     * Return the HTTP status code associated with this Response.
     */
    public int getStatus() {

	return (this.status);

    }


    /**
     * Release all object references, and initialize instance variables, in
     * preparation for reuse of this object.
     */
    public void recycle() {

	// connector is NOT reset when recycling
	contentLength = -1;
	contentType = "text/plain";
	context = null;
	headers.clear();
	request = null;
	status = -1;
	stream = null;

    }


    // ------------------------------------------------ ServletResponse Methods


    /**
     * Flush the buffer and commit this response.
     *
     * @exception IOException if an input/output error occurs
     */
    public void flushBuffer() throws IOException {

	;	// FIXME: flushBuffer()

    }


    /**
     * Return the actual buffer size used for this Response.
     */
    public int getBufferSize() {

	return (-1);	// FIXME: getBufferSize()

    }


    /**
     * Return the character encoding used for this Response.
     */
    public String getCharacterEncoding() {

	return (null);	// FIXME: getCharacterEncoding()

    }


    /**
     * Return the servlet output stream associated with this Response.
     *
     * @exception IllegalStateException if <code>getWriter</code> has
     *  already been called for this response
     * @exception IOException if an input/output error occurs
     */
    public ServletOutputStream getOutputStream() throws IOException {

	return (null);	// FIXME: getOutputStream()

    }


    /**
     * Return the Locale assigned to this response.
     */
    public Locale getLocale() {

	return (null);

    }


    /**
     * Return the writer associated with this Response.
     *
     * @exception IllegalStateException if <code>getOutputStream</code> has
     *  already been called for this response
     * @exception IOException if an input/output error occurs
     */
    public PrintWriter getWriter() throws IOException {

	return (null);	// FIXME: getWriter()

    }


    /**
     * Has the output of this response already been committed?
     */
    public boolean isCommitted() {

	return (false);	// FIXME: isCommitted()

    }


    /**
     * Clear any content written to the buffer.
     *
     * @exception IllegalStateException if this response has already
     *  been committed
     */
    public void reset() {

	;	// FIXME: reset()

    }


    /**
     * Set the buffer size to be used for this Response.
     *
     * @param size The new buffer size
     *
     * @exception IllegalStateException if this method is called after
     *  output has been committed for this response
     */
    public void setBufferSize(int size) {

	;	// FIXME: setBufferSize()

    }


    /**
     * Set the content length (in bytes) for this Response.
     *
     * @param length The new content length
     */
    public void setContentLength(int length) {

	this.contentLength = length;

    }


    /**
     * Set the content type for this Response.
     *
     * @param type The new content type
     */
    public void setContentType(String type) {

	this.contentType = type;

    }


    /**
     * Set the Locale that is appropriate for this response, including
     * setting the appropriate character encoding.
     *
     * @param locale The new locale
     */
    public void setLocale(Locale locale) {

	;	// FIXME: setLocale()

    }


    // -------------------------------------------- HttpServletResponse Methods


    /**
     * Add the specified Cookie to those that will be included with
     * this Response.
     *
     * @param cookie Cookie to be added
     */
    public void addCookie(Cookie cookie) {

	;	// FIXME: addCookie()

    }


    /**
     * Add the specified date header to the specified value.
     *
     * @param name Name of the header to set
     * @param value Date value to be set
     */
    public void addDateHeader(String name, long value) {

	;	// FIXME: setDateHeader()

    }


    /**
     * Add the specified header to the specified value.
     *
     * @param name Name of the header to set
     * @param value Value to be set
     */
    public void addHeader(String name, String value) {

	;	// FIXME: addHeader()

    }


    /**
     * Add the specified integer header to the specified value.
     *
     * @param name Name of the header to set
     * @param value Integer value to be set
     */
    public void addIntHeader(String name, int value) {

	;	// FIXME: addIntHeader()

    }


    /**
     * Has the specified header been set already in this response?
     *
     * @param name Name of the header to check
     */
    public boolean containsHeader(String name) {

	return (false);	// FIXME: containsHeader

    }


    /**
     * Encode the session identifier associated with this response
     * into the specified redirect URL, if necessary.
     *
     * @param url URL to be encoded
     */
    public String encodeRedirectURL(String url) {

	return (url);	// FIXME: encodeRedirectURL()

    }


    /**
     * Encode the session identifier associated with this response
     * into the specified redirect URL, if necessary.
     *
     * @param url URL to be encoded
     *
     * @deprecated As of Version 2.1 of the Java Servlet API, use
     *  <code>encodeRedirectURL()</code> instead.
     */
    public String encodeRedirectUrl(String url) {

	return (encodeRedirectURL(url));

    }


    /**
     * Encode the session identifier associated with this response
     * into the specified URL, if necessary.
     *
     * @param url URL to be encoded
     */
    public String encodeURL(String url) {

	return (url);	// FIXME: encodeURL()

    }


    /**
     * Encode the session identifier associated with this response
     * into the specified URL, if necessary.
     *
     * @param url URL to be encoded
     *
     * @deprecated As of Version 2.1 of the Java Servlet API, use
     *  <code>encodeURL()</code> instead.
     */
    public String encodeUrl(String url) {

	return (encodeURL(url));

    }


    /**
     * Send an error response with the specified status and a
     * default message.
     *
     * @param status HTTP status code to send
     *
     * @exception IllegalStateException if this response has
     *  already been committed
     * @exception IOException if an input/output error occurs
     */
    public void sendError(int status) throws IOException {

	;	// FIXME: sendError(status)

    }


    /**
     * Send an error response with the specified status and message.
     *
     * @param status HTTP status code to send
     * @param message Corresponding message to send
     *
     * @exception IllegalStateException if this response has
     *  already been committed
     * @exception IOException if an input/output error occurs
     */
    public void sendError(int status, String message) throws IOException {

	;	// FIXME: sendError(status, message)

    }


    /**
     * Send a temporary redirect to the specified redirect location URL.
     *
     * @param location Location URL to redirect to
     *
     * @exception IllegalStateException if this response has
     *  already been committed
     * @exception IOException if an input/output error occurs
     */
    public void sendRedirect(String location) throws IOException {

	;	// FIXME: sendRedirect()

    }


    /**
     * Set the specified date header to the specified value.
     *
     * @param name Name of the header to set
     * @param date Date value to be set
     */
    public void setDateHeader(String name, long date) {

	;	// FIXME: setDateHeader()

    }


    /**
     * Set the specified header to the specified value.
     *
     * @param name Name of the header to set
     * @param value Value to be set
     */
    public void setHeader(String name, String value) {

	;	// FIXME: setHeader()

    }


    /**
     * Set the specified integer header to the specified value.
     *
     * @param name Name of the header to set
     * @param value Integer value to be set
     */
    public void setIntHeader(String name, int value) {

	;	// FIXME: setIntHeader()

    }


    /**
     * Set the HTTP status to be returned with this response.
     *
     * @param status The new HTTP status
     */
    public void setStatus(int status) {

	;	// FIXME: setStatus(status)

    }


    /**
     * Set the HTTP status and message to be returned with this response.
     *
     * @param status The new HTTP status
     * @param message The associated text message
     *
     * @deprecated As of Version 2.1 of the Java Servlet API, this method
     *  has been deprecated due to the ambiguous meaning of the message
     *  parameter.
     */
    public void setStatus(int status, String message) {

	;	// FIXME: setStatus(status, message)

    }


}
