/*
 * $Header: /home/cvs/jakarta-tomcat/proposals/catalina/src/share/org/apache/tomcat/core/StandardHost.java,v 1.4 2000/01/30 02:28:57 craigmcc Exp $
 * $Revision: 1.4 $
 * $Date: 2000/01/30 02:28:57 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 


package org.apache.tomcat.core;


import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.Container;
import org.apache.tomcat.Context;
import org.apache.tomcat.Host;
import org.apache.tomcat.Request;
import org.apache.tomcat.Response;


/**
 * Standard implementation of the <b>Host</b> interface.  Each
 * child container must be a Context implementation to process the
 * requests directed to a particular web application.
 *
 * @author Craig R. McClanahan
 * @version $Revision: 1.4 $ $Date: 2000/01/30 02:28:57 $
 */

public final class StandardHost
    extends ContainerBase
    implements Host {


    // ----------------------------------------------------------- Constructors


    /**
     * Create a new StandardHost component with the default basic Valve.
     */
    public StandardHost() {

	super();
	setBasic(new StandardHostValve());

    }


    // ----------------------------------------------------- Instance Variables


    /**
     * The descriptive information string for this implementation.
     */
    private static final String info =
	"org.apache.tomcat.core.StandardHost/1.0";


    /**
     * Should we return a root context?
     */
    private boolean root = false;


    /**
     * The root context for this virtual host.
     */
    private ServletContext rootContext = null;


    // ------------------------------------------------------------- Properties


    /**
     * Return the canonical, fully qualified, name of the virtual host
     * this Container represents.
     */
    public String getName() {

	return (name);

    }


    /**
     * Set the canonical, fully qualified, name of the virtual host
     * this Container represents.
     *
     * @param name Virtual host name
     *
     * @exception IllegalArgumentException if name is null
     */
    public void setName(String name) {

	if (name == null)
	    throw new IllegalArgumentException
		(sm.getString("standardHost.nullName"));

	String oldName = this.name;
	this.name = name;
	support.firePropertyChange("name", oldName, this.name);

    }


    /**
     * Return the root context flag.
     */
    public boolean getRoot() {

	return (this.root);

    }


    /**
     * Set the root context flag.
     *
     * @param root The new root context flag
     */
    public void setRoot(boolean root) {

	boolean oldRoot = this.root;
	this.root = root;
	support.firePropertyChange("root", new Boolean(oldRoot),
				   new Boolean(this.root));

    }


    /**
     * Return a specialized ServletContext instance that wraps the
     * resources of the underlying virtual host; or <code>null</code>
     * if access to these resources is not supported or not allowed.
     * In general, this method will be used when a servlet calls
     * <code>ServletContext.getContext("/")</code>.
     */
    public ServletContext getRootContext() {

	if (!root)
	    return (null);

	// Construct a root context object if necessary
	rootContext = null;	// XXX - create root context object

	return (rootContext);

    }


    // --------------------------------------------------------- Public Methods


    /**
     * Add a child Container, only if the proposed child is an implementation
     * of Context.
     *
     * @param child Child container to be added
     */
    public void addChild(Container child) {

	if (!(child instanceof Context))
	    throw new IllegalArgumentException
		(sm.getString("standardHost.notContext"));
	super.addChild(child);

    }


    /**
     * Return descriptive information about this Container implementation and
     * the corresponding version number, in the format
     * <code>&lt;description&gt;/&lt;version&gt;</code>.
     */
    public String getInfo() {

	return (info);

    }


    /**
     * Return the Context that should be used to process this request,
     * based on matching the longest possible context path (or selecting
     * the default context.  If no such Context can be identified,
     * return <code>null</code> instead.
     *
     * @param uri Request URI, which must start with a '/'
     */
    public Context map(String uri) {

	String path = uri;
	Context context = null;
	while (path.length() > 1) {
	    context = (Context) findChild(path);
	    if (context != null)
		break;
	    path = path.substring(0, path.lastIndexOf("/"));
	}
	return (context);

    }


}
