/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import java.util.ArrayList;
import java.util.List;
import sun.tools.agent.AbsentInformationException;
import sun.tools.agent.CachedClass;
import sun.tools.agent.CachedMethod;
import sun.tools.agent.Location;

class StackFrame {
    private long frameID;
    private Class clazz;
    private long methodID;
    private int bci;
    private boolean isNative;
    private CachedMethod method;
    private Location location;
    List localVariables;

    StackFrame() {
    }

    static native void fillInFrameData(Thread var0, StackFrame[] var1);

    static native int frameCount(Thread var0);

    int getBCI() {
        return this.bci;
    }

    String getClassName() {
        return this.clazz.getName();
    }

    int getLinenumber() {
        try {
            Location location = this.location();
            if (location == null) {
                return -1;
            }
            return location.line;
        }
        catch (AbsentInformationException absentInformationException) {
            return -1;
        }
    }

    List getLocalVariables() {
        block2: {
            if (this.localVariables != null) break block2;
            try {
                this.localVariables = this.getMethod().getVisibleLocalVariables(this.bci);
            }
            catch (AbsentInformationException absentInformationException) {
                this.localVariables = new ArrayList(0);
            }
        }
        return this.localVariables;
    }

    CachedMethod getMethod() {
        if (this.method == null) {
            this.method = CachedClass.getCachedClass(this.clazz).getMethod(this.methodID);
        }
        return this.method;
    }

    String getMethodName() {
        return this.getMethod().getName();
    }

    String getMethodSignature() {
        return this.getMethod().getTypeSignature();
    }

    Class getRealClass() {
        return this.clazz;
    }

    static StackFrame[] getStackFrames(Thread thread) {
        StackFrame[] stackFrameArray = new StackFrame[StackFrame.frameCount(thread)];
        int n = 0;
        while (n < stackFrameArray.length) {
            stackFrameArray[n] = new StackFrame();
            ++n;
        }
        StackFrame.fillInFrameData(thread, stackFrameArray);
        return stackFrameArray;
    }

    boolean isNative() {
        return this.isNative;
    }

    Location location() throws AbsentInformationException {
        if (this.location == null) {
            this.location = this.getMethod().bciToLocation(this.bci);
        }
        return this.location;
    }

    public String toString() {
        String string = this.clazz.getName();
        String string2 = this.getMethod().getName();
        if (this.isNative) {
            return String.valueOf(string) + "." + string2 + " (native method)";
        }
        try {
            this.location();
        }
        catch (AbsentInformationException absentInformationException) {}
        if (this.location == null || this.location.line == -1) {
            return String.valueOf(string) + "." + string2 + " (offset " + this.bci + ")";
        }
        int n = string.lastIndexOf(46);
        String string3 = n >= 0 ? string.substring(n + 1) : string;
        return String.valueOf(string) + "." + string2 + " (" + string3 + ":" + this.getLinenumber() + ")";
    }
}

