/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.moo;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.moo.Logger;
import org.apache.tools.moo.TestResult;
import org.apache.tools.moo.Testable;

public class Main {
    private static final String ConfigFileName = "testlist.txt";
    private static final String HelpArg = "-help";
    private static final String DebugArg = "-debug";
    private static final String ConfigFileArg = "-testfile";
    public static final String HostName = "test.hostName";
    public static final String PortName = "test.port";
    public static final String DefaultHost = "localhost";
    public static final String DefaultPort = "8080";
    private static final int TrimSize = 35;
    private static final int PageSize = 75;
    private String[] args = null;
    private boolean debug = true;

    public Main(String[] stringArray) {
        long l = System.currentTimeMillis();
        this.args = stringArray;
        if (this.argExists(DebugArg)) {
            this.debug = true;
        }
        if (this.argExists(HelpArg)) {
            System.out.print("usage: ");
            System.out.print(this.getClass().getName());
            System.out.println(" [-options]");
            System.out.println("");
            System.out.println("where options include:");
            System.out.println("    -help             print out this message");
            System.out.println("    -debug            print debug messages");
            System.out.println("    -testfile <file>  set test config file");
            System.exit(0);
        }
        this.setDefaults();
        Vector vector = this.getTests(this.getArg(ConfigFileArg));
        Logger logger = Logger.getLogger();
        System.out.println();
        System.out.println("testing " + vector.size() + " module" + (vector.size() != 1 ? "s" : ""));
        System.out.println();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("errorLog");
            this.doTest(vector.elements(), fileOutputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
        long l2 = System.currentTimeMillis() - l;
        String string = String.valueOf(l2 / 1000L) + "." + l2 % 1000L;
        System.out.println();
        System.out.println("complete in : " + string + " seconds");
        System.out.println();
    }

    private boolean argExists(String string) {
        int n = 0;
        while (n < this.args.length) {
            String string2 = this.args[n];
            if (string2.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void doTest(Enumeration enumeration, OutputStream outputStream) {
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            CharSequence charSequence;
            Object var5_5 = null;
            try {
                charSequence = (String)enumeration.nextElement();
                var5_5 = Class.forName((String)charSequence).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.debug) continue;
                classNotFoundException.printStackTrace();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!this.debug) continue;
                illegalAccessException.printStackTrace();
                continue;
            }
            catch (InstantiationException instantiationException) {
                if (!this.debug) continue;
                instantiationException.printStackTrace();
                continue;
            }
            charSequence = new StringBuffer("  ");
            ((StringBuffer)charSequence).append("  ");
            if (var5_5 instanceof Testable) {
                String string;
                boolean bl;
                String string2;
                TestResult testResult;
                block18: {
                    testResult = null;
                    string2 = null;
                    bl = false;
                    try {
                        ((Testable)var5_5).setStream(outputStream);
                        string2 = ((Testable)var5_5).getDescription();
                        testResult = ((Testable)var5_5).runTest();
                        bl = testResult.getStatus();
                    }
                    catch (Exception exception) {
                        if (!this.debug) break block18;
                        exception.printStackTrace();
                    }
                }
                if (string2.length() > 35) {
                    ((StringBuffer)charSequence).append(string2.substring(0, 32));
                    ((StringBuffer)charSequence).append("...");
                } else {
                    ((StringBuffer)charSequence).append(string2);
                    int n3 = string2.length();
                    while (n3 < 35) {
                        ((StringBuffer)charSequence).append(" ");
                        ++n3;
                    }
                }
                ((StringBuffer)charSequence).append(" : ");
                if (bl) {
                    ((StringBuffer)charSequence).append("OK");
                    ++n;
                } else {
                    ((StringBuffer)charSequence).append("FAIL");
                    ++n2;
                }
                if (testResult != null && (string = testResult.getMessage()) != null && string.trim().length() > 0) {
                    ((StringBuffer)charSequence).append(" - ");
                    int n4 = 40;
                    if (string.length() > n4) {
                        ((StringBuffer)charSequence).append(System.getProperty("line.separator"));
                        ((StringBuffer)charSequence).append("      ");
                    }
                    ((StringBuffer)charSequence).append(string);
                }
            } else {
                ((StringBuffer)charSequence).append("FAIL");
                ((StringBuffer)charSequence).append(" - not testable");
                ++n2;
            }
            System.out.println(charSequence);
        }
        System.out.println();
        if (n2 == 0) {
            System.out.println("<<< PASS >>>");
        } else {
            System.out.println("<<< FAIL >>>");
        }
        System.out.println("Number of tests Passed: " + n);
        System.out.println("Number of tests Failed: " + n2);
    }

    private String getArg(String string) {
        int n = 0;
        while (n < this.args.length) {
            String string2 = this.args[n];
            if (string2.equals(string)) {
                try {
                    String string3 = this.args[n + 1];
                    return string3;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    private BufferedReader getReader(String string) {
        BufferedReader bufferedReader;
        block2: {
            bufferedReader = null;
            if (string == null || string.trim().length() <= 0) break block2;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!this.debug) break block2;
                fileNotFoundException.printStackTrace();
            }
        }
        return bufferedReader;
    }

    private Vector getTests(String string) {
        Vector<String> vector;
        block4: {
            BufferedReader bufferedReader = null;
            vector = new Vector<String>();
            bufferedReader = this.getReader(string);
            if (bufferedReader == null) {
                bufferedReader = this.getReader(ConfigFileName);
            }
            if (bufferedReader == null) break block4;
            String string2 = null;
            try {
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0 || string2.startsWith("#")) continue;
                    vector.addElement(string2.trim());
                }
            }
            catch (IOException iOException) {
                if (!this.debug) break block4;
                iOException.printStackTrace();
            }
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        try {
            new Main(stringArray);
        }
        catch (Exception exception) {
            System.out.println("can't instantiate : Main");
            exception.printStackTrace();
        }
    }

    private void setDefaults() {
        block5: {
            Properties properties = null;
            try {
                properties = System.getProperties();
            }
            catch (SecurityException securityException) {
                if (this.debug) {
                    securityException.printStackTrace();
                }
                properties = new Properties();
            }
            ((Hashtable)properties).put(HostName, properties.getProperty(HostName, DefaultHost));
            ((Hashtable)properties).put(PortName, properties.getProperty(PortName, DefaultPort));
            try {
                System.setProperties(properties);
            }
            catch (SecurityException securityException) {
                if (!this.debug) break block5;
                securityException.printStackTrace();
            }
        }
    }
}

