/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.moo.cookie;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.moo.cookie.RfcDateParser;

public class HttpCookie {
    private Date expirationDate = null;
    private String nameAndValue;
    private String path;
    private String domain;
    private boolean isSecure = false;
    private static boolean defaultSet = false;
    private static long defExprTime = 0L;

    public HttpCookie(String string) {
        this.parseCookieString(string);
    }

    public HttpCookie(URL uRL, String string) {
        this.parseCookieString(string);
        this.applyDefaults(uRL);
    }

    public HttpCookie(Date date, String string, String string2, String string3, boolean bl) {
        this.expirationDate = date;
        this.nameAndValue = string;
        this.path = string2;
        this.domain = string3;
        this.isSecure = bl;
    }

    private void applyDefaults(URL uRL) {
        if (this.domain == null) {
            this.domain = String.valueOf(uRL.getHost()) + ":" + (uRL.getPort() == -1 ? 80 : uRL.getPort());
        }
        if (this.path == null) {
            this.path = uRL.getFile();
            int n = this.path.lastIndexOf("/");
            if (n > -1) {
                this.path = this.path.substring(0, n);
            }
        }
    }

    private Date getDefaultExpiration() {
        if (!defaultSet) {
            Properties properties = new Properties();
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("cookie.properties");
                if (inputStream == null) {
                    throw new IOException();
                }
                properties.load(inputStream);
                System.out.println("Got properties from ServerAutoRun.properties");
                properties.list(System.out);
            }
            catch (IOException iOException) {
                System.out.println("HttpCookie getDefaultExpiration : cookie.properties not found!" + iOException);
            }
            defExprTime = Long.parseLong(properties.getProperty("cookies.default.expiration"));
        }
        defaultSet = true;
        return new Date(System.currentTimeMillis() + defExprTime);
    }

    public String getDomain() {
        return this.domain;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getName() {
        if (this.nameAndValue == null) {
            return "=";
        }
        int n = this.nameAndValue.indexOf("=");
        return n < 0 ? "=" : this.nameAndValue.substring(0, n);
    }

    public String getNameValue() {
        return this.nameAndValue;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasExpired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate.getTime() <= System.currentTimeMillis();
    }

    public boolean isSaveable() {
        return this.expirationDate != null && this.expirationDate.getTime() > System.currentTimeMillis();
    }

    public boolean isSaveableInMemory() {
        return this.expirationDate == null || this.expirationDate != null && this.expirationDate.getTime() > System.currentTimeMillis();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private void parseCookieString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (!stringTokenizer.hasMoreTokens()) {
            this.nameAndValue = "=";
            return;
        }
        this.nameAndValue = stringTokenizer.nextToken().trim();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equalsIgnoreCase("secure")) {
                this.isSecure = true;
                continue;
            }
            int n = string2.indexOf("=");
            if (n < 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equalsIgnoreCase("path")) {
                this.path = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("domain")) {
                if (string4.indexOf(".") == 0) {
                    this.domain = string4.substring(1);
                    continue;
                }
                this.domain = string4;
                continue;
            }
            if (!string3.equalsIgnoreCase("expires")) continue;
            this.expirationDate = this.parseExpireDate(string4);
        }
    }

    private Date parseExpireDate(String string) {
        RfcDateParser rfcDateParser = new RfcDateParser(string);
        Date date = rfcDateParser.getDate();
        if (date == null) {
            date = this.getDefaultExpiration();
        }
        return date;
    }

    public String toString() {
        String string;
        String string2 = string = this.nameAndValue == null ? "=" : this.nameAndValue;
        if (this.expirationDate != null) {
            string = String.valueOf(string) + "; expires=" + this.expirationDate;
        }
        if (this.path != null) {
            string = String.valueOf(string) + "; path=" + this.path;
        }
        if (this.domain != null) {
            string = String.valueOf(string) + "; domain=" + this.domain;
        }
        if (this.isSecure) {
            string = String.valueOf(string) + "; secure";
        }
        return string;
    }
}

