/**
 * TagExtraInfo for an action that accepts only arguments A,B,C
 * such that A+B==C
 */


package tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public class SillyArgsExtraInfo extends TagExtraInfo {

    public boolean isValid(TagData data) {
        //System.out.println("isValid()");
	if (data == null) {
	    return false;
	}
	int a, b, c;
	String oa, ob, oc;
	oa = data.getAttributeString("a");
	ob = data.getAttributeString("b");
	oc = data.getAttributeString("c");
        
        //System.out.println("a: "+oa+" b: "+ob+" c: "+oc);

	if ((oa == null) || (ob == null) || (oc == null)) {
	    return false;
	}
	
	if (Integer.parseInt(oa) +
	    Integer.parseInt(ob) !=
	    Integer.parseInt(oc)) {
            //System.out.println("false 'cos they are not equal");
	    return false;
	}
	
	if (data.getAttribute("testLibInfo") != null) {
	    if (!testLibInfo()) {
                //System.out.println("false 'cos of testLibInfo");
		return false;
	    }
	}

	return true;
    }

    private boolean testLibInfo() {
	// Now test that TagInfo is somewhat appropriate...
	TagInfo ti = getTagInfo();

	if (!(ti.getTagClassName()+"ExtraInfo").equals(this.getClass().getName())) {
            //System.out.println("ti.getTagClassName: "+ti.getTagClassName());
	    return false;
	}
	
	TagAttributeInfo tai[] = ti.getAttributes();

	if (tai.length != 3 && tai.length != 4) {
            //System.out.println("tai.length = "+tai.length);
	    return false;	// there should be 3 attributes
	}

	if (!has(tai, "a") || !has(tai, "b") || !has(tai, "c")) {
            //System.out.println("has issue");
	    return false;
	}

	TagLibraryInfo tli = ti.getTagLibrary();
	TagInfo ti2 = tli.getTag(ti.getTagName());

	if (!(ti2.getTagClassName()+"ExtraInfo").equals(this.getClass().getName())) {
            //System.out.println("ti2.getTagClassName: "+ti2.getTagClassName());
	    return false;
	}

	return true;
    }


    private static boolean has(TagAttributeInfo tai[], String s) {
	for (int i = 0; i<tai.length; i++) {
	    if (tai[i].getName().equals(s)) {
		return true;
	    }
	}
	return false;
    }
}
