/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.activescript;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.engines.activescript.JavaBean;
import com.ibm.bsf.engines.activescript.JavaBeanAddEventListener;
import com.ibm.bsf.util.BSFEngineImpl;
import com.ibm.bsf.util.EngineUtils;
import java.util.Hashtable;
import java.util.Vector;

public class ActiveScriptEngine
extends BSFEngineImpl
implements JavaBeanAddEventListener {
    static BSFException dllLoadException = null;
    static final String libName = "bsfactivescriptengine";
    static final String LANG_VBSCRIPT = "vbscript";
    static final String LANG_PERLSCRIPT = "perlscript";
    static final String LANG_JSCRIPT = "jscript";
    byte[] css;
    BSFManager bsfmgr;
    private Hashtable evalRet;
    protected String lang;

    protected final boolean isVBScript() {
        return this.lang.equalsIgnoreCase(LANG_VBSCRIPT);
    }

    protected final boolean isPerlScript() {
        return this.lang.equalsIgnoreCase(LANG_PERLSCRIPT);
    }

    protected final boolean isJScript() {
        return this.lang.equalsIgnoreCase(LANG_JSCRIPT);
    }

    protected final boolean isCaseSensitive() {
        return this.isVBScript();
    }

    public final void setEvalRet(Object object) {
        this.evalRet.put(new Integer(Thread.currentThread().hashCode()), object != null ? object : this.evalRet);
    }

    private final boolean terminated() {
        return this.css == null;
    }

    private native void nativeInit(String var1, String var2, Object[] var3) throws BSFException;

    private native Object nativeEval(byte[] var1, int var2, int var3, String var4, boolean var5) throws BSFException;

    private native void nativeTerminate(byte[] var1) throws BSFException;

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        if (dllLoadException != null) {
            throw dllLoadException;
        }
        Object object = this;
        synchronized (object) {
            if (this.lang != null) {
                this.lang = string;
                throw new BSFException(BSFException.REASON_OTHER_ERROR, "Engine " + this + " initialized again");
            }
            this.lang = string;
        }
        super.initialize(bSFManager, string, vector);
        if (this.isPerlScript()) {
            this.evalRet = new Hashtable();
        }
        this.bsfmgr = bSFManager;
        this.nativeInit(this.lang, null, null);
        if (this.css == null) {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "Engine " + this + " failed to initialize native interface properly.");
        }
        if (vector.size() != 0) {
            object = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (this.isVBScript()) {
                object = "SET ";
                string2 = "=bsf.lookupBean(\"";
                string3 = "\")";
                string4 = ":";
                string5 = "";
            } else if (this.isJScript()) {
                object = "var ";
                string2 = "=bsf.lookupBean(\"";
                string3 = "\")";
                string5 = string4 = ";";
            } else if (this.isPerlScript()) {
                object = "$";
                string2 = "=$bsf->lookupBean('";
                string3 = "')";
                string5 = string4 = ";";
            } else {
                throw new BSFException(BSFException.REASON_OTHER_ERROR, String.valueOf(this.lang) + " does not support undeclareBean.");
            }
            StringBuffer stringBuffer = new StringBuffer("");
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                BSFDeclaredBean bSFDeclaredBean = (BSFDeclaredBean)vector.elementAt(n2);
                stringBuffer.append(String.valueOf(object) + bSFDeclaredBean.name + string2 + bSFDeclaredBean.name + string3 + (n2 < n - 1 ? string4 : string5));
                ++n2;
            }
            this.exec("<declareBean>", 0, 0, stringBuffer.toString());
        }
    }

    public void exec(String string, int n, int n2, Object object) throws BSFException {
        ActiveScriptEngine activeScriptEngine = this;
        synchronized (activeScriptEngine) {
            if (this.terminated()) {
                throw new BSFException(BSFException.REASON_OTHER_ERROR, "Exec or eval called after engine termination!");
            }
        }
        this.nativeEval(this.css, n, n2, object.toString(), false);
    }

    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        if (!this.isPerlScript()) {
            return this.nativeEval(this.css, n, n2, object.toString(), true);
        }
        Integer n3 = new Integer(Thread.currentThread().hashCode());
        this.nativeEval(this.css, n, n2, "$bsf->setEvalRet(" + object.toString() + "); #via eval", false);
        Object v = this.evalRet.get(n3);
        if (v == this.evalRet) {
            v = null;
        }
        this.evalRet.put(n3, this.evalRet);
        return v;
    }

    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(object.toString());
        stringBuffer.append(".");
        stringBuffer.append(string);
        stringBuffer.append("(");
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n].toString());
                if (n < objectArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
        }
        stringBuffer.append(")");
        return this.eval("<internal>", -1, -1, stringBuffer.toString());
    }

    private final Object callBeanMethod(Object object, String string, Object[] objectArray) throws BSFException {
        if (object.equals(this) && string.equals("callMethodViaBSF")) {
            return this.callMethodViaBSF((Object[])objectArray[0]);
        }
        if (object.equals(this) && string.equals("createBean")) {
            return this.createBean((Object[])objectArray[0]);
        }
        return EngineUtils.callBeanMethod((Object)object, (String)string, (Object[])objectArray);
    }

    final Object callMethodViaBSF(Object[] objectArray) throws BSFException {
        Object[] objectArray2 = new Object[objectArray.length - 2];
        if (objectArray.length > 2) {
            System.arraycopy(objectArray, 2, objectArray2, 0, objectArray.length - 2);
        }
        return EngineUtils.callBeanMethod((Object)objectArray[0], (String)((String)objectArray[1]), (Object[])objectArray2);
    }

    final Object createBean(Object[] objectArray) throws BSFException {
        Object[] objectArray2 = new Object[objectArray.length - 1];
        if (objectArray.length > 1) {
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        }
        return EngineUtils.createBean((String)((String)objectArray[0]), (Object[])objectArray2);
    }

    public void addEventListener(Object object, String string, String string2, String string3) throws BSFException {
        EngineUtils.addEventListener((Object)object, (String)string, (String)string2, (BSFEngine)this, (BSFManager)this.bsfmgr, (String)"ActiveScriptEngine", (int)0, (int)0, (Object)string3);
    }

    public final int bindMember(Object object, String string, short s) throws Exception {
        return JavaBean.bindMember(object.getClass(), string, s);
    }

    public final Object callMethod(Object object, int n, Object[] objectArray) throws Exception {
        return JavaBean.callMethod(this, object, n, objectArray);
    }

    public final Object lookupBean(String string) {
        return this.bsfmgr.lookupBean(string);
    }

    public final void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (this.isVBScript()) {
            this.exec("<declareBean>", 0, 0, "SET " + bSFDeclaredBean.name + "=bsf.lookupBean(\"" + bSFDeclaredBean.name + "\") 'via declareBean");
            return;
        }
        if (this.isJScript()) {
            this.exec("<declareBean>", 0, 0, "var " + bSFDeclaredBean.name + "=bsf.lookupBean(\"" + bSFDeclaredBean.name + "\"); //via declareBean");
            return;
        }
        if (this.isPerlScript()) {
            this.exec("<declareBean>", 0, 0, "$" + bSFDeclaredBean.name + "=$bsf->lookupBean('" + bSFDeclaredBean.name + "'); #via declareBean");
            return;
        }
        throw new BSFException(BSFException.REASON_OTHER_ERROR, String.valueOf(this.lang) + " does not support declareBean.");
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (this.isVBScript()) {
            this.exec("<undeclareBean>", 0, 0, "SET " + bSFDeclaredBean.name + "=Nothing 'via undeclareBean");
            return;
        }
        if (this.isJScript()) {
            this.exec("<undeclareBean>", 0, 0, String.valueOf(bSFDeclaredBean.name) + "=null; // via undeclareBean");
            return;
        }
        if (this.isPerlScript()) {
            this.exec("<undeclareBean>", 0, 0, "undef " + bSFDeclaredBean.name + " ; #via undeclareBean");
            return;
        }
        throw new BSFException(BSFException.REASON_OTHER_ERROR, String.valueOf(this.lang) + " does not support undeclareBean.");
    }

    private static final byte[] objectToVariant(Object object) {
        byte[] byArray = new byte[16];
        if (object instanceof Boolean) {
            byte by;
            byArray[0] = 11;
            byArray[1] = 0;
            byArray[8] = by = (byte)((Boolean)object != false ? 255 : 0);
            byArray[9] = by;
            byArray[10] = by;
            byArray[11] = by;
        } else if (object instanceof Integer) {
            byArray[0] = 3;
            byArray[1] = 0;
            int n = (Integer)object;
            byArray[8] = (byte)n;
            byArray[9] = (byte)(n >>> 8 & 0xFF);
            byArray[10] = (byte)(n >>> 16 & 0xFF);
            byArray[11] = (byte)(n >>> 24 & 0xFF);
        } else if (object instanceof String) {
            byArray[0] = 8;
            byArray[1] = 0;
        } else if (object instanceof Long) {
            byArray[0] = 5;
            byArray[1] = 0;
            long l = Double.doubleToLongBits(((Long)object).longValue());
            byArray[8] = (byte)l;
            byArray[9] = (byte)(l >>> 8 & 0xFFL);
            byArray[10] = (byte)(l >>> 16 & 0xFFL);
            byArray[11] = (byte)(l >>> 24 & 0xFFL);
            byArray[12] = (byte)(l >>> 32 & 0xFFL);
            byArray[13] = (byte)(l >>> 40 & 0xFFL);
            byArray[14] = (byte)(l >>> 48 & 0xFFL);
            byArray[15] = (byte)(l >>> 56 & 0xFFL);
        } else if (object instanceof Short) {
            byArray[0] = 2;
            byArray[1] = 0;
            int n = Float.floatToIntBits(((Float)object).floatValue());
            byArray[8] = (byte)n;
            byArray[9] = (byte)(n >>> 8 & 0xFF);
            byArray[10] = (byte)(n >>> 16 & 0xFF);
            byArray[11] = (byte)(n >>> 24 & 0xFF);
        } else if (object instanceof Float) {
            byArray[0] = 4;
            byArray[1] = 0;
            int n = Float.floatToIntBits(((Float)object).floatValue());
            byArray[8] = (byte)n;
            byArray[9] = (byte)(n >>> 8 & 0xFF);
            byArray[10] = (byte)(n >>> 16 & 0xFF);
            byArray[11] = (byte)(n >>> 24 & 0xFF);
        } else if (object instanceof Double) {
            byArray[0] = 5;
            byArray[1] = 0;
            long l = Double.doubleToLongBits((Double)object);
            byArray[8] = (byte)l;
            byArray[9] = (byte)(l >>> 8 & 0xFFL);
            byArray[10] = (byte)(l >>> 16 & 0xFFL);
            byArray[11] = (byte)(l >>> 24 & 0xFFL);
            byArray[12] = (byte)(l >>> 32 & 0xFFL);
            byArray[13] = (byte)(l >>> 40 & 0xFFL);
            byArray[14] = (byte)(l >>> 48 & 0xFFL);
            byArray[15] = (byte)(l >>> 56 & 0xFFL);
        } else if (object instanceof Byte) {
            byte by;
            byArray[0] = 17;
            byArray[1] = 0;
            byArray[8] = by = ((Byte)object).byteValue();
        } else if (object instanceof Character) {
            byte by;
            byArray[0] = 17;
            byArray[1] = 0;
            byArray[8] = by = (byte)((Character)object).charValue();
        } else if (object instanceof Void) {
            byArray[0] = 1;
            byArray[1] = 0;
        } else {
            byArray[0] = 9;
            byArray[1] = 0;
        }
        return byArray;
    }

    public synchronized void terminate() throws BSFException {
        if (!this.terminated()) {
            byte[] byArray = this.css;
            this.css = null;
            this.bsfmgr = null;
            this.evalRet = null;
            this.lang = null;
            this.nativeTerminate(byArray);
        }
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    static {
        try {
            System.loadLibrary(libName);
            return;
        }
        catch (SecurityException securityException) {
            dllLoadException = new BSFException(BSFException.REASON_OTHER_ERROR, "SecurityException loading library:bsfactivescriptengine " + securityException.getMessage(), (Throwable)securityException);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            dllLoadException = new BSFException(BSFException.REASON_OTHER_ERROR, "UnsatisfiedLinkError loading library:bsfactivescriptengine " + unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
            return;
        }
    }
}

