/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.loader.Extension;
import org.apache.catalina.loader.Reloader;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class WebappClassLoader
extends URLClassLoader
implements Reloader,
Lifecycle {
    private static final String[] triggers = new String[]{"javax.servlet.Servlet"};
    private static final String[] packageTriggers = new String[]{"javax", "org.xml.sax", "org.w3c.dom", "org.apache.xerces", "org.apache.xalan"};
    protected DirContext resources = null;
    protected ArrayList available = new ArrayList();
    protected HashMap resourceEntries = new HashMap();
    protected HashMap notFoundResources = new HashMap();
    protected int debug = 0;
    protected boolean delegate = false;
    protected String[] repositories = new String[0];
    protected File[] files = new File[0];
    protected JarFile[] jarFiles = new JarFile[0];
    protected File[] jarRealFiles = new File[0];
    protected String jarPath = null;
    protected String[] jarNames = new String[0];
    protected long[] lastModifiedDates = new long[0];
    protected String[] paths = new String[0];
    protected ArrayList required = new ArrayList();
    private ArrayList permissionList = new ArrayList();
    private HashMap loaderPC = new HashMap();
    private SecurityManager securityManager = null;
    private ClassLoader parent = null;
    private ClassLoader system = null;
    protected boolean started = false;
    protected boolean hasExternalRepositories = false;
    private Permission allPermission = new AllPermission();

    public WebappClassLoader() {
        super(new URL[0]);
        this.parent = this.getParent();
        this.system = ClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebappClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.parent = this.getParent();
        this.system = ClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public DirContext getResources() {
        return this.resources;
    }

    public void setResources(DirContext resources) {
        this.resources = resources;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public void addPermission(String path) {
        if (this.securityManager != null) {
            Object permission = null;
            permission = path.startsWith("jndi:") || path.startsWith("jar:jndi:") ? new JndiPermission(path + "*") : new FilePermission(path + "-", "read");
            this.addPermission((Permission)permission);
        }
    }

    public void addPermission(URL url) {
        this.addPermission(url.toString());
    }

    public void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public void addRepository(String repository) {
        if (repository.startsWith("/WEB-INF/lib") || repository.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            URL url = new URL(repository);
            super.addURL(url);
            this.hasExternalRepositories = true;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    synchronized void addRepository(String repository, File file) {
        if (repository == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log("addRepository(" + repository + ")");
        }
        String[] result = new String[this.repositories.length + 1];
        int i = 0;
        while (i < this.repositories.length) {
            result[i] = this.repositories[i];
            ++i;
        }
        result[this.repositories.length] = repository;
        this.repositories = result;
        File[] result2 = new File[this.files.length + 1];
        i = 0;
        while (i < this.files.length) {
            result2[i] = this.files[i];
            ++i;
        }
        result2[this.files.length] = file;
        this.files = result2;
    }

    synchronized void addJar(String jar, JarFile jarFile, File file) throws IOException {
        int i;
        if (jar == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log("addJar(" + jar + ")");
        }
        if (this.jarPath != null && jar.startsWith(this.jarPath)) {
            String jarName = jar.substring(this.jarPath.length());
            while (jarName.startsWith("/")) {
                jarName = jarName.substring(1);
            }
            String[] result = new String[this.jarNames.length + 1];
            i = 0;
            while (i < this.jarNames.length) {
                result[i] = this.jarNames[i];
                ++i;
            }
            result[this.jarNames.length] = jarName;
            this.jarNames = result;
        }
        try {
            long lastModified = ((ResourceAttributes)this.resources.getAttributes(jar)).getLastModified();
            String[] result = new String[this.paths.length + 1];
            i = 0;
            while (i < this.paths.length) {
                result[i] = this.paths[i];
                ++i;
            }
            result[this.paths.length] = jar;
            this.paths = result;
            long[] result3 = new long[this.lastModifiedDates.length + 1];
            i = 0;
            while (i < this.lastModifiedDates.length) {
                result3[i] = this.lastModifiedDates[i];
                ++i;
            }
            result3[this.lastModifiedDates.length] = lastModified;
            this.lastModifiedDates = result3;
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (!this.validateJarFile(file)) {
            return;
        }
        JarFile[] result2 = new JarFile[this.jarFiles.length + 1];
        i = 0;
        while (i < this.jarFiles.length) {
            result2[i] = this.jarFiles[i];
            ++i;
        }
        result2[this.jarFiles.length] = jarFile;
        this.jarFiles = result2;
        File[] result4 = new File[this.jarRealFiles.length + 1];
        i = 0;
        while (i < this.jarRealFiles.length) {
            result4[i] = this.jarRealFiles[i];
            ++i;
        }
        result4[this.jarRealFiles.length] = file;
        this.jarRealFiles = result4;
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            Iterator extensions = Extension.getAvailable((Manifest)manifest).iterator();
            while (extensions.hasNext()) {
                this.available.add(extensions.next());
            }
            extensions = Extension.getRequired((Manifest)manifest).iterator();
            while (extensions.hasNext()) {
                this.required.add(extensions.next());
            }
        }
    }

    public Extension[] findAvailable() {
        Extension[] extensions;
        ArrayList results = new ArrayList();
        Iterator available = this.available.iterator();
        while (available.hasNext()) {
            results.add(available.next());
        }
        ClassLoader loader = this;
        while ((loader = loader.getParent()) != null) {
            if (!(loader instanceof WebappClassLoader)) continue;
            extensions = ((WebappClassLoader)loader).findAvailable();
            int i = 0;
            while (i < extensions.length) {
                results.add(extensions[i]);
                ++i;
            }
        }
        extensions = new Extension[results.size()];
        return results.toArray(extensions);
    }

    public String[] findRepositories() {
        return this.repositories;
    }

    public Extension[] findRequired() {
        Extension[] extensions;
        ArrayList results = new ArrayList();
        Iterator required = this.required.iterator();
        while (required.hasNext()) {
            results.add(required.next());
        }
        ClassLoader loader = this;
        while ((loader = loader.getParent()) != null) {
            if (!(loader instanceof WebappClassLoader)) continue;
            extensions = ((WebappClassLoader)loader).findRequired();
            int i = 0;
            while (i < extensions.length) {
                results.add(extensions[i]);
                ++i;
            }
        }
        extensions = new Extension[results.size()];
        return results.toArray(extensions);
    }

    public boolean modified() {
        int length2;
        int length;
        if (this.debug >= 2) {
            this.log("modified()");
        }
        if ((length = this.paths.length) > (length2 = this.lastModifiedDates.length)) {
            length = length2;
        }
        int i = 0;
        while (i < length) {
            try {
                long lastModified = ((ResourceAttributes)this.resources.getAttributes(this.paths[i])).getLastModified();
                if (lastModified != this.lastModifiedDates[i]) {
                    this.log("  Resource '" + this.paths[i] + "' was modified; Date is now: " + new Date(lastModified) + " Was: " + new Date(this.lastModifiedDates[i]));
                    return true;
                }
            }
            catch (NamingException e) {
                this.log("    Resource '" + this.paths[i] + "' is missing");
                return true;
            }
            ++i;
        }
        length = this.jarNames.length;
        if (this.getJarPath() != null) {
            try {
                String name;
                NameClassPair ncPair;
                NamingEnumeration<Binding> namingEnumeration = this.resources.listBindings(this.getJarPath());
                int i2 = 0;
                while (namingEnumeration.hasMoreElements() && i2 < length) {
                    ncPair = (NameClassPair)namingEnumeration.nextElement();
                    name = ncPair.getName();
                    if (!name.endsWith(".jar")) continue;
                    if (!name.equals(this.jarNames[i2])) {
                        this.log("    Additional JARs have been added : '" + name + "'");
                        return true;
                    }
                    ++i2;
                }
                if (namingEnumeration.hasMoreElements()) {
                    while (namingEnumeration.hasMoreElements()) {
                        ncPair = (NameClassPair)namingEnumeration.nextElement();
                        name = ncPair.getName();
                        if (!name.endsWith(".jar")) continue;
                        this.log("    Additional JARs have been added");
                        return true;
                    }
                } else if (i2 < this.jarNames.length) {
                    this.log("    Additional JARs have been added");
                    return true;
                }
            }
            catch (NamingException e) {
                if (this.debug > 2) {
                    this.log("    Failed tracking modifications of '" + this.getJarPath() + "'");
                }
            }
            catch (ClassCastException e) {
                this.log("    Failed tracking modifications of '" + this.getJarPath() + "' : " + e.getMessage());
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WebappClassLoader\r\n");
        sb.append("  available:\r\n");
        Iterator available = this.available.iterator();
        while (available.hasNext()) {
            sb.append("    ");
            sb.append(available.next().toString());
            sb.append("\r\n");
        }
        sb.append("  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        sb.append("  repositories:\r\n");
        int i = 0;
        while (i < this.repositories.length) {
            sb.append("    ");
            sb.append(this.repositories[i]);
            sb.append("\r\n");
            ++i;
        }
        sb.append("  required:\r\n");
        Iterator required = this.required.iterator();
        while (required.hasNext()) {
            sb.append("    ");
            sb.append(required.next().toString());
            sb.append("\r\n");
        }
        if (this.parent != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.parent.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public Class findClass(String name) throws ClassNotFoundException {
        int i;
        if (this.debug >= 3) {
            this.log("    findClass(" + name + ")");
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                if (this.debug >= 4) {
                    this.log("      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                if (this.debug >= 4) {
                    this.log("      -->Exception-->ClassNotFoundException", se);
                }
                throw new ClassNotFoundException(name);
            }
        }
        Class<?> clazz = null;
        try {
            if (this.debug >= 4) {
                this.log("      findClassInternal(" + name + ")");
            }
            try {
                clazz = this.findClassInternal(name);
            }
            catch (ClassNotFoundException cnfe) {
                if (!this.hasExternalRepositories) {
                    throw cnfe;
                }
            }
            catch (AccessControlException ace) {
                ace.printStackTrace();
                throw new ClassNotFoundException(name);
            }
            catch (RuntimeException e) {
                if (this.debug >= 4) {
                    this.log("      -->RuntimeException Rethrown", e);
                }
                throw e;
            }
            if (clazz == null && this.hasExternalRepositories) {
                try {
                    clazz = super.findClass(name);
                }
                catch (AccessControlException ace) {
                    throw new ClassNotFoundException(name);
                }
                catch (RuntimeException e) {
                    if (this.debug >= 4) {
                        this.log("      -->RuntimeException Rethrown", e);
                    }
                    throw e;
                }
            }
            if (clazz == null) {
                if (this.debug >= 3) {
                    this.log("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            if (this.debug >= 3) {
                this.log("    --> Passing on ClassNotFoundException", e);
            }
            throw e;
        }
        if (this.debug >= 4) {
            this.log("      Returning class " + clazz);
        }
        if (this.debug >= 4 && clazz != null) {
            this.log("      Loaded by " + clazz.getClassLoader());
        }
        return clazz;
    }

    public URL findResource(String name) {
        if (this.debug >= 3) {
            this.log("    findResource(" + name + ")");
        }
        URL url = null;
        ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
        if (entry == null) {
            if (this.securityManager != null) {
                PrivilegedFindResource dp = new PrivilegedFindResource(name, name);
                entry = (ResourceEntry)AccessController.doPrivileged(dp);
            } else {
                entry = this.findResourceInternal(name, name);
            }
        }
        if (entry != null) {
            url = entry.source;
        }
        if (url == null && this.hasExternalRepositories) {
            url = super.findResource(name);
        }
        if (this.debug >= 3) {
            if (url != null) {
                this.log("    --> Returning '" + url.toString() + "'");
            } else {
                this.log("    --> Resource not found, returning null");
            }
        }
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.debug >= 3) {
            this.log("    findResources(" + name + ")");
        }
        Vector<URL> result = new Vector<URL>();
        int jarFilesLength = this.jarFiles.length;
        int repositoriesLength = this.repositories.length;
        int i = 0;
        while (i < repositoriesLength) {
            try {
                String fullPath = this.repositories[i] + name;
                this.resources.lookup(fullPath);
                try {
                    result.addElement(this.getURL(new File(this.files[i], name)));
                }
                catch (MalformedURLException e) {}
            }
            catch (NamingException e) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < jarFilesLength) {
            JarEntry jarEntry = this.jarFiles[i].getJarEntry(name);
            if (jarEntry != null) {
                try {
                    String jarFakeUrl = this.getURL(this.jarRealFiles[i]).toString();
                    jarFakeUrl = "jar:" + jarFakeUrl + "!/" + name;
                    result.addElement(new URL(jarFakeUrl));
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (this.hasExternalRepositories) {
            Enumeration<URL> otherResourcePaths = super.findResources(name);
            while (otherResourcePaths.hasMoreElements()) {
                result.addElement(otherResourcePaths.nextElement());
            }
        }
        return result.elements();
    }

    public URL getResource(String name) {
        ClassLoader loader;
        if (this.debug >= 2) {
            this.log("getResource(" + name + ")");
        }
        URL url = null;
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning '" + url.toString() + "'");
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        URL url;
        if (this.debug >= 2) {
            this.log("getResourceAsStream(" + name + ")");
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from local");
            }
            stream = this.findLoadedResource(name);
            try {
                if (this.hasExternalRepositories && stream == null) {
                    stream = url.openStream();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (stream != null) {
                return stream;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader loader;
        boolean delegateLoad;
        int i;
        if (this.debug >= 2) {
            this.log("loadClass(" + name + ", " + resolve + ")");
        }
        Class<?> clazz = null;
        if (!this.started) {
            this.log("Lifecycle error : CL stopped");
            throw new ClassNotFoundException(name);
        }
        clazz = this.findLoadedClass0(name);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = this.system.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                System.out.println(error);
                se.printStackTrace();
                this.log(error);
                throw new ClassNotFoundException(error);
            }
        }
        boolean bl = delegateLoad = this.delegate || this.filter(name);
        if (delegateLoad) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (this.debug >= 3) {
                    this.log("  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!delegateLoad) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = (PermissionCollection)this.loaderPC.get(codeUrl);
        if (pc == null && (pc = super.getPermissions(codeSource)) != null) {
            Iterator perms = this.permissionList.iterator();
            while (perms.hasNext()) {
                Permission p = (Permission)perms.next();
                pc.add(p);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    public URL[] getURLs() {
        URL[] external = super.getURLs();
        int filesLength = this.files.length;
        int jarFilesLength = this.jarRealFiles.length;
        int length = filesLength + jarFilesLength + external.length;
        try {
            URL[] urls = new URL[length];
            int i = 0;
            while (i < length) {
                urls[i] = i < filesLength ? this.getURL(this.files[i]) : (i < filesLength + jarFilesLength ? this.getURL(this.jarRealFiles[i - filesLength]) : external[i - filesLength - jarFilesLength]);
                ++i;
            }
            return urls;
        }
        catch (MalformedURLException e) {
            return new URL[0];
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void start() throws LifecycleException {
        this.started = true;
    }

    public void stop() throws LifecycleException {
        this.started = false;
        int length = this.jarFiles.length;
        int i = 0;
        while (i < length) {
            try {
                this.jarFiles[i].close();
                this.jarFiles[i] = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        this.notFoundResources.clear();
        this.resourceEntries.clear();
        this.repositories = new String[0];
        this.files = new File[0];
        this.jarFiles = new JarFile[0];
        this.jarRealFiles = new File[0];
        this.jarPath = null;
        this.jarNames = new String[0];
        this.lastModifiedDates = new long[0];
        this.paths = new String[0];
        this.hasExternalRepositories = false;
        this.required.clear();
        this.permissionList.clear();
        this.loaderPC.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClassInternal(String name) throws ClassNotFoundException {
        if (!this.validate(name)) {
            throw new ClassNotFoundException(name);
        }
        String tempPath = name.replace('.', '/');
        String classPath = tempPath + ".class";
        ResourceEntry entry = null;
        if (this.securityManager != null) {
            PrivilegedFindResource dp = new PrivilegedFindResource(name, classPath);
            entry = (ResourceEntry)AccessController.doPrivileged(dp);
        } else {
            entry = this.findResourceInternal(name, classPath);
        }
        if (entry == null || entry.binaryContent == null) {
            throw new ClassNotFoundException(name);
        }
        Class<?> clazz = entry.loadedClass;
        if (clazz != null) {
            return clazz;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            packageName = name.substring(0, pos);
        }
        Package pkg = null;
        if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
            if (entry.manifest == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            } else {
                this.definePackage(packageName, entry.manifest, entry.codeBase);
            }
        }
        CodeSource codeSource = new CodeSource(entry.codeBase, entry.certificates);
        if (this.securityManager != null && pkg != null) {
            boolean sealCheck = true;
            if (pkg.isSealed()) {
                sealCheck = pkg.isSealed(entry.codeBase);
            } else {
                boolean bl = sealCheck = entry.manifest == null || !this.isPackageSealed(packageName, entry.manifest);
            }
            if (!sealCheck) {
                throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
            }
        }
        if (entry.loadedClass == null) {
            WebappClassLoader webappClassLoader = this;
            synchronized (webappClassLoader) {
                if (entry.loadedClass == null) {
                    entry.loadedClass = clazz = this.defineClass(name, entry.binaryContent, 0, entry.binaryContent.length, codeSource);
                } else {
                    clazz = entry.loadedClass;
                }
            }
        } else {
            clazz = entry.loadedClass;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceEntry findResourceInternal(String name, String path) {
        if (!this.started) {
            this.log("Lifecycle error : CL stopped");
            return null;
        }
        if (name == null || path == null) {
            return null;
        }
        ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
        if (entry != null) {
            return entry;
        }
        int contentLength = -1;
        InputStream binaryStream = null;
        int jarFilesLength = this.jarFiles.length;
        int repositoriesLength = this.repositories.length;
        Resource resource = null;
        int i = 0;
        while (entry == null && i < repositoriesLength) {
            block38: {
                try {
                    String fullPath = this.repositories[i] + path;
                    Object lookupResult = this.resources.lookup(fullPath);
                    if (lookupResult instanceof Resource) {
                        resource = (Resource)lookupResult;
                    }
                    entry = new ResourceEntry();
                    try {
                        entry.codeBase = entry.source = this.getURL(new File(this.files[i], path));
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                    ResourceAttributes attributes = (ResourceAttributes)this.resources.getAttributes(fullPath);
                    contentLength = (int)attributes.getContentLength();
                    entry.lastModified = attributes.getLastModified();
                    if (resource == null) break block38;
                    try {
                        binaryStream = resource.streamContent();
                    }
                    catch (IOException e) {
                        return null;
                    }
                    Permission e = this.allPermission;
                    synchronized (e) {
                        long[] result2 = new long[this.lastModifiedDates.length + 1];
                        int j = 0;
                        while (j < this.lastModifiedDates.length) {
                            result2[j] = this.lastModifiedDates[j];
                            ++j;
                        }
                        result2[this.lastModifiedDates.length] = entry.lastModified;
                        this.lastModifiedDates = result2;
                        String[] result = new String[this.paths.length + 1];
                        j = 0;
                        while (j < this.paths.length) {
                            result[j] = this.paths[j];
                            ++j;
                        }
                        result[this.paths.length] = fullPath;
                        this.paths = result;
                    }
                }
                catch (NamingException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (entry == null && this.notFoundResources.containsKey(name)) {
            return null;
        }
        JarEntry jarEntry = null;
        i = 0;
        while (entry == null && i < jarFilesLength) {
            jarEntry = this.jarFiles[i].getJarEntry(path);
            if (jarEntry != null) {
                entry = new ResourceEntry();
                try {
                    entry.codeBase = this.getURL(this.jarRealFiles[i]);
                    String jarFakeUrl = entry.codeBase.toString();
                    jarFakeUrl = "jar:" + jarFakeUrl + "!/" + path;
                    entry.source = new URL(jarFakeUrl);
                }
                catch (MalformedURLException e) {
                    return null;
                }
                contentLength = (int)jarEntry.getSize();
                try {
                    entry.manifest = this.jarFiles[i].getManifest();
                    binaryStream = this.jarFiles[i].getInputStream(jarEntry);
                }
                catch (IOException e) {
                    return null;
                }
            }
            ++i;
        }
        if (entry == null) {
            HashMap e = this.notFoundResources;
            synchronized (e) {
                this.notFoundResources.put(name, name);
            }
            return null;
        }
        if (binaryStream != null) {
            byte[] binaryContent = new byte[contentLength];
            try {
                int n;
                int pos = 0;
                while ((n = binaryStream.read(binaryContent, pos, binaryContent.length - pos)) > 0) {
                    pos += n;
                }
                binaryStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            entry.binaryContent = binaryContent;
            if (jarEntry != null) {
                entry.certificates = jarEntry.getCertificates();
            }
        }
        HashMap hashMap = this.resourceEntries;
        synchronized (hashMap) {
            ResourceEntry entry2 = (ResourceEntry)this.resourceEntries.get(name);
            if (entry2 == null) {
                this.resourceEntries.put(name, entry);
            } else {
                entry = entry2;
            }
        }
        return entry;
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = name + "/";
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected InputStream findLoadedResource(String name) {
        ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
        if (entry != null && entry.binaryContent != null) {
            return new ByteArrayInputStream(entry.binaryContent);
        }
        return null;
    }

    protected Class findLoadedClass0(String name) {
        ResourceEntry entry = (ResourceEntry)this.resourceEntries.get(name);
        if (entry != null) {
            return entry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String name) {
        if (name == null) {
            return false;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        packageName = name.substring(0, pos);
        int i = 0;
        while (i < packageTriggers.length) {
            if (packageName.startsWith(packageTriggers[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean validate(String name) {
        if (name == null) {
            return false;
        }
        return !name.startsWith("java.");
    }

    private boolean validateJarFile(File jarfile) throws IOException {
        if (triggers == null) {
            return true;
        }
        JarFile jarFile = new JarFile(jarfile);
        int i = 0;
        while (i < triggers.length) {
            Class<?> clazz = null;
            try {
                clazz = this.parent != null ? this.parent.loadClass(triggers[i]) : Class.forName(triggers[i]);
            }
            catch (Throwable t) {
                clazz = null;
            }
            if (clazz != null) {
                JarEntry jarEntry;
                String name = triggers[i].replace('.', '/') + ".class";
                if (this.debug >= 2) {
                    this.log(" Checking for " + name);
                }
                if ((jarEntry = jarFile.getJarEntry(name)) != null) {
                    this.log("validateJarFile(" + jarfile + ") - jar not loaded. See Servlet Spec 2.3, " + "section 9.7.2. Offending class: " + name);
                    jarFile.close();
                    return false;
                }
            }
            ++i;
        }
        jarFile.close();
        return true;
    }

    protected URL getURL(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return realFile.toURL();
    }

    private void log(String message) {
        System.out.println("WebappClassLoader: " + message);
    }

    private void log(String message, Throwable throwable) {
        System.out.println("WebappClassLoader: " + message);
        throwable.printStackTrace(System.out);
    }

    protected class PrivilegedFindResource
    implements PrivilegedAction {
        private String name;
        private String path;

        PrivilegedFindResource(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public Object run() {
            return WebappClassLoader.this.findResourceInternal(this.name, this.path);
        }
    }
}

