/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.jar.JarFile;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.loader.Extension;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.naming.resources.Resource;

public class WebappLoader
implements Lifecycle,
Loader,
PropertyChangeListener,
Runnable {
    private int checkInterval = 15;
    private WebappClassLoader classLoader = null;
    private Container container = null;
    private int debug = 0;
    protected DefaultContext defaultContext = null;
    private boolean delegate = false;
    private static final String info = "org.apache.catalina.loader.WebappLoader/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String loaderClass = "org.apache.catalina.loader.WebappClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    private String[] repositories = new String[0];
    protected static final StringManager sm;
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "WebappLoader";
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int checkInterval) {
        int oldCheckInterval = this.checkInterval;
        this.checkInterval = checkInterval;
        this.support.firePropertyChange("checkInterval", new Integer(oldCheckInterval), new Integer(this.checkInterval));
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", new Integer(oldDebug), new Integer(this.debug));
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", new Boolean(oldDelegate), new Boolean(this.delegate));
    }

    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String loaderClass) {
        this.loaderClass = loaderClass;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", new Boolean(oldReloadable), new Boolean(this.reloadable));
        if (!this.started) {
            return;
        }
        if (!oldReloadable && this.reloadable) {
            this.threadStart();
        } else if (oldReloadable && !this.reloadable) {
            this.threadStop();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addRepository(String repository) {
        if (this.debug >= 1) {
            this.log(sm.getString("webappLoader.addRepository", repository));
        }
        int i = 0;
        while (i < this.repositories.length) {
            if (repository.equals(this.repositories[i])) {
                return;
            }
            ++i;
        }
        String[] results = new String[this.repositories.length + 1];
        int i2 = 0;
        while (i2 < this.repositories.length) {
            results[i2] = this.repositories[i2];
            ++i2;
        }
        results[this.repositories.length] = repository;
        this.repositories = results;
        if (this.started && this.classLoader != null) {
            this.classLoader.addRepository(repository);
            this.setClassPath();
        }
    }

    public String[] findRepositories() {
        return this.repositories;
    }

    public boolean modified() {
        return this.classLoader.modified();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WebappLoader[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("webappLoader.alreadyStarted"));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("webappLoader.starting"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container.getResources() == null) {
            return;
        }
        DirContextURLStreamHandlerFactory streamHandlerFactory = new DirContextURLStreamHandlerFactory();
        try {
            URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)streamHandlerFactory);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.setResources(this.container.getResources());
            this.classLoader.setDebug(this.debug);
            this.classLoader.setDelegate(this.delegate);
            int i = 0;
            while (i < this.repositories.length) {
                this.classLoader.addRepository(this.repositories[i]);
                ++i;
            }
            this.setRepositories();
            this.setClassPath();
            this.setPermissions();
            if (this.classLoader instanceof Lifecycle) {
                this.classLoader.start();
            }
            DirContextURLStreamHandler.bind((ClassLoader)this.classLoader, (DirContext)this.container.getResources());
        }
        catch (Throwable t) {
            throw new LifecycleException("start: ", t);
        }
        this.validatePackages();
        if (this.reloadable) {
            this.log(sm.getString("webappLoader.reloading"));
            try {
                this.threadStart();
            }
            catch (IllegalStateException e) {
                throw new LifecycleException(e);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("webappLoader.notStarted"));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("webappLoader.stopping"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.reloadable) {
            this.threadStop();
        }
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        if (this.classLoader instanceof Lifecycle) {
            this.classLoader.stop();
        }
        DirContextURLStreamHandler.unbind((ClassLoader)this.classLoader);
        this.classLoader = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)event.getSource();
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException e) {
                this.log(sm.getString("webappLoader.reloadable", event.getNewValue().toString()));
            }
        }
    }

    private WebappClassLoader createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoader classLoader = null;
        if (this.parentClassLoader == null) {
            classLoader = (WebappClassLoader)clazz.newInstance();
        } else {
            Class[] argTypes = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = WebappLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
            Object[] args = new Object[]{this.parentClassLoader};
            Constructor<?> constr = clazz.getConstructor(argTypes);
            classLoader = (WebappClassLoader)constr.newInstance(args);
        }
        return classLoader;
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("WebappLoader[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("WebappLoader[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("WebappLoader[" + this.container.getName() + "] " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("WebappLoader[" + containerName + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void notifyContext() {
        WebappContextNotifier notifier = new WebappContextNotifier();
        new Thread(notifier).start();
    }

    private void setPermissions() {
        block21: {
            if (System.getSecurityManager() == null) {
                return;
            }
            if (!(this.container instanceof Context)) {
                return;
            }
            ServletContext servletContext = ((Context)this.container).getServletContext();
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (workDir != null) {
                try {
                    String workDirPath = workDir.getCanonicalPath();
                    this.classLoader.addPermission(new FilePermission(workDirPath, "read,write"));
                    this.classLoader.addPermission(new FilePermission(workDirPath + File.separator + "-", "read,write,delete"));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                String path;
                URL libURL;
                URL classesURL;
                URL rootURL = servletContext.getResource("/");
                this.classLoader.addPermission(rootURL);
                String contextRoot = servletContext.getRealPath("/");
                if (contextRoot != null) {
                    try {
                        contextRoot = new File(contextRoot).getCanonicalPath() + File.separator;
                        this.classLoader.addPermission(contextRoot);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if ((classesURL = servletContext.getResource("/WEB-INF/classes/")) != null) {
                    this.classLoader.addPermission(classesURL);
                }
                if ((libURL = servletContext.getResource("/WEB-INF/lib/")) != null) {
                    this.classLoader.addPermission(libURL);
                }
                if (contextRoot != null) {
                    if (libURL == null) break block21;
                    File rootDir = new File(contextRoot);
                    File libDir = new File(rootDir, "WEB-INF/lib/");
                    String path2 = null;
                    try {
                        path2 = libDir.getCanonicalPath() + File.separator;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (path2 != null) {
                        this.classLoader.addPermission(path2);
                    }
                    break block21;
                }
                if (workDir == null) break block21;
                if (libURL != null) {
                    File libDir = new File(workDir, "WEB-INF/lib/");
                    path = null;
                    try {
                        path = libDir.getCanonicalPath() + File.separator;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.classLoader.addPermission(path);
                }
                if (classesURL == null) break block21;
                File classesDir = new File(workDir, "WEB-INF/classes/");
                path = null;
                try {
                    path = classesDir.getCanonicalPath() + File.separator;
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.classLoader.addPermission(path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private void setRepositories() {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (workDir == null) {
            return;
        }
        this.log(sm.getString("webappLoader.deploy", workDir.getAbsolutePath()));
        DirContext resources = this.container.getResources();
        String classesPath = "/WEB-INF/classes";
        DirContext classes = null;
        try {
            Object object = resources.lookup(classesPath);
            if (object instanceof DirContext) {
                classes = (DirContext)object;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (classes != null) {
            File classRepository = null;
            String absoluteClassesPath = servletContext.getRealPath(classesPath);
            if (absoluteClassesPath != null) {
                classRepository = new File(absoluteClassesPath);
            } else {
                classRepository = new File(workDir, classesPath);
                classRepository.mkdirs();
                this.copyDir(classes, classRepository);
            }
            this.log(sm.getString("webappLoader.classDeploy", classesPath, classRepository.getAbsolutePath()));
            this.classLoader.addRepository(classesPath + "/", classRepository);
        }
        String libPath = "/WEB-INF/lib";
        this.classLoader.setJarPath(libPath);
        DirContext libDir = null;
        try {
            Object object = resources.lookup(libPath);
            if (object instanceof DirContext) {
                libDir = (DirContext)object;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (libDir != null) {
            boolean copyJars = false;
            String absoluteLibPath = servletContext.getRealPath(libPath);
            File destDir = null;
            if (absoluteLibPath != null) {
                destDir = new File(absoluteLibPath);
            } else {
                copyJars = true;
                destDir = new File(workDir, libPath);
                destDir.mkdirs();
            }
            try {
                NamingEnumeration<Binding> namingEnumeration = resources.listBindings(libPath);
                while (namingEnumeration.hasMoreElements()) {
                    Binding binding = (Binding)namingEnumeration.nextElement();
                    String filename = libPath + "/" + binding.getName();
                    if (!filename.endsWith(".jar")) continue;
                    File destFile = new File(destDir, binding.getName());
                    this.log(sm.getString("webappLoader.jarDeploy", filename, destFile.getAbsolutePath()));
                    Resource jarResource = (Resource)binding.getObject();
                    if (copyJars && !this.copy(jarResource.streamContent(), new FileOutputStream(destFile))) continue;
                    JarFile jarFile = new JarFile(destFile);
                    this.classLoader.addJar(filename, jarFile, destFile);
                }
            }
            catch (NamingException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setClassPath() {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        StringBuffer classpath = new StringBuffer();
        ClassLoader loader = this.getClassLoader();
        int layers = 0;
        int n = 0;
        while (layers < 3 && loader != null) {
            if (!(loader instanceof URLClassLoader)) break;
            URL[] repositories = ((URLClassLoader)loader).getURLs();
            int i = 0;
            while (i < repositories.length) {
                block12: {
                    String repository;
                    block10: {
                        block11: {
                            block9: {
                                repository = repositories[i].toString();
                                if (!repository.startsWith("file://")) break block9;
                                repository = repository.substring(7);
                                break block10;
                            }
                            if (!repository.startsWith("file:")) break block11;
                            repository = repository.substring(5);
                            break block10;
                        }
                        if (!repository.startsWith("jndi:")) break block12;
                        repository = servletContext.getRealPath(repository.substring(5));
                    }
                    if (repository != null) {
                        if (n > 0) {
                            classpath.append(File.pathSeparator);
                        }
                        classpath.append(repository);
                        ++n;
                    }
                }
                ++i;
            }
            loader = loader.getParent();
            ++layers;
        }
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)classpath.toString());
    }

    private boolean copyDir(DirContext srcDir, File destDir) {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = srcDir.list("");
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)namingEnumeration.nextElement();
                String name = ncPair.getName();
                Object object = srcDir.lookup(name);
                File currentFile = new File(destDir, name);
                if (object instanceof Resource) {
                    FileOutputStream os;
                    InputStream is = ((Resource)object).streamContent();
                    if (this.copy(is, os = new FileOutputStream(currentFile))) continue;
                    return false;
                }
                if (object instanceof InputStream) {
                    FileOutputStream os = new FileOutputStream(currentFile);
                    if (this.copy((InputStream)object, os)) continue;
                    return false;
                }
                if (!(object instanceof DirContext)) continue;
                currentFile.mkdir();
                this.copyDir((DirContext)object, currentFile);
            }
        }
        catch (NamingException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean copy(InputStream is, OutputStream os) {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (!this.reloadable) {
            throw new IllegalStateException(sm.getString("webappLoader.notReloadable"));
        }
        if (!(this.container instanceof Context)) {
            throw new IllegalStateException(sm.getString("webappLoader.notContext"));
        }
        if (this.debug >= 1) {
            this.log(" Starting background thread");
        }
        this.threadDone = false;
        this.threadName = "WebappLoader[" + this.container.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(" Stopping background thread");
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    private void validatePackages() throws LifecycleException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader instanceof WebappClassLoader) {
            Extension[] available = ((WebappClassLoader)classLoader).findAvailable();
            Extension[] required = ((WebappClassLoader)classLoader).findRequired();
            if (this.debug >= 1) {
                this.log("Optional Packages:  available=" + available.length + ", required=" + required.length);
            }
            int i = 0;
            while (i < required.length) {
                if (this.debug >= 1) {
                    this.log("Checking for required package " + required[i]);
                }
                boolean found = false;
                int j = 0;
                while (j < available.length) {
                    if (available[j].isCompatibleWith(required[i])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    throw new LifecycleException("Missing optional package " + required[i]);
                }
                ++i;
            }
        }
    }

    public void run() {
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Starting");
        }
        while (!this.threadDone) {
            block6: {
                this.threadSleep();
                if (!this.started) break;
                try {
                    if (!this.classLoader.modified()) {
                    }
                    break block6;
                }
                catch (Exception e) {
                    this.log(sm.getString("webappLoader.failModifiedCheck"), e);
                }
                continue;
            }
            this.notifyContext();
            break;
        }
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Stopping");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        info = info;
        sm = StringManager.getManager("org.apache.catalina.loader");
    }

    protected class WebappContextNotifier
    implements Runnable {
        protected WebappContextNotifier() {
        }

        public void run() {
            ((Context)WebappLoader.this.container).reload();
        }
    }
}

