/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.net;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLServerSocket;
import org.apache.catalina.net.ServerSocketFactory;

public class SSLServerSocketFactory
implements ServerSocketFactory {
    private static final String PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    private static final String PROTOCOL_PACKAGES = "java.protocol.handler.pkgs";
    private javax.net.ssl.SSLServerSocketFactory sslProxy = null;
    private String algorithm = "SunX509";
    private boolean clientAuth = false;
    private KeyStore keyStore = null;
    private String keystoreFile = System.getProperty("user.home") + File.separator + ".keystore";
    private String keystorePass = "changeit";
    private String keystoreType = "JKS";
    private String protocol = "TLS";

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public boolean getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public KeyStore getKeyStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (this.sslProxy == null) {
            this.initialize();
        }
        return this.keyStore;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        File file = new File(keystoreFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), keystoreFile);
        }
        this.keystoreFile = file.getAbsolutePath();
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public ServerSocket createSocket(int port) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (this.sslProxy == null) {
            this.initialize();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (this.sslProxy == null) {
            this.initialize();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (this.sslProxy == null) {
            this.initialize();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    private synchronized void initialize() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        this.initHandler();
        this.initKeyStore();
        this.initProxy();
    }

    private void initHandler() {
        String packages = System.getProperty(PROTOCOL_PACKAGES);
        if (packages == null) {
            packages = PROTOCOL_HANDLER;
        } else if (packages.indexOf(PROTOCOL_HANDLER) < 0) {
            packages = packages + "|com.sun.net.ssl.internal.www.protocol";
        }
        System.setProperty(PROTOCOL_PACKAGES, packages);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initKeyStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        FileInputStream istream = null;
        try {
            try {
                this.keyStore = KeyStore.getInstance(this.keystoreType);
                istream = new FileInputStream(this.keystoreFile);
                this.keyStore.load(istream, this.keystorePass.toCharArray());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (KeyStoreException kse) {
                throw kse;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw nsae;
            }
            catch (CertificateException ce) {
                throw ce;
            }
            Object var7_2 = null;
            if (istream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_3 = null;
            if (istream == null) throw throwable;
            istream.close();
            throw throwable;
        }
        istream.close();
    }

    private void initProxy() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        try {
            Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
        }
        catch (Throwable t) {
            // empty catch block
        }
        SSLContext context = SSLContext.getInstance((String)this.protocol);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)this.algorithm);
        keyManagerFactory.init(this.keyStore, this.keystorePass.toCharArray());
        context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        this.sslProxy = context.getServerSocketFactory();
    }

    private void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        String[] cipherSuites = socket.getSupportedCipherSuites();
        socket.setEnabledCipherSuites(cipherSuites);
        socket.setNeedClientAuth(this.clientAuth);
    }

    static {
        PROTOCOL_HANDLER = PROTOCOL_HANDLER;
        PROTOCOL_PACKAGES = PROTOCOL_PACKAGES;
    }
}

