/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.ResourceAttributes;

public class HostConfig
implements LifecycleListener,
Runnable {
    protected String configClass = "org.apache.catalina.startup.ContextConfig";
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected int debug = 0;
    protected ArrayList deployed = new ArrayList();
    protected Host host = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private int checkInterval = 15;
    private boolean deployXML = false;
    private boolean liveDeploy = false;
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "HostConfig";
    private boolean unpackWARs = false;
    private HashMap webXmlLastModified = new HashMap();

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean isLiveDeploy() {
        return this.liveDeploy;
    }

    public void setLiveDeploy(boolean liveDeploy) {
        this.liveDeploy = liveDeploy;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.host = (Host)((Object)event.getLifecycle());
            if (this.host instanceof StandardHost) {
                int hostDebug = ((StandardHost)this.host).getDebug();
                if (hostDebug > this.debug) {
                    this.debug = hostDebug;
                }
                this.setDeployXML(((StandardHost)this.host).isDeployXML());
                this.setLiveDeploy(((StandardHost)this.host).getLiveDeploy());
                this.setUnpackWARs(((StandardHost)this.host).isUnpackWARs());
            }
        }
        catch (ClassCastException e) {
            this.log(sm.getString("hostConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected File appBase() {
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        return file;
    }

    protected void deployApps() {
        File appBase;
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.deploying"));
        }
        if (!(appBase = this.appBase()).exists() || !appBase.isDirectory()) {
            return;
        }
        String[] files = appBase.list();
        this.deployDescriptors(appBase, files);
        this.deployWARs(appBase, files);
        this.deployDirectories(appBase, files);
    }

    protected void deployDescriptors(File appBase, String[] files) {
        if (!this.deployXML) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (!(files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i]))) {
                File dir = new File(appBase, files[i]);
                if (files[i].toLowerCase().endsWith(".xml")) {
                    this.deployed.add(files[i]);
                    String file = files[i].substring(0, files[i].length() - 4);
                    String contextPath = "/" + file;
                    if (file.equals("ROOT")) {
                        contextPath = "";
                    }
                    if (this.host.findChild(contextPath) == null) {
                        this.log(sm.getString("hostConfig.deployDescriptor", files[i]));
                        try {
                            URL config = new URL("file", null, dir.getCanonicalPath());
                            ((Deployer)((Object)this.host)).install(config, null);
                        }
                        catch (Throwable t) {
                            this.log(sm.getString("hostConfig.deployDescriptor.error", files[i]), t);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void deployWARs(File appBase, String[] files) {
        int i = 0;
        while (i < files.length) {
            if (!(files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i]))) {
                File dir = new File(appBase, files[i]);
                if (files[i].toLowerCase().endsWith(".war")) {
                    this.deployed.add(files[i]);
                    String contextPath = "/" + files[i];
                    int period = contextPath.lastIndexOf(".");
                    if (period >= 0) {
                        contextPath = contextPath.substring(0, period);
                    }
                    if (contextPath.equals("/ROOT")) {
                        contextPath = "";
                    }
                    if (this.host.findChild(contextPath) == null) {
                        URL url;
                        if (this.isUnpackWARs()) {
                            this.log(sm.getString("hostConfig.expand", files[i]));
                            try {
                                url = new URL("jar:file:" + dir.getCanonicalPath() + "!/");
                                String path = this.expand(url);
                                url = new URL("file:" + path);
                                ((Deployer)((Object)this.host)).install(contextPath, url);
                            }
                            catch (Throwable t) {
                                this.log(sm.getString("hostConfig.expand.error", files[i]), t);
                            }
                        } else {
                            this.log(sm.getString("hostConfig.deployJar", files[i]));
                            try {
                                url = new URL("file", null, dir.getCanonicalPath());
                                url = new URL("jar:" + url.toString() + "!/");
                                ((Deployer)((Object)this.host)).install(contextPath, url);
                            }
                            catch (Throwable t) {
                                this.log(sm.getString("hostConfig.deployJar.error", files[i]), t);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void deployDirectories(File appBase, String[] files) {
        int i = 0;
        while (i < files.length) {
            File dir;
            if (!files[i].equalsIgnoreCase("META-INF") && !files[i].equalsIgnoreCase("WEB-INF") && !this.deployed.contains(files[i]) && (dir = new File(appBase, files[i])).isDirectory()) {
                this.deployed.add(files[i]);
                File webInf = new File(dir, "/WEB-INF");
                if (webInf.exists() && webInf.isDirectory() && webInf.canRead()) {
                    String contextPath = "/" + files[i];
                    if (files[i].equals("ROOT")) {
                        contextPath = "";
                    }
                    if (this.host.findChild(contextPath) == null) {
                        this.log(sm.getString("hostConfig.deployDir", files[i]));
                        try {
                            URL url = new URL("file", null, dir.getCanonicalPath());
                            ((Deployer)((Object)this.host)).install(contextPath, url);
                        }
                        catch (Throwable t) {
                            this.log(sm.getString("hostConfig.deployDir.error", files[i]), t);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void checkWebXmlLastModified() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        Deployer deployer = (Deployer)((Object)this.host);
        String[] contextNames = deployer.findDeployedApps();
        int i = 0;
        while (i < contextNames.length) {
            String contextName = contextNames[i];
            Context context = deployer.findDeployedApp(contextName);
            if (context instanceof Lifecycle) {
                try {
                    DirContext resources = context.getResources();
                    if (resources != null) {
                        ResourceAttributes webXmlAttributes = (ResourceAttributes)resources.getAttributes("/WEB-INF/web.xml");
                        long newLastModified = webXmlAttributes.getLastModified();
                        Long lastModified = (Long)this.webXmlLastModified.get(contextName);
                        if (lastModified == null) {
                            this.webXmlLastModified.put(contextName, new Long(newLastModified));
                        } else if (lastModified != newLastModified) {
                            this.webXmlLastModified.remove(contextName);
                            ((Lifecycle)((Object)context)).stop();
                            ((Lifecycle)((Object)context)).start();
                        }
                    }
                }
                catch (LifecycleException e) {
                }
                catch (NamingException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String expand(URL war) throws IOException {
        File docBase;
        block29: {
            Throwable t22;
            JarFile jarFile;
            block26: {
                File appBase;
                int slash;
                int period;
                String pathname;
                if (this.getDebug() >= 1) {
                    this.log("expand(" + war.toString() + ")");
                }
                if ((pathname = war.toString().replace('\\', '/')).endsWith("!/")) {
                    pathname = pathname.substring(0, pathname.length() - 2);
                }
                if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
                    pathname = pathname.substring(0, period);
                }
                if ((slash = pathname.lastIndexOf(47)) >= 0) {
                    pathname = pathname.substring(slash + 1);
                }
                if (this.getDebug() >= 1) {
                    this.log("  Proposed directory name: " + pathname);
                }
                if (!(appBase = new File(this.host.getAppBase())).isAbsolute()) {
                    appBase = new File(System.getProperty("catalina.base"), this.host.getAppBase());
                }
                if (!appBase.exists() || !appBase.isDirectory()) {
                    throw new IOException(sm.getString("standardHost.appBase", appBase.getAbsolutePath()));
                }
                docBase = new File(appBase, pathname);
                if (docBase.exists()) {
                    return docBase.getAbsolutePath();
                }
                docBase.mkdir();
                if (this.getDebug() >= 2) {
                    this.log("  Have created expansion directory " + docBase.getAbsolutePath());
                }
                JarURLConnection juc = (JarURLConnection)war.openConnection();
                juc.setUseCaches(false);
                jarFile = null;
                InputStream input = null;
                try {
                    jarFile = juc.getJarFile();
                    if (this.getDebug() >= 2) {
                        this.log("  Have opened JAR file successfully");
                    }
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    if (this.getDebug() >= 2) {
                        this.log("  Have retrieved entries enumeration");
                    }
                    while (jarEntries.hasMoreElements()) {
                        int last;
                        JarEntry jarEntry = jarEntries.nextElement();
                        String name = jarEntry.getName();
                        if (this.getDebug() >= 2) {
                            this.log("  Am processing entry " + name);
                        }
                        if ((last = name.lastIndexOf(47)) >= 0) {
                            File parent = new File(docBase, name.substring(0, last));
                            if (this.getDebug() >= 2) {
                                this.log("  Creating parent directory " + parent);
                            }
                            parent.mkdirs();
                        }
                        if (name.endsWith("/")) continue;
                        if (this.getDebug() >= 2) {
                            this.log("  Creating expanded file " + name);
                        }
                        input = jarFile.getInputStream(jarEntry);
                        this.expand(input, docBase, name);
                        input.close();
                        input = null;
                    }
                    jarFile.close();
                    jarFile = null;
                    Object var16_15 = null;
                    if (input == null) break block26;
                }
                catch (Throwable throwable) {
                    Throwable t22;
                    Object var16_16 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable t22) {
                            // empty catch block
                        }
                        input = null;
                    }
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable t22) {
                            // empty catch block
                        }
                        jarFile = null;
                    }
                    throw throwable;
                }
                try {
                    input.close();
                }
                catch (Throwable t22) {
                    // empty catch block
                }
                input = null;
            }
            if (jarFile == null) break block29;
            try {
                jarFile.close();
            }
            catch (Throwable t22) {
                // empty catch block
            }
            jarFile = null;
            {
            }
        }
        return docBase.getAbsolutePath();
    }

    protected void expand(InputStream input, File docBase, String name) throws IOException {
        int n;
        File file = new File(docBase, name);
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        byte[] buffer = new byte[2048];
        while ((n = input.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
        output.close();
    }

    protected void log(String message) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "]: " + message);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("HostConfig[" + this.host.getName() + "] " + message, throwable);
        } else {
            System.out.println("HostConfig[" + this.host.getName() + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    protected void start() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.start"));
        }
        if (this.host.getAutoDeploy()) {
            this.deployApps();
        }
        if (this.isLiveDeploy()) {
            this.threadStart();
        }
    }

    protected void stop() {
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.stop"));
        }
        this.threadStop();
        this.undeployApps();
    }

    protected void undeployApps() {
        if (!(this.host instanceof Deployer)) {
            return;
        }
        if (this.debug >= 1) {
            this.log(sm.getString("hostConfig.undeploying"));
        }
        String[] contextPaths = ((Deployer)((Object)this.host)).findDeployedApps();
        int i = 0;
        while (i < contextPaths.length) {
            if (this.debug >= 1) {
                this.log(sm.getString("hostConfig.undeploy", contextPaths[i]));
            }
            try {
                ((Deployer)((Object)this.host)).remove(contextPaths[i]);
            }
            catch (Throwable t) {
                this.log(sm.getString("hostConfig.undeploy.error", contextPaths[i]), t);
            }
            ++i;
        }
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(" Starting background thread");
        }
        this.threadDone = false;
        this.threadName = "HostConfig[" + this.host.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(" Stopping background thread");
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Starting");
        }
        while (!this.threadDone) {
            this.threadSleep();
            this.deployApps();
            this.checkWebXmlLastModified();
        }
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Stopping");
        }
    }
}

