/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.AbstractUser;
import org.apache.catalina.users.MemoryUserDatabase;

public class MemoryUser
extends AbstractUser {
    protected MemoryUserDatabase database = null;
    protected ArrayList groups = new ArrayList();
    protected ArrayList roles = new ArrayList();

    MemoryUser(MemoryUserDatabase database, String username, String password, String fullName) {
        this.database = database;
        this.setUsername(username);
        this.setPassword(password);
        this.setFullName(fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGroups() {
        ArrayList arrayList = this.groups;
        synchronized (arrayList) {
            Iterator iterator = this.groups.iterator();
            return iterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getRoles() {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            Iterator iterator = this.roles.iterator();
            return iterator;
        }
    }

    public UserDatabase getUserDatabase() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(Group group) {
        ArrayList arrayList = this.groups;
        synchronized (arrayList) {
            if (!this.groups.contains(group)) {
                this.groups.add(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRole(Role role) {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            if (!this.roles.contains(role)) {
                this.roles.add(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInGroup(Group group) {
        ArrayList arrayList = this.groups;
        synchronized (arrayList) {
            boolean bl = this.groups.contains(group);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInRole(Role role) {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            boolean bl = this.roles.contains(role);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(Group group) {
        ArrayList arrayList = this.groups;
        synchronized (arrayList) {
            this.groups.remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroups() {
        ArrayList arrayList = this.groups;
        synchronized (arrayList) {
            this.groups.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRole(Role role) {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.remove(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoles() {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer("<user username=\"");
        sb.append(this.username);
        sb.append("\" password=\"");
        sb.append(this.password);
        sb.append("\"");
        if (this.fullName != null) {
            sb.append(" fullName=\"");
            sb.append(this.fullName);
            sb.append("\"");
        }
        ArrayList arrayList = this.groups;
        synchronized (arrayList) {
            if (this.groups.size() > 0) {
                sb.append(" groups=\"");
                int n = 0;
                Iterator values = this.groups.iterator();
                while (values.hasNext()) {
                    if (n > 0) {
                        sb.append(',');
                    }
                    ++n;
                    sb.append(((Group)values.next()).getGroupname());
                }
                sb.append("\"");
            }
        }
        ArrayList arrayList2 = this.roles;
        synchronized (arrayList2) {
            if (this.roles.size() > 0) {
                sb.append(" roles=\"");
                int n = 0;
                Iterator values = this.roles.iterator();
                while (values.hasNext()) {
                    if (n > 0) {
                        sb.append(',');
                    }
                    ++n;
                    sb.append(((Role)values.next()).getRolename());
                }
                sb.append("\"");
            }
        }
        sb.append("/>");
        return sb.toString();
    }
}

