/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Constructor;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanConstructorInfo
extends MBeanFeatureInfo {
    private static final long serialVersionUID = 4433990064191844427L;
    private MBeanParameterInfo[] signature;

    public MBeanConstructorInfo(String description, Constructor constructor) {
        super(constructor.getName(), description);
        Class<?>[] params = constructor.getParameterTypes();
        this.signature = new MBeanParameterInfo[params.length];
        int i = 0;
        while (i < params.length) {
            this.signature[i] = new MBeanParameterInfo("", params[i].getName(), "");
            ++i;
        }
    }

    public MBeanConstructorInfo(String name, String description, MBeanParameterInfo[] signature) {
        super(name, description);
        this.signature = signature == null ? new MBeanParameterInfo[]{} : signature;
    }

    public MBeanParameterInfo[] getSignature() {
        return this.signature;
    }

    public int hashCode() {
        int hash = super.hashCode();
        MBeanParameterInfo[] signature = this.getSignature();
        int i = 0;
        while (i < signature.length) {
            MBeanParameterInfo param = signature[i];
            hash ^= param == null ? 0 : param.hashCode();
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        try {
            MBeanConstructorInfo other = (MBeanConstructorInfo)obj;
            MBeanParameterInfo[] signature = this.getSignature();
            MBeanParameterInfo[] otherSignature = other.getSignature();
            if (signature.length != otherSignature.length) {
                return false;
            }
            int i = 0;
            while (i < signature.length) {
                MBeanParameterInfo param = signature[i];
                MBeanParameterInfo otherParam = otherSignature[i];
                if (param != null && !param.equals(otherParam)) {
                    return false;
                }
                if (param == null && otherParam != null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }
}

