/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.RuntimeOperationsException;
import mx4j.log.Log;
import mx4j.log.Logger;

public class NotificationBroadcasterSupport
implements NotificationBroadcaster {
    private static final NotificationFilter NULL_FILTER = new NotificationFilter(){

        public boolean isNotificationEnabled(Notification notification) {
            return true;
        }

        public String toString() {
            return "null filter";
        }
    };
    private static final Object NULL_HANDBACK = new Object(){

        public String toString() {
            return "null handback";
        }
    };
    private Map m_filters = new HashMap();
    private Map m_handbacks = new HashMap();
    private Logger m_logger;

    private Logger getLogger() {
        return Log.getLogger("jmx.mbean." + this.getClass().getName());
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Adding notification listener: " + listener + ", filter: " + filter + ", handback: " + handback);
        }
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification listener cannot be null"));
        }
        if (filter == null) {
            filter = NULL_FILTER;
        }
        if (handback == null) {
            handback = NULL_HANDBACK;
        }
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            ArrayList<NotificationFilter> filts = (ArrayList<NotificationFilter>)this.m_filters.get(listener);
            ArrayList<Object> hands = (ArrayList<Object>)this.m_handbacks.get(listener);
            if (filts == null) {
                filts = new ArrayList<NotificationFilter>();
                this.m_filters.put(listener, filts);
                hands = new ArrayList<Object>();
                this.m_handbacks.put(listener, hands);
                filts.add(filter);
                hands.add(handback);
            } else {
                int i = 0;
                while (i < filts.size()) {
                    if (filts.get(i).equals(filter) && hands.get(i).equals(handback)) {
                        throw new RuntimeOperationsException(new IllegalArgumentException("Notification listener is already registered"));
                    }
                    ++i;
                }
                filts.add(filter);
                hands.add(handback);
            }
            if (logger.isEnabledFor(10)) {
                logger.debug("Filters for this listener: " + filts);
                logger.debug("Handbacks for this listener: " + hands);
            }
            if (logger.isEnabledFor(20)) {
                logger.info("Notification listener added successfully");
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Removing notification listener: " + listener);
        }
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            List filts = (List)this.m_filters.remove(listener);
            this.m_handbacks.remove(listener);
            if (filts == null) {
                throw new ListenerNotFoundException("Notification listener not found");
            }
            if (logger.isEnabledFor(20)) {
                logger.info(filts.size() + "notification listener removed successfully");
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    private boolean hasListeners() {
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            boolean bl = this.m_filters.size() > 0;
            return bl;
        }
    }

    public void sendNotification(final Notification n) {
        final Logger logger = this.getLogger();
        boolean debug = logger.isEnabledFor(10);
        final boolean info = logger.isEnabledFor(20);
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            Iterator i = this.m_filters.keySet().iterator();
            if (i.hasNext() && info) {
                logger.info("Sending notifications...");
            }
            while (i.hasNext()) {
                final NotificationListener listener = (NotificationListener)i.next();
                if (info) {
                    logger.info("\tListener is: " + listener);
                }
                List filts = (List)this.m_filters.get(listener);
                List hands = (List)this.m_handbacks.get(listener);
                if (debug) {
                    logger.debug("\tFilters for this listener: " + filts);
                    logger.debug("\tHandbacks for this listener: " + hands);
                }
                int j = 0;
                while (j < filts.size()) {
                    final NotificationFilter filter = (NotificationFilter)filts.get(j);
                    Object hb = hands.get(j);
                    if (hb == NULL_HANDBACK) {
                        hb = null;
                    }
                    final Object handback = hb;
                    Runnable run = new Runnable(){

                        public void run() {
                            block8: {
                                boolean enabled;
                                block7: {
                                    enabled = false;
                                    try {
                                        enabled = filter != null && filter.isNotificationEnabled(n);
                                    }
                                    catch (RuntimeException x) {
                                        if (!info) break block7;
                                        logger.info("\t\tRuntimeException caught from isNotificationEnabled", x);
                                    }
                                }
                                if (info) {
                                    logger.info("\t\tFilter is: " + filter + ", enabled: " + enabled);
                                }
                                if (enabled) {
                                    if (info) {
                                        logger.info("\t\tHandback is: " + handback);
                                        logger.info("\t\tSending notification " + n);
                                    }
                                    try {
                                        listener.handleNotification(n, handback);
                                    }
                                    catch (RuntimeException x) {
                                        if (!info) break block8;
                                        logger.info("\t\tRuntimeException caught from handleNotification", x);
                                    }
                                }
                            }
                        }
                    };
                    if (listener instanceof Serializable) {
                        new Thread(run, "NotificationBroadcasterSupport Thread").start();
                    } else {
                        run.run();
                    }
                    ++j;
                }
            }
        }
    }
}

