/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.relation.Relation;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationSupportMBean;
import javax.management.relation.RelationType;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.util.StandardMBeanProxy;

public class RelationService
extends NotificationBroadcasterSupport
implements RelationServiceMBean,
MBeanRegistration,
NotificationListener {
    private boolean m_purgeFlag;
    private Long m_notificationCounter = new Long(0L);
    private MBeanServer m_server = null;
    private RelationSupportMBean m_proxy = null;
    private InternalRelation m_internalRelation = null;
    private ObjectName m_relationServiceObjectName = null;
    private MBeanServerNotificationFilter m_notificationFilter = null;
    private Map m_relationIdToRelationObject = new HashMap();
    private Map m_relationIdToRelationTypeName = new HashMap();
    private Map m_relationMBeanObjectNameToRelationId = new HashMap();
    private Map m_relationTypeNameToRelationTypeObject = new HashMap();
    private Map m_relationTypeNameToRelationIds = new HashMap();
    private Map m_referencedMBeanObjectNameToRelationIds = new HashMap();
    private List m_deregisteredNotificationList = new ArrayList();
    static /* synthetic */ Class class$javax$management$relation$RelationSupportMBean;

    public RelationService(boolean purgeFlag) {
        this.m_purgeFlag = purgeFlag;
    }

    public void isActive() throws RelationServiceNotRegisteredException {
        Logger logger = this.getLogger();
        if (this.m_server == null) {
            logger.error("RelationService has not been registered in the MBeanServer");
            throw new RelationServiceNotRegisteredException("Relation Service is not registered");
        }
    }

    public boolean getPurgeFlag() {
        return this.m_purgeFlag;
    }

    public void setPurgeFlag(boolean purgeFlag) {
        this.m_purgeFlag = purgeFlag;
    }

    public void createRelationType(String relationTypeName, RoleInfo[] roleInfos) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Illegal Null Relation Type Name value");
        }
        if (roleInfos == null) {
            throw new IllegalArgumentException("Illegal Null RoleInfo");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Creating Relation Type with relationTypeName: " + relationTypeName);
        }
        RelationTypeSupport relationType = new RelationTypeSupport(relationTypeName, roleInfos);
        this.addRelationTypeToMap(relationTypeName, relationType);
    }

    private void addRelationTypeToMap(String relationTypeName, RelationType relationType) {
        Logger logger = this.getLogger();
        Map map = this.m_relationTypeNameToRelationTypeObject;
        synchronized (map) {
            if ((RelationType)this.m_relationTypeNameToRelationTypeObject.get(relationTypeName) != null) {
                logger.error("Cannot addRelationType as a relationType of the same name: " + relationTypeName + " already exists in the RelationService");
                throw new IllegalArgumentException("RelationType with name: " + relationTypeName + " already exists in the RelationService");
            }
            if (relationType instanceof RelationTypeSupport) {
                ((RelationTypeSupport)relationType).setRelationServiceFlag(true);
            }
            this.m_relationTypeNameToRelationTypeObject.put(relationTypeName, relationType);
        }
    }

    private RelationType getRelationType(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Null relation type name");
        }
        RelationType relationType = null;
        Map map = this.m_relationTypeNameToRelationTypeObject;
        synchronized (map) {
            relationType = (RelationType)this.m_relationTypeNameToRelationTypeObject.get(relationTypeName);
            if (relationType == null) {
                throw new RelationTypeNotFoundException("No RelationType found for relationTypeName: " + relationTypeName);
            }
            RelationType relationType2 = relationType;
            return relationType2;
        }
    }

    public void addRelationType(RelationType relationType) throws IllegalArgumentException, InvalidRelationTypeException {
        List roleInfoList;
        if (relationType == null) {
            throw new IllegalArgumentException("Relation Type should not be null.");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Adding a RelationType");
        }
        if ((roleInfoList = relationType.getRoleInfos()) == null) {
            logger.error("Cannot add RelationType: " + relationType.getClass().getName() + " RoleInfo information was not provided with the RelationType.");
            throw new IllegalArgumentException("No RoleInfo provided with Relation Type");
        }
        RoleInfo[] roleInfos = new RoleInfo[roleInfoList.size()];
        int index = 0;
        Iterator i = roleInfoList.iterator();
        while (i.hasNext()) {
            RoleInfo currentRoleInfo;
            roleInfos[index] = currentRoleInfo = (RoleInfo)i.next();
            ++index;
        }
        RelationTypeSupport.checkRoleInfos(roleInfos);
        String relationTypeName = relationType.getRelationTypeName();
        this.addRelationTypeToMap(relationTypeName, relationType);
    }

    public List getAllRelationTypeNames() {
        ArrayList result = null;
        Map map = this.m_relationTypeNameToRelationTypeObject;
        synchronized (map) {
            result = new ArrayList(this.m_relationTypeNameToRelationTypeObject.keySet());
        }
        return result;
    }

    public List getRoleInfos(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Illegal relationType name is null.");
        }
        RelationType relationType = this.getRelationType(relationTypeName);
        return relationType.getRoleInfos();
    }

    public RoleInfo getRoleInfo(String relationTypeName, String roleInfoName) throws IllegalArgumentException, RelationTypeNotFoundException, RoleInfoNotFoundException {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Null relation type name");
        }
        if (roleInfoName == null) {
            throw new IllegalArgumentException("Null RoleInfo name");
        }
        return this.getRelationType(relationTypeName).getRoleInfo(roleInfoName);
    }

    public void removeRelationType(String relationTypeName) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException {
        Logger logger = this.getLogger();
        this.isActive();
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Illegal: relationType name cannot be null.");
        }
        if (logger.isEnabledFor(20)) {
            logger.info("Removing RelationType with relationTypeName: " + relationTypeName);
        }
        RelationType relationType = this.getRelationType(relationTypeName);
        List relationIdList = null;
        List tempList = this.getRelationIds(relationTypeName);
        if (tempList != null) {
            relationIdList = tempList;
        }
        this.removeRelationTypeObject(relationTypeName);
        this.removeRelationTypeName(relationTypeName);
        if (relationIdList != null) {
            Iterator i = relationIdList.iterator();
            while (i.hasNext()) {
                String currentRelationId = (String)i.next();
                try {
                    this.removeRelation(currentRelationId);
                }
                catch (RelationNotFoundException ex) {
                    throw new RuntimeOperationsException(ex.getMessage());
                }
            }
        }
    }

    private void removeRelationTypeObject(String relationTypeName) {
        Map map = this.m_relationTypeNameToRelationTypeObject;
        synchronized (map) {
            this.m_relationTypeNameToRelationTypeObject.remove(relationTypeName);
        }
    }

    private List getRelationIds(String relationTypeName) {
        Map map = this.m_relationTypeNameToRelationIds;
        synchronized (map) {
            List list = (List)this.m_relationTypeNameToRelationIds.get(relationTypeName);
            return list;
        }
    }

    public void createRelation(String relationId, String relationTypeName, RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        this.isActive();
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id");
        }
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Null Relation Type Name");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Creating an InternalRelation with ID: " + relationId + " and relationType name: " + relationTypeName);
        }
        this.m_internalRelation = new InternalRelation(relationId, this.m_relationServiceObjectName, relationTypeName, roleList);
        try {
            if (this.getRelationObject(relationId) != null) {
                logger.error("There is a Relation already registered in the RelationServcie with ID: " + relationId);
                throw new InvalidRelationIdException("There is already a relation with id: " + relationId);
            }
        }
        catch (RelationNotFoundException ex) {
            // empty catch block
        }
        RelationType relationType = this.getRelationType(relationTypeName);
        ArrayList roleInfoList = (ArrayList)this.buildRoleInfoList(relationType, roleList);
        if (!roleInfoList.isEmpty()) {
            this.initializeMissingCreateRoles(roleInfoList, this.m_internalRelation, relationId, relationTypeName);
        }
        this.addRelationObject(relationId, this.m_internalRelation);
        this.addRelationId(relationId, relationTypeName);
        this.addRelationTypeName(relationId, relationTypeName);
        this.updateRoles(roleList, relationId);
        try {
            if (logger.isEnabledFor(20)) {
                logger.info("sending RelationCreation notification to all listeners");
            }
            this.sendRelationCreationNotification(relationId);
        }
        catch (RelationNotFoundException ex) {
            throw new RuntimeOperationsException("Unable to send notification as Relation not found");
        }
    }

    private void updateRoles(RoleList roleList, String relationId) throws RelationServiceNotRegisteredException, IllegalArgumentException {
        if (roleList == null) {
            throw new IllegalArgumentException("Null RoleList");
        }
        if (relationId == null) {
            throw new IllegalArgumentException("Null relationId");
        }
        Iterator i = ((AbstractList)roleList).iterator();
        while (i.hasNext()) {
            Role currentRole = (Role)i.next();
            ArrayList tempList = new ArrayList();
            try {
                this.updateRoleMap(relationId, currentRole, tempList);
            }
            catch (RelationNotFoundException ex) {
                throw new RuntimeOperationsException("Cannot update the roleMap as Relation not found");
            }
        }
    }

    private List buildRoleInfoList(RelationType relationType, List roleList) throws InvalidRoleValueException, RoleNotFoundException {
        List roleInfoList = relationType.getRoleInfos();
        if (roleList != null) {
            Iterator i = roleList.iterator();
            while (i.hasNext()) {
                Role currentRole = (Role)i.next();
                String currentRoleName = currentRole.getRoleName();
                List currentRoleValue = currentRole.getRoleValue();
                RoleInfo roleInfo = null;
                try {
                    roleInfo = relationType.getRoleInfo(currentRoleName);
                }
                catch (RoleInfoNotFoundException ex) {
                    throw new RoleNotFoundException(ex.getMessage());
                }
                int problemType = this.checkRoleCardinality(currentRoleName, currentRoleValue, roleInfo);
                if (problemType != 0) {
                    RelationService.throwRoleProblemException(problemType, currentRoleName);
                }
                roleInfoList.remove(roleInfoList.indexOf(roleInfo));
            }
        }
        return roleInfoList;
    }

    private void addRelationTypeName(String relationId, String relationTypeName) {
        Map map = this.m_relationTypeNameToRelationIds;
        synchronized (map) {
            ArrayList<String> idList = (ArrayList<String>)this.m_relationTypeNameToRelationIds.get(relationTypeName);
            boolean isNewRelation = false;
            if (idList == null) {
                isNewRelation = true;
                idList = new ArrayList<String>();
            }
            idList.add(relationId);
            if (isNewRelation) {
                this.m_relationTypeNameToRelationIds.put(relationTypeName, idList);
            }
        }
    }

    private void addRelationObject(String relationId, RelationSupport relationSupport) {
        Map map = this.m_relationIdToRelationObject;
        synchronized (map) {
            this.m_relationIdToRelationObject.put(relationId, relationSupport);
        }
    }

    private void addRelationObjectName(String relationId, ObjectName relationObjectName) {
        Map map = this.m_relationIdToRelationObject;
        synchronized (map) {
            this.m_relationIdToRelationObject.put(relationId, relationObjectName);
        }
    }

    private void addRelationId(String relationId, String relationTypeName) {
        Map map = this.m_relationIdToRelationTypeName;
        synchronized (map) {
            this.m_relationIdToRelationTypeName.put(relationId, relationTypeName);
        }
    }

    private void initializeMissingCreateRoles(List roleInfoList, InternalRelation internalRelation, String relationId, String relationTypeName) throws RelationTypeNotFoundException, RelationServiceNotRegisteredException, InvalidRoleValueException, RoleNotFoundException, IllegalArgumentException {
        this.isActive();
        if (roleInfoList == null) {
            throw new IllegalArgumentException("RoleInfoList is Null");
        }
        if (relationId == null) {
            throw new IllegalArgumentException("RelationId is Null.");
        }
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Relation Type Name is Null.");
        }
        Iterator i = roleInfoList.iterator();
        while (i.hasNext()) {
            RoleInfo currentRoleInfo = (RoleInfo)i.next();
            String roleName = currentRoleInfo.getName();
            ArrayList temp = new ArrayList();
            Role role = new Role(roleName, temp);
            try {
                internalRelation.setRole(role);
            }
            catch (RelationNotFoundException ex) {
                throw new RuntimeOperationsException(ex.getMessage());
            }
        }
    }

    private Integer checkRoleCardinality(String roleName, List roleValue, RoleInfo roleInfo) {
        if (roleName == null) {
            throw new IllegalArgumentException("Null Role Name");
        }
        if (roleValue == null) {
            throw new IllegalArgumentException("Null roleValue List");
        }
        if (roleInfo == null) {
            throw new IllegalArgumentException("Null RoleInfo");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("checking role cardinality");
        }
        if (!roleName.equals(roleInfo.getName())) {
            logger.error("Role does not have a valid roleName");
            return new Integer(1);
        }
        if (!roleInfo.checkMinDegree(roleValue.size())) {
            logger.error("Minimum number of references defined in the RoleInfo has fallen below minimum");
            return new Integer(4);
        }
        if (!roleInfo.checkMaxDegree(roleValue.size())) {
            logger.error("Maximum number of references defined in the RoleInfo has gone above the maximum");
            return new Integer(5);
        }
        String referencedClassName = roleInfo.getRefMBeanClassName();
        Iterator i = roleValue.iterator();
        while (i.hasNext()) {
            ObjectName currentObjectName = (ObjectName)i.next();
            if (currentObjectName == null) {
                logger.error("The mbean with ObjectName: " + currentObjectName.getCanonicalName() + " is not registered in the MBeanServer");
                return new Integer(7);
            }
            if (!this.m_server.isRegistered(currentObjectName)) {
                logger.error("The mbean with ObjectName: " + currentObjectName.getCanonicalName() + " is not registered in the MBeanServer");
                return new Integer(7);
            }
            try {
                if (this.m_server.isInstanceOf(currentObjectName, referencedClassName)) continue;
                logger.error("The class referenced: " + currentObjectName.toString() + " does not match the class expected: " + referencedClassName + " in RoleInfo: " + roleInfo.toString());
                return new Integer(6);
            }
            catch (InstanceNotFoundException ex) {
                return null;
            }
        }
        return new Integer(0);
    }

    public void addRelation(ObjectName relationMBeanObjectName) throws IllegalArgumentException, RelationServiceNotRegisteredException, NoSuchMethodException, InvalidRelationIdException, InstanceNotFoundException, InvalidRelationServiceException, RelationTypeNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        String relationId;
        this.isActive();
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("adding a Relation with ObjectName: " + relationMBeanObjectName.toString());
        }
        this.checkValidRelation(relationMBeanObjectName);
        if (this.m_proxy == null) {
            this.m_proxy = (RelationSupportMBean)StandardMBeanProxy.create(class$javax$management$relation$RelationSupportMBean == null ? (class$javax$management$relation$RelationSupportMBean = RelationService.class$("javax.management.relation.RelationSupportMBean")) : class$javax$management$relation$RelationSupportMBean, this.m_server, relationMBeanObjectName);
        }
        if ((relationId = this.m_proxy.getRelationId()) == null) {
            throw new InvalidRelationIdException("No RelationId provided");
        }
        ObjectName relationServiceObjectName = this.m_proxy.getRelationServiceName();
        if (!this.checkRelationServiceIsCurrent(relationMBeanObjectName, relationServiceObjectName)) {
            throw new InvalidRelationServiceException("The Relation Service referenced in the MBean is not the current one.");
        }
        String relationTypeName = this.m_proxy.getRelationTypeName();
        if (relationTypeName == null) {
            throw new RelationTypeNotFoundException("RelationType not found");
        }
        RoleList roleList = this.m_proxy.retrieveAllRoles();
        try {
            if (this.getRelationObject(relationId) != null) {
                throw new InvalidRelationIdException("Relation with ID " + relationId + " already exists");
            }
        }
        catch (RelationNotFoundException ex) {
            // empty catch block
        }
        RelationType relationType = this.getRelationType(relationTypeName);
        ArrayList roleInfoList = (ArrayList)this.buildRoleInfoList(relationType, roleList);
        if (!roleInfoList.isEmpty()) {
            Iterator i = ((AbstractList)roleInfoList).iterator();
            while (i.hasNext()) {
                RoleInfo currentRoleInfo = (RoleInfo)i.next();
                String currentRoleName = currentRoleInfo.getName();
                ArrayList emptyValueList = new ArrayList();
                Role role = new Role(currentRoleName, emptyValueList);
                try {
                    this.m_proxy.setRole(role);
                }
                catch (RelationNotFoundException ex) {
                    throw new RuntimeOperationsException(ex.getMessage());
                }
            }
        }
        this.updateAllInternals(relationId, relationMBeanObjectName, relationTypeName, roleList);
    }

    private void updateAllInternals(String relationId, ObjectName relationMBeanObjectName, String relationTypeName, RoleList roleList) throws RelationServiceNotRegisteredException {
        this.addRelationObjectName(relationId, relationMBeanObjectName);
        this.addRelationId(relationId, relationTypeName);
        this.addRelationTypeName(relationId, relationTypeName);
        this.updateRoles(roleList, relationId);
        try {
            this.sendRelationCreationNotification(relationId);
        }
        catch (RelationNotFoundException ex) {
            throw new RuntimeOperationsException("Cannot send a notification for relationId " + relationId + " as relation not found.");
        }
        this.addMBeanObjectNameToRelationId(relationMBeanObjectName, relationId);
        this.m_proxy.setRelationServiceManagementFlag(new Boolean(true));
        ArrayList<ObjectName> newReferenceList = new ArrayList<ObjectName>();
        newReferenceList.add(relationMBeanObjectName);
        this.updateUnregistrationListener(newReferenceList, null);
    }

    private boolean checkRelationServiceIsCurrent(ObjectName relationMBeanObjectName, ObjectName relationServiceObjectName) {
        if (relationServiceObjectName == null) {
            return false;
        }
        return relationServiceObjectName.equals(this.m_relationServiceObjectName);
    }

    private void checkValidRelation(ObjectName relationMBeanObjectName) throws IllegalArgumentException, InstanceNotFoundException {
        if (relationMBeanObjectName == null) {
            throw new IllegalArgumentException("Cannot have a null Relation ObjectName");
        }
        Logger logger = this.getLogger();
        if (!this.m_server.isInstanceOf(relationMBeanObjectName, "javax.management.relation.Relation")) {
            logger.error("An MBean which is to be added as a Relation must implement the Relation interface");
            throw new InstanceNotFoundException("MBean does implement the Relation interface");
        }
    }

    public ObjectName isRelationMBean(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id.");
        }
        Object result = this.getRelationObject(relationId);
        if (result instanceof ObjectName) {
            return (ObjectName)result;
        }
        return null;
    }

    public String isRelation(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("Null ObjectName");
        }
        return this.getMBeanObjectName(objectName);
    }

    public Boolean hasRelation(String relationId) throws IllegalArgumentException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id");
        }
        try {
            Object result = this.getRelationObject(relationId);
            return new Boolean(true);
        }
        catch (RelationNotFoundException ex) {
            return new Boolean(false);
        }
    }

    public List getAllRelationIds() {
        Map map = this.m_relationIdToRelationObject;
        synchronized (map) {
            ArrayList arrayList = new ArrayList(this.m_relationIdToRelationObject.keySet());
            return arrayList;
        }
    }

    public Integer checkRoleReading(String roleName, String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (roleName == null) {
            throw new IllegalArgumentException("Null RoleName");
        }
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Null RelationType name.");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("checking if Role with RoleName: " + roleName + " is readable");
        }
        RelationType relationType = this.getRelationType(relationTypeName);
        try {
            RoleInfo roleInfo = relationType.getRoleInfo(roleName);
            if (!roleName.equals(roleInfo.getName())) {
                return new Integer(1);
            }
            if (!roleInfo.isReadable()) {
                logger.error("RoleInfo: " + roleInfo.toString() + " cannot be read");
                return new Integer(2);
            }
        }
        catch (RoleInfoNotFoundException ex) {
            logger.error("roleInfo for roleName: " + roleName + " has not been found.");
            return new Integer(1);
        }
        return new Integer(0);
    }

    public Integer checkRoleWriting(Role role, String relationTypeName, Boolean isInitialized) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (role == null) {
            throw new IllegalArgumentException("checkRoleWriting was given a null Role");
        }
        if (relationTypeName == null) {
            throw new IllegalArgumentException("checkRoleWriting was given a null RelationTypeName");
        }
        if (isInitialized == null) {
            throw new IllegalArgumentException("checkRoleWriting was given a null Boolean");
        }
        Logger logger = this.getLogger();
        RelationType relationType = this.getRelationType(relationTypeName);
        String roleName = role.getRoleName();
        if (logger.isEnabledFor(20)) {
            logger.info("checking if Role with RoleName: " + roleName + " is readable");
        }
        ArrayList roleValue = (ArrayList)role.getRoleValue();
        boolean canWrite = true;
        if (isInitialized.booleanValue()) {
            canWrite = false;
        }
        RoleInfo roleInfo = null;
        try {
            roleInfo = relationType.getRoleInfo(roleName);
        }
        catch (RoleInfoNotFoundException ex) {
            logger.error("roleInfo for roleName: " + roleName + " has not been found.");
            return new Integer(1);
        }
        if (canWrite && !roleInfo.isWritable()) {
            logger.error("RoleInfo: " + roleInfo.toString() + " cannot be written to.");
            return new Integer(3);
        }
        return this.checkRoleCardinality(roleName, roleValue, roleInfo);
    }

    public void sendRelationCreationNotification(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id.");
        }
        Logger logger = this.getLogger();
        String message = "Creation of relation " + relationId;
        String relationTypeName = this.getRelationTypeNameFromMap(relationId);
        if (logger.isEnabledFor(20)) {
            logger.info("A relation has been created with ID: " + relationId + " and relationTypeName: " + relationTypeName + " ..sending notification");
        }
        ObjectName relationObjectName = this.isRelationMBean(relationId);
        String notificationType = this.getCreationNotificationType(relationObjectName);
        long sequenceNumber = this.getNotificationSequenceNumber();
        Date currentDate = new Date();
        long timestamp = currentDate.getTime();
        RelationNotification relationNotification = new RelationNotification(notificationType, this, sequenceNumber, timestamp, message, relationId, relationTypeName, relationObjectName, null);
    }

    private Long getNotificationSequenceNumber() {
        Long result = null;
        Long l = this.m_notificationCounter;
        synchronized (l) {
            result = new Long(this.m_notificationCounter + 1L);
            this.m_notificationCounter = new Long(result);
        }
        return result;
    }

    private String getCreationNotificationType(ObjectName relationObjectName) {
        if (relationObjectName != null) {
            return "jmx.relation.creation.mbean";
        }
        return "jmx.relation.creation.basic";
    }

    public void sendRoleUpdateNotification(String relationId, Role newRole, List oldRoleValues) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null RelationId");
        }
        if (newRole == null) {
            throw new IllegalArgumentException("Null Role");
        }
        if (oldRoleValues == null) {
            throw new IllegalArgumentException("Null List of role values");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Sending a roleUpdateNotification of Relation with ID: " + relationId);
        }
        String roleName = newRole.getRoleName();
        List newRoleValues = newRole.getRoleValue();
        String newRoleValueMessage = Role.roleValueToString(newRoleValues);
        String oldRoleValueMessage = Role.roleValueToString(oldRoleValues);
        StringBuffer message = new StringBuffer("Value of the role ");
        message.append(roleName);
        message.append(" has changed\nOld value:\n");
        message.append(oldRoleValueMessage);
        message.append("\nNew value:\n");
        message.append(newRoleValueMessage);
        if (logger.isEnabledFor(20)) {
            logger.info("Notification message: " + message.toString());
        }
        String relationTypeName = this.getRelationTypeNameFromMap(relationId);
        ObjectName relationObjectName = this.isRelationMBean(relationId);
        String notificationType = null;
        notificationType = relationObjectName != null ? "jmx.relation.update.mbean" : "jmx.relation.update.basic";
        long sequenceNumber = this.getNotificationSequenceNumber();
        Date currentDate = new Date();
        long timeStamp = currentDate.getTime();
        RelationNotification notification = new RelationNotification(notificationType, this, sequenceNumber, timeStamp, message.toString(), relationId, relationTypeName, relationObjectName, roleName, oldRoleValues, newRoleValues);
        this.sendNotification(notification);
    }

    public void sendRelationRemovalNotification(String relationId, List unregisteredMBeanList) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null RelationId");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("sending relationRemovalNotification of ID: " + relationId);
        }
        StringBuffer message = new StringBuffer("Removal of relation ");
        message.append(relationId);
        String relationTypeName = this.getRelationTypeNameFromMap(relationId);
        ObjectName relationObjectName = this.isRelationMBean(relationId);
        String notificationType = null;
        notificationType = relationObjectName != null ? "jmx.relation.removal.mbean" : "jmx.relation.removal.basic";
        long sequenceNumber = this.getNotificationSequenceNumber();
        Date currentDate = new Date();
        long timeStamp = currentDate.getTime();
        RelationNotification notification = new RelationNotification(notificationType, this, sequenceNumber, timeStamp, message.toString(), relationId, relationTypeName, relationObjectName, unregisteredMBeanList);
        this.sendNotification(notification);
    }

    public void updateRoleMap(String relationId, Role role, List oldRoleValues) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        this.isActive();
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id");
        }
        if (role == null) {
            throw new IllegalArgumentException("Null Role");
        }
        if (oldRoleValues == null) {
            throw new IllegalArgumentException("Null Role value list.");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Updating the RelationService RoleMap");
        }
        Object result = this.getRelationObject(relationId);
        String roleName = role.getRoleName();
        List newRoleValue = role.getRoleValue();
        ArrayList oldValues = (ArrayList)((ArrayList)oldRoleValues).clone();
        ArrayList<ObjectName> newReferenceList = new ArrayList<ObjectName>();
        Iterator i = newRoleValue.iterator();
        while (i.hasNext()) {
            ObjectName currentObjectName = (ObjectName)i.next();
            int currentObjectNamePosition = oldValues.indexOf(currentObjectName);
            if (currentObjectNamePosition == -1) {
                if (!this.addNewMBeanReference(currentObjectName, relationId, roleName)) continue;
                newReferenceList.add(currentObjectName);
                continue;
            }
            oldValues.remove(currentObjectNamePosition);
        }
        List obsoleteReferenceList = this.getObsoleteReferenceList(oldValues, relationId, roleName);
        this.updateUnregistrationListener(newReferenceList, obsoleteReferenceList);
    }

    private List getObsoleteReferenceList(List oldValues, String relationId, String roleName) throws IllegalArgumentException {
        ArrayList<ObjectName> obsoleteReferenceList = new ArrayList<ObjectName>();
        Iterator i = oldValues.iterator();
        while (i.hasNext()) {
            ObjectName currentObjectName = (ObjectName)i.next();
            if (!this.removeMBeanReference(currentObjectName, relationId, roleName)) continue;
            obsoleteReferenceList.add(currentObjectName);
        }
        return obsoleteReferenceList;
    }

    private boolean removeMBeanReference(ObjectName objectName, String relationId, String roleName) throws IllegalArgumentException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null ObjectName");
        }
        if (roleName == null) {
            throw new IllegalArgumentException("Null Role Name.");
        }
        HashMap mbeanReferenceMap = (HashMap)this.getReferencedMBeansFromMap(objectName);
        if (mbeanReferenceMap == null) {
            return true;
        }
        ArrayList roleNames = (ArrayList)mbeanReferenceMap.get(relationId);
        if (roleNames.indexOf(roleName) != -1) {
            roleNames.remove(roleNames.indexOf(roleName));
        }
        if (roleNames.isEmpty()) {
            mbeanReferenceMap.remove(relationId);
        }
        if (mbeanReferenceMap.isEmpty()) {
            this.removeObjectName(objectName);
            return true;
        }
        return false;
    }

    private Map getReferencedMBeansFromMap(ObjectName objectName) {
        Map map = this.m_referencedMBeanObjectNameToRelationIds;
        synchronized (map) {
            HashMap hashMap = (HashMap)this.m_referencedMBeanObjectNameToRelationIds.get(objectName);
            return hashMap;
        }
    }

    private boolean addNewMBeanReference(ObjectName objectName, String relationId, String roleName) throws IllegalArgumentException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id");
        }
        if (roleName == null) {
            throw new IllegalArgumentException("Null Role Name");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null ObjectName.");
        }
        HashMap<String, ArrayList<String>> mbeanReferenceMap = (HashMap<String, ArrayList<String>>)this.getAllMBeanObjectNames(objectName);
        if (mbeanReferenceMap == null) {
            ArrayList<String> roleNames = new ArrayList<String>();
            roleNames.add(roleName);
            mbeanReferenceMap = new HashMap<String, ArrayList<String>>();
            mbeanReferenceMap.put(relationId, roleNames);
            this.addObjectNameToMBeanReference(objectName, mbeanReferenceMap);
            return true;
        }
        return false;
    }

    private void addObjectNameToMBeanReference(ObjectName objectName, HashMap mbeanReferenceMap) {
        Map map = this.m_referencedMBeanObjectNameToRelationIds;
        synchronized (map) {
            this.m_referencedMBeanObjectNameToRelationIds.put(objectName, mbeanReferenceMap);
        }
    }

    public void removeRelation(String relationId) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        Object result;
        this.isActive();
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Removing a Relation from the RelationService.");
        }
        if ((result = this.getRelationObject(relationId)) instanceof ObjectName) {
            ArrayList<ObjectName> obsoleteReferences = new ArrayList<ObjectName>();
            obsoleteReferences.add((ObjectName)result);
            this.updateUnregistrationListener(null, obsoleteReferences);
        }
        this.sendRelationRemovalNotification(relationId, null);
        ArrayList referencedMBeanList = new ArrayList();
        List nonReferencedObjectNameList = this.getNonReferencedMBeans(relationId);
        this.removeNonReferencedMBeans(nonReferencedObjectNameList);
        this.removeRelationId(relationId);
        if (result instanceof ObjectName) {
            this.removeRelationMBean((ObjectName)result);
        }
        String relationTypeName = this.getRelationTypeNameFromMap(relationId);
        this.removeRelationIdToRelationTypeName(relationId);
        List relationIdsList = this.getRelationIds(relationTypeName);
        if (relationIdsList != null) {
            relationIdsList.remove(relationId);
            if (relationIdsList.isEmpty()) {
                this.removeRelationTypeName(relationTypeName);
            }
        }
    }

    private void removeRelationMBean(ObjectName objectName) {
        Map map = this.m_relationMBeanObjectNameToRelationId;
        synchronized (map) {
            this.m_relationMBeanObjectNameToRelationId.remove(objectName);
        }
    }

    private void removeNonReferencedMBeans(List nonReferencedMBeansList) {
        Map map = this.m_referencedMBeanObjectNameToRelationIds;
        synchronized (map) {
            Iterator i = nonReferencedMBeansList.iterator();
            while (i.hasNext()) {
                ObjectName currentObjectName = (ObjectName)i.next();
                this.m_referencedMBeanObjectNameToRelationIds.remove(currentObjectName);
            }
        }
    }

    private List getNonReferencedMBeans(String relationId) {
        ArrayList<ObjectName> referencedMBeanList = new ArrayList<ObjectName>();
        ArrayList<ObjectName> nonReferencedObjectNameList = new ArrayList<ObjectName>();
        Map map = this.m_referencedMBeanObjectNameToRelationIds;
        synchronized (map) {
            Iterator i = this.m_referencedMBeanObjectNameToRelationIds.keySet().iterator();
            while (i.hasNext()) {
                ObjectName currentObjectName = (ObjectName)i.next();
                HashMap relationIdMap = (HashMap)this.m_referencedMBeanObjectNameToRelationIds.get(currentObjectName);
                if (relationIdMap.containsKey(relationId)) {
                    relationIdMap.remove(relationId);
                    referencedMBeanList.add(currentObjectName);
                }
                if (!relationIdMap.isEmpty()) continue;
                nonReferencedObjectNameList.add(currentObjectName);
            }
        }
        return nonReferencedObjectNameList;
    }

    private void removeRelationTypeName(String relationTypeName) {
        Map map = this.m_relationTypeNameToRelationIds;
        synchronized (map) {
            this.m_relationTypeNameToRelationIds.remove(relationTypeName);
        }
    }

    private String getRelationTypeNameFromMap(String relationId) {
        Map map = this.m_relationIdToRelationTypeName;
        synchronized (map) {
            String string = (String)this.m_relationIdToRelationTypeName.get(relationId);
            return string;
        }
    }

    private void removeRelationIdToRelationTypeName(String relationId) {
        Map map = this.m_relationIdToRelationTypeName;
        synchronized (map) {
            this.m_relationIdToRelationTypeName.remove(relationId);
        }
    }

    private String getMBeanObjectName(ObjectName objectName) {
        Map map = this.m_relationMBeanObjectNameToRelationId;
        synchronized (map) {
            String string = (String)this.m_relationMBeanObjectNameToRelationId.get(objectName);
            return string;
        }
    }

    private void addMBeanObjectNameToRelationId(ObjectName relationObjectName, String relationId) {
        Map map = this.m_relationMBeanObjectNameToRelationId;
        synchronized (map) {
            this.m_relationMBeanObjectNameToRelationId.put(relationObjectName, relationId);
        }
    }

    private void removeRelationId(String relationId) {
        Map map = this.m_relationIdToRelationObject;
        synchronized (map) {
            this.m_relationIdToRelationObject.remove(relationId);
        }
    }

    private Map getAllMBeanObjectNames(ObjectName objectName) {
        Map map = this.m_relationMBeanObjectNameToRelationId;
        synchronized (map) {
            HashMap hashMap = (HashMap)this.m_relationMBeanObjectNameToRelationId.get(objectName);
            return hashMap;
        }
    }

    private void updateUnregistrationListener(List newReferenceList, List obsoleteReferences) throws RelationServiceNotRegisteredException {
        Logger logger = this.getLogger();
        if (newReferenceList != null && obsoleteReferences != null && newReferenceList.isEmpty() && obsoleteReferences.isEmpty()) {
            return;
        }
        this.isActive();
        if (newReferenceList != null || obsoleteReferences != null) {
            boolean isNewListener = false;
            if (this.m_notificationFilter == null) {
                this.m_notificationFilter = new MBeanServerNotificationFilter();
                isNewListener = true;
            }
            MBeanServerNotificationFilter mBeanServerNotificationFilter = this.m_notificationFilter;
            synchronized (mBeanServerNotificationFilter) {
                if (newReferenceList != null) {
                    this.updateNewReferences(newReferenceList);
                }
                if (obsoleteReferences != null) {
                    this.updateObsoleteReferences(obsoleteReferences);
                }
                ObjectName mbeanServerDelegateName = null;
                try {
                    mbeanServerDelegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                }
                catch (MalformedObjectNameException ignored) {
                    // empty catch block
                }
                if (isNewListener) {
                    try {
                        this.m_server.addNotificationListener(mbeanServerDelegateName, this, (NotificationFilter)this.m_notificationFilter, null);
                    }
                    catch (InstanceNotFoundException ex) {
                        throw new RelationServiceNotRegisteredException(ex.getMessage());
                    }
                }
            }
        }
    }

    private void updateObsoleteReferences(List obsoleteReferences) {
        Iterator i = obsoleteReferences.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            this.m_notificationFilter.disableObjectName(name);
        }
    }

    private void updateNewReferences(List newReferencesList) {
        Iterator i = newReferencesList.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            this.m_notificationFilter.enableObjectName(name);
        }
    }

    private Relation getRelation(String relationId) throws RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null relation id passed into getRelation.");
        }
        Relation relation = null;
        if (this.isRelationMBean(relationId) == null) {
            Map map = this.m_relationIdToRelationObject;
            synchronized (map) {
                Relation relation2 = relation = (Relation)this.m_relationIdToRelationObject.get(relationId);
                return relation2;
            }
        }
        if (this.m_proxy != null) {
            return this.m_proxy;
        }
        throw new RelationNotFoundException("Relation not found with ID: " + relationId);
    }

    private Object getRelationObject(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id");
        }
        Object relationObject = null;
        Map map = this.m_relationIdToRelationObject;
        synchronized (map) {
            relationObject = this.m_relationIdToRelationObject.get(relationId);
            if (relationObject == null) {
                throw new RelationNotFoundException("Null Relation");
            }
            Object var4_4 = relationObject;
            return var4_4;
        }
    }

    public void purgeRelations() throws RelationServiceNotRegisteredException {
        Iterator i;
        this.isActive();
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("purging relations");
        }
        ArrayList localDeregisteredNotificationList = null;
        List list = this.m_deregisteredNotificationList;
        synchronized (list) {
            localDeregisteredNotificationList = (ArrayList)((ArrayList)this.m_deregisteredNotificationList).clone();
            this.m_deregisteredNotificationList = new ArrayList();
        }
        ArrayList<ObjectName> obsoleteReferenceList = new ArrayList<ObjectName>();
        HashMap<ObjectName, HashMap> localMBeanToRelationId = new HashMap<ObjectName, HashMap>();
        Map map = this.m_referencedMBeanObjectNameToRelationIds;
        synchronized (map) {
            i = ((AbstractList)localDeregisteredNotificationList).iterator();
            while (i.hasNext()) {
                MBeanServerNotification serverNotification = (MBeanServerNotification)i.next();
                ObjectName deregisteredMBeanName = serverNotification.getMBeanName();
                obsoleteReferenceList.add(deregisteredMBeanName);
                HashMap relationIdMap = (HashMap)this.m_referencedMBeanObjectNameToRelationIds.get(deregisteredMBeanName);
                localMBeanToRelationId.put(deregisteredMBeanName, relationIdMap);
                this.m_referencedMBeanObjectNameToRelationIds.remove(deregisteredMBeanName);
            }
        }
        this.updateUnregistrationListener(null, obsoleteReferenceList);
        i = ((AbstractList)localDeregisteredNotificationList).iterator();
        while (i.hasNext()) {
            MBeanServerNotification currentNotification = (MBeanServerNotification)i.next();
            ObjectName unregisteredMBeanObjectName = currentNotification.getMBeanName();
            HashMap localRelationIdMap = (HashMap)localMBeanToRelationId.get(unregisteredMBeanObjectName);
            Set localRelationIdSet = localRelationIdMap.keySet();
            this.unregisterReferences(localRelationIdSet, localRelationIdMap, unregisteredMBeanObjectName);
        }
    }

    private void unregisterReferences(Set relationIdSet, Map relationIdMap, ObjectName objectName) throws RelationServiceNotRegisteredException {
        Iterator iter = relationIdSet.iterator();
        while (iter.hasNext()) {
            String currentRelationId = (String)iter.next();
            ArrayList localRoleNamesList = (ArrayList)relationIdMap.get(currentRelationId);
            try {
                this.handleReferenceUnregistration(currentRelationId, objectName, localRoleNamesList);
            }
            catch (RelationTypeNotFoundException ex) {
                throw new RuntimeOperationsException(ex.getMessage());
            }
            catch (RelationNotFoundException ex) {
                throw new RuntimeOperationsException(ex.getMessage());
            }
            catch (RoleNotFoundException ex) {
                throw new RuntimeOperationsException(ex.getMessage());
            }
        }
    }

    private void handleReferenceUnregistration(String relationId, ObjectName unregisteredObjectName, List roleNames) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException, RelationTypeNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null relationId");
        }
        if (unregisteredObjectName == null) {
            throw new IllegalArgumentException("Null ObjectName");
        }
        if (roleNames == null) {
            throw new IllegalArgumentException("Null roleName list");
        }
        this.isActive();
        String relationTypeName = this.getRelationTypeName(relationId);
        Object relationObject = this.getRelationObject(relationId);
        boolean canDeleteRelation = false;
        Iterator i = roleNames.iterator();
        while (i.hasNext()) {
            String currentRoleName = (String)i.next();
            int currentRoleCardinality = this.getRoleCardinality(relationId, currentRoleName);
            int newRoleCardinality = currentRoleCardinality - 1;
            RoleInfo currentRoleInfo = null;
            try {
                currentRoleInfo = this.getRoleInfo(relationTypeName, currentRoleName);
            }
            catch (RelationTypeNotFoundException ex) {
                throw new RuntimeOperationsException(ex.getMessage());
            }
            catch (RoleInfoNotFoundException ex) {
                throw new RuntimeOperationsException(ex.getMessage());
            }
            if (currentRoleInfo.checkMinDegree(newRoleCardinality)) continue;
            canDeleteRelation = true;
        }
        if (canDeleteRelation) {
            this.removeRelation(relationId);
        } else {
            Iterator i2 = roleNames.iterator();
            while (i2.hasNext()) {
                String currentRoleName = (String)i2.next();
                try {
                    Relation relation = this.getRelation(relationId);
                    relation.handleMBeanUnregistration(unregisteredObjectName, currentRoleName);
                }
                catch (InvalidRoleValueException ex) {
                    throw new RuntimeOperationsException(ex.getMessage());
                }
            }
        }
    }

    private void removeObjectName(ObjectName objectName) {
        Map map = this.m_referencedMBeanObjectNameToRelationIds;
        synchronized (map) {
            this.m_referencedMBeanObjectNameToRelationIds.remove(objectName);
        }
    }

    public Map findReferencingRelations(ObjectName mbeanObjectName, String relationTypeName, String roleName) throws IllegalArgumentException {
        if (mbeanObjectName == null) {
            throw new IllegalArgumentException("Cannot find references for a null ObjectName");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("finding referencing relations for MBean with ObjectName: " + mbeanObjectName.getCanonicalName() + " and relationTypeName: " + relationTypeName + " and roleName: " + roleName);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap relationIdMap = (HashMap)this.getReferencedMBeansFromMap(mbeanObjectName);
        if (relationIdMap != null) {
            Set allRelationIds = relationIdMap.keySet();
            ArrayList relationIdList = null;
            relationIdList = relationTypeName == null ? new ArrayList(allRelationIds) : this.findReferencesFromIds(allRelationIds, relationTypeName);
            Iterator i = relationIdList.iterator();
            while (i.hasNext()) {
                String currentRelationId = (String)i.next();
                ArrayList currentRoleNameList = (ArrayList)relationIdMap.get(currentRelationId);
                if (roleName == null) {
                    result.put(currentRelationId, currentRoleNameList.clone());
                    continue;
                }
                if (!currentRoleNameList.contains(roleName)) continue;
                ArrayList<String> roleNameList = new ArrayList<String>();
                roleNameList.add(roleName);
                result.put(currentRelationId, roleNameList);
            }
        }
        return result;
    }

    private ArrayList findReferencesFromIds(Set allRelationIds, String relationTypeName) {
        ArrayList<String> relationIdList = new ArrayList<String>();
        Iterator i = allRelationIds.iterator();
        while (i.hasNext()) {
            String currentRelationId = (String)i.next();
            String currentRelationTypeName = this.getRelationTypeNameFromMap(currentRelationId);
            if (!currentRelationTypeName.equals(relationTypeName)) continue;
            relationIdList.add(currentRelationId);
        }
        return relationIdList;
    }

    public Map findAssociatedMBeans(ObjectName mbeanObjectName, String relationTypeName, String roleName) throws IllegalArgumentException {
        if (mbeanObjectName == null) {
            throw new IllegalArgumentException("mbean ObjectName cannot be null.");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("finding associated relations for MBean with ObjectName: " + mbeanObjectName.getCanonicalName() + " and relationTypeName: " + relationTypeName + " and roleName: " + roleName);
        }
        HashMap relationIdsToRoleNames = (HashMap)this.findReferencingRelations(mbeanObjectName, relationTypeName, roleName);
        HashMap result = new HashMap();
        Iterator i = relationIdsToRoleNames.keySet().iterator();
        while (i.hasNext()) {
            String currentRelationId = (String)i.next();
            HashMap objectNamesToRoleMap = null;
            try {
                objectNamesToRoleMap = (HashMap)this.getReferencedMBeans(currentRelationId);
            }
            catch (RelationNotFoundException ex) {
                logger.error("Relation with ID: " + currentRelationId + " not found.");
                throw new RuntimeOperationsException("Relation Not Found");
            }
            Iterator iter = objectNamesToRoleMap.keySet().iterator();
            while (iter.hasNext()) {
                ObjectName objectName = (ObjectName)iter.next();
                if (objectName.equals(mbeanObjectName)) continue;
                ArrayList<String> currentRelationIdList = new ArrayList<String>();
                currentRelationIdList.add(currentRelationId);
                result.put(objectName, currentRelationIdList);
            }
        }
        return result;
    }

    public List findRelationsOfType(String relationTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("relation type name cannot be null.");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("finding relations matching relationTypeName: " + relationTypeName);
        }
        RelationType relationType = this.getRelationType(relationTypeName);
        List relationIdList = this.getRelationIds(relationTypeName);
        List result = new ArrayList();
        if (relationIdList != null) {
            result = relationIdList;
        }
        return result;
    }

    public List getRole(String relationId, String roleName) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException {
        this.isActive();
        if (relationId == null) {
            throw new IllegalArgumentException("RelationId cannot have a null value.");
        }
        if (roleName == null) {
            throw new IllegalArgumentException("Role Name cannot have a null value.");
        }
        Relation relationObject = this.getRelation(relationId);
        return relationObject.getRole(roleName);
    }

    public RoleResult getRoles(String relationId, String[] roleNames) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        if (relationId == null) {
            throw new IllegalArgumentException("Illegal Argument relationId is null.");
        }
        if (roleNames == null) {
            throw new IllegalArgumentException("Array of Roles Names should not be null");
        }
        this.isActive();
        Relation relation = this.getRelation(relationId);
        return relation.getRoles(roleNames);
    }

    public RoleResult getAllRoles(String relationId) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        if (relationId == null) {
            throw new IllegalArgumentException("RelationId cannot be null");
        }
        Relation relation = this.getRelation(relationId);
        return relation.getAllRoles();
    }

    public Integer getRoleCardinality(String relationId, String roleName) throws IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Relation Id is null.");
        }
        if (roleName == null) {
            throw new IllegalArgumentException("Role Name is null.");
        }
        Object relationObject = this.getRelationObject(relationId);
        if (relationObject instanceof InternalRelation) {
            return ((InternalRelation)relationObject).getRoleCardinality(roleName);
        }
        return this.m_proxy.getRoleCardinality(roleName);
    }

    public void setRole(String relationId, Role role) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException, InvalidRoleValueException, RelationTypeNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Illegal Null Relation Id.");
        }
        if (role == null) {
            throw new IllegalArgumentException("Illegal Null Role.");
        }
        this.isActive();
        Relation relation = this.getRelation(relationId);
        relation.setRole(role);
    }

    public RoleResult setRoles(String relationId, RoleList roleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        Logger logger = this.getLogger();
        if (relationId == null) {
            throw new IllegalArgumentException("Relation Id is null");
        }
        if (roleList == null) {
            throw new IllegalArgumentException("RoleList is null");
        }
        this.isActive();
        Object relationObject = this.getRelationObject(relationId);
        Object roleResult = null;
        Relation relation = this.getRelation(relationId);
        try {
            return relation.setRoles(roleList);
        }
        catch (RelationTypeNotFoundException ex) {
            throw new RuntimeOperationsException("Unable to find a RelationTypeName for relation ID: " + relationId);
        }
    }

    public Map getReferencedMBeans(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("getting MBeans referenced for ID: " + relationId);
        }
        Relation relation = this.getRelation(relationId);
        return relation.getReferencedMBeans();
    }

    public String getRelationTypeName(String relationId) throws IllegalArgumentException, RelationNotFoundException {
        if (relationId == null) {
            throw new IllegalArgumentException("Null Relation Id");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("getting the relationType for ID: " + relationId);
        }
        Relation relation = this.getRelation(relationId);
        return relation.getRelationTypeName();
    }

    public void handleNotification(Notification notification, Object handback) {
        String notificationType;
        if (notification == null) {
            throw new IllegalArgumentException("Null Notification");
        }
        if (notification instanceof MBeanServerNotification && (notificationType = notification.getType()).equals("JMX.mbean.unregistered")) {
            ObjectName mbeanName = ((MBeanServerNotification)notification).getMBeanName();
            this.handleUnregistration(notification, mbeanName);
            this.handleMBeanRemoval(mbeanName);
        }
    }

    private void handleMBeanRemoval(ObjectName mbeanName) {
        String relationId = this.getMBeanObjectName(mbeanName);
        if (relationId != null) {
            try {
                this.removeRelation(relationId);
            }
            catch (Exception ex) {
                throw new RuntimeOperationsException(ex.getMessage());
            }
        }
    }

    private void handleUnregistration(Notification notification, ObjectName objectName) {
        boolean isReferenced = false;
        Map map = this.m_referencedMBeanObjectNameToRelationIds;
        synchronized (map) {
            if (this.m_referencedMBeanObjectNameToRelationIds.containsKey(objectName)) {
                List list = this.m_deregisteredNotificationList;
                synchronized (list) {
                    this.m_deregisteredNotificationList.add(notification);
                }
                isReferenced = true;
            }
            if (isReferenced && this.m_purgeFlag) {
                try {
                    this.purgeRelations();
                }
                catch (Exception ex) {
                    throw new RuntimeOperationsException(ex.getMessage());
                }
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notificationInfo = new MBeanNotificationInfo[1];
        String[] notificationTypes = new String[]{"jmx.relation.creation.basic", "jmx.relation.creation.mbean", "jmx.relation.update.basic", "jmx.relation.update.mbean", "jmx.relation.removal.basic", "jmx.relation.removal.mbean"};
        String notificationDescription = "Sent when a relation is created, updated or deleted.";
        notificationInfo[0] = new MBeanNotificationInfo(notificationTypes, "RelationNotification", notificationDescription);
        return notificationInfo;
    }

    private void addDeregisteredMbean(Notification notification) {
        List list = this.m_deregisteredNotificationList;
        synchronized (list) {
            this.m_deregisteredNotificationList.add(notification);
        }
    }

    private boolean isMBeanReferenced(ObjectName mbeanObjectName) {
        Map map = this.m_relationMBeanObjectNameToRelationId;
        synchronized (map) {
            boolean bl = this.m_relationMBeanObjectNameToRelationId.containsKey(mbeanObjectName);
            return bl;
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.m_server = server;
        this.m_relationServiceObjectName = name == null ? new ObjectName(this.m_server.getDefaultDomain(), "service", "Relation") : name;
        return this.m_relationServiceObjectName;
    }

    public void postRegister(Boolean registrationDone) {
        Logger logger = this.getLogger();
        boolean done = registrationDone;
        if (!done) {
            this.m_server = null;
            logger.warn("Relation service was NOT registered");
        } else if (logger.isEnabledFor(0)) {
            logger.trace("Relation service postRegistered");
        }
    }

    public void preDeregister() throws Exception {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.debug("Relation service preDeregistered");
        }
    }

    public void postDeregister() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.debug("Relation service postDeregistered");
        }
    }

    static void throwRoleProblemException(int problemType, String roleName) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException {
        if (roleName == null) {
            throw new IllegalArgumentException("Null Role Name");
        }
        switch (problemType) {
            case 1: {
                throw new RoleNotFoundException("RoleName: " + roleName + " does not exist in the relation");
            }
            case 2: {
                throw new RoleNotFoundException("RoleName: " + roleName + " is not readable");
            }
            case 3: {
                throw new RoleNotFoundException("RoleName: " + roleName + " is not writable");
            }
            case 4: {
                throw new InvalidRoleValueException("RoleName: " + roleName + " has references less than the expected minimum.");
            }
            case 5: {
                throw new InvalidRoleValueException("RoleName: " + roleName + " has references more than the expected maximum.");
            }
            case 6: {
                throw new InvalidRoleValueException("RoleName: " + roleName + " has a MBean reference to a MBean not of the expected class of references for that role.");
            }
            case 7: {
                throw new InvalidRoleValueException("RoleName: " + roleName + "  has a reference to null MBean or to a MBean not registered.");
            }
        }
    }

    private Logger getLogger() {
        return Log.getLogger("jmx.mbean." + this.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class InternalRelation
    extends RelationSupport {
        InternalRelation(String relationId, ObjectName relationServiceObjectName, String relationTypeName, RoleList roleList) throws InvalidRoleValueException, IllegalArgumentException {
            super(relationId, relationServiceObjectName, relationTypeName, roleList);
        }

        int getReadingProblemType(Role role, String roleName, String relationTypeName) {
            if (roleName == null) {
                throw new IllegalArgumentException("Null RoleName");
            }
            if (role == null) {
                return 1;
            }
            try {
                return RelationService.this.checkRoleReading(roleName, relationTypeName);
            }
            catch (RelationTypeNotFoundException ex) {
                throw new RuntimeOperationsException(ex.getMessage());
            }
        }

        int getRoleWritingValue(Role role, String relationTypeName, Boolean toBeInitialized) throws RelationTypeNotFoundException {
            try {
                return RelationService.this.checkRoleWriting(role, relationTypeName, toBeInitialized);
            }
            catch (RelationTypeNotFoundException ex) {
                throw new RuntimeOperationsException(ex.getMessage());
            }
        }

        void sendUpdateRoleNotification(String relationId, Role role, List oldRoleValue) throws RelationServiceNotRegisteredException, RelationNotFoundException {
            if (relationId == null) {
                throw new IllegalArgumentException("Null RelationId passed into sendUpdateRoleNotification");
            }
            if (role == null) {
                throw new IllegalArgumentException("Null role passed into sendUpdateRoleNotification");
            }
            if (oldRoleValue == null) {
                throw new IllegalArgumentException("Null list of role Values passed into sendUpdateRoleNotification");
            }
            RelationService.this.sendRoleUpdateNotification(relationId, role, oldRoleValue);
        }

        void updateRelationServiceMap(String relationId, Role role, List oldRoleValue) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
            if (relationId == null) {
                throw new IllegalArgumentException("Null RelationId passed into updateRelationServiceMap");
            }
            if (role == null) {
                throw new IllegalArgumentException("Null role passed into updateRelationServiceMap");
            }
            if (oldRoleValue == null) {
                throw new IllegalArgumentException("Null list of role Values passed into updateRelationServiceMap");
            }
            RelationService.this.updateRoleMap(relationId, role, oldRoleValue);
        }
    }
}

