/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidApplicationException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import mx4j.ImplementationException;
import mx4j.loading.ClassLoaderObjectInputStream;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.server.BaseClassLoaderRepository;
import mx4j.server.DefaultClassLoaderRepository;
import mx4j.server.DefaultMBeanRepository;
import mx4j.server.MBeanIntrospector;
import mx4j.server.MBeanMetaData;
import mx4j.server.MBeanRepository;
import mx4j.server.interceptor.ContextClassLoaderMBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptor;
import mx4j.server.interceptor.MBeanServerInterceptorConfigurator;
import mx4j.server.interceptor.NotificationListenerMBeanServerInterceptor;
import mx4j.server.interceptor.SecurityMBeanServerInterceptor;
import mx4j.util.Utils;

public class MBeanServerImpl
implements MBeanServer {
    private String m_defaultDomain;
    private MBeanRepository m_repository;
    private MBeanServerDelegate m_delegate;
    private ObjectName m_delegateName;
    private MBeanIntrospector m_introspector;
    private MBeanServerInterceptorConfigurator m_invoker;
    private long m_notifications;
    private BaseClassLoaderRepository m_classLoaderRepository;
    private static final String[] EMPTY_PARAMS = new String[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static BaseClassLoaderRepository m_staticClassLoaderRepository = new DefaultClassLoaderRepository();
    static /* synthetic */ Class class$mx4j$server$MBeanServerImpl;

    public MBeanServerImpl(String defaultDomain) {
        SecurityManager sm;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Creating MBeanServer instance...");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Checking permission to create MBeanServer...");
            }
            sm.checkPermission(new MBeanServerPermission("newMBeanServer"));
        }
        if (defaultDomain == null) {
            defaultDomain = "";
        }
        this.m_defaultDomain = defaultDomain;
        if (logger.isEnabledFor(0)) {
            logger.trace("MBeanServer default domain is: '" + this.m_defaultDomain + "'");
        }
        this.m_repository = this.createMBeanRepository();
        this.m_classLoaderRepository = this.createClassLoaderRepository();
        this.m_introspector = new MBeanIntrospector();
        try {
            this.m_delegateName = new ObjectName("JMImplementation", "type", "MBeanServerDelegate");
        }
        catch (MalformedObjectNameException ignored) {
            // empty catch block
        }
        this.m_delegate = new MBeanServerDelegate();
        try {
            ReservedObjectName invokerName = new ReservedObjectName("JMImplementation:type=MBeanServerInterceptorConfigurator");
            this.m_invoker = new MBeanServerInterceptorConfigurator(this);
            this.registerMBean(this.m_invoker, invokerName);
            this.m_invoker.registerInterceptor(new ContextClassLoaderMBeanServerInterceptor(), new ReservedObjectName("JMImplementation", "interceptor", "contextclassloader"));
            this.m_invoker.registerInterceptor(new NotificationListenerMBeanServerInterceptor(), new ReservedObjectName("JMImplementation", "interceptor", "notificationwrapper"));
            this.m_invoker.registerInterceptor(new SecurityMBeanServerInterceptor(), new ReservedObjectName("JMImplementation", "interceptor", "security"));
            this.m_invoker.start();
        }
        catch (Exception x) {
            logger.error("MBeanServerInterceptorConfigurator cannot be registered", x);
            throw new ImplementationException();
        }
        try {
            ReservedObjectName delegateName = new ReservedObjectName("JMImplementation", "type", "MBeanServerDelegate");
            this.registerMBean(this.m_delegate, delegateName);
        }
        catch (Exception x) {
            logger.error("MBeanServerDelegate cannot be registered", x);
            throw new ImplementationException();
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("MBeanServer instance created successfully");
        }
    }

    public static BaseClassLoaderRepository getStaticClassLoaderRepository() {
        return m_staticClassLoaderRepository;
    }

    public BaseClassLoaderRepository getClassLoaderRepository() {
        return this.m_classLoaderRepository;
    }

    private MBeanServerInterceptor getHeadInterceptor() {
        MBeanServerInterceptorConfigurator mBeanServerInterceptorConfigurator = this.m_invoker;
        synchronized (mBeanServerInterceptorConfigurator) {
            MBeanServerInterceptor interceptor = null;
            while ((interceptor = this.m_invoker.getHeadInterceptor()) == null) {
                try {
                    this.m_invoker.wait();
                }
                catch (InterruptedException x) {
                    break;
                }
            }
            MBeanServerInterceptor mBeanServerInterceptor = interceptor;
            return mBeanServerInterceptor;
        }
    }

    private Logger getLogger() {
        return Log.getLogger("mx4j.mbeanserver.implementation");
    }

    private MBeanRepository createMBeanRepository() {
        block6: {
            String value;
            Logger logger = this.getLogger();
            String property = "mx4j.mbeanserver.repository";
            if (logger.isEnabledFor(0)) {
                logger.trace("Checking for system property mx4j.mbeanserver.repository");
            }
            if ((value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("mx4j.mbeanserver.repository");
                }
            })) != null) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Property found for custom MBeanServer registry; class is: " + value);
                }
                try {
                    MBeanRepository registry = (MBeanRepository)Thread.currentThread().getContextClassLoader().loadClass(value).newInstance();
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Custom MBeanServer registry created successfully");
                    }
                    return registry;
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(0)) break block6;
                    logger.trace("Custom MBeanServer registry could not be created", x);
                }
            }
        }
        return new DefaultMBeanRepository();
    }

    private BaseClassLoaderRepository createClassLoaderRepository() {
        block6: {
            String value;
            Logger logger = this.getLogger();
            String property = "mx4j.mbeanserver.classloader.repository";
            if (logger.isEnabledFor(0)) {
                logger.trace("Checking for system property mx4j.mbeanserver.classloader.repository");
            }
            if ((value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("mx4j.mbeanserver.classloader.repository");
                }
            })) != null) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Property found for custom ClassLoaderRepository; class is: " + value);
                }
                try {
                    BaseClassLoaderRepository repository = (BaseClassLoaderRepository)Thread.currentThread().getContextClassLoader().loadClass(value).newInstance();
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Custom ClassLoaderRepository created successfully");
                    }
                    return repository;
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(0)) break block6;
                    logger.trace("Custom ClassLoaderRepository could not be created", x);
                }
            }
        }
        return new DefaultClassLoaderRepository();
    }

    private MBeanRepository getMBeanRepository() {
        return this.m_repository;
    }

    private MBeanMetaData findMBeanMetaData(ObjectName objectName) throws InstanceNotFoundException {
        MBeanMetaData metadata = null;
        if (objectName != null) {
            MBeanRepository repository;
            objectName = this.normalizeObjectName(objectName);
            MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
            synchronized (mBeanRepository) {
                metadata = repository.get(objectName);
            }
        }
        if (metadata == null) {
            throw new InstanceNotFoundException("MBeanServer cannot find MBean with ObjectName " + objectName);
        }
        return metadata;
    }

    public void addNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Object mbean = this.findMBeanMetaData((ObjectName)listener).mbean;
        if (!(mbean instanceof NotificationListener)) {
            throw new InstanceNotFoundException("ObjectName " + listener + " is not a NotificationListener");
        }
        this.addNotificationListener(observed, (NotificationListener)mbean, filter, handback);
    }

    public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(observed);
        Object mbean = metadata.mbean;
        if (!(mbean instanceof NotificationBroadcaster)) {
            throw new InstanceNotFoundException("ObjectName " + observed + " is not a NotificationBroadcaster");
        }
        this.addNotificationListenerImpl(metadata, listener, filter, handback);
    }

    private void addNotificationListenerImpl(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.getHeadInterceptor().addNotificationListener(metadata, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Object mbean = this.findMBeanMetaData((ObjectName)listener).mbean;
        if (!(mbean instanceof NotificationListener)) {
            throw new InstanceNotFoundException("ObjectName " + listener + " is not a NotificationListener");
        }
        this.removeNotificationListener(observed, (NotificationListener)mbean);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("NotificationListener cannot be null");
        }
        MBeanMetaData metadata = this.findMBeanMetaData(observed);
        Object mbean = metadata.mbean;
        if (!(mbean instanceof NotificationBroadcaster)) {
            throw new InstanceNotFoundException("ObjectName " + observed + " is not a NotificationBroadcaster");
        }
        this.removeNotificationListenerImpl(metadata, listener, null, null);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        Object mbean = this.findMBeanMetaData((ObjectName)listener).mbean;
        if (!(mbean instanceof NotificationListener)) {
            throw new InstanceNotFoundException("ObjectName " + listener + " is not a NotificationListener");
        }
        this.removeNotificationListener(observed, (NotificationListener)mbean, filter, handback);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("NotificationListener cannot be null");
        }
        MBeanMetaData metadata = this.findMBeanMetaData(observed);
        Object mbean = metadata.mbean;
        if (!(mbean instanceof NotificationBroadcaster)) {
            throw new InstanceNotFoundException("ObjectName " + observed + " is not a NotificationBroadcaster");
        }
        this.removeNotificationListenerImpl(metadata, listener, filter, handback);
    }

    private void removeNotificationListenerImpl(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.getHeadInterceptor().removeNotificationListener(metadata, listener, filter, handback);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiate(className, null, null);
    }

    public Object instantiate(String className, Object[] args, String[] parameters) throws ReflectionException, MBeanException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name cannot be null or empty"));
        }
        try {
            Class cls = this.getClassLoaderRepository().loadClass(className);
            return this.instantiateImpl((String)className, (ClassLoader)cls.getClassLoader(), (String[])parameters, (Object[])args).mbean;
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(className, loaderName, null, null);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name cannot be null or empty"));
        }
        if (loaderName != null && loaderName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName for the ClassLoader cannot be a pattern ObjectName"));
        }
        ClassLoader cl = this.findClassLoader(loaderName);
        return this.instantiateImpl((String)className, (ClassLoader)cl, (String[])parameters, (Object[])args).mbean;
    }

    private ClassLoader findClassLoader(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl != null) {
                return cl;
            }
            return ClassLoader.getSystemClassLoader();
        }
        Object mbean = this.findMBeanMetaData((ObjectName)name).mbean;
        if (!(mbean instanceof ClassLoader)) {
            throw new InstanceNotFoundException(name.toString());
        }
        return (ClassLoader)mbean;
    }

    private MBeanMetaData instantiateImpl(String className, ClassLoader classloader, String[] params, Object[] args) throws ReflectionException, MBeanException {
        if (params == null) {
            params = EMPTY_PARAMS;
        }
        if (args == null) {
            args = EMPTY_ARGS;
        }
        MBeanMetaData metadata = new MBeanMetaData();
        metadata.classloader = classloader;
        this.getHeadInterceptor().instantiate(metadata, className, params, args);
        return metadata;
    }

    public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(className, objectName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            Class cls = this.getClassLoaderRepository().loadClass(className);
            MBeanMetaData metadata = this.instantiateImpl(className, cls.getClassLoader(), parameters, args);
            metadata.name = objectName;
            this.registerImpl(metadata);
            return metadata.instance;
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, objectName, loaderName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ClassLoader cl = this.findClassLoader(loaderName);
        MBeanMetaData metadata = this.instantiateImpl(className, cl, parameters, args);
        metadata.name = objectName;
        this.registerImpl(metadata);
        return metadata.instance;
    }

    public ObjectInstance registerMBean(Object mbean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (mbean == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean cannot be null"));
        }
        MBeanMetaData metadata = new MBeanMetaData();
        metadata.mbean = mbean;
        ClassLoader cl = mbean.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        metadata.classloader = cl;
        metadata.name = objectName;
        this.registerImpl(metadata);
        return metadata.instance;
    }

    private void registerImpl(MBeanMetaData metadata) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.m_introspector.introspect(metadata);
        if (!this.m_introspector.isMBeanCompliant(metadata)) {
            throw new NotCompliantMBeanException("MBean is not compliant");
        }
        boolean invokeRegistration = metadata.mbean instanceof MBeanRegistration;
        MBeanRepository mBeanRepository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            if (invokeRegistration) {
                this.getHeadInterceptor().registration(metadata, 1);
            }
            try {
                this.register(metadata);
                if (invokeRegistration) {
                    this.getHeadInterceptor().registration(metadata, 2);
                }
            }
            catch (Throwable x) {
                if (invokeRegistration) {
                    try {
                        this.getHeadInterceptor().registration(metadata, 3);
                    }
                    catch (MBeanRegistrationException ignored) {
                        // empty catch block
                    }
                }
                if (x instanceof InstanceAlreadyExistsException) {
                    throw (InstanceAlreadyExistsException)x;
                }
                if (x instanceof MBeanRegistrationException) {
                    throw (MBeanRegistrationException)x;
                }
                if (x instanceof Exception) {
                    throw new MBeanRegistrationException((Exception)x);
                }
                if (x instanceof Error) {
                    throw new MBeanRegistrationException(new RuntimeErrorException((Error)x));
                }
                throw new ImplementationException();
            }
            if (metadata.mbean instanceof ClassLoader) {
                this.getClassLoaderRepository().addClassLoader((ClassLoader)metadata.mbean);
                MBeanServerImpl.getStaticClassLoaderRepository().addClassLoader((ClassLoader)metadata.mbean);
            }
            metadata.instance = new ObjectInstance(metadata.name, metadata.info.getClassName());
        }
    }

    private void register(MBeanMetaData metadata) throws InstanceAlreadyExistsException {
        MBeanRepository repository;
        metadata.name = this.normalizeObjectName(metadata.name);
        ObjectName objectName = metadata.name;
        if (objectName == null || objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null or a pattern ObjectName"));
        }
        if (objectName.getDomain().equals("JMImplementation") && !(objectName instanceof ReservedObjectName)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Domain 'JMImplementation' is reserved for the JMX Agent"));
        }
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            if (repository.get(objectName) != null) {
                throw new InstanceAlreadyExistsException(objectName.toString());
            }
            repository.put(objectName, metadata);
        }
        this.notify(objectName, "JMX.mbean.registered");
    }

    private void notify(ObjectName objectName, String notificationType) {
        long sequenceNumber = 0L;
        Class clazz = class$mx4j$server$MBeanServerImpl == null ? (class$mx4j$server$MBeanServerImpl = MBeanServerImpl.class$("mx4j.server.MBeanServerImpl")) : class$mx4j$server$MBeanServerImpl;
        synchronized (clazz) {
            sequenceNumber = this.m_notifications++;
        }
        this.m_delegate.sendNotification(new MBeanServerNotification(notificationType, (Object)this.m_delegateName, sequenceNumber, objectName));
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (objectName == null || objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName cannot be null or a pattern ObjectName"));
        }
        if (objectName.getDomain().equals("JMImplementation")) {
            throw new MBeanRegistrationException(new RuntimeOperationsException(new IllegalArgumentException("Domain 'JMImplementation' is reserved for the JMX Agent")));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        try {
            boolean invokeRegistration = metadata.mbean instanceof MBeanRegistration;
            if (invokeRegistration) {
                this.getHeadInterceptor().registration(metadata, 4);
            }
            this.unregister(metadata);
            if (invokeRegistration) {
                this.getHeadInterceptor().registration(metadata, 5);
            }
            if (metadata.mbean instanceof ClassLoader) {
                this.getClassLoaderRepository().removeClassLoader((ClassLoader)metadata.mbean);
                MBeanServerImpl.getStaticClassLoaderRepository().removeClassLoader((ClassLoader)metadata.mbean);
            }
        }
        catch (MBeanRegistrationException x) {
            throw x;
        }
        catch (Exception x) {
            throw new MBeanRegistrationException(x);
        }
        catch (Error x) {
            throw new MBeanRegistrationException(new RuntimeErrorException(x));
        }
    }

    private void unregister(MBeanMetaData metadata) {
        MBeanRepository repository;
        ObjectName objectName = metadata.name;
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            repository.remove(objectName);
        }
        this.notify(objectName, "JMX.mbean.unregistered");
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] bytes) throws InstanceNotFoundException, OperationsException, ReflectionException {
        ClassLoader cl = this.findClassLoader(loaderName);
        return this.deserializeImpl(cl, bytes);
    }

    public ObjectInputStream deserialize(String className, byte[] bytes) throws OperationsException, ReflectionException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid class name"));
        }
        Class cls = null;
        try {
            cls = this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException x) {
            try {
                cls = this.getClassLoaderRepository().loadClass(className);
            }
            catch (ClassNotFoundException xx) {
                throw new ReflectionException(xx);
            }
        }
        return this.deserializeImpl(cls.getClassLoader(), bytes);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] bytes) throws InstanceNotFoundException, OperationsException {
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return this.deserializeImpl(metadata.classloader, bytes);
    }

    private ObjectInputStream deserializeImpl(ClassLoader classloader, byte[] bytes) throws OperationsException {
        if (bytes == null || bytes.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid bytes"));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            return new ClassLoaderObjectInputStream(bais, classloader);
        }
        catch (IOException x) {
            throw new OperationsException(x.toString());
        }
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        if (attribute == null || attribute.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return this.getHeadInterceptor().getAttribute(metadata, attribute);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null || attribute.getName().trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        this.getHeadInterceptor().setAttribute(metadata, attribute);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        if (attributes == null || attributes.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute list"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return this.getHeadInterceptor().getAttributes(metadata, attributes);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid attribute list"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return this.getHeadInterceptor().setAttributes(metadata, attributes);
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (methodName == null || methodName.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid operation name"));
        }
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if (parameters == null) {
            parameters = EMPTY_PARAMS;
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return this.getHeadInterceptor().invoke(metadata, methodName, parameters, args);
    }

    public String getDefaultDomain() {
        return this.m_defaultDomain;
    }

    public Integer getMBeanCount() {
        MBeanRepository repository;
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            Integer n = new Integer(repository.size());
            return n;
        }
    }

    public boolean isRegistered(ObjectName objectName) {
        try {
            return this.findMBeanMetaData(objectName) != null;
        }
        catch (InstanceNotFoundException x) {
            return false;
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        if (metadata.dynamic) {
            MBeanInfo info;
            metadata.info = info = this.getHeadInterceptor().getMBeanInfo(metadata);
        }
        return (MBeanInfo)metadata.info.clone();
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        return metadata.instance;
    }

    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException {
        if (className == null || className.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid class name"));
        }
        MBeanMetaData metadata = this.findMBeanMetaData(objectName);
        try {
            Class<?> cls = metadata.classloader.loadClass(className);
            return cls.isInstance(metadata.mbean);
        }
        catch (ClassNotFoundException x) {
            return false;
        }
    }

    public Set queryMBeans(ObjectName patternName, QueryExp filter) {
        Set match = this.queryNames(patternName, filter);
        HashSet<ObjectInstance> set = new HashSet<ObjectInstance>();
        Iterator i = match.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            try {
                MBeanMetaData metadata = this.findMBeanMetaData(name);
                set.add(metadata.instance);
            }
            catch (InstanceNotFoundException ignored) {
                // empty catch block
            }
        }
        return set;
    }

    public Set queryNames(ObjectName patternName, QueryExp filter) {
        Set scope = this.findMBeansByPattern(patternName);
        Set match = this.filterMBeans(scope, filter);
        return match;
    }

    private Set findMBeansByPattern(ObjectName pattern) {
        MBeanRepository repository;
        if (pattern == null) {
            try {
                pattern = new ObjectName("*:*");
            }
            catch (MalformedObjectNameException ignored) {
                // empty catch block
            }
        }
        pattern = this.normalizeObjectName(pattern);
        String patternDomain = pattern.getDomain();
        Hashtable patternProps = pattern.getKeyPropertyList();
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        MBeanRepository mBeanRepository = repository = this.getMBeanRepository();
        synchronized (mBeanRepository) {
            Iterator i = repository.iterator();
            while (i.hasNext()) {
                MBeanMetaData metadata = (MBeanMetaData)i.next();
                ObjectName name = metadata.name;
                Hashtable props = name.getKeyPropertyList();
                String domain = name.getDomain();
                if (!Utils.wildcardMatch(patternDomain, domain)) continue;
                if (pattern.isPropertyPattern()) {
                    if (patternProps.size() == 0) {
                        set.add(name);
                        continue;
                    }
                    boolean found = true;
                    Iterator j = patternProps.entrySet().iterator();
                    while (j.hasNext()) {
                        Map.Entry entry = j.next();
                        Object patternKey = entry.getKey();
                        Object patternValue = entry.getValue();
                        if (patternKey.equals("*")) continue;
                        if (!props.containsKey(patternKey)) {
                            found = false;
                            break;
                        }
                        Object value = props.get(patternKey);
                        if (value == null && patternValue == null || value != null && value.equals(patternValue)) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    set.add(name);
                    continue;
                }
                if (!props.entrySet().equals(patternProps.entrySet())) continue;
                set.add(name);
            }
        }
        return set;
    }

    private Set filterMBeans(Set scope, QueryExp filter) {
        if (filter == null) {
            return scope;
        }
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        Iterator i = scope.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            filter.setMBeanServer(this);
            try {
                if (!filter.apply(name)) continue;
                set.add(name);
            }
            catch (BadStringOperationException ignored) {
            }
            catch (BadBinaryOpValueExpException ignored) {
            }
            catch (BadAttributeValueExpException x) {
            }
            catch (InvalidApplicationException x) {
            }
            catch (SecurityException x) {
                // empty catch block
            }
        }
        return set;
    }

    private ObjectName normalizeObjectName(ObjectName name) {
        if (name == null) {
            return null;
        }
        String defaultDomain = this.getDefaultDomain();
        String domain = name.getDomain();
        if (domain.length() == 0 && defaultDomain.length() > 0) {
            StringBuffer buffer = new StringBuffer(this.getDefaultDomain()).append(":").append(name.getKeyPropertyListString());
            if (name.isPropertyPattern()) {
                if (name.getKeyPropertyList().size() > 0) {
                    buffer.append(",*");
                } else {
                    buffer.append("*");
                }
            }
            try {
                name = new ObjectName(buffer.toString());
            }
            catch (MalformedObjectNameException ignored) {
                // empty catch block
            }
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ReservedObjectName
    extends ObjectName {
        private ReservedObjectName(String name) throws MalformedObjectNameException {
            super(name);
        }

        private ReservedObjectName(String domain, String key, String value) throws MalformedObjectNameException {
            super(domain, key, value);
        }
    }
}

