/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import mx4j.ImplementationException;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.server.MBeanInvoker;
import mx4j.server.MBeanMetaData;
import mx4j.util.MethodTernaryTree;
import mx4j.util.Utils;

public class ReflectedMBeanInvoker
implements MBeanInvoker {
    private static final String[] EMPTY_PARAMS = new String[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private HashMap m_attributeCache = new HashMap();
    private MethodTernaryTree m_operationCache = new MethodTernaryTree();
    private MethodTernaryTree m_methodCache = new MethodTernaryTree();

    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        MBeanOperationInfo oper;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("invoke for standard MBean");
        }
        if ((oper = this.getStandardOperationInfo(metadata, method, params)) != null) {
            try {
                return this.invokeImpl(metadata, method, params, args);
            }
            catch (IllegalArgumentException x) {
                throw new RuntimeOperationsException(x);
            }
        }
        throw new ReflectionException(new NoSuchMethodException("Method " + method + " does not belong to the management interface"));
    }

    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        MBeanAttributeInfo attr;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("getAttribute for standard MBean");
        }
        if ((attr = this.getStandardAttributeInfo(metadata, attribute, false)) != null) {
            String prefix = attr.isIs() ? "is" : "get";
            try {
                return this.invokeImpl(metadata, prefix + attribute, EMPTY_PARAMS, EMPTY_ARGS);
            }
            catch (IllegalArgumentException x) {
                throw new ImplementationException();
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        String name;
        MBeanAttributeInfo attr;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("setAttribute for standard MBean");
        }
        if ((attr = this.getStandardAttributeInfo(metadata, name = attribute.getName(), true)) != null) {
            try {
                this.invokeImpl(metadata, "set" + name, new String[]{attr.getType()}, new Object[]{attribute.getValue()});
            }
            catch (IllegalArgumentException x) {
                throw new InvalidAttributeValueException("Invalid value for attribute " + attribute.getName() + ": " + attribute.getValue());
            }
        } else {
            throw new AttributeNotFoundException(name);
        }
    }

    protected Object invokeImpl(MBeanMetaData metadata, String method, String[] signature, Object[] args) throws ReflectionException, MBeanException, IllegalArgumentException {
        Method m = this.getStandardManagementMethod(metadata, method, signature);
        try {
            return m.invoke(metadata.mbean, args);
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
            if (t instanceof JMRuntimeException) {
                throw (JMRuntimeException)t;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            throw new MBeanException((Exception)t);
        }
    }

    private MBeanAttributeInfo getStandardAttributeInfo(MBeanMetaData metadata, String attribute, boolean isWritable) {
        MBeanAttributeInfo attr = (MBeanAttributeInfo)this.m_attributeCache.get(attribute);
        if (attr != null) {
            if (isWritable ? attr.isWritable() : attr.isReadable()) {
                return attr;
            }
        } else {
            MBeanInfo info = metadata.info;
            MBeanAttributeInfo[] attrs = info.getAttributes();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.length) {
                    attr = attrs[i];
                    String name = attr.getName();
                    if (attribute.equals(name)) {
                        this.m_attributeCache.put(attribute, attr);
                        if (isWritable ? attr.isWritable() : attr.isReadable()) {
                            return attr;
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private MBeanOperationInfo getStandardOperationInfo(MBeanMetaData metadata, String method, String[] signature) {
        MBeanOperationInfo oper = (MBeanOperationInfo)this.m_operationCache.get(method, signature);
        if (oper != null) {
            return oper;
        }
        MBeanInfo info = metadata.info;
        MBeanOperationInfo[] opers = info.getOperations();
        if (opers != null) {
            int i = 0;
            while (i < opers.length) {
                MBeanParameterInfo[] params;
                oper = opers[i];
                String name = oper.getName();
                if (method.equals(name) && signature.length == (params = oper.getSignature()).length) {
                    boolean match = true;
                    int j = 0;
                    while (j < params.length) {
                        MBeanParameterInfo param = params[j];
                        if (!signature[j].equals(param.getType())) {
                            match = false;
                            break;
                        }
                        ++j;
                    }
                    if (match) {
                        this.m_operationCache.put(method, signature, oper);
                        return oper;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private Method getStandardManagementMethod(MBeanMetaData metadata, String name, String[] signature) throws ReflectionException {
        Method method = (Method)this.m_methodCache.get(name, signature);
        if (method != null) {
            return method;
        }
        try {
            Class[] params = Utils.loadClasses(metadata.classloader, signature);
            method = metadata.mbean.getClass().getMethod(name, params);
            this.m_methodCache.put(name, signature, method);
            return method;
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (NoSuchMethodException x) {
            throw new ReflectionException(x);
        }
    }

    protected Logger getLogger() {
        return Log.getLogger("mx4j.mbeanserver.mbeaninvoker.reflected");
    }
}

