/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import mx4j.ImplementationException;
import mx4j.log.Logger;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;
import mx4j.server.interceptor.InvokerMBeanServerInterceptorMBean;
import mx4j.util.Utils;

public class InvokerMBeanServerInterceptor
extends DefaultMBeanServerInterceptor
implements InvokerMBeanServerInterceptorMBean {
    private MBeanServer m_server;

    public InvokerMBeanServerInterceptor(MBeanServer server) {
        this.m_server = server;
    }

    public String getType() {
        return "invoker";
    }

    public boolean isEnabled() {
        return true;
    }

    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        ((NotificationBroadcaster)metadata.mbean).addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        ((NotificationBroadcaster)metadata.mbean).removeNotificationListener(listener);
    }

    public void instantiate(MBeanMetaData metadata, String className, String[] params, Object[] args) throws ReflectionException, MBeanException {
        try {
            Class<?> cls = metadata.classloader.loadClass(className);
            Class[] signature = Utils.loadClasses(metadata.classloader, params);
            Constructor<?> ctor = cls.getConstructor(signature);
            metadata.mbean = ctor.newInstance(args);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (NoSuchMethodException x) {
            throw new ReflectionException(x);
        }
        catch (InstantiationException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalArgumentException x) {
            throw new ReflectionException(x);
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            throw new MBeanException((Exception)t);
        }
    }

    public void registration(MBeanMetaData metadata, int operation) throws MBeanRegistrationException {
        MBeanRegistration registrable = (MBeanRegistration)metadata.mbean;
        try {
            switch (operation) {
                case 1: {
                    ObjectName objName = registrable.preRegister(this.m_server, metadata.name);
                    if (objName != null) {
                        metadata.name = objName;
                    }
                    break;
                }
                case 2: {
                    registrable.postRegister(Boolean.TRUE);
                    break;
                }
                case 3: {
                    registrable.postRegister(Boolean.FALSE);
                    break;
                }
                case 4: {
                    registrable.preDeregister();
                    break;
                }
                case 5: {
                    registrable.postDeregister();
                    break;
                }
                default: {
                    throw new ImplementationException();
                }
            }
        }
        catch (Exception x) {
            if (x instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)x;
            }
            throw new MBeanRegistrationException(x);
        }
    }

    public MBeanInfo getMBeanInfo(MBeanMetaData metadata) {
        return ((DynamicMBean)metadata.mbean).getMBeanInfo();
    }

    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("invoke for dynamic MBean");
            }
            try {
                return ((DynamicMBean)metadata.mbean).invoke(method, args, params);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("invoke for standard MBean");
        }
        return metadata.invoker.invoke(metadata, method, params, args);
    }

    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("getAttribute for dynamic MBean");
            }
            try {
                return ((DynamicMBean)metadata.mbean).getAttribute(attribute);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("getAttribute for standard MBean");
        }
        return metadata.invoker.getAttribute(metadata, attribute);
    }

    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("setAttribute for dynamic MBean");
            }
            try {
                ((DynamicMBean)metadata.mbean).setAttribute(attribute);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        } else {
            if (logger.isEnabledFor(0)) {
                logger.trace("setAttribute for standard MBean");
            }
            metadata.invoker.setAttribute(metadata, attribute);
        }
    }

    public AttributeList getAttributes(MBeanMetaData metadata, String[] attributes) {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("getAttributes for dynamic MBean");
            }
            try {
                return ((DynamicMBean)metadata.mbean).getAttributes(attributes);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("getAttributes for standard MBean");
        }
        AttributeList list = new AttributeList();
        int i = 0;
        while (i < attributes.length) {
            block10: {
                String name = attributes[i];
                try {
                    Object value = this.getAttribute(metadata, name);
                    Attribute attr = new Attribute(name, value);
                    list.add(attr);
                }
                catch (Exception ignored) {
                    if (!logger.isEnabledFor(20)) break block10;
                    logger.info("Exception caught from getAttribute, ignoring attribute " + name);
                }
            }
            ++i;
        }
        return list;
    }

    public AttributeList setAttributes(MBeanMetaData metadata, AttributeList attributes) {
        Logger logger = this.getLogger();
        if (metadata.dynamic) {
            if (logger.isEnabledFor(0)) {
                logger.trace("setAttributes for dynamic MBean");
            }
            try {
                return ((DynamicMBean)metadata.mbean).setAttributes(attributes);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("setAttributes for standard MBean");
        }
        AttributeList list = new AttributeList();
        int i = 0;
        while (i < attributes.size()) {
            block10: {
                Attribute attr = (Attribute)attributes.get(i);
                try {
                    this.setAttribute(metadata, attr);
                    list.add(attr);
                }
                catch (Exception ignored) {
                    if (!logger.isEnabledFor(20)) break block10;
                    logger.info("Exception caught from setAttribute, ignoring attribute " + attr);
                }
            }
            ++i;
        }
        return list;
    }
}

