/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.warp.WarpConfigurationHandler;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpLogger;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.connector.warp.WarpRequestHandler;

public class WarpConnection
implements LifecycleListener,
Runnable {
    private InputStream input = null;
    private OutputStream output = null;
    private boolean started = false;
    private Thread thread = null;
    private WarpLogger logger = new WarpLogger(this);
    private Socket socket = null;
    private WarpConnector connector = null;

    public WarpConnector getConnector() {
        return this.connector;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("stop".equals(lifecycleEvent.getType())) {
            this.stop();
        }
    }

    public void recv(WarpPacket warpPacket) throws IOException {
        block2: {
            int n;
            int n2;
            int n3 = this.input.read();
            if ((n3 | (n2 = this.input.read()) | (n = this.input.read())) == -1) {
                throw new IOException("Premature packet header end");
            }
            warpPacket.reset();
            warpPacket.setType(n3 & 0xFF);
            warpPacket.size = (n2 & 0xFF) << 8 | n & 0xFF;
            if (warpPacket.size <= 0) break block2;
            int n4 = 0;
            int n5 = 0;
            do {
                if ((n5 = this.input.read(warpPacket.buffer, n4, warpPacket.size - n4)) != -1) continue;
                throw new IOException("Premature packet payload end");
            } while ((n4 += n5) != warpPacket.size);
        }
    }

    public void run() {
        WarpPacket warpPacket = new WarpPacket();
        try {
            try {
                this.input = this.socket.getInputStream();
                this.output = this.socket.getOutputStream();
                if (!new WarpConfigurationHandler().handle(this, warpPacket)) {
                    this.logger.log("Configuration handler returned false");
                    this.stop();
                }
                WarpRequestHandler warpRequestHandler = new WarpRequestHandler();
                while (warpRequestHandler.handle(this, warpPacket)) {
                }
            }
            catch (IOException iOException) {
                this.logger.log("Exception on socket", iOException);
            }
            Object var3_4 = null;
            this.stop();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.stop();
            throw throwable;
        }
    }

    public void send(WarpPacket warpPacket) throws IOException {
        this.output.write(warpPacket.getType() & 0xFF);
        this.output.write(warpPacket.size >> 8 & 0xFF);
        this.output.write(warpPacket.size & 0xFF);
        this.output.write(warpPacket.buffer, 0, warpPacket.size);
        this.output.flush();
        warpPacket.reset();
    }

    public void setConnector(WarpConnector warpConnector) {
        this.connector = warpConnector;
        this.logger.setContainer(warpConnector.getContainer());
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void start() {
        WarpConnection warpConnection = this;
        synchronized (warpConnection) {
            this.started = true;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        WarpConnection warpConnection = this;
        synchronized (warpConnection) {
            try {
                this.started = false;
                this.socket.close();
                this.getConnector().removeLifecycleListener(this);
            }
            catch (IOException iOException) {
                this.logger.log("Cannot close socket", iOException);
            }
        }
    }
}

