/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.JarFile;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.Role;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Session;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;

public class ManagerServlet
extends HttpServlet
implements ContainerServlet {
    protected Context context = null;
    protected int debug = 1;
    protected File deployed = null;
    protected Deployer deployer = null;
    protected javax.naming.Context global = null;
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.servlets");
    protected Wrapper wrapper = null;

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.deployer = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.deployer = (Deployer)this.context.getParent();
        }
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getAttribute("org.apache.catalina.INVOKED") != null) {
            throw new UnavailableException(sm.getString("managerServlet.cannotInvoke"));
        }
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String config = request.getParameter("config");
        String path = request.getParameter("path");
        String type = request.getParameter("type");
        String war = request.getParameter("war");
        response.setContentType("text/plain");
        Locale locale = Locale.getDefault();
        response.setLocale(locale);
        PrintWriter writer = response.getWriter();
        if (command == null) {
            writer.println(sm.getString("managerServlet.noCommand"));
        } else if (command.equals("/install")) {
            this.install(writer, config, path, war);
        } else if (command.equals("/list")) {
            this.list(writer);
        } else if (command.equals("/reload")) {
            this.reload(writer, path);
        } else if (command.equals("/remove")) {
            this.remove(writer, path);
        } else if (command.equals("/resources")) {
            this.resources(writer, type);
        } else if (command.equals("/roles")) {
            this.roles(writer);
        } else if (command.equals("/sessions")) {
            this.sessions(writer, path);
        } else if (command.equals("/start")) {
            this.start(writer, path);
        } else if (command.equals("/stop")) {
            this.stop(writer, path);
        } else if (command.equals("/undeploy")) {
            this.undeploy(writer, path);
        } else {
            writer.println(sm.getString("managerServlet.unknownCommand", (Object)command));
        }
        writer.flush();
        writer.close();
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getAttribute("org.apache.catalina.INVOKED") != null) {
            throw new UnavailableException(sm.getString("managerServlet.cannotInvoke"));
        }
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String path = request.getParameter("path");
        response.setContentType("text/plain");
        Locale locale = Locale.getDefault();
        response.setLocale(locale);
        PrintWriter writer = response.getWriter();
        if (command == null) {
            writer.println(sm.getString("managerServlet.noCommand"));
        } else if (command.equals("/deploy")) {
            this.deploy(writer, path, request);
        } else {
            writer.println(sm.getString("managerServlet.unknownCommand", (Object)command));
        }
        Server server = ServerFactory.getServer();
        if (server != null && server instanceof StandardServer) {
            try {
                ((StandardServer)server).store();
            }
            catch (Exception e) {
                writer.println(sm.getString("managerServlet.saveFail", (Object)e.getMessage()));
            }
        }
        writer.flush();
        writer.close();
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("managerServlet.noWrapper"));
        }
        String servletName = this.getServletConfig().getServletName();
        if (servletName == null) {
            servletName = "";
        }
        if (servletName.startsWith("org.apache.catalina.INVOKER.")) {
            throw new UnavailableException(sm.getString("managerServlet.cannotInvoke"));
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            // empty catch block
        }
        Server server = ServerFactory.getServer();
        if (server != null && server instanceof StandardServer) {
            this.global = ((StandardServer)server).getGlobalNamingContext();
        }
        this.deployed = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        if (this.debug >= 1) {
            this.log("init: Associated with Deployer '" + this.deployer.getName() + "'");
            if (this.global != null) {
                this.log("init: Global resources are available");
            }
        }
    }

    protected synchronized void deploy(PrintWriter writer, String path, HttpServletRequest request) {
        if (this.debug >= 1) {
            this.log("deploy: Deploying web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", (Object)path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        String basename = null;
        basename = path.equals("") ? "_" : path.substring(1);
        if (this.deployer.findDeployedApp(path) != null) {
            writer.println(sm.getString("managerServlet.alreadyContext", (Object)displayPath));
            return;
        }
        File localWar = new File(this.deployed, basename + ".war");
        if (this.debug >= 2) {
            this.log("Uploading WAR file to " + localWar);
        }
        try {
            this.uploadWar(request, localWar);
        }
        catch (IOException e) {
            this.log("managerServlet.upload[" + displayPath + "]", e);
            writer.println(sm.getString("managerServlet.exception", (Object)e.toString()));
            return;
        }
        File localXml = new File(this.deployed, basename + ".xml");
        if (this.debug >= 2) {
            this.log("Extracting XML file to " + localXml);
        }
        try {
            this.extractXml(localWar, localXml);
        }
        catch (IOException e) {
            this.log("managerServlet.extract[" + displayPath + "]", e);
            writer.println(sm.getString("managerServlet.exception", (Object)e.toString()));
            return;
        }
        try {
            URL warURL = new URL("jar:file:" + localWar.getAbsolutePath() + "!/");
            URL xmlURL = null;
            if (localXml.exists()) {
                xmlURL = new URL("file:" + localXml.getAbsolutePath());
            }
            if (xmlURL != null) {
                this.deployer.install(xmlURL, warURL);
            } else {
                this.deployer.install(path, warURL);
            }
        }
        catch (Throwable t) {
            this.log("ManagerServlet.deploy[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
            localWar.delete();
            localXml.delete();
            return;
        }
        writer.println(sm.getString("managerServlet.installed", (Object)displayPath));
    }

    protected void install(PrintWriter writer, String config, String path, String war) {
        if (this.debug >= 1) {
            if (config != null) {
                if (war != null) {
                    this.log("install: Installing context configuration at '" + config + "' from '" + war + "'");
                } else {
                    this.log("install: Installing context configuration at '" + config + "'");
                }
            } else {
                this.log("install: Installing web application at '" + path + "' from '" + war + "'");
            }
        }
        if (config != null) {
            if (war != null && !war.startsWith("file:") && !war.startsWith("jar:")) {
                writer.println(sm.getString("managerServlet.invalidWar", (Object)war));
                return;
            }
            try {
                if (war == null) {
                    this.deployer.install(new URL(config), null);
                } else {
                    this.deployer.install(new URL(config), new URL(war));
                }
                writer.println(sm.getString("managerServlet.configured", (Object)config));
            }
            catch (Throwable t) {
                this.log("ManagerServlet.configure[" + config + "]", t);
                writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
            }
        } else {
            if (path == null || !path.startsWith("/") && path.equals("")) {
                writer.println(sm.getString("managerServlet.invalidPath", (Object)path));
                return;
            }
            String displayPath = path;
            if ("/".equals(path)) {
                path = "";
            }
            if (war == null || !war.startsWith("file:") && !war.startsWith("jar:")) {
                writer.println(sm.getString("managerServlet.invalidWar", (Object)war));
                return;
            }
            try {
                Context context = this.deployer.findDeployedApp(path);
                if (context != null) {
                    writer.println(sm.getString("managerServlet.alreadyContext", (Object)displayPath));
                    return;
                }
                this.deployer.install(path, new URL(war));
                writer.println(sm.getString("managerServlet.installed", (Object)displayPath));
            }
            catch (Throwable t) {
                this.log("ManagerServlet.install[" + displayPath + "]", t);
                writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
            }
        }
    }

    protected void list(PrintWriter writer) {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.deployer.getName() + "'");
        }
        writer.println(sm.getString("managerServlet.listed", (Object)this.deployer.getName()));
        String[] contextPaths = this.deployer.findDeployedApps();
        int i = 0;
        while (i < contextPaths.length) {
            Context context = this.deployer.findDeployedApp(contextPaths[i]);
            String displayPath = contextPaths[i];
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            if (context != null) {
                if (context.getAvailable()) {
                    writer.println(sm.getString("managerServlet.listitem", (Object)displayPath, (Object)"running", (Object)("" + context.getManager().findSessions().length), (Object)context.getDocBase()));
                } else {
                    writer.println(sm.getString("managerServlet.listitem", (Object)displayPath, (Object)"stopped", (Object)"0", (Object)context.getDocBase()));
                }
            }
            ++i;
        }
    }

    protected void reload(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", (Object)path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", (Object)displayPath));
                return;
            }
            DirContext resources = context.getResources();
            if (resources instanceof ProxyDirContext) {
                resources = ((ProxyDirContext)resources).getDirContext();
            }
            if (resources instanceof WARDirContext) {
                writer.println(sm.getString("managerServlet.noReload", (Object)displayPath));
                return;
            }
            if (context.getPath().equals(this.context.getPath())) {
                writer.println(sm.getString("managerServlet.noSelf"));
                return;
            }
            context.reload();
            writer.println(sm.getString("managerServlet.reloaded", (Object)displayPath));
        }
        catch (Throwable t) {
            this.log("ManagerServlet.reload[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }

    protected void remove(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("remove: Removing web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", (Object)path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", (Object)displayPath));
                return;
            }
            if (context.getPath().equals(this.context.getPath())) {
                writer.println(sm.getString("managerServlet.noSelf"));
                return;
            }
            this.deployer.remove(path);
            writer.println(sm.getString("managerServlet.removed", (Object)displayPath));
        }
        catch (Throwable t) {
            this.log("ManagerServlet.remove[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }

    protected void resources(PrintWriter writer, String type) {
        if (this.debug >= 1) {
            if (type != null) {
                this.log("resources:  Listing resources of type " + type);
            } else {
                this.log("resources:  Listing resources of all types");
            }
        }
        if (this.global == null) {
            writer.println(sm.getString("managerServlet.noGlobal"));
            return;
        }
        if (type != null) {
            writer.println(sm.getString("managerServlet.resourcesType", (Object)type));
        } else {
            writer.println(sm.getString("managerServlet.resourcesAll"));
        }
        Class<?> clazz = null;
        try {
            if (type != null) {
                clazz = Class.forName(type);
            }
        }
        catch (Throwable t) {
            this.log("ManagerServlet.resources[" + type + "]", t);
            writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
            return;
        }
        this.printResources(writer, "", this.global, type, clazz);
    }

    protected void printResources(PrintWriter writer, String prefix, javax.naming.Context namingContext, String type, Class clazz) {
        try {
            NamingEnumeration<Binding> items = namingContext.listBindings("");
            while (items.hasMore()) {
                Binding item = items.next();
                if (item.getObject() instanceof javax.naming.Context) {
                    this.printResources(writer, prefix + item.getName() + "/", (javax.naming.Context)item.getObject(), type, clazz);
                    continue;
                }
                if (clazz != null && !clazz.isInstance(item.getObject())) continue;
                writer.print(prefix + item.getName());
                writer.print(':');
                writer.print(item.getClassName());
                writer.println();
            }
        }
        catch (Throwable t) {
            this.log("ManagerServlet.resources[" + type + "]", t);
            writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }

    protected void roles(PrintWriter writer) {
        if (this.debug >= 1) {
            this.log("roles:  List security roles from user database");
        }
        UserDatabase database = null;
        try {
            InitialContext ic = new InitialContext();
            database = (UserDatabase)ic.lookup("java:comp/env/users");
        }
        catch (NamingException e) {
            writer.println(sm.getString("managerServlet.userDatabaseError"));
            this.log("java:comp/env/users", e);
            return;
        }
        if (database == null) {
            writer.println(sm.getString("managerServlet.userDatabaseMissing"));
            return;
        }
        writer.println(sm.getString("managerServlet.rolesList"));
        Iterator roles = database.getRoles();
        if (roles != null) {
            while (roles.hasNext()) {
                Role role = (Role)roles.next();
                writer.print(role.getRolename());
                writer.print(':');
                if (role.getDescription() != null) {
                    writer.print(role.getDescription());
                }
                writer.println();
            }
        }
    }

    protected void sessions(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("sessions: Session information for web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", (Object)path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", (Object)displayPath));
                return;
            }
            writer.println(sm.getString("managerServlet.sessions", (Object)displayPath));
            writer.println(sm.getString("managerServlet.sessiondefaultmax", (Object)("" + context.getManager().getMaxInactiveInterval() / 60)));
            Session[] sessions = context.getManager().findSessions();
            int[] timeout = new int[60];
            int notimeout = 0;
            int i = 0;
            while (i < sessions.length) {
                int time = sessions[i].getMaxInactiveInterval() / 600;
                if (time < 0) {
                    ++notimeout;
                } else if (time >= timeout.length) {
                    int n = timeout.length - 1;
                    timeout[n] = timeout[n] + 1;
                } else {
                    int n = time;
                    timeout[n] = timeout[n] + 1;
                }
                ++i;
            }
            if (timeout[0] > 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout", (Object)("<10" + timeout[0])));
            }
            int i2 = 1;
            while (i2 < timeout.length - 1) {
                if (timeout[i2] > 0) {
                    writer.println(sm.getString("managerServlet.sessiontimeout", (Object)("" + i2 * 10 + " - <" + (i2 + 1) * 10), (Object)("" + timeout[i2])));
                }
                ++i2;
            }
            if (timeout[timeout.length - 1] > 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout", (Object)(">=" + timeout.length * 10), (Object)("" + timeout[timeout.length - 1])));
            }
            if (notimeout > 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout", (Object)"unlimited", (Object)("" + notimeout)));
            }
        }
        catch (Throwable t) {
            this.log("ManagerServlet.sessions[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }

    protected void start(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("start: Starting web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", (Object)path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", (Object)displayPath));
                return;
            }
            this.deployer.start(path);
            if (context.getAvailable()) {
                writer.println(sm.getString("managerServlet.started", (Object)displayPath));
            } else {
                writer.println(sm.getString("managerServlet.startFailed", (Object)displayPath));
            }
        }
        catch (Throwable t) {
            this.getServletContext().log(sm.getString("managerServlet.startFailed", (Object)displayPath), t);
            writer.println(sm.getString("managerServlet.startFailed", (Object)displayPath));
            writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }

    protected void stop(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", (Object)path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", (Object)displayPath));
                return;
            }
            if (context.getPath().equals(this.context.getPath())) {
                writer.println(sm.getString("managerServlet.noSelf"));
                return;
            }
            this.deployer.stop(path);
            writer.println(sm.getString("managerServlet.stopped", (Object)displayPath));
        }
        catch (Throwable t) {
            this.log("ManagerServlet.stop[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
        }
    }

    protected void undeploy(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("undeploy: Undeploying web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", (Object)path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            String docBasePath;
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", (Object)displayPath));
                return;
            }
            String appBase = null;
            File appBaseDir = null;
            String appBasePath = null;
            if (context.getParent() instanceof Host) {
                appBase = ((Host)context.getParent()).getAppBase();
                appBaseDir = new File(appBase);
                if (!appBaseDir.isAbsolute()) {
                    appBaseDir = new File(System.getProperty("catalina.base"), appBase);
                }
                appBasePath = appBaseDir.getCanonicalPath();
            }
            String deployedPath = this.deployed.getCanonicalPath();
            String docBase = context.getDocBase();
            File docBaseDir = new File(docBase);
            if (!docBaseDir.isAbsolute()) {
                docBaseDir = new File(appBaseDir, docBase);
            }
            if (!(docBasePath = docBaseDir.getCanonicalPath()).startsWith(deployedPath)) {
                writer.println(sm.getString("managerServlet.noDocBase", (Object)displayPath));
                return;
            }
            if (this.debug >= 2) {
                this.log("Undeploying document base " + docBasePath);
            }
            if (context.getPath().equals(this.context.getPath())) {
                writer.println(sm.getString("managerServlet.noSelf"));
                return;
            }
            this.deployer.remove(path);
            if (docBaseDir.isDirectory()) {
                this.undeployDir(docBaseDir);
            } else {
                docBaseDir.delete();
            }
            String docBaseXmlPath = docBasePath.substring(0, docBasePath.length() - 4) + ".xml";
            File docBaseXml = new File(docBaseXmlPath);
            docBaseXml.delete();
            writer.println(sm.getString("managerServlet.undeployed", (Object)displayPath));
        }
        catch (Throwable t) {
            this.log("ManagerServlet.undeploy[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", (Object)t.toString()));
        }
        Server server = ServerFactory.getServer();
        if (server != null && server instanceof StandardServer) {
            try {
                ((StandardServer)server).store();
            }
            catch (Exception e) {
                writer.println(sm.getString("managerServlet.saveFail", (Object)e.getMessage()));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractXml(File war, File xml) throws IOException {
        block32: {
            block33: {
                block30: {
                    block31: {
                        block23: {
                            block28: {
                                block29: {
                                    block21: {
                                        block27: {
                                            block22: {
                                                xml.delete();
                                                jar = null;
                                                entry = null;
                                                istream = null;
                                                ostream = null;
                                                try {
                                                    try {
                                                        jar = new JarFile(war);
                                                        entry = jar.getJarEntry("META-INF/context.xml");
                                                        if (entry == null) {
                                                            var10_7 = null;
                                                            if (ostream == null) break block21;
                                                            break block22;
                                                        }
                                                        istream = jar.getInputStream(entry);
                                                        ostream = new BufferedOutputStream(new FileOutputStream(xml), 1024);
                                                        buffer = new byte[1024];
                                                        while (true) {
                                                            if ((n = istream.read(buffer)) < 0) {
                                                                ostream.flush();
                                                                ostream.close();
                                                                ostream = null;
                                                                istream.close();
                                                                istream = null;
                                                                entry = null;
                                                                jar.close();
                                                                jar = null;
                                                                break block23;
                                                            }
                                                            ostream.write(buffer, 0, n);
                                                        }
                                                    }
                                                    catch (IOException e) {
                                                        xml.delete();
                                                        throw e;
                                                    }
                                                }
                                                catch (Throwable var9_16) {
                                                    var10_9 = null;
                                                    if (ostream != null) {
                                                        try {
                                                            ostream.close();
                                                        }
                                                        catch (Throwable t) {
                                                            // empty catch block
                                                        }
                                                        ostream = null;
                                                    }
                                                    if (istream != null) {
                                                        try {
                                                            istream.close();
                                                        }
                                                        catch (Throwable t) {
                                                            // empty catch block
                                                        }
                                                        istream = null;
                                                    }
                                                    entry = null;
                                                    if (jar == null) throw var9_16;
                                                    try {
                                                        jar.close();
                                                    }
                                                    catch (Throwable t) {
                                                        // empty catch block
                                                    }
                                                    jar = null;
                                                    throw var9_16;
                                                }
                                            }
                                            ** try [egrp 2[TRYBLOCK] [4 : 172->180)] { 
lbl67:
                                            // 1 sources

                                            ostream.close();
                                            break block27;
lbl69:
                                            // 1 sources

                                            catch (Throwable t) {
                                                // empty catch block
                                            }
                                        }
                                        ostream = null;
                                    }
                                    if (istream == null) break block28;
                                    ** try [egrp 3[TRYBLOCK] [5 : 190->198)] { 
lbl76:
                                    // 1 sources

                                    istream.close();
                                    break block29;
lbl78:
                                    // 1 sources

                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                }
                                istream = null;
                            }
                            entry = null;
                            if (jar == null) return;
                            ** try [egrp 4[TRYBLOCK] [6 : 210->217)] { 
lbl86:
                            // 1 sources

                            jar.close();
                            return;
lbl88:
                            // 1 sources

                            catch (Throwable t) {
                                // empty catch block
                            }
                            return;
                        }
                        var10_8 = null;
                        if (ostream == null) break block30;
                        ** try [egrp 2[TRYBLOCK] [4 : 172->180)] { 
lbl95:
                        // 1 sources

                        ostream.close();
                        break block31;
lbl97:
                        // 1 sources

                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    ostream = null;
                }
                if (istream == null) break block32;
                ** try [egrp 3[TRYBLOCK] [5 : 190->198)] { 
lbl104:
                // 1 sources

                istream.close();
                break block33;
lbl106:
                // 1 sources

                catch (Throwable t) {
                    // empty catch block
                }
            }
            istream = null;
        }
        entry = null;
        if (jar == null) return;
        ** try [egrp 4[TRYBLOCK] [6 : 210->217)] { 
lbl114:
        // 1 sources

        jar.close();
        return;
lbl116:
        // 1 sources

        catch (Throwable t) {
            // empty catch block
        }
    }

    protected void undeployDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        int i = 0;
        while (i < files.length) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                this.undeployDir(file);
            } else {
                file.delete();
            }
            ++i;
        }
        dir.delete();
    }

    /*
     * Loose catch block
     */
    protected void uploadWar(HttpServletRequest request, File war) throws IOException {
        block16: {
            Throwable t2;
            FilterOutputStream ostream;
            ServletInputStream istream;
            block13: {
                int n;
                war.delete();
                istream = null;
                ostream = null;
                istream = request.getInputStream();
                ostream = new BufferedOutputStream(new FileOutputStream(war), 1024);
                byte[] buffer = new byte[1024];
                while ((n = istream.read(buffer)) >= 0) {
                    ((BufferedOutputStream)ostream).write(buffer, 0, n);
                }
                ((BufferedOutputStream)ostream).flush();
                ostream.close();
                ostream = null;
                istream.close();
                istream = null;
                Object var8_8 = null;
                if (ostream == null) break block13;
                try {
                    ostream.close();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                ostream = null;
            }
            if (istream == null) break block16;
            try {
                istream.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            istream = null;
            {
                break block16;
                catch (IOException e) {
                    war.delete();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    ostream = null;
                }
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    istream = null;
                }
                throw throwable;
            }
        }
    }
}

