/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.common.SocketAcceptor;
import org.apache.jk.common.SocketConnection;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.tomcat.util.threads.ThreadPool;

public class ChannelSocket
extends JkHandler {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$ChannelSocket == null ? (class$org$apache$jk$common$ChannelSocket = ChannelSocket.class$("org.apache.jk.common.ChannelSocket")) : class$org$apache$jk$common$ChannelSocket));
    int startPort = 8009;
    int maxPort = 8019;
    int port = this.startPort;
    InetAddress inet;
    int serverTimeout;
    boolean tcpNoDelay;
    int linger = 100;
    int socketTimeout;
    long requestCount = 0L;
    static final boolean BUFFER_WRITE = false;
    ThreadPool tp = new ThreadPool();
    ServerSocket sSocket;
    int socketNote = 1;
    int isNote = 2;
    int osNote = 3;
    protected boolean running = true;
    static /* synthetic */ Class class$org$apache$jk$common$ChannelSocket;

    public ThreadPool getThreadPool() {
        return this.tp;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public void setPort(int port) {
        this.startPort = port;
        this.port = port;
        this.maxPort = port + 10;
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setAddress(String inet) {
        try {
            this.inet = InetAddress.getByName(inet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getAddress() {
        if (this.inet != null) {
            return this.inet.toString();
        }
        return null;
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setSoLinger(int i) {
        this.linger = i;
    }

    public int getSoLinger() {
        return this.linger;
    }

    public void setSoTimeout(int i) {
        this.socketTimeout = i;
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public void setMaxPort(int i) {
        this.maxPort = i;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public int getInstanceId() {
        return this.port - this.startPort;
    }

    public void setDaemon(boolean b) {
        this.tp.setDaemon(b);
    }

    public boolean getDaemon() {
        return this.tp.getDaemon();
    }

    public void accept(MsgContext ep) throws IOException {
        if (this.sSocket == null) {
            return;
        }
        Socket s = this.sSocket.accept();
        ep.setNote(this.socketNote, s);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accepted socket " + s));
        }
        if (this.linger > 0) {
            s.setSoLinger(true, this.linger);
        }
        if (this.socketTimeout > 0) {
            s.setSoTimeout(this.socketTimeout);
        }
        ++this.requestCount;
        BufferedInputStream is = new BufferedInputStream(s.getInputStream());
        OutputStream os = s.getOutputStream();
        ep.setNote(this.isNote, is);
        ep.setNote(this.osNote, os);
    }

    public void resetCounters() {
        this.requestCount = 0L;
    }

    public void reinit() throws IOException {
        this.destroy();
        this.init();
    }

    public void init() throws IOException {
        if (this.maxPort < this.startPort) {
            this.maxPort = this.startPort;
        }
        int i = this.startPort;
        while (i <= this.maxPort) {
            try {
                this.sSocket = new ServerSocket(i);
                this.port = i;
                break;
            }
            catch (IOException ex) {
                log.info((Object)("Port busy " + i + " " + ex.toString()));
                ++i;
            }
        }
        if (this.sSocket == null) {
            log.error((Object)("Can't find free port " + this.startPort + " " + this.maxPort));
            return;
        }
        log.info((Object)("JK2: ajp13 listening on tcp port " + this.port));
        if ("channelSocket".equals(this.name) && this.port != this.startPort && this.wEnv.getLocalId() == 0) {
            this.wEnv.setLocalId(this.port - this.startPort);
        }
        if (this.serverTimeout > 0) {
            this.sSocket.setSoTimeout(this.serverTimeout);
        }
        if (this.next == null) {
            if (this.nextName != null) {
                this.setNext(this.wEnv.getHandler(this.nextName));
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("dispatch");
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("request");
            }
        }
        this.running = true;
        this.tp.start();
        SocketAcceptor acceptAjp = new SocketAcceptor(this);
        this.tp.runIt(acceptAjp);
    }

    public void open(MsgContext ep) throws IOException {
    }

    public void close(MsgContext ep) throws IOException {
        Socket s = (Socket)ep.getNote(this.socketNote);
        s.close();
    }

    public void destroy() throws IOException {
        this.running = false;
        try {
            Socket s;
            this.tp.shutdown();
            if (this.inet == null) {
                s = new Socket("127.0.0.1", this.port);
            } else {
                s = new Socket(this.inet, this.port);
                s.setSoLinger(true, 0);
            }
            s.close();
            this.sSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int send(Msg msg, MsgContext ep) throws IOException {
        msg.end();
        byte[] buf = msg.getBuffer();
        int len = msg.getLen();
        if (log.isTraceEnabled()) {
            log.trace((Object)("send() " + len + " " + buf[4]));
        }
        OutputStream os = (OutputStream)ep.getNote(this.osNote);
        os.write(buf, 0, len);
        return len;
    }

    public int flush(Msg msg, MsgContext ep) throws IOException {
        return 0;
    }

    public int receive(Msg msg, MsgContext ep) throws IOException {
        int hlen;
        byte[] buf;
        int rd;
        if (log.isDebugEnabled()) {
            log.debug((Object)"receive() ");
        }
        if ((rd = this.read(ep, buf = msg.getBuffer(), 0, hlen = msg.getHeaderLength())) < 0) {
            return rd;
        }
        msg.processHeader();
        int blen = msg.getLen();
        int total_read = 0;
        total_read = this.read(ep, buf, hlen, blen);
        if (total_read <= 0 && blen > 0) {
            log.warn((Object)("can't read body, waited #" + blen));
            return -1;
        }
        if (total_read != blen) {
            log.warn((Object)("incomplete read, waited #" + blen + " got only " + total_read));
            return -2;
        }
        return total_read;
    }

    public int read(MsgContext ep, byte[] b, int offset, int len) throws IOException {
        InputStream is = (InputStream)ep.getNote(this.isNote);
        int pos = 0;
        while (pos < len) {
            int got = is.read(b, pos + offset, len - pos);
            if (log.isTraceEnabled()) {
                log.trace((Object)("read() " + b + " " + (b == null ? 0 : b.length) + " " + offset + " " + len + " = " + got));
            }
            if (got <= 0) {
                return -3;
            }
            pos += got;
        }
        return pos;
    }

    void acceptConnections() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accepting ajp connections on " + this.port));
        }
        while (this.running) {
            try {
                MsgContext ep = new MsgContext();
                ep.setSource(this);
                ep.setWorkerEnv(this.wEnv);
                this.accept(ep);
                if (!this.running) break;
                SocketConnection ajpConn = new SocketConnection(this, ep);
                this.tp.runIt(ajpConn);
            }
            catch (Exception ex) {
                if (!this.running) continue;
                ex.printStackTrace();
            }
        }
    }

    void processConnection(MsgContext ep) {
        try {
            MsgAjp recv = new MsgAjp();
            while (this.running) {
                int status = this.receive(recv, ep);
                if (status <= 0) {
                    if (status == -3) {
                        log.warn((Object)"server has closed the current connection (-1)");
                        break;
                    }
                    log.warn((Object)("Closing ajp connection " + status));
                    break;
                }
                ep.setLong(0, System.currentTimeMillis());
                ep.setType(0);
                status = this.invoke(recv, ep);
                if (status == 0) continue;
                log.warn((Object)("processCallbacks status " + status));
                break;
            }
            this.close(ep);
        }
        catch (Exception ex) {
            if (ex.getMessage().indexOf("Connection reset") >= 0) {
                log.warn((Object)"Server has closed connection");
            }
            log.error((Object)"Error, closing connection", (Throwable)ex);
        }
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        int type = ep.getType();
        switch (type) {
            case 10: {
                return this.receive(msg, ep);
            }
            case 11: {
                return this.send(msg, ep);
            }
            case 12: {
                return this.flush(msg, ep);
            }
        }
        return this.next.invoke(msg, ep);
    }

    public boolean isSameAddress(MsgContext ep) {
        Socket s = (Socket)ep.getNote(this.socketNote);
        return ChannelSocket.isSameAddress(s.getLocalAddress(), s.getInetAddress());
    }

    public static boolean isSameAddress(InetAddress server, InetAddress client) {
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        int i = 0;
        while (i < serverAddr.length) {
            if (serverAddr[i] != clientAddr[i]) {
                match = false;
                break;
            }
            ++i;
        }
        if (match) {
            return true;
        }
        int i2 = 0;
        while (i2 < serverAddr.length) {
            if (serverAddr[i2] != clientAddr[serverAddr.length - 1 - i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BUFFER_WRITE = false;
    }
}

