/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.common.AprAcceptor;
import org.apache.jk.common.AprConnection;
import org.apache.jk.common.JniHandler;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.tomcat.util.threads.ThreadPool;

public class ChannelUn
extends JniHandler {
    static final int CH_OPEN = 4;
    static final int CH_CLOSE = 5;
    static final int CH_READ = 6;
    static final int CH_WRITE = 7;
    String file;
    ThreadPool tp;
    int socketNote = 1;
    int isNote = 2;
    int osNote = 3;
    boolean running = true;
    private static Log log;
    static /* synthetic */ Class class$org$apache$jk$common$ChannelUn;

    public ThreadPool getThreadPool() {
        return this.tp;
    }

    public void setFile(String f) {
        this.file = f;
    }

    public void init() throws IOException {
        if (this.file == null) {
            log.info((Object)"No file, disabling unix channel");
            return;
        }
        if (this.wEnv.getLocalId() != 0) {
            this.file = this.file + this.wEnv.getLocalId();
        }
        super.initNative("channel.un:" + this.file);
        if (this.apr == null || !this.apr.isLoaded()) {
            log.debug((Object)"Apr is not available, disabling unix channel ");
            this.apr = null;
            return;
        }
        this.setNativeAttribute("file", this.file);
        this.setNativeAttribute("listen", "10");
        if (this.next == null) {
            if (this.nextName != null) {
                this.setNext(this.wEnv.getHandler(this.nextName));
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("dispatch");
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("request");
            }
        }
        this.tp = new ThreadPool();
        File socketFile = new File(this.file);
        if (socketFile.exists() && !socketFile.delete()) {
            throw new IOException("Cannot remove " + this.file);
        }
        super.initJkComponent();
        log.info((Object)("JK: listening on unix socket: " + this.file));
        this.tp.start();
        AprAcceptor acceptAjp = new AprAcceptor(this);
        this.tp.runIt(acceptAjp);
    }

    public void destroy() throws IOException {
        if (this.apr == null) {
            return;
        }
        try {
            if (this.tp != null) {
                this.tp.shutdown();
            }
            super.destroyJkComponent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open(MsgContext ep) throws IOException {
        super.nativeDispatch(ep.getMsg(0), ep, 4, 1);
    }

    public void close(MsgContext ep) throws IOException {
        super.nativeDispatch(ep.getMsg(0), ep, 5, 1);
    }

    public int send(Msg msg, MsgContext ep) throws IOException {
        return super.nativeDispatch(msg, ep, 7, 0);
    }

    public int receive(Msg msg, MsgContext ep) throws IOException {
        int rc = super.nativeDispatch(msg, ep, 6, 1);
        if (rc != 0) {
            log.error((Object)("receive error:   " + rc));
            return -1;
        }
        msg.processHeader();
        if (log.isDebugEnabled()) {
            log.debug((Object)("receive:  total read = " + msg.getLen()));
        }
        return msg.getLen();
    }

    void acceptConnections() {
        if (this.apr == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accepting ajp connections on " + this.file));
        }
        while (this.running) {
            try {
                MsgContext ep = this.createMsgContext();
                this.open(ep);
                AprConnection ajpConn = new AprConnection(this, ep);
                this.tp.runIt(ajpConn);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void processConnection(MsgContext ep) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"New ajp connection ");
        }
        try {
            MsgAjp recv = new MsgAjp();
            while (this.running) {
                int res = this.receive(recv, ep);
                if (res < 0) break;
                ep.setType(0);
                log.debug((Object)"Process msg ");
                int status = this.next.invoke(recv, ep);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing un channel");
            }
            this.close(ep);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        int type = ep.getType();
        switch (type) {
            case 10: {
                return this.receive(msg, ep);
            }
            case 11: {
                return this.send(msg, ep);
            }
            case 12: {
                return 0;
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CH_OPEN = 4;
        CH_CLOSE = 5;
        CH_READ = 6;
        CH_WRITE = 7;
        log = LogFactory.getLog((Class)(class$org$apache$jk$common$ChannelUn == null ? (class$org$apache$jk$common$ChannelUn = ChannelUn.class$("org.apache.jk.common.ChannelUn")) : class$org$apache$jk$common$ChannelUn));
    }
}

