/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;

public class HandlerDispatch
extends JkHandler {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$HandlerDispatch == null ? (class$org$apache$jk$common$HandlerDispatch = HandlerDispatch.class$("org.apache.jk.common.HandlerDispatch")) : class$org$apache$jk$common$HandlerDispatch));
    JkHandler[] handlers = new JkHandler[32];
    String[] handlerNames = new String[32];
    static final int MAX_HANDLERS = 32;
    static final int RESERVED = 16;
    int currentId = 16;
    static /* synthetic */ Class class$org$apache$jk$common$HandlerDispatch;

    public void init() {
    }

    public int registerMessageType(int id, String name, JkHandler h, String[] sig) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Register message " + id + " " + h.getName() + " " + h.getClass().getName()));
        }
        if (id < 0) {
            int i = 0;
            while (i < this.handlerNames.length) {
                if (this.handlerNames[i] != null && name.equals(this.handlerNames[i])) {
                    return i;
                }
                ++i;
            }
            this.handlers[this.currentId] = h;
            this.handlerNames[this.currentId] = name;
            ++this.currentId;
            return this.currentId;
        }
        this.handlers[id] = h;
        this.handlerNames[this.currentId] = name;
        return id;
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        byte type = msg.peekByte();
        ep.setType(type);
        if (type > this.handlers.length || this.handlers[type] == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid handler " + type));
            }
            return 2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received " + type + " " + this.handlers[type].getName()));
        }
        JkHandler handler = this.handlers[type];
        return handler.invoke(msg, ep);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MAX_HANDLERS = 32;
        RESERVED = 16;
    }
}

