/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.core.JkHandler;
import org.apache.jk.server.JkMain;
import org.apache.tomcat.util.mx.DynamicMBeanProxy;

public class JkMX
extends JkHandler {
    MBeanServer mserver;
    private int port = -1;
    private String host;
    ObjectName serverName = null;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$JkMX == null ? (class$org$apache$jk$common$JkMX = JkMX.class$("org.apache.jk.common.JkMX")) : class$org$apache$jk$common$JkMX));
    static /* synthetic */ Class class$org$apache$jk$common$JkMX;

    public void setPort(int i) {
        this.port = i;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void loadAdapter() throws IOException {
        try {
            this.serverName = new ObjectName("Http:name=HttpAdaptor");
            this.mserver.createMBean("mx4j.adaptor.http.HttpAdaptor", this.serverName, null);
            if (this.host != null) {
                this.mserver.setAttribute(this.serverName, new Attribute("Host", this.host));
            }
            this.mserver.setAttribute(this.serverName, new Attribute("Port", new Integer(this.port)));
            ObjectName processorName = new ObjectName("Http:name=XSLTProcessor");
            this.mserver.createMBean("mx4j.adaptor.http.XSLTProcessor", processorName, null);
            this.mserver.setAttribute(this.serverName, new Attribute("ProcessorName", processorName));
            this.mserver.invoke(this.serverName, "start", null, null);
            return;
        }
        catch (Throwable t) {
            log.error((Object)("Can't load the MX4J http adapter " + t.toString()));
            try {
                Class<?> c = Class.forName("com.sun.jdmk.comm.HtmlAdaptorServer");
                Object o = c.newInstance();
                this.serverName = new ObjectName("Adaptor:name=html,port=" + this.port);
                log.info((Object)("Registering the JMX_RI html adapter " + this.serverName));
                this.mserver.registerMBean(o, this.serverName);
                this.mserver.setAttribute(this.serverName, new Attribute("Port", new Integer(this.port)));
                this.mserver.invoke(this.serverName, "start", null, null);
            }
            catch (Throwable t2) {
                log.error((Object)("Can't load the JMX_RI http adapter " + t2.toString()));
            }
            return;
        }
    }

    public void destroy() {
        try {
            log.info((Object)"Stoping JMX ");
            if (this.serverName != null) {
                this.mserver.invoke(this.serverName, "stop", null, null);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Destroy error", t);
        }
    }

    public void init() throws IOException {
        try {
            this.mserver = DynamicMBeanProxy.getMBeanServer();
            if (this.port > 0) {
                this.loadAdapter();
            }
            try {
                Class<?> c = Class.forName("org.apache.log4j.jmx.HierarchyDynamicMBean");
                Object o = c.newInstance();
                log.info((Object)"Registering the JMX hierarchy for Log4J ");
                this.mserver.registerMBean(o, new ObjectName("log4j:hierarchy=default"));
            }
            catch (Throwable t) {
                log.info((Object)"Can't enable log4j mx");
            }
            DynamicMBeanProxy.createMBean(JkMain.getJkMain(), "jk2", "name=JkMain");
            int i = 0;
            while (i < this.wEnv.getHandlerCount()) {
                JkHandler h = this.wEnv.getHandler(i);
                DynamicMBeanProxy.createMBean(h, "jk2", "name=" + h.getName());
                ++i;
            }
        }
        catch (Throwable t) {
            log.error((Object)"Init error", t);
        }
    }

    public void addHandlerCallback(JkHandler w) {
        if (w != this) {
            DynamicMBeanProxy.createMBean(w, "jk2", "name=" + w.getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

