/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.apr.AprImpl;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.MessageBytes;

public class JniHandler
extends JkHandler {
    protected AprImpl apr;
    protected long nativeJkHandlerP;
    protected String jkHome;
    public static final int JK_HANDLE_JNI_DISPATCH = 21;
    public static final int JK_HANDLE_SHM_DISPATCH = 22;
    public static final int MSG_NOTE = 0;
    public static final int C2B_NOTE = 1;
    public static final int MB_NOTE = 2;
    private static Log log;
    static /* synthetic */ Class class$org$apache$jk$common$JniHandler;

    public void setJkHome(String s) {
        this.jkHome = s;
    }

    public void init() throws IOException {
    }

    protected void initNative(String nativeComponentName) {
        this.apr = (AprImpl)this.wEnv.getHandler("apr");
        if (this.apr == null || !this.apr.isLoaded()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No apr, disabling jni proxy ");
            }
            this.apr = null;
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.nativeJkHandlerP = this.apr.getJkHandler(xEnv, nativeComponentName);
        if (this.nativeJkHandlerP == 0L) {
            log.debug((Object)("Component not found, creating it " + nativeComponentName));
            this.nativeJkHandlerP = this.apr.createJkHandler(xEnv, nativeComponentName);
        }
        log.debug((Object)("Native proxy " + this.nativeJkHandlerP));
        this.apr.releaseJkEnv(xEnv);
    }

    public void appendString(Msg msg, String s, C2BConverter charsetDecoder) throws IOException {
        ByteChunk bc = charsetDecoder.getByteChunk();
        charsetDecoder.recycle();
        charsetDecoder.convert(s);
        charsetDecoder.flushBuffer();
        msg.appendByteChunk(bc);
    }

    public MsgContext createMsgContext() {
        if (this.nativeJkHandlerP == 0L || this.apr == null) {
            return null;
        }
        try {
            MsgContext msgCtx = new MsgContext();
            MsgAjp msg = new MsgAjp();
            msgCtx.setSource(this);
            msgCtx.setWorkerEnv(this.wEnv);
            msgCtx.setNext(this);
            msgCtx.setMsg(0, msg);
            C2BConverter c2b = new C2BConverter("UTF8");
            msgCtx.setNote(1, c2b);
            MessageBytes tmpMB = new MessageBytes();
            msgCtx.setNote(2, tmpMB);
            return msgCtx;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setNativeAttribute(String name, String val) throws IOException {
        if (this.apr == null) {
            return;
        }
        if (this.nativeJkHandlerP == 0L) {
            log.error((Object)("Unitialized component " + name + " " + val));
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.apr.jkSetAttribute(xEnv, this.nativeJkHandlerP, name, val);
        this.apr.releaseJkEnv(xEnv);
    }

    public void initJkComponent() throws IOException {
        if (this.apr == null) {
            return;
        }
        if (this.nativeJkHandlerP == 0L) {
            log.error((Object)"Unitialized component ");
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.apr.jkInit(xEnv, this.nativeJkHandlerP);
        this.apr.releaseJkEnv(xEnv);
    }

    public void destroyJkComponent() throws IOException {
        if (this.apr == null) {
            return;
        }
        if (this.nativeJkHandlerP == 0L) {
            log.error((Object)"Unitialized component ");
            return;
        }
        long xEnv = this.apr.getJkEnv();
        this.apr.jkDestroy(xEnv, this.nativeJkHandlerP);
        this.apr.releaseJkEnv(xEnv);
    }

    protected void setNativeEndpoint(MsgContext msgCtx) {
        long xEnv = this.apr.getJkEnv();
        msgCtx.setJniEnv(xEnv);
        long epP = this.apr.createJkHandler(xEnv, "endpoint");
        log.debug((Object)("create ep " + epP));
        if (epP == 0L) {
            return;
        }
        this.apr.jkInit(xEnv, epP);
        msgCtx.setJniContext(epP);
    }

    protected void recycleNative(MsgContext ep) {
        this.apr.jkRecycle(ep.getJniEnv(), ep.getJniContext());
    }

    protected int nativeDispatch(Msg msg, MsgContext ep, int code, int raw) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending packet " + code + " " + raw));
        }
        if (raw == 0) {
            msg.end();
            if (log.isTraceEnabled()) {
                msg.dump("OUT:");
            }
        }
        long xEnv = ep.getJniEnv();
        long nativeContext = ep.getJniContext();
        if (nativeContext == 0L || xEnv == 0L) {
            this.setNativeEndpoint(ep);
            xEnv = ep.getJniEnv();
            nativeContext = ep.getJniContext();
        }
        if (xEnv == 0L || nativeContext == 0L || this.nativeJkHandlerP == 0L) {
            log.error((Object)"invokeNative: Null pointer ");
            return -1;
        }
        int status = AprImpl.jkInvoke(xEnv, this.nativeJkHandlerP, nativeContext, code, msg.getBuffer(), 0, msg.getLen(), raw);
        if (status != 0 && status != 2) {
            log.error((Object)("nativeDispatch: error " + status));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending packet - done " + status));
        }
        return status;
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        long xEnv = ep.getJniEnv();
        int type = ep.getType();
        int status = this.nativeDispatch(msg, ep, type, 0);
        this.apr.jkRecycle(xEnv, ep.getJniContext());
        this.apr.releaseJkEnv(xEnv);
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JK_HANDLE_JNI_DISPATCH = 21;
        JK_HANDLE_SHM_DISPATCH = 22;
        MSG_NOTE = 0;
        C2B_NOTE = 1;
        MB_NOTE = 2;
        log = LogFactory.getLog((Class)(class$org$apache$jk$common$JniHandler == null ? (class$org$apache$jk$common$JniHandler = JniHandler.class$("org.apache.jk.common.JniHandler")) : class$org$apache$jk$common$JniHandler));
    }
}

