/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.jk.config.WebXml2Jk;

public class GeneratorJk2
implements WebXml2Jk.MappingGenerator {
    WebXml2Jk wxml;
    String vhost;
    String cpath;
    String worker;
    PrintWriter out;

    public void setWebXmlReader(WebXml2Jk wxml) {
        this.wxml = wxml;
        this.vhost = wxml.vhost;
        this.cpath = wxml.cpath;
        this.worker = wxml.worker;
    }

    public void generateStart() throws IOException {
        File base = this.wxml.getJkDir();
        File outF = new File(base, "jk2map.properties");
        this.out = new PrintWriter(new FileWriter(outF));
        this.out.println("# Autogenerated from web.xml");
    }

    public void generateEnd() {
        this.out.close();
    }

    public void generateServletMapping(String servlet, String url) {
        this.out.println("[uri:" + this.vhost + this.cpath + url + "]");
        this.out.println("group=" + this.worker);
        this.out.println("servlet=" + servlet);
        this.out.println("host=" + this.vhost);
        this.out.println("context=" + this.cpath);
        this.out.println();
    }

    public void generateFilterMapping(String servlet, String url) {
        this.out.println("[url:" + this.vhost + this.cpath + url + "]");
        this.out.println("group=" + this.worker);
        this.out.println("filter=" + servlet);
        this.out.println("host=" + this.vhost);
        this.out.println("context=" + this.cpath);
        this.out.println();
    }

    public void generateLoginConfig(String loginPage, String errPage, String authM) {
        this.out.println("[url:" + this.vhost + this.cpath + loginPage + "]");
        this.out.println("group=" + this.worker);
        this.out.println("host=" + this.vhost);
        this.out.println("context=" + this.cpath);
        this.out.println();
        this.out.println("[url:" + this.vhost + this.cpath + errPage + "]");
        this.out.println("group=" + this.worker);
        this.out.println("host=" + this.vhost);
        this.out.println("context=" + this.cpath);
        this.out.println();
    }

    public void generateErrorPage(int err, String location) {
    }

    public void generateMimeMapping(String ext, String type) {
    }

    public void generateWelcomeFiles(Vector wf) {
    }

    public void generateConstraints(Vector urls, Vector methods, Vector roles, boolean isSSL) {
        int i = 0;
        while (i < urls.size()) {
            String url = (String)urls.elementAt(i);
            this.out.println("[url:" + this.vhost + this.cpath + url + "]");
            this.out.println("group=" + this.worker);
            this.out.println("host=" + this.vhost);
            this.out.println("context=" + this.cpath);
            int j = 0;
            while (j < roles.size()) {
                String role = (String)roles.elementAt(j);
                this.out.println("role=" + role);
                ++j;
            }
            int j2 = 0;
            while (j2 < methods.size()) {
                String m = (String)methods.elementAt(j2);
                this.out.println("method=" + m);
                ++j2;
            }
            if (isSSL) {
                this.out.println("ssl=true");
            }
            ++i;
        }
    }
}

