/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.WorkerEnv;
import org.apache.tomcat.util.IntrospectionUtils;

public class JkMain {
    WorkerEnv wEnv = new WorkerEnv();
    String propFile;
    Properties props = new Properties();
    Properties modules = new Properties();
    boolean modified = false;
    boolean started = false;
    String out;
    String err;
    File propsF;
    static String[] defaultHandlers = new String[]{"request", "container", "channelSocket"};
    long initTime;
    long startTime;
    static JkMain jkMain = null;
    private static String CNAME = "org/apache/jk/server/JkMain.class";
    static Log log = LogFactory.getLog((Class)(class$org$apache$jk$server$JkMain == null ? (class$org$apache$jk$server$JkMain = JkMain.class$("org.apache.jk.server.JkMain")) : class$org$apache$jk$server$JkMain));
    static /* synthetic */ Class class$org$apache$jk$server$JkMain;

    public JkMain() {
        jkMain = this;
        this.modules.put("channelSocket", "org.apache.jk.common.ChannelSocket");
        this.modules.put("channelUnix", "org.apache.jk.common.ChannelUn");
        this.modules.put("channelJni", "org.apache.jk.common.ChannelJni");
        this.modules.put("apr", "org.apache.jk.apr.AprImpl");
        this.modules.put("mx", "org.apache.jk.common.JkMX");
        this.modules.put("shm", "org.apache.jk.common.Shm");
        this.modules.put("request", "org.apache.jk.common.HandlerRequest");
        this.modules.put("container", "org.apache.jk.common.HandlerRequest");
    }

    public static JkMain getJkMain() {
        return jkMain;
    }

    public void setPropertiesFile(String p) {
        this.propFile = p;
        try {
            this.props.load(new FileInputStream(this.propFile));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getPropertiesFile() {
        return this.propFile;
    }

    public void setProperty(String n, String v) {
        if ("jkHome".equals(n)) {
            this.setJkHome(v);
        }
        this.props.put(n, v);
        if (this.started) {
            this.processProperty(n, v);
            this.saveProperties();
        }
    }

    public void setChannelClassName(String name) {
        this.props.put("handler.channel.className", name);
    }

    public String getChannelClassName() {
        return (String)this.props.get("handler.channel.className");
    }

    public void setWorkerClassName(String name) {
        this.props.put("handler.container.className", name);
    }

    public String getWorkerClassName() {
        return (String)this.props.get("handler.container.className");
    }

    public void setJkHome(String s) {
        this.wEnv.setJkHome(s);
    }

    public String getJkHome() {
        return this.wEnv.getJkHome();
    }

    public void setOut(String s) {
        this.out = s;
    }

    public String getOut() {
        return this.out;
    }

    public void setErr(String s) {
        this.err = s;
    }

    public String getErr() {
        return this.err;
    }

    public void init() throws IOException {
        String home;
        long t1 = System.currentTimeMillis();
        if (null != this.out) {
            PrintStream outS = new PrintStream(new FileOutputStream(this.out));
            System.setOut(outS);
        }
        if (null != this.err) {
            PrintStream errS = new PrintStream(new FileOutputStream(this.err));
            System.setErr(errS);
        }
        if ((home = this.wEnv.getJkHome()) == null) {
            this.guessHome();
        }
        if ((home = this.wEnv.getJkHome()) != null) {
            File hF = new File(home);
            File conf = new File(home, "conf");
            if (!conf.exists()) {
                conf = new File(home, "etc");
            }
            this.propsF = new File(conf, "jk2.properties");
            if (this.propsF.exists()) {
                log.debug((Object)("Starting Jk2, base dir= " + home + " conf=" + this.propsF));
                this.setPropertiesFile(this.propsF.getAbsolutePath());
            } else {
                log.debug((Object)("Starting Jk2, base dir= " + home));
                if (log.isWarnEnabled()) {
                    log.warn((Object)("No properties file found " + this.propsF));
                }
            }
        }
        long t2 = System.currentTimeMillis();
        this.initTime = t2 - t1;
    }

    public void stop() {
        int i = 0;
        while (i < this.wEnv.getHandlerCount()) {
            if (this.wEnv.getHandler(i) != null) {
                try {
                    this.wEnv.getHandler(i).destroy();
                }
                catch (IOException ex) {
                    log.error((Object)("Error stoping " + this.wEnv.getHandler(i).getName()), (Throwable)ex);
                }
            }
            ++i;
        }
        this.started = false;
    }

    public void start() throws IOException {
        long t1 = System.currentTimeMillis();
        String[] handlers = defaultHandlers;
        String workers = this.props.getProperty("handler.list", null);
        if (workers != null) {
            handlers = this.split(workers, ",");
        }
        this.processModules();
        int i = 0;
        while (i < handlers.length) {
            String name = handlers[i];
            JkHandler w = this.wEnv.getHandler(name);
            if (w == null) {
                this.newHandler(name, "", name);
            }
            ++i;
        }
        this.processProperties();
        int i2 = 0;
        while (i2 < this.wEnv.getHandlerCount()) {
            if (this.wEnv.getHandler(i2) != null) {
                try {
                    this.wEnv.getHandler(i2).init();
                }
                catch (IOException ex) {
                    if ("apr".equals(this.wEnv.getHandler(i2).getName())) {
                        log.info((Object)("APR not loaded, disabling jni components: " + ex.toString()));
                    }
                    log.error((Object)("error initializing " + this.wEnv.getHandler(i2).getName()), (Throwable)ex);
                }
            }
            ++i2;
        }
        this.started = true;
        long t2 = System.currentTimeMillis();
        this.startTime = t2 - t1;
        this.saveProperties();
        log.info((Object)("Jk running ID=" + this.wEnv.getLocalId() + " time=" + this.initTime + "/" + this.startTime + "  config=" + this.propFile));
    }

    public WorkerEnv getWorkerEnv() {
        return this.wEnv;
    }

    public void setBeanProperty(Object target, String name, String val) {
        if (val != null) {
            val = IntrospectionUtils.replaceProperties(val, this.props);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setProperty " + target + " " + name + "=" + val));
        }
        IntrospectionUtils.setProperty(target, name, val);
    }

    public void setPropertyString(String handlerN, String name, String val) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setProperty " + handlerN + " " + name + "=" + val));
        }
        JkHandler target = this.wEnv.getHandler(handlerN);
        this.setBeanProperty(target, name, val);
        if (this.started) {
            this.saveProperties();
        }
    }

    public long getInitTime() {
        return this.initTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 1 && ("-?".equals(args[0]) || "-h".equals(args[0]))) {
                System.out.println("Usage: ");
                System.out.println("  JkMain [args]");
                System.out.println();
                System.out.println("  Each bean setter corresponds to an arg ( like -debug 10 )");
                System.out.println("  System properties:");
                System.out.println("    jk2.home    Base dir of jk2");
                return;
            }
            jkMain = new JkMain();
            IntrospectionUtils.processArgs(jkMain, args, new String[0], null, new Hashtable());
            jkMain.init();
            jkMain.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveProperties() {
        String outFile = this.propFile + ".save";
        log.debug((Object)("Saving properties " + outFile));
        try {
            this.props.save(new FileOutputStream(outFile), "AUTOMATICALLY GENERATED");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void processProperties() {
        Enumeration<Object> keys = this.props.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String propValue = this.props.getProperty(name);
            this.processProperty(name, propValue);
        }
    }

    private void processProperty(String name, String propValue) {
        String type = name;
        String fullName = name;
        String localName = "";
        String propName = "";
        int dot = name.indexOf(".");
        int lastDot = name.lastIndexOf(".");
        if (dot > 0) {
            type = name.substring(0, dot);
            if (dot != lastDot) {
                localName = name.substring(dot + 1, lastDot);
                fullName = type + "." + localName;
            } else {
                fullName = type;
            }
        } else {
            return;
        }
        propName = name.substring(lastDot + 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing " + type + ":" + localName + ":" + fullName + " " + propName));
        }
        if ("class".equals(type) || "handler".equals(type)) {
            return;
        }
        JkHandler comp = this.wEnv.getHandler(fullName);
        if (comp == null) {
            comp = this.newHandler(type, localName, fullName);
        }
        if (comp == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting " + propName + " on " + fullName + " " + comp));
        }
        this.setBeanProperty(comp, propName, propValue);
    }

    private JkHandler newHandler(String type, String localName, String fullName) {
        JkHandler handler2;
        String classN = this.modules.getProperty(type);
        if (classN == null) {
            log.error((Object)("No class name for " + fullName + " " + type));
            return null;
        }
        try {
            Class<?> channelclass = Class.forName(classN);
            handler2 = (JkHandler)channelclass.newInstance();
        }
        catch (Throwable ex) {
            Object handler2 = null;
            log.error((Object)("Can't create " + fullName), ex);
            return null;
        }
        this.wEnv.addHandler(fullName, handler2);
        return handler2;
    }

    private void processModules() {
        Enumeration<Object> keys = this.props.keys();
        int plen = 6;
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            if (!k.startsWith("class.")) continue;
            String name = k.substring(plen);
            String propValue = this.props.getProperty(k);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register " + name + " " + propValue));
            }
            this.modules.put(name, propValue);
        }
    }

    private String[] split(String s, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, delim);
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        String[] res = new String[v.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = (String)v.elementAt(i);
            ++i;
        }
        return res;
    }

    private void guessHome() {
        String home = this.wEnv.getJkHome();
        if (home != null) {
            return;
        }
        home = IntrospectionUtils.guessInstall("jk2.home", "jk2.home", "tomcat-jk2.jar", CNAME);
        if (home != null) {
            log.info((Object)("Guessed home " + home));
            this.wEnv.setJkHome(home);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

