; build the static data_bases in the /usr/local/gifa/macro/att directory
;
; This macro is not used in normal work, the 3let_1let and 1let_3let db
; being permanently there.
; If you modify it, you will have to rerun it.
;
; You is also possible that you cannot read the dbm files in the distribution
; because your dbm set-up is not compatible (this is the case with Linux)
; in this case, remove the files *.pag and *.dir from the directory
; and rerun this macro, which will recreate them

dbopen /usr/local/gifa/macro/att/topology topo
; This db defines the spin-systems that are known
; each spin-syst has a name and a list of known spins.

set topo["AMX"] = "HN,HA,HB1,HB2,QB"
set topo["LONG"] = "HN,HA,HB1,HB2,QB,HG1,HG2,QG,HD1,HD2,QD,HE1,HE2,QE"
set topo["DiMet"] = HN,HA,HB,HB1,HB2,QB,HG,HG1,HG2,HG3,QG,H1,HD1,HD2,QD"
set topo["Arom-Phe"] = "2H,3H,4H"
set topo["Arom-Tyr"] = "2H,3H"
set topo["Arom-His"] = "2H,4H"
set topo["Arom-Trp"] = "2H,4H,5H,6H,7H"
set topo["Met"] = "HMET"
set topo["NH3+"] = "HN+"
set topo["Amide"] = "HN1,HN2"
set topo["H2O"] = "H2O"
set topo["GLY"] = "HN,HA1,HA2,QA"
set topo["ALA"] = "HN,HA,HB"
set topo["VAL"] = "HN,HA,HB,HG1,HG2,QG"
set topo["PHE"] = "HN,HA,HB1,HB2,QB,2H,3H,4H"
set topo["ILE"] = "HN,HA,HB,HG1,HG2,HG3,QG,HD"
set topo["LEU"] = "HN,HA,HB1,HB2,QB,HG,HD1,HD2,QD"
set topo["PRO"] = "HA,HB1,HB2,QB,HG1,HG2,QG,HD1,HD2,QD"
set topo["MET"] = "HN,HA,HB1,HB2,QB,HG1,HG2,QG,HE"
set topo["ASP"] = "HN,HA,HB1,HB2,QB"
set topo["GLU"] = "HN,HA,HB1,HB2,QB,HG1,HG2,QG"
set topo["GLN"] = "HN,HA,HB1,HB2,QB,HG1,HG2,QG,HN1,HN2"
set topo["LYS"] = "HN,HA,HB1,HB2,QB,HG1,HG2,QG,HD1,HD2,QD,HE1,HE2,QE,HNE"
set topo["ARG"] = "HN,HA,HB1,HB2,QB,HG1,HG2,QG,HD1,HD2,QD,HNE"
set topo["SER"] = "HN,HA,HB1,HB2,QB"
set topo["THR"] = "HN,HA,HB,HG"
set topo["TYR"] = "HN,HA,HB1,HB2,QB,2H,3H"
set topo["HIS"] = "HN,HA,HB1,HB2,QB,2H,4H"
set topo["CYS"] = "HN,HA,HB1,HB2,QB"
set topo["ASN"] = "HN,HA,HB1,HB2,QB,HN1,HN2"
set topo["TRP"] = "HN,HA,HB1,HB2,QB,2H,4H,5H,6H,7H"
dbclose topo

dbopen /usr/local/gifa/macro/att/3let_1let code
; These data bases defines the known residues.
; There are 2 db, one for 3 letters entries, one for 1 letters
; is coded : name list_of_spin_systems

set code["GLY"] = "G GLY"
set code["ALA"] = "A ALA"
set code["VAL"] = "V DiMet"
set code["PHE"] = "F AMX,Arom-Phe"
set code["ILE"] = "I DiMet"
set code["LEU"] = "L DiMet"
set code["PRO"] = "P LONG"
set code["MET"] = "M LONG,Met"
set code["ASP"] = "D AMX"
set code["GLU"] = "E LONG"
set code["GLN"] = "Q LONG,Amide"
set code["LYS"] = "K LONG,HN3+"
set code["ARG"] = "R LONG,Amide"
set code["SER"] = "S AMX"
set code["THR"] = "T THR"
set code["TYR"] = "Y AMX,Arom-Tyr"
set code["HIS"] = "H AMX,Arom-His"
set code["CYS"] = "C AMX"
set code["ASN"] = "N AMX,Amide"
set code["TRP"] = "W AMX,Arom-Trp"

; now inverse the db
dbopen /usr/local/gifa/macro/att/1let_3let code2
foreach i in code
  set j = $code[$i]
  set code2[head($j)] = ($i; tail($j))
endfor
dbclose code
dbclose code2


