; dosy.g
;
; this is a Graphic Interface to the dosy2d and dosy3d macros
;
; in 2D file will be written at the en of the processing
; in 3D file is part of the processing.
;
; see also : dosy2d dosy3d

if (!$arg) then
formbox 'Dosy processing' \
  'dosy.g $type $size $thres $file' \ 
  'Experiment type' enum 'regular,tabulated' type % \
  noreturn 'Size in diffusion dim' int size (2*$si1_2d) \
  'Noise threshold' real thres 10 \
  noreturn '(Only points above this level will be processed)' message \
  'Output file name' string file ($name // '.dosy') \
  separator \
  'Help on dosy' action 'help dosy2d' \
  *
else
if ($dim == 1) then
  error 'Not for 1D, use INVLAP/INVTLAP'
elsif ($dim == 2) then
  dosy2d $_ $_ $_
  write $_
else
  dosy3d $_ $_ $_ $_
endif
endif

